/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.federation;

import java.util.List;
import java.util.Set;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.graph.Graph;
import org.modeshape.graph.connector.federation.AbstractFederatedRepositorySourceIntegrationTest;
import org.modeshape.graph.request.UnsupportedRequestException;

public class FederatedRepositorySourceUsingOffsetProjectionTest
extends AbstractFederatedRepositorySourceIntegrationTest {
    private String offsetSourceName;
    private String offsetWorkspaceName;

    @Override
    @Before
    public void beforeEach() throws Exception {
        super.beforeEach();
        this.offsetSourceName = "Offset Source";
        this.offsetWorkspaceName = "Offset Workspace";
        this.addProjection("fedSpace", "Offset Projection", this.offsetSourceName, this.offsetWorkspaceName, "/a/b => /");
        Graph source = this.graphFor(this.offsetSourceName, this.offsetWorkspaceName);
        source.importXmlFrom(this.getClass().getClassLoader().getResource("cars.xml").toURI()).into("/");
    }

    protected void assertSameNode(String pathToSourceNode) {
        String pathToFedNode = "/a/b" + pathToSourceNode;
        this.assertSameNode(pathToFedNode, pathToSourceNode, this.offsetSourceName, this.offsetWorkspaceName, new String[0]);
    }

    protected void assertNoNode(String pathToSourceNode) {
        String pathToFedNode = "/a/b" + pathToSourceNode;
        this.assertNoNode(pathToFedNode, pathToSourceNode, this.offsetSourceName, this.offsetWorkspaceName);
    }

    @Test
    public void shouldListAllFederatedWorkspaces() {
        Set workspaces = this.federated.getWorkspaces();
        Assert.assertThat((Object)workspaces.contains("fedSpace"), Is.is(true));
        Assert.assertThat((Object)workspaces.size(), Is.is(1));
    }

    @Test
    public void shouldFederateNodesInOffsetSource() {
        this.assertSameNode("/");
        this.assertSameNode("/Cars");
        this.assertSameNode("/Cars/Hybrid");
        this.assertSameNode("/Cars/Hybrid/Toyota Prius");
        this.assertSameNode("/Cars/Hybrid/Toyota Highlander");
        this.assertSameNode("/Cars/Hybrid/Nissan Altima");
        this.assertSameNode("/Cars/Sports/Aston Martin DB9");
        this.assertSameNode("/Cars/Sports/Infiniti G37");
        this.assertSameNode("/Cars/Luxury/Cadillac DTS");
        this.assertSameNode("/Cars/Luxury/Bentley Continental");
        this.assertSameNode("/Cars/Luxury/Lexus IS350");
        this.assertSameNode("/Cars/Utility/Land Rover LR2");
        this.assertSameNode("/Cars/Utility/Land Rover LR3");
        this.assertSameNode("/Cars/Utility/Hummer H3");
        this.assertSameNode("/Cars/Utility/Ford F-150");
    }

    @Test(expected=UnsupportedRequestException.class)
    public void shouldNodeAllowCreatingNodeWithinOffset() {
        this.federated.createAt("/a/Hovercraft").with("prop1", new Object[]{"value1"}).and();
    }

    @Test
    public void shouldCreateNodeUnderRootInOffsetSource() {
        this.federated.createAt("/a/b/Hovercraft").with("prop1", new Object[]{"value1"}).and();
        this.assertSameNode("/Hovercraft");
        this.assertSameNode("/");
    }

    @Test
    public void shouldCreateNodeWellBelowRootInOffsetSource() {
        this.federated.createAt("/a/b/Cars/Hybrid/MyNewHybrid").with("prop1", new Object[]{"value1"}).and();
        this.assertSameNode("/Cars/Hybrid/MyNewHybrid");
        this.assertSameNode("/Cars/Hybrid");
    }

    @Test
    public void shouldAllowDeletingNodeAtBottomOfOffset() {
        this.federated.delete("/a/b");
        this.assertSameNode("/");
        Assert.assertThat((Object)((List)this.federated.getChildren().of("/a/b")).size(), Is.is(0));
    }

    @Test
    public void shouldNodeAllowDeletingNodeWithinOffset() {
        this.federated.delete("/a");
        this.assertSameNode("/");
        Assert.assertThat((Object)((List)this.federated.getChildren().of("/a")).size(), Is.is(1));
        Assert.assertThat((Object)((List)this.federated.getChildren().of("/a/b")).size(), Is.is(0));
    }

    @Test
    public void shouldDeleteNodeUnderRootInOffsetSource() {
        this.federated.createAt("/a/b/Hovercraft").with("prop1", new Object[]{"value1"}).and();
        this.assertSameNode("/Hovercraft");
        this.assertSameNode("/");
        this.federated.delete("/a/b/Hovercraft");
        this.assertNoNode("/Hovercraft");
        this.assertSameNode("/");
        this.federated.delete("/a/b/Cars");
        this.assertSameNode("/");
    }

    @Test
    public void shouldDeleteNodeWellBelowRootInOffsetSource() {
        this.federated.delete("/a/b/Cars/Luxury/Cadillac DTS");
        this.assertNoNode("/Cars/Luxury/Cadillac DTS");
        this.assertSameNode("/Cars/Luxury");
    }
}

