/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.federation;

import java.util.List;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.connector.federation.AbstractProjectorTest;
import org.modeshape.graph.connector.federation.MirrorProjector;
import org.modeshape.graph.connector.federation.ProjectedNode;
import org.modeshape.graph.connector.federation.ProxyNode;

public class MirrorProjectorTest
extends AbstractProjectorTest<MirrorProjector> {
    private String sourceName;
    private String workspaceName;

    @Override
    @Before
    public void beforeEach() {
        super.beforeEach();
        this.sourceName = "source1";
        this.workspaceName = "workspace1";
        this.addProjection(this.sourceName, this.workspaceName, "/ => /");
        this.projector = MirrorProjector.with((ExecutionContext)this.context, (List)this.projections);
    }

    @Test
    public void shouldAlwaysReturnProxyNodeForSuppliedLocation() {
        ProjectedNode node = ((MirrorProjector)this.projector).project(this.context, this.locationA, false);
        Assert.assertThat((Object)node.isProxy(), Is.is(true));
        ProxyNode proxy = node.asProxy();
        Assert.assertThat((Object)proxy.location(), Is.is(this.locationA));
        Assert.assertThat((Object)proxy.source(), Is.is(this.sourceName));
        Assert.assertThat((Object)proxy.workspaceName(), Is.is(this.workspaceName));
    }
}

