/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.federation;

import java.util.List;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Location;
import org.modeshape.graph.connector.federation.AbstractProjectorTest;
import org.modeshape.graph.connector.federation.OffsetMirrorProjector;
import org.modeshape.graph.connector.federation.ProjectedNode;
import org.modeshape.graph.connector.federation.ProxyNode;

public class OffsetMirrorProjectorTest
extends AbstractProjectorTest<OffsetMirrorProjector> {
    private String mirrorSourceName;
    private String mirrorWorkspaceName;

    @Override
    @Before
    public void beforeEach() {
        super.beforeEach();
        this.mirrorSourceName = "source1";
        this.mirrorWorkspaceName = "workspace1";
        this.addProjection(this.mirrorSourceName, this.mirrorWorkspaceName, "/a/b/c => /d/e");
        this.projector = OffsetMirrorProjector.with((ExecutionContext)this.context, (List)this.projections);
    }

    protected void assertProjectedIntoMirror(String federatedPath, String pathInSource) {
        Location location = this.location(federatedPath);
        ProjectedNode node = ((OffsetMirrorProjector)this.projector).project(this.context, location, false);
        Assert.assertThat((Object)node.isProxy(), Is.is(true));
        ProxyNode proxy = node.asProxy();
        Assert.assertThat((Object)proxy.location().getPath(), Is.is(this.path(pathInSource)));
        Assert.assertThat((Object)proxy.source(), Is.is(this.mirrorSourceName));
        Assert.assertThat((Object)proxy.workspaceName(), Is.is(this.mirrorWorkspaceName));
        Assert.assertThat((Object)proxy.hasNext(), Is.is(false));
    }

    @Test
    public void shouldAlwaysReturnProxyNodeForLocationAboveMirrorSource() {
        this.assertPlacholderHasChildren("/", "a");
        this.assertPlacholderHasChildren("/a", "b");
        this.assertPlacholderHasChildren("/a/b", "c");
        this.assertProjectedIntoMirror("/a/b/c", "/d/e");
    }

    @Test
    public void shouldAlwaysReturnProxyNodeForLocationWithinMirror() {
        this.assertProjectedIntoMirror("/a/b/c", "/d/e");
        this.assertProjectedIntoMirror("/a/b/c/f", "/d/e/f");
        this.assertProjectedIntoMirror("/a/b/c/f/g", "/d/e/f/g");
    }

    @Test
    public void shouldReturnNoProjectedNodeForLocationOffPathToSourceBranch() {
        this.assertNoProjectedNodeAt("/a[2]");
        this.assertNoProjectedNodeAt("/a/b[2]");
        this.assertNoProjectedNodeAt("/a/b/c[2]");
    }
}

