/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.federation;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.hamcrest.core.IsSame;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.matchers.JUnitMatchers;
import org.modeshape.common.text.TextEncoder;
import org.modeshape.common.text.UrlEncoder;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.connector.federation.Projection;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;

public class ProjectionPathRuleTest {
    private ExecutionContext context;
    private Projection.PathRule rule;
    private PathFactory pathFactory;
    private Path repositoryPath;
    private Path sourcePath;
    private Path[] validExceptions;
    private NamespaceRegistry registry;
    private TextEncoder encoder;

    @Before
    public void beforeEach() {
        this.context = new ExecutionContext();
        this.pathFactory = this.context.getValueFactories().getPathFactory();
        this.registry = this.context.getNamespaceRegistry();
        this.encoder = new UrlEncoder();
        this.repositoryPath = (Path)this.pathFactory.create("/a/b/c");
        this.sourcePath = (Path)this.pathFactory.create("/x/y");
        this.validExceptions = new Path[]{(Path)this.pathFactory.create("e/f"), (Path)this.pathFactory.create("e/g")};
        this.rule = new Projection.PathRule(this.repositoryPath, this.sourcePath, this.validExceptions);
    }

    @Test
    public void shouldCreateInstanceWithValidRepositoryPathAndValidSourcePathAndNoExceptions() {
        this.rule = new Projection.PathRule(this.repositoryPath, this.sourcePath);
        Assert.assertThat((Object)this.rule.getPathInRepository(), Is.is(IsSame.sameInstance(this.repositoryPath)));
        Assert.assertThat((Object)this.rule.getPathInSource(), Is.is(IsSame.sameInstance(this.sourcePath)));
        Assert.assertThat((Object)this.rule.hasExceptionsToRule(), Is.is(false));
    }

    @Test
    public void shouldCreateInstanceWithValidRepositoryPathAndValidSourcePathAndValidExceptions() {
        this.rule = new Projection.PathRule(this.repositoryPath, this.sourcePath, this.validExceptions);
        Assert.assertThat((Object)this.rule.getPathInRepository(), Is.is(IsSame.sameInstance(this.repositoryPath)));
        Assert.assertThat((Object)this.rule.getPathInSource(), Is.is(IsSame.sameInstance(this.sourcePath)));
        Assert.assertThat((Object)this.rule.hasExceptionsToRule(), Is.is(true));
        Assert.assertThat((Object)this.rule.getExceptionsToRule(), (Matcher)JUnitMatchers.hasItems((Object[])this.validExceptions));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailToCreateInstanceWithNullRepositoryPathAndValidSourcePathAndNoExceptions() {
        this.repositoryPath = null;
        new Projection.PathRule(this.repositoryPath, this.sourcePath);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailToCreateInstanceWithValidRepositoryPathAndNullSourcePathAndNoExceptions() {
        this.sourcePath = null;
        new Projection.PathRule(this.repositoryPath, this.sourcePath);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailToCreateInstanceWithValidRepositoryPathAndValidSourcePathAndAbsoluteExceptions() {
        Path relativePath = this.validExceptions[0];
        Path absolutePath = (Path)this.pathFactory.create("/j/k/l/m");
        new Projection.PathRule(this.repositoryPath, this.sourcePath, new Path[]{relativePath, absolutePath});
    }

    @Test
    public void shouldIncludeRepositoryPathsAtPathInRepository() {
        Assert.assertThat((Object)this.rule.includes(this.sourcePath), Is.is(true));
    }

    @Test
    public void shouldIncludeRepositoryPathsBelowPathInRepositoryThatAreNotExcluded() {
        Assert.assertThat((Object)this.rule.includes(this.pathFactory.create(this.sourcePath, "m")), Is.is(true));
        Assert.assertThat((Object)this.rule.includes(this.pathFactory.create(this.sourcePath, "m/n")), Is.is(true));
        Assert.assertThat((Object)this.rule.includes(this.pathFactory.create(this.sourcePath, "o/p")), Is.is(true));
        Assert.assertThat((Object)this.rule.includes(this.pathFactory.create(this.sourcePath, "e/e")), Is.is(true));
        Assert.assertThat((Object)this.rule.includes(this.pathFactory.create(this.sourcePath, "e")), Is.is(true));
    }

    @Test
    public void shouldNotIncludeRepositoryPathsBelowPathInRepositoryThatAreExcluded() {
        Assert.assertThat((Object)this.rule.includes(this.pathFactory.create(this.sourcePath, "e/f")), Is.is(false));
        Assert.assertThat((Object)this.rule.includes(this.pathFactory.create(this.sourcePath, "e/g")), Is.is(false));
        Assert.assertThat((Object)this.rule.includes(this.pathFactory.create(this.sourcePath, "e/f/g")), Is.is(false));
        Assert.assertThat((Object)this.rule.includes(this.pathFactory.create(this.sourcePath, "e/g/h")), Is.is(false));
    }

    @Test
    public void shouldNotIncludeRepositoryPathsNotBelowPathInRepository() {
        Assert.assertThat((Object)this.rule.includes((Path)this.pathFactory.create("/m/n")), Is.is(false));
        Assert.assertThat((Object)this.rule.includes((Path)this.pathFactory.create("/x/y[3]")), Is.is(false));
    }

    @Test
    public void shouldProjectRepositoryPathIntoSourcePath() {
        Assert.assertThat((Object)this.rule.projectPathInRepositoryToPathInSource(this.repositoryPath, this.pathFactory), Is.is(this.sourcePath));
    }

    @Test
    public void shouldProjectPathBelowRepositoryPathIntoPathBelowSourcePath() {
        Path pathInRepository = this.pathFactory.create(this.repositoryPath, "m/n");
        Path pathInSource = this.pathFactory.create(this.sourcePath, "m/n");
        Assert.assertThat((Object)this.rule.projectPathInRepositoryToPathInSource(pathInRepository, this.pathFactory), Is.is(pathInSource));
        pathInRepository = this.pathFactory.create(this.repositoryPath, "m");
        pathInSource = this.pathFactory.create(this.sourcePath, "m");
        Assert.assertThat((Object)this.rule.projectPathInRepositoryToPathInSource(pathInRepository, this.pathFactory), Is.is(pathInSource));
        pathInRepository = this.pathFactory.create(this.repositoryPath, "m/n[3]");
        pathInSource = this.pathFactory.create(this.sourcePath, "m/n[3]");
        Assert.assertThat((Object)this.rule.projectPathInRepositoryToPathInSource(pathInRepository, this.pathFactory), Is.is(pathInSource));
    }

    @Test
    public void shouldProjectSourcePathIntoRepositoryPath() {
        Assert.assertThat((Object)this.rule.projectPathInSourceToPathInRepository(this.sourcePath, this.pathFactory), Is.is(this.repositoryPath));
    }

    @Test
    public void shouldProjectPathBelowSourcePathIntoPathBelowRepositoryPath() {
        Path pathInRepository = this.pathFactory.create(this.repositoryPath, "m/n");
        Path pathInSource = this.pathFactory.create(this.sourcePath, "m/n");
        Assert.assertThat((Object)this.rule.projectPathInSourceToPathInRepository(pathInSource, this.pathFactory), Is.is(pathInRepository));
        pathInRepository = this.pathFactory.create(this.repositoryPath, "m");
        pathInSource = this.pathFactory.create(this.sourcePath, "m");
        Assert.assertThat((Object)this.rule.projectPathInSourceToPathInRepository(pathInSource, this.pathFactory), Is.is(pathInRepository));
        pathInRepository = this.pathFactory.create(this.repositoryPath, "m/n[3]");
        pathInSource = this.pathFactory.create(this.sourcePath, "m/n[3]");
        Assert.assertThat((Object)this.rule.projectPathInSourceToPathInRepository(pathInSource, this.pathFactory), Is.is(pathInRepository));
    }

    @Test
    public void shouldGetPathsInRepositoryGivenPathsInSourceAtOrBelowSourcePathIfNotExcluded() {
        Assert.assertThat((Object)this.rule.getPathInRepository(this.sourcePath, this.pathFactory), Is.is(this.repositoryPath));
        this.assertThatGetPathInRepositoryReturnsCorrectPathInSource("");
        this.assertThatGetPathInRepositoryReturnsCorrectPathInSource("m/n");
        this.assertThatGetPathInRepositoryReturnsCorrectPathInSource("m[1]");
        this.assertThatGetPathInRepositoryReturnsCorrectPathInSource("m[1]/n/o/p");
    }

    protected void assertThatGetPathInRepositoryReturnsCorrectPathInSource(String subpath) {
        Assert.assertThat((Object)this.rule.getPathInRepository(this.pathFactory.create(this.sourcePath, subpath), this.pathFactory), Is.is(this.pathFactory.create(this.repositoryPath, subpath)));
    }

    @Test
    public void shouldGetNullPathInRepositoryGivenPathsInSourceAtOrBelowSourcePathIfExcluded() {
        Assert.assertThat((Object)this.rule.getPathInRepository(this.pathFactory.create(this.sourcePath, "e/f"), this.pathFactory), Is.is(IsNull.nullValue()));
        Assert.assertThat((Object)this.rule.getPathInRepository(this.pathFactory.create(this.sourcePath, "e/g"), this.pathFactory), Is.is(IsNull.nullValue()));
        Assert.assertThat((Object)this.rule.getPathInRepository(this.pathFactory.create(this.sourcePath, "e/f/h"), this.pathFactory), Is.is(IsNull.nullValue()));
        Assert.assertThat((Object)this.rule.getPathInRepository(this.pathFactory.create(this.sourcePath, "e/g/h"), this.pathFactory), Is.is(IsNull.nullValue()));
    }

    @Test
    public void shouldGetNullPathInRepositoryGivenPathsInRepositoryNotAtOrBelowSourcePath() {
        Assert.assertThat((Object)this.rule.getPathInRepository((Path)this.pathFactory.create("/m/n"), this.pathFactory), Is.is(IsNull.nullValue()));
    }

    @Test
    public void shouldGetPathsInSourceGivenPathsInRepositoryAtOrBelowRepositoryPathIfNotExcluded() {
        Assert.assertThat((Object)this.rule.getPathInSource(this.repositoryPath, this.pathFactory), Is.is(this.sourcePath));
        this.assertThatGetPathInSourceReturnsCorrectPathInRepository("");
        this.assertThatGetPathInSourceReturnsCorrectPathInRepository("m/n");
        this.assertThatGetPathInSourceReturnsCorrectPathInRepository("m[1]");
        this.assertThatGetPathInSourceReturnsCorrectPathInRepository("m[1]/n/o/p");
    }

    protected void assertThatGetPathInSourceReturnsCorrectPathInRepository(String subpath) {
        Assert.assertThat((Object)this.rule.getPathInSource(this.pathFactory.create(this.repositoryPath, subpath), this.pathFactory), Is.is(this.pathFactory.create(this.sourcePath, subpath)));
    }

    @Test
    public void shouldGetNullPathInSourceGivenPathsInRepositoryAtOrBelowRepositoryPathIfExcluded() {
        Assert.assertThat((Object)this.rule.getPathInSource(this.pathFactory.create(this.repositoryPath, "e/f"), this.pathFactory), Is.is(IsNull.nullValue()));
        Assert.assertThat((Object)this.rule.getPathInSource(this.pathFactory.create(this.repositoryPath, "e/g"), this.pathFactory), Is.is(IsNull.nullValue()));
        Assert.assertThat((Object)this.rule.getPathInSource(this.pathFactory.create(this.repositoryPath, "e/f/h"), this.pathFactory), Is.is(IsNull.nullValue()));
        Assert.assertThat((Object)this.rule.getPathInSource(this.pathFactory.create(this.repositoryPath, "e/g/h"), this.pathFactory), Is.is(IsNull.nullValue()));
    }

    @Test
    public void shouldGetNullPathInSourceGivenPathsInRepositoryNotAtOrBelowRepositoryPath() {
        Assert.assertThat((Object)this.rule.getPathInSource((Path)this.pathFactory.create("/m/n"), this.pathFactory), Is.is(IsNull.nullValue()));
    }

    @Test
    public void shouldConvertToString() {
        Assert.assertThat((Object)this.rule.getString(this.registry, this.encoder), Is.is("/a/b/c => /x/y $ e/f $ e/g"));
        this.repositoryPath = (Path)this.pathFactory.create("/a/b/c");
        this.sourcePath = (Path)this.pathFactory.create("/");
        this.rule = new Projection.PathRule(this.repositoryPath, this.sourcePath, this.validExceptions);
        Assert.assertThat((Object)this.rule.getString(this.registry, this.encoder), Is.is("/a/b/c => / $ e/f $ e/g"));
        this.repositoryPath = (Path)this.pathFactory.create("/");
        this.sourcePath = (Path)this.pathFactory.create("/");
        this.rule = new Projection.PathRule(this.repositoryPath, this.sourcePath, this.validExceptions);
        Assert.assertThat((Object)this.rule.getString(this.registry, this.encoder), Is.is("/ => / $ e/f $ e/g"));
    }

    @Test
    public void shouldHaveToString() {
        Assert.assertThat((Object)this.rule.toString(), Is.is("/{}a/{}b/{}c => /{}x/{}y $ {}e/{}f $ {}e/{}g"));
        this.repositoryPath = (Path)this.pathFactory.create("/a/b/c");
        this.sourcePath = (Path)this.pathFactory.create("/");
        this.rule = new Projection.PathRule(this.repositoryPath, this.sourcePath, this.validExceptions);
        Assert.assertThat((Object)this.rule.toString(), Is.is("/{}a/{}b/{}c => / $ {}e/{}f $ {}e/{}g"));
    }
}

