/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.inmemory;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.modeshape.common.util.Reflection;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.Location;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositoryContext;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.request.GetWorkspacesRequest;
import org.modeshape.graph.request.ReadNodeRequest;
import org.modeshape.graph.request.Request;

public class InMemoryRepositorySourceTest {
    private ExecutionContext context;
    private RepositoryContext repositoryContext;
    private InMemoryRepositorySource source;
    private String[] predefinedWorkspaces = new String[]{"foo", "bar", "baz"};

    @Before
    public void beforeEach() {
        this.context = new ExecutionContext();
        this.repositoryContext = (RepositoryContext)Mockito.mock(RepositoryContext.class);
        Mockito.when((Object)this.repositoryContext.getExecutionContext()).thenReturn((Object)this.context);
        this.source = new InMemoryRepositorySource();
        this.source.setName("In-Memory Repository Source");
        this.source.setPredefinedWorkspaceNames(this.predefinedWorkspaces);
        this.source.setDefaultWorkspaceName(this.predefinedWorkspaces[0]);
        this.source.initialize(this.repositoryContext);
    }

    public Location locationFor(String path) {
        return Location.create((Path)this.pathFor(path));
    }

    public Path pathFor(String path) {
        return (Path)this.context.getValueFactories().getPathFactory().create(path);
    }

    @Test
    public void shouldMakeAvailablePredefinedWorkspaces() {
        RepositoryConnection connection = this.source.getConnection();
        GetWorkspacesRequest request = new GetWorkspacesRequest();
        connection.execute(this.context, (Request)request);
        Set workspaces = request.getAvailableWorkspaceNames();
        HashSet<String> graphWorkspaces = new HashSet<String>(Arrays.asList(this.predefinedWorkspaces));
        Assert.assertThat((Object)workspaces, CoreMatchers.is(graphWorkspaces));
        for (String workspaceName : this.predefinedWorkspaces) {
            ReadNodeRequest readRoot = new ReadNodeRequest(this.locationFor("/"), workspaceName);
            connection.execute(this.context, (Request)readRoot);
            Assert.assertThat((Object)readRoot.getActualLocationOfNode().getPath(), CoreMatchers.is(this.pathFor("/")));
        }
    }

    @Test
    public void shouldHaveProperties() throws Exception {
        Reflection reflection = new Reflection(this.source.getClass());
        Reflection.Property property = reflection.getProperty((Object)this.source, "updatesAllowed");
        Assert.assertThat((Object)property.getDescription(), CoreMatchers.is(GraphI18n.updatesAllowedPropertyDescription.text(new Object[0])));
        Assert.assertThat((Object)property.getLabel(), CoreMatchers.is(GraphI18n.updatesAllowedPropertyLabel.text(new Object[0])));
        Assert.assertThat((Object)property.getCategory(), CoreMatchers.is(GraphI18n.updatesAllowedPropertyCategory.text(new Object[0])));
        Assert.assertThat((Object)property.getCategory(), CoreMatchers.is("Advanced"));
        Assert.assertThat((Object)property.isInferred(), CoreMatchers.is(false));
        Assert.assertThat((Object)property.isReadOnly(), CoreMatchers.is(true));
        Assert.assertThat((Object)property.isBooleanType(), CoreMatchers.is(true));
        property = reflection.getProperty((Object)this.source, "defaultCachePolicy");
        Assert.assertThat((Object)property.getDescription(), CoreMatchers.is(""));
        Assert.assertThat((Object)property.getLabel(), CoreMatchers.is("Default Cache Policy"));
        Assert.assertThat((Object)property.getCategory(), CoreMatchers.is(""));
        Assert.assertThat((Object)property.isInferred(), CoreMatchers.is(true));
        Assert.assertThat((Object)property.isReadOnly(), CoreMatchers.is(false));
        Assert.assertThat((Object)property.isBooleanType(), CoreMatchers.is(false));
        Map properties = reflection.getAllPropertiesByNameOn((Object)this.source);
        Assert.assertThat((Object)properties.containsKey("name"), CoreMatchers.is(true));
        Assert.assertThat((Object)properties.containsKey("jndiName"), CoreMatchers.is(true));
        Assert.assertThat((Object)properties.containsKey("defaultWorkspaceName"), CoreMatchers.is(true));
        Assert.assertThat((Object)properties.containsKey("predefinedWorkspaceNames"), CoreMatchers.is(true));
        Assert.assertThat((Object)properties.containsKey("updatesAllowed"), CoreMatchers.is(true));
        Assert.assertThat((Object)properties.containsKey("defaultCachePolicy"), CoreMatchers.is(true));
    }
}

