/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.test;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.modeshape.common.statistic.Stopwatch;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.Location;
import org.modeshape.graph.ModeShapeLexicon;
import org.modeshape.graph.Node;
import org.modeshape.graph.Subgraph;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositoryConnectionFactory;
import org.modeshape.graph.connector.RepositoryContext;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.observe.Changes;
import org.modeshape.graph.observe.Observer;
import org.modeshape.graph.property.DateTime;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.request.CollectGarbageRequest;
import org.modeshape.graph.request.Request;

public abstract class AbstractConnectorTest {
    protected ExecutionContext context;
    protected RepositorySource source;
    protected Graph graph;
    protected RepositorySource configSource;
    private RepositoryConnectionFactory connectionFactory;
    private List<RepositoryConnection> openConnections;
    private boolean running;
    private Location rootLocation;
    private UUID rootUuid;
    protected Observer observer;
    protected LinkedList<Changes> allChanges;
    protected boolean print = false;
    protected boolean useLargeValues = false;
    protected boolean useUniqueLargeValues = false;
    protected PrintStream output = null;
    protected long largeValueCounter = 0L;

    public void startRepository() throws Exception {
        if (!this.running) {
            this.context = this.setUpExecutionContext(new ExecutionContext());
            this.configSource = this.setUpConfigurationSource();
            this.allChanges = new LinkedList();
            this.observer = new Observer(){

                public void notify(Changes changes) {
                    AbstractConnectorTest.this.allChanges.add(changes);
                }
            };
            this.source = this.setUpSource();
            this.openConnections = new ArrayList<RepositoryConnection>();
            this.connectionFactory = new RepositoryConnectionFactory(){

                public RepositoryConnection createConnection(String sourceName) throws RepositorySourceException {
                    if (!AbstractConnectorTest.this.source.getName().equals(sourceName)) {
                        return null;
                    }
                    RepositoryConnection connection = AbstractConnectorTest.this.source.getConnection();
                    if (connection == null) {
                        throw new RepositorySourceException("Unable to create a repository connection to " + AbstractConnectorTest.this.source.getName());
                    }
                    AbstractConnectorTest.this.openConnections.add(connection);
                    return connection;
                }
            };
            this.source.initialize(new RepositoryContext(){

                public ExecutionContext getExecutionContext() {
                    return AbstractConnectorTest.this.context;
                }

                public RepositoryConnectionFactory getRepositoryConnectionFactory() {
                    return AbstractConnectorTest.this.connectionFactory;
                }

                public Observer getObserver() {
                    return AbstractConnectorTest.this.observer;
                }

                public Subgraph getConfiguration(int depth) {
                    Subgraph result = null;
                    if (AbstractConnectorTest.this.configSource != null) {
                        Graph config = Graph.create((RepositorySource)AbstractConnectorTest.this.configSource, (ExecutionContext)this.getExecutionContext());
                        config.useWorkspace(null);
                        result = (Subgraph)config.getSubgraphOfDepth(depth).at(AbstractConnectorTest.this.source.getName());
                    }
                    return result;
                }
            });
            this.graph = Graph.create((String)this.source.getName(), (RepositoryConnectionFactory)this.connectionFactory, (ExecutionContext)this.context);
            this.initializeContent(this.graph);
            this.running = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownRepository() throws Exception {
        if (this.running) {
            try {
                for (RepositoryConnection connection : this.openConnections) {
                    connection.close();
                }
            }
            finally {
                this.openConnections = null;
                this.running = false;
                this.rootLocation = null;
                this.rootUuid = null;
            }
        }
        if (this.source != null) {
            try {
                this.source.close();
            }
            finally {
                this.source = null;
            }
        }
        this.graph = null;
        this.context = null;
        this.configSource = null;
        this.connectionFactory = null;
    }

    @Before
    public void beforeEach() throws Exception {
        this.print = false;
        this.startRepository();
    }

    @After
    public void afterEach() throws Exception {
        this.shutdownRepository();
        this.cleanUpSourceResources();
    }

    @AfterClass
    public static void afterAll() throws Exception {
    }

    protected ExecutionContext setUpExecutionContext(ExecutionContext context) {
        return context;
    }

    protected RepositorySource setUpConfigurationSource() throws Exception {
        return null;
    }

    protected abstract RepositorySource setUpSource() throws Exception;

    protected void cleanUpSourceResources() throws Exception {
    }

    protected abstract void initializeContent(Graph var1) throws Exception;

    protected Name name(String name) {
        return (Name)this.context.getValueFactories().getNameFactory().create(name);
    }

    protected Path.Segment segment(String name) {
        return this.context.getValueFactories().getPathFactory().createSegment(name);
    }

    protected Path path(String path) {
        return (Path)this.context.getValueFactories().getPathFactory().create(path);
    }

    protected Path path(String parentPath, String subPath) {
        return this.path(this.path(parentPath), subPath);
    }

    protected Path path(Path parentPath, String subPath) {
        return this.context.getValueFactories().getPathFactory().create(parentPath, subPath);
    }

    protected Location location(String path) {
        return Location.create((Path)this.path(path));
    }

    protected Location location(UUID uuid) {
        return Location.create((UUID)uuid);
    }

    protected UUID getRootNodeUuid() {
        if (this.rootUuid == null) {
            Property uuid;
            Node root = this.graph.getNodeAt("/");
            this.rootLocation = root.getLocation();
            this.rootUuid = this.rootLocation.getUuid();
            if (this.rootUuid == null && (uuid = root.getProperty(ModeShapeLexicon.UUID)) != null) {
                this.rootUuid = (UUID)this.context.getValueFactories().getUuidFactory().create(uuid.getFirstValue());
            }
            if (this.rootUuid == null && (uuid = root.getProperty(JcrLexicon.UUID)) != null) {
                this.rootUuid = (UUID)this.context.getValueFactories().getUuidFactory().create(uuid.getFirstValue());
            }
        }
        return this.rootUuid;
    }

    protected String string(Object value) {
        if (value instanceof Property) {
            value = ((Property)value).getFirstValue();
        }
        return (String)this.context.getValueFactories().getStringFactory().create(value);
    }

    protected DateTime date(Object value) {
        if (value instanceof Property) {
            value = ((Property)value).getFirstValue();
        }
        return (DateTime)this.context.getValueFactories().getDateFactory().create(value);
    }

    protected long longValue(Object value) {
        if (value instanceof Property) {
            value = ((Property)value).getFirstValue();
        }
        return (Long)this.context.getValueFactories().getLongFactory().create(value);
    }

    protected Name name(Object value) {
        if (value instanceof Property) {
            value = ((Property)value).getFirstValue();
        }
        return (Name)this.context.getValueFactories().getNameFactory().create(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T extends Request> T execute(T request) {
        RepositoryConnection connection = this.connectionFactory.createConnection(this.source.getName());
        try {
            connection.execute(this.context, request);
        }
        finally {
            connection.close();
        }
        if (request.hasError()) {
            Throwable error = request.getError();
            if (error instanceof RuntimeException) {
                throw (RuntimeException)error;
            }
            throw new RepositorySourceException(this.source.getName(), error);
        }
        return request;
    }

    public Node readNodeThoroughly(Location location) {
        Assert.assertThat((Object)location, Is.is(IsNull.notNullValue()));
        Node result = null;
        if (location.hasPath() && location.hasIdProperties()) {
            result = this.graph.getNodeAt(location);
            Node resultByPath = this.graph.getNodeAt(location.getPath());
            AbstractConnectorTest.assertSameNode(resultByPath, result);
            if (location.hasIdProperties()) {
                Node resultByIdProps = this.graph.getNodeAt((Iterable)location.getIdProperties());
                AbstractConnectorTest.assertSameNode(resultByIdProps, result);
            }
            Assert.assertThat((String)"The node that was read doesn't have the expected location", (Object)result.getLocation(), Is.is(location));
        } else {
            result = this.graph.getNodeAt(location);
            Assert.assertThat((String)"The node that was read doesn't have the expected location", (Object)result.getLocation().equals((Object)location), Is.is(true));
        }
        AbstractConnectorTest.assertSameProperties(result, (Iterable)this.graph.getProperties().on(location));
        Assert.assertThat((Object)this.graph.getChildren().of(location), Is.is(result.getChildren()));
        return result;
    }

    protected int createSubgraph(Graph graph, String initialPath, int depth, int numberOfChildrenPerNode, int numberOfPropertiesPerNode, boolean oneBatch, Stopwatch stopwatch) {
        return this.createSubgraph(graph, initialPath, depth, numberOfChildrenPerNode, numberOfPropertiesPerNode, oneBatch, stopwatch, null, null);
    }

    protected int createSubgraph(Graph graph, String initialPath, int depth, int numberOfChildrenPerNode, int numberOfPropertiesPerNode, boolean oneBatch, Stopwatch stopwatch, PrintStream output, String description) {
        Graph.Batch batch;
        long totalNumber = this.calculateTotalNumberOfNodesInTree(numberOfChildrenPerNode, depth, false);
        if (initialPath == null) {
            initialPath = "";
        }
        if (description == null) {
            description = "" + numberOfChildrenPerNode + "x" + depth + " tree with " + numberOfPropertiesPerNode + " properties per node";
        }
        if (output != null) {
            output.println(description + " (" + totalNumber + " nodes):");
        }
        long totalNumberCreated = 0L;
        Graph.Batch batch2 = batch = oneBatch ? graph.batch() : null;
        if (batch != null) {
            totalNumberCreated += (long)this.createChildren(batch, initialPath, "node", numberOfChildrenPerNode, numberOfPropertiesPerNode, depth, null);
            if (stopwatch != null) {
                stopwatch.start();
            }
            batch.execute();
        } else {
            if (stopwatch != null) {
                stopwatch.start();
            }
            totalNumberCreated += (long)this.createChildren(null, initialPath, "node", numberOfChildrenPerNode, numberOfPropertiesPerNode, depth, null);
        }
        if (stopwatch != null) {
            stopwatch.stop();
            if (output != null) {
                output.println("    " + this.getTotalAndAverageDuration(stopwatch, totalNumberCreated));
            }
            batch = graph.batch();
            totalNumberCreated += (long)this.createChildren(batch, initialPath, "secondBranch", 2, numberOfPropertiesPerNode, 2, null);
            Stopwatch sw = new Stopwatch();
            sw.start();
            batch.execute();
            sw.stop();
            this.print("     final " + this.getTotalAndAverageDuration(sw, totalNumberCreated));
            Assert.assertThat((Object)totalNumberCreated, Is.is(totalNumber + (long)this.calculateTotalNumberOfNodesInTree(2, 2, false)));
        }
        return (int)totalNumberCreated;
    }

    protected void print(String msg) {
        if (this.print) {
            System.out.println(msg);
        }
    }

    protected String getTotalAndAverageDuration(Stopwatch stopwatch, long numNodes) {
        long totalDurationInMilliseconds = TimeUnit.NANOSECONDS.toMillis(stopwatch.getTotalDuration().longValue());
        long avgDuration = totalDurationInMilliseconds / numNodes;
        String units = " millisecond(s)";
        if (avgDuration < 1L) {
            long totalDurationInMicroseconds = TimeUnit.NANOSECONDS.toMicros(stopwatch.getTotalDuration().longValue());
            avgDuration = totalDurationInMicroseconds / numNodes;
            units = " microsecond(s)";
        }
        return "total = " + stopwatch.getTotalDuration() + "; avg = " + avgDuration + units;
    }

    protected int createChildren(Graph.Batch useBatch, String parentPath, String nodePrefix, int number, int numProps, int depthRemaining, PrintWriter output) {
        String path;
        int i;
        int numberCreated = 0;
        Graph.Batch batch = useBatch;
        String originalValue = "The quick brown fox jumped over the moon. What? ";
        if (batch == null) {
            batch = this.graph.batch();
        }
        for (i = 0; i != number; ++i) {
            path = parentPath + "/" + nodePrefix + (i + 1);
            Graph.Create create = batch.create(path);
            String value = originalValue;
            for (int j = 0; j != numProps; ++j) {
                if ((this.useLargeValues || this.useUniqueLargeValues) && i % 3 == 0) {
                    String largeValue = originalValue;
                    for (int k = 0; k != 100; ++k) {
                        largeValue = largeValue + "(" + k + ")";
                    }
                    if (this.useUniqueLargeValues) {
                        largeValue = "" + ++this.largeValueCounter + largeValue;
                    }
                    create = create.with("property" + (j + 1), new Object[]{largeValue});
                    continue;
                }
                create = create.with("property" + (j + 1), new Object[]{value});
            }
            create.and();
        }
        numberCreated += number;
        if (useBatch == null) {
            batch.execute();
            if (output != null) {
                output.println("         total created ... " + numberCreated);
            }
        }
        if (depthRemaining > 1) {
            for (i = 0; i != number; ++i) {
                path = parentPath + "/" + nodePrefix + (i + 1);
                numberCreated += this.createChildren(useBatch, path, nodePrefix, number, numProps, depthRemaining - 1, null);
                if (output == null) continue;
                output.println("         total created ... " + numberCreated);
            }
        }
        return numberCreated;
    }

    protected int calculateTotalNumberOfNodesInTree(int numberOfChildrenPerNode, int depth, boolean countRoot) {
        assert (depth > 0);
        assert (numberOfChildrenPerNode > 0);
        int totalNumber = 0;
        for (int i = 0; i <= depth; ++i) {
            totalNumber += (int)Math.pow(numberOfChildrenPerNode, i);
        }
        return countRoot ? totalNumber : totalNumber - 1;
    }

    public static void assertEquivalentSubgraphs(Subgraph subgraph1, Subgraph subgraph2, boolean idPropertiesShouldMatch, boolean pathsShouldMatch) {
        Assert.assertThat((Object)subgraph1, Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)subgraph2, Is.is(IsNull.notNullValue()));
        if (subgraph1.getLocation().isSame(subgraph2.getLocation())) {
            return;
        }
        Path rootPath1 = subgraph1.getRoot().getLocation().getPath();
        Path rootPath2 = subgraph2.getRoot().getLocation().getPath();
        Iterator iter1 = subgraph1.iterator();
        Iterator iter2 = subgraph2.iterator();
        while (iter1.hasNext() && iter2.hasNext()) {
            Node node1 = (Node)iter1.next();
            Node node2 = (Node)iter2.next();
            Assert.assertThat((Object)node1, Is.is(IsNull.notNullValue()));
            Assert.assertThat((Object)node2, Is.is(IsNull.notNullValue()));
            Assert.assertThat((Object)node1.getLocation().hasPath(), Is.is(true));
            Assert.assertThat((Object)node2.getLocation().hasPath(), Is.is(true));
            if (pathsShouldMatch) {
                Assert.assertThat((Object)node1.getLocation().getPath(), Is.is(node2.getLocation().getPath()));
            } else {
                Path relativeNode1 = node1.getLocation().getPath().relativeTo(rootPath1);
                Path relativeNode2 = node2.getLocation().getPath().relativeTo(rootPath2);
                Assert.assertThat((Object)relativeNode1, Is.is(relativeNode2));
            }
            if (idPropertiesShouldMatch) {
                Assert.assertThat((Object)node1.getLocation().getIdProperties(), Is.is(node2.getLocation().getIdProperties()));
            }
            HashMap properties1 = new HashMap(node1.getPropertiesByName());
            HashMap properties2 = new HashMap(node2.getPropertiesByName());
            if (!idPropertiesShouldMatch) {
                for (Property idProperty : node1.getLocation().getIdProperties()) {
                    properties1.remove(idProperty.getName());
                }
                for (Property idProperty : node2.getLocation().getIdProperties()) {
                    properties2.remove(idProperty.getName());
                }
            }
            Assert.assertThat(properties1, Is.is(properties2));
            Assert.assertThat((Object)node1.getChildrenSegments(), Is.is(node2.getChildrenSegments()));
        }
        Assert.assertThat((Object)iter1.hasNext(), Is.is(false));
        Assert.assertThat((Object)iter2.hasNext(), Is.is(false));
    }

    public static void assertSameNode(Node node1, Node node2) {
        Assert.assertThat((Object)node1, Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)node2, Is.is(IsNull.notNullValue()));
        Location location1 = node1.getLocation();
        Location location2 = node2.getLocation();
        Assert.assertThat((Object)location1.isSame(location2), Is.is(true));
        Assert.assertThat((Object)location1.getPath(), Is.is(location2.getPath()));
        Assert.assertThat((Object)location1.getIdProperties(), Is.is(location2.getIdProperties()));
        Assert.assertThat((Object)node1.getChildren(), Is.is(node2.getChildren()));
        Assert.assertThat((Object)node1.getChildrenSegments(), Is.is(node2.getChildrenSegments()));
    }

    public static void assertSameProperties(Node node, Map<Name, Property> properties) {
        Assert.assertThat((Object)node, Is.is(IsNull.notNullValue()));
        Assert.assertThat(properties, Is.is(IsNull.notNullValue()));
        HashSet<Name> names = new HashSet<Name>(properties.keySet());
        for (Property prop1 : node.getProperties()) {
            Name name = prop1.getName();
            Assert.assertThat((Object)names.remove(name), Is.is(true));
            Assert.assertThat((Object)prop1, Is.is(properties.get(name)));
        }
        Assert.assertThat((Object)names.isEmpty(), Is.is(true));
    }

    public static void assertSameProperties(Node node, Iterable<Property> properties) {
        Assert.assertThat((Object)node, Is.is(IsNull.notNullValue()));
        Assert.assertThat(properties, Is.is(IsNull.notNullValue()));
        HashSet names = new HashSet(node.getPropertiesByName().keySet());
        for (Property prop1 : properties) {
            Name name = prop1.getName();
            Assert.assertThat((Object)names.remove(name), Is.is(true));
            Assert.assertThat((Object)prop1, Is.is(node.getProperty(name)));
        }
        Assert.assertThat((Object)names.isEmpty(), Is.is(true));
    }

    public Path findPathToNonExistentNodeUnder(String pathToExistingParent) {
        return this.findPathToNonExistentNodeUnder(this.path(pathToExistingParent));
    }

    public Path findPathToNonExistentNodeUnder(Path pathToExistingParent) {
        String nonExistentChildName = "ab39dbyfg739_adf7bg";
        boolean verifiedNoChildWithName = false;
        block0: while (!verifiedNoChildWithName) {
            verifiedNoChildWithName = true;
            for (Location childLocation : (List)this.graph.getChildren().of(pathToExistingParent)) {
                if (!childLocation.getPath().getLastSegment().getName().getLocalName().equals(nonExistentChildName)) continue;
                nonExistentChildName = nonExistentChildName + '2' + nonExistentChildName;
                verifiedNoChildWithName = false;
                continue block0;
            }
        }
        return this.path(pathToExistingParent, nonExistentChildName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void collectGarbage(int maxNumberOfPasses) {
        RepositoryConnection connection = this.connectionFactory.createConnection(this.source.getName());
        try {
            for (int i = 0; i != maxNumberOfPasses; ++i) {
                CollectGarbageRequest request = new CollectGarbageRequest();
                connection.execute(this.context, (Request)request);
                if (request.isAdditionalPassRequired()) continue;
                break;
            }
        }
        finally {
            connection.close();
        }
    }
}

