/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.test;

import java.io.InputStream;
import java.util.UUID;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.FixFor;
import org.modeshape.common.statistic.Stopwatch;
import org.modeshape.common.util.IoUtil;
import org.modeshape.graph.Graph;
import org.modeshape.graph.IsNodeWithChildren;
import org.modeshape.graph.IsNodeWithProperty;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.ModeShapeLexicon;
import org.modeshape.graph.Node;
import org.modeshape.graph.Subgraph;
import org.modeshape.graph.SubgraphNode;
import org.modeshape.graph.connector.UuidAlreadyExistsException;
import org.modeshape.graph.connector.test.AbstractConnectorTest;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathNotFoundException;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.PropertyFactory;
import org.modeshape.graph.property.Reference;

public abstract class WritableConnectorTest
extends AbstractConnectorTest {
    protected String[] validLargeValues;

    @Override
    @Before
    public void beforeEach() throws Exception {
        super.beforeEach();
        this.validLargeValues = new String[]{IoUtil.read((InputStream)this.getClass().getClassLoader().getResourceAsStream("LoremIpsum1.txt")), IoUtil.read((InputStream)this.getClass().getClassLoader().getResourceAsStream("LoremIpsum2.txt")), IoUtil.read((InputStream)this.getClass().getClassLoader().getResourceAsStream("LoremIpsum3.txt"))};
    }

    @Override
    @After
    public void afterEach() throws Exception {
        super.afterEach();
    }

    @Test
    public void shouldHaveUpdateCapabilities() {
        Assert.assertThat((Object)this.source.getCapabilities().supportsUpdates(), Is.is(true));
    }

    @Test
    public void shouldSetPropertyOnRootNode() {
        ((Graph.On)this.graph.set("propA").to("valueA")).on("/");
        Node root = this.graph.getNodeAt("/");
        Assert.assertThat((Object)root, Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)root, (Matcher)((Object)IsNodeWithProperty.hasProperty(ModeShapeLexicon.UUID, this.getRootNodeUuid())));
        Assert.assertThat((Object)root, (Matcher)((Object)IsNodeWithProperty.hasProperty("propA", "valueA")));
    }

    @Test
    public void shouldAddChildUnderRootNode() {
        ((Graph.Batch)this.graph.batch().create("/a").with("propB", new Object[]{"valueB"}).and("propC", new Object[]{"valueC"}).and()).execute();
        Node root = this.graph.getNodeAt("/");
        Assert.assertThat((Object)root, Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)root, (Matcher)((Object)IsNodeWithProperty.hasProperty(ModeShapeLexicon.UUID, this.getRootNodeUuid())));
        Assert.assertThat((Object)root.getChildren(), (Matcher)((Object)IsNodeWithChildren.hasChild(this.segment("a"))));
        Node nodeA = this.graph.getNodeAt("/a");
        Assert.assertThat((Object)nodeA, Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)nodeA, (Matcher)((Object)IsNodeWithProperty.hasProperty("propB", "valueB")));
        Assert.assertThat((Object)nodeA, (Matcher)((Object)IsNodeWithProperty.hasProperty("propC", "valueC")));
        Assert.assertThat((Object)nodeA.getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
    }

    @Test
    public void shouldAddChildrenAndSettingProperties() {
        ((Graph.Batch)((Graph.Batch)((Graph.Batch)((Graph.BatchConjunction)((Graph.On)this.graph.batch().set("propA").to("valueA")).on("/")).and()).create("/a").with("propB", new Object[]{"valueB"}).and("propC", new Object[]{"valueC"}).and()).create("/b").with("propD", new Object[]{"valueD"}).and("propE", new Object[]{"valueE"}).and()).execute();
        Node root = this.graph.getNodeAt("/");
        Assert.assertThat((Object)root, Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)root, (Matcher)((Object)IsNodeWithProperty.hasProperty(ModeShapeLexicon.UUID, this.getRootNodeUuid())));
        Assert.assertThat((Object)root, (Matcher)((Object)IsNodeWithProperty.hasProperty("propA", "valueA")));
        Assert.assertThat((Object)root.getChildren(), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("a"), this.segment("b"))));
        Node nodeA = this.graph.getNodeAt("/a");
        Assert.assertThat((Object)nodeA, Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)nodeA, (Matcher)((Object)IsNodeWithProperty.hasProperty("propB", "valueB")));
        Assert.assertThat((Object)nodeA, (Matcher)((Object)IsNodeWithProperty.hasProperty("propC", "valueC")));
        Assert.assertThat((Object)nodeA.getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
        Node nodeB = this.graph.getNodeAt("/b");
        Assert.assertThat((Object)nodeB, Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)nodeB, (Matcher)((Object)IsNodeWithProperty.hasProperty("propD", "valueD")));
        Assert.assertThat((Object)nodeB, (Matcher)((Object)IsNodeWithProperty.hasProperty("propE", "valueE")));
        Assert.assertThat((Object)nodeB.getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
        Subgraph subgraph = (Subgraph)this.graph.getSubgraphOfDepth(3).at("/");
        Assert.assertThat((Object)subgraph, Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)subgraph.getNode("."), (Matcher)((Object)IsNodeWithProperty.hasProperty(ModeShapeLexicon.UUID, this.getRootNodeUuid())));
        Assert.assertThat((Object)subgraph.getNode("."), (Matcher)((Object)IsNodeWithProperty.hasProperty("propA", "valueA")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode(".")).getChildren(), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("a"), this.segment("b"))));
        Assert.assertThat((Object)subgraph.getNode("a"), Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)subgraph.getNode("a"), (Matcher)((Object)IsNodeWithProperty.hasProperty("propB", "valueB")));
        Assert.assertThat((Object)subgraph.getNode("a"), (Matcher)((Object)IsNodeWithProperty.hasProperty("propC", "valueC")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("a")).getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
        Assert.assertThat((Object)subgraph.getNode("b"), Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)subgraph.getNode("b"), (Matcher)((Object)IsNodeWithProperty.hasProperty("propD", "valueD")));
        Assert.assertThat((Object)subgraph.getNode("b"), (Matcher)((Object)IsNodeWithProperty.hasProperty("propE", "valueE")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("b")).getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
    }

    @Test
    public void shouldStoreManyPropertiesOnANode() {
        Graph.Create create = this.graph.batch().create("/a");
        for (int i = 0; i != 100; ++i) {
            create = create.with("property" + i, new Object[]{"value" + i});
        }
        ((Graph.Batch)create.and()).execute();
        Node nodeA = this.graph.getNodeAt("/a");
        Assert.assertThat((Object)nodeA, Is.is(IsNull.notNullValue()));
        for (int i = 0; i != 100; ++i) {
            Assert.assertThat((Object)nodeA, (Matcher)((Object)IsNodeWithProperty.hasProperty("property" + i, "value" + i)));
        }
        Assert.assertThat((Object)nodeA.getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
    }

    @Test
    public void shouldUpdateSmallPropertiesOnANode() {
        Graph.Create create = this.graph.batch().create("/a");
        for (int i = 0; i != 10; ++i) {
            create = create.with("property" + i, new Object[]{"value" + i});
        }
        ((Graph.Batch)create.and()).execute();
        Node nodeA = this.graph.getNodeAt("/a");
        Assert.assertThat((Object)nodeA, Is.is(IsNull.notNullValue()));
        for (int i = 0; i != 10; ++i) {
            Assert.assertThat((Object)nodeA, (Matcher)((Object)IsNodeWithProperty.hasProperty("property" + i, "value" + i)));
        }
        Assert.assertThat((Object)nodeA.getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
        Graph.Batch batch = this.graph.batch();
        batch.remove(new String[]{"property0", "property1"}).on("/a");
        ((Graph.On)batch.set("property6").to("new valid 6")).on("/a");
        batch.execute();
        nodeA = this.graph.getNodeAt("/a");
        Assert.assertThat((Object)nodeA, Is.is(IsNull.notNullValue()));
        for (int i = 0; i != 10; ++i) {
            if (i == 0 || i == 1) continue;
            if (i == 6) {
                Assert.assertThat((Object)nodeA, (Matcher)((Object)IsNodeWithProperty.hasProperty("property" + i, "new valid 6")));
                continue;
            }
            Assert.assertThat((Object)nodeA, (Matcher)((Object)IsNodeWithProperty.hasProperty("property" + i, "value" + i)));
        }
        Assert.assertThat((Object)nodeA.getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
    }

    @Test
    public void shouldUpdateLargePropertiesOnANode() {
        Graph.Create create = this.graph.batch().create("/a");
        for (int i = 0; i != 100; ++i) {
            create = create.with("property" + i, new Object[]{"value" + i});
        }
        create = create.with("largeProperty1", new Object[]{this.validLargeValues[0]});
        create = create.with("largeProperty2", new Object[]{this.validLargeValues[1]});
        ((Graph.Batch)create.and()).execute();
        Node nodeA = this.graph.getNodeAt("/a");
        Assert.assertThat((Object)nodeA, Is.is(IsNull.notNullValue()));
        for (int i = 0; i != 100; ++i) {
            Assert.assertThat((Object)nodeA, (Matcher)((Object)IsNodeWithProperty.hasProperty("property" + i, "value" + i)));
        }
        Assert.assertThat((Object)nodeA, (Matcher)((Object)IsNodeWithProperty.hasProperty("largeProperty1", this.validLargeValues[0])));
        Assert.assertThat((Object)nodeA, (Matcher)((Object)IsNodeWithProperty.hasProperty("largeProperty2", this.validLargeValues[1])));
        Assert.assertThat((Object)nodeA.getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
        Graph.Batch batch = this.graph.batch();
        batch.remove(new String[]{"largeProperty1", "property0", "property1"}).on("/a");
        ((Graph.On)batch.set("property50").to("new valid 50")).on("/a");
        ((Graph.On)batch.set("largeProperty3").to(this.validLargeValues[2])).on("/a");
        batch.execute();
        nodeA = this.graph.getNodeAt("/a");
        Assert.assertThat((Object)nodeA, Is.is(IsNull.notNullValue()));
        for (int i = 0; i != 100; ++i) {
            if (i == 0 || i == 1) continue;
            if (i == 50) {
                Assert.assertThat((Object)nodeA, (Matcher)((Object)IsNodeWithProperty.hasProperty("property" + i, "new valid 50")));
                continue;
            }
            Assert.assertThat((Object)nodeA, (Matcher)((Object)IsNodeWithProperty.hasProperty("property" + i, "value" + i)));
        }
        Assert.assertThat((Object)nodeA, (Matcher)((Object)IsNodeWithProperty.hasProperty("largeProperty2", this.validLargeValues[1])));
        Assert.assertThat((Object)nodeA, (Matcher)((Object)IsNodeWithProperty.hasProperty("largeProperty3", this.validLargeValues[2])));
        Assert.assertThat((Object)nodeA.getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
    }

    @Test
    public void shouldCreateDeepBranchUsingIndividualRequests() {
        String initialPath = "";
        int depth = 50;
        int numChildrenPerNode = 1;
        int numPropertiesPerNode = 7;
        Stopwatch sw = new Stopwatch();
        boolean batch = false;
        String description = "deep and narrow tree, 1x50";
        this.createSubgraph(this.graph, initialPath, depth, numChildrenPerNode, numPropertiesPerNode, batch, sw, this.output, description);
    }

    @Test
    public void shouldCreateDeepBranchUsingOneBatch() {
        String initialPath = "";
        int depth = 50;
        int numChildrenPerNode = 1;
        int numPropertiesPerNode = 7;
        Stopwatch sw = new Stopwatch();
        boolean batch = true;
        String description = "deep and narrow tree, 1x50";
        this.createSubgraph(this.graph, initialPath, depth, numChildrenPerNode, numPropertiesPerNode, batch, sw, this.output, description);
    }

    @Test
    public void shouldCreateFlatAndWideTreeUsingOneBatch() {
        String initialPath = "";
        int depth = 1;
        int numChildrenPerNode = 300;
        int numPropertiesPerNode = 7;
        Stopwatch sw = new Stopwatch();
        boolean batch = true;
        this.createSubgraph(this.graph, initialPath, depth, numChildrenPerNode, numPropertiesPerNode, batch, sw, this.output, null);
    }

    @Test
    public void shouldCreateBinaryTreeUsingOneBatch() {
        String initialPath = "";
        int depth = 8;
        int numChildrenPerNode = 2;
        int numPropertiesPerNode = 7;
        Stopwatch sw = new Stopwatch();
        boolean batch = true;
        String description = "binary tree, 2x8";
        this.createSubgraph(this.graph, initialPath, depth, numChildrenPerNode, numPropertiesPerNode, batch, sw, this.output, description);
    }

    @Test
    public void shouldCreateTreeWith10ChildrenAnd2LevelsDeepUsingIndividualRequests() {
        String initialPath = "";
        int depth = 2;
        int numChildrenPerNode = 10;
        int numPropertiesPerNode = 7;
        Stopwatch sw = new Stopwatch();
        boolean batch = false;
        this.createSubgraph(this.graph, initialPath, depth, numChildrenPerNode, numPropertiesPerNode, batch, sw, this.output, null);
    }

    @Test
    public void shouldCreateTreeWith10ChildrenAnd2LevelsDeepUsingOneBatch() {
        String initialPath = "";
        int depth = 2;
        int numChildrenPerNode = 10;
        int numPropertiesPerNode = 7;
        Stopwatch sw = new Stopwatch();
        boolean batch = true;
        this.createSubgraph(this.graph, initialPath, depth, numChildrenPerNode, numPropertiesPerNode, batch, sw, this.output, null);
    }

    @Test
    public void shouldCreateTreeWith10ChildrenAnd3LevelsDeepUsingOneBatch() {
        String initialPath = "";
        int depth = 3;
        int numChildrenPerNode = 10;
        int numPropertiesPerNode = 7;
        Stopwatch sw = new Stopwatch();
        boolean batch = true;
        this.createSubgraph(this.graph, initialPath, depth, numChildrenPerNode, numPropertiesPerNode, batch, sw, this.output, null);
    }

    @Test
    public void shouldCreateAndReadTree() {
        String initialPath = "";
        int depth = 3;
        int numChildrenPerNode = 3;
        int numPropertiesPerNode = 3;
        Stopwatch sw = new Stopwatch();
        boolean batch = true;
        this.createSubgraph(this.graph, initialPath, depth, numChildrenPerNode, numPropertiesPerNode, batch, sw, this.output, null);
        Assert.assertThat((Object)this.graph.getChildren().of("/node1"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node1/node1"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node1/node2"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node1/node3"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node1/node3/node1"), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
        Assert.assertThat((Object)this.graph.getChildren().of("/node2"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node2/node1"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node2/node2"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node2/node3"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node2/node3/node1"), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
        Assert.assertThat((Object)this.graph.getChildren().of("/node3"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node3/node1"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node3/node2"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node3/node3"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node3/node3/node1"), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
        Subgraph subgraph = (Subgraph)this.graph.getSubgraphOfDepth(2).at("/node3/node2");
        Assert.assertThat((Object)subgraph, Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode(".")).getChildren(), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)subgraph.getNode("."), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("."), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("."), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("node1")).getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
        Assert.assertThat((Object)subgraph.getNode("node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("node2")).getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
        Assert.assertThat((Object)subgraph.getNode("node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("node3")).getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
        Assert.assertThat((Object)subgraph.getNode("node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        subgraph = (Subgraph)this.graph.getSubgraphOfDepth(2).at("/node3");
        Assert.assertThat((Object)subgraph, Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode(".")).getChildren(), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)subgraph.getNode("."), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("."), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("."), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("node1")).getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
        Assert.assertThat((Object)subgraph.getNode("node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("node2")).getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
        Assert.assertThat((Object)subgraph.getNode("node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("node3")).getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
        Assert.assertThat((Object)subgraph.getNode("node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
    }

    @Test
    public void shouldDeleteNodes() {
        String initialPath = "";
        int depth = 3;
        int numChildrenPerNode = 3;
        int numPropertiesPerNode = 3;
        Stopwatch sw = new Stopwatch();
        boolean batch = true;
        this.createSubgraph(this.graph, initialPath, depth, numChildrenPerNode, numPropertiesPerNode, batch, sw, this.output, null);
        ((Graph)this.graph.delete("/node2/node2").and()).delete("/node3/node1");
        Assert.assertThat((Object)this.graph.getChildren().of("/node1"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node1/node1"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node1/node2"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node1/node3"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node1/node3/node1"), (Matcher)((Object)IsNodeWithChildren.hasChildren(new Path.Segment[0])));
        Assert.assertThat((Object)this.graph.getChildren().of("/node2"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node2/node1"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node2/node3"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node2/node3/node1"), (Matcher)((Object)IsNodeWithChildren.hasChildren(new Path.Segment[0])));
        Assert.assertThat((Object)this.graph.getChildren().of("/node3"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node3/node2"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node3/node3"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node3/node3/node1"), (Matcher)((Object)IsNodeWithChildren.hasChildren(new Path.Segment[0])));
        Subgraph subgraph = (Subgraph)this.graph.getSubgraphOfDepth(3).at("/");
        Assert.assertThat((Object)subgraph, Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode(".")).getChildren(), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node3"))));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("node1")).getChildren(), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)subgraph.getNode("node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("node2")).getChildren(), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node3"))));
        Assert.assertThat((Object)subgraph.getNode("node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("node3")).getChildren(), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)subgraph.getNode("node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        subgraph = (Subgraph)this.graph.getSubgraphOfDepth(2).at("/node3");
        Assert.assertThat((Object)subgraph, Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode(".")).getChildren(), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)subgraph.getNode("."), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("."), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("."), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("node2")).getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
        Assert.assertThat((Object)subgraph.getNode("node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("node3")).getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
        Assert.assertThat((Object)subgraph.getNode("node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
    }

    @Test
    public void shouldCopyNodeWithChildren() {
        String initialPath = "";
        int depth = 3;
        int numChildrenPerNode = 3;
        int numPropertiesPerNode = 3;
        Stopwatch sw = new Stopwatch();
        boolean batch = true;
        this.createSubgraph(this.graph, initialPath, depth, numChildrenPerNode, numPropertiesPerNode, batch, sw, this.output, null);
        if (this.source.getCapabilities().supportsReferences()) {
            ((Graph.SetValuesTo)this.graph.set("refProp").on("/node1")).to(this.graph.getNodeAt("/node1/node3"));
            ((Graph.SetValuesTo)this.graph.set("refProp").on("/node1/node1")).to(this.graph.getNodeAt("/node3/node2"));
            ((Graph.SetValuesTo)this.graph.set("refProp").on("/node1/node2")).to(this.graph.getNodeAt("/node2/node2"));
            ((Graph.SetValuesTo)this.graph.set("refProp").on("/node1/node3")).to(this.graph.getNodeAt("/node2/node2"));
            ((Graph.SetValuesTo)this.graph.set("refProp").on("/node2/node1")).to(this.graph.getNodeAt("/node1/node1"));
            ((Graph.SetValuesTo)this.graph.set("refProp").on("/node2/node3")).to(this.graph.getNodeAt("/node1/node2"));
            ((Graph.SetValuesTo)this.graph.set("refProp").on("/node2/node2")).to(this.graph.getNodeAt("/node2/node2/node1"));
            ((Graph.SetValuesTo)this.graph.set("refProp").on("/node2/node3/node1")).to(this.graph.getNodeAt("/node2/node2/node1"));
            this.assertReference("/node1", "refProp", "/node1/node3");
            this.assertReference("/node1/node1", "refProp", "/node3/node2");
            this.assertReference("/node1/node2", "refProp", "/node2/node2");
            this.assertReference("/node1/node3", "refProp", "/node2/node2");
            this.assertReference("/node2/node1", "refProp", "/node1/node1");
            this.assertReference("/node2/node3", "refProp", "/node1/node2");
            this.assertReference("/node2/node2", "refProp", "/node2/node2/node1");
            this.assertReference("/node2/node3/node1", "refProp", "/node2/node2/node1");
        }
        this.graph.copy("/node2").into("/node3");
        if (this.source.getCapabilities().supportsReferences()) {
            this.assertReference("/node1", "refProp", "/node1/node3");
            this.assertReference("/node1/node1", "refProp", "/node3/node2[1]");
            this.assertReference("/node1/node2", "refProp", "/node2/node2");
            this.assertReference("/node1/node3", "refProp", "/node2/node2");
            this.assertReference("/node2/node1", "refProp", "/node1/node1");
            this.assertReference("/node2/node3", "refProp", "/node1/node2");
            this.assertReference("/node2/node2", "refProp", "/node2/node2/node1");
            this.assertReference("/node2/node3/node1", "refProp", "/node2/node2/node1");
            this.assertReference("/node3/node2[2]/node1", "refProp", "/node1/node1");
            this.assertReference("/node3/node2[2]/node3", "refProp", "/node1/node2");
            this.assertReference("/node3/node2[2]/node2", "refProp", "/node3/node2[2]/node2/node1");
            this.assertReference("/node3/node2[2]/node3/node1", "refProp", "/node3/node2[2]/node2/node1");
        }
        Assert.assertThat((Object)this.graph.getChildren().of("/node1"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node1/node1"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node1/node2"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node1/node3"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node1/node3/node1"), (Matcher)((Object)IsNodeWithChildren.hasChildren(new Path.Segment[0])));
        Assert.assertThat((Object)this.graph.getChildren().of("/node2"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node2/node1"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node2/node3"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node2/node3/node1"), (Matcher)((Object)IsNodeWithChildren.hasChildren(new Path.Segment[0])));
        Assert.assertThat((Object)this.graph.getChildren().of("/node3"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node2[1]"), this.segment("node3"), this.segment("node2[2]"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node3/node2[1]"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node3/node3"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node3/node3/node1"), (Matcher)((Object)IsNodeWithChildren.hasChildren(new Path.Segment[0])));
        Assert.assertThat((Object)this.graph.getChildren().of("/node3/node2[2]"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node3/node2[2]/node1"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node3/node2[2]/node2"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node3/node2[2]/node3"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node3/node2[2]/node1/node1"), (Matcher)((Object)IsNodeWithChildren.hasChildren(new Path.Segment[0])));
        Subgraph subgraph = (Subgraph)this.graph.getSubgraphOfDepth(4).at("/node3");
        Assert.assertThat((Object)subgraph, Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode(".")).getChildren(), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)subgraph.getNode("."), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("."), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("."), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("node2[1]")).getChildren(), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)subgraph.getNode("node2[1]"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[1]"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[1]"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("node3")).getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
        Assert.assertThat((Object)subgraph.getNode("node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("node2[2]")).getChildren(), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)subgraph.getNode("node2[2]"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[2]"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[2]"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("node2[2]/node1")).getChildren(), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("node2[2]/node1/node1")).getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node1/node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node1/node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node1/node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("node2[2]/node1/node2")).getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node1/node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node1/node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node1/node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("node2[2]/node1/node3")).getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node1/node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node1/node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node1/node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        if (this.source.getCapabilities().supportsReferences()) {
            Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("node2[2]/node2")).getChildren(), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        }
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("node2[2]/node2/node1")).getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node2/node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node2/node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node2/node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("node2[2]/node2/node2")).getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node2/node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node2/node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node2/node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("node2[2]/node2/node3")).getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node2/node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node2/node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node2/node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        if (this.source.getCapabilities().supportsReferences()) {
            Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("node2[2]/node3")).getChildren(), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        }
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("node2[2]/node3/node1")).getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node3/node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node3/node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node3/node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("node2[2]/node3/node2")).getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node3/node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node3/node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node3/node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("node2[2]/node3/node3")).getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node3/node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node3/node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node3/node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
    }

    @Test
    public void shouldCopyChildrenBetweenWorkspacesWithNewUuids() throws Exception {
        String defaultWorkspaceName = this.graph.getCurrentWorkspaceName();
        String workspaceName = "copyChildrenSource";
        this.tryCreatingAWorkspaceNamed(workspaceName);
        this.graph.useWorkspace(workspaceName);
        String initialPath = "";
        int depth = 3;
        int numChildrenPerNode = 3;
        int numPropertiesPerNode = 3;
        Stopwatch sw = new Stopwatch();
        boolean batch = true;
        this.createSubgraph(this.graph, initialPath, depth, numChildrenPerNode, numPropertiesPerNode, batch, sw, this.output, null);
        Subgraph source = (Subgraph)this.graph.getSubgraphOfDepth(3).at("/node1");
        this.graph.useWorkspace(defaultWorkspaceName);
        this.graph.create("/newUuids").and();
        ((Graph.CopyTarget)this.graph.copy("/node1").fromWorkspace(workspaceName)).to("/newUuids/node1");
        Subgraph target = (Subgraph)this.graph.getSubgraphOfDepth(3).at("/newUuids/node1");
        Assert.assertThat((Object)target, Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)((SubgraphNode)target.getNode(".")).getChildren(), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.uuidFor(target.getNode(".")), IsNot.not(this.uuidFor(source.getNode("."))));
        Assert.assertThat((Object)((SubgraphNode)target.getNode("node1")).getChildren(), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.uuidFor(target.getNode("node1")), IsNot.not(this.uuidFor(source.getNode("node1"))));
        Assert.assertThat((Object)((SubgraphNode)target.getNode("node2")).getChildren(), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.uuidFor(target.getNode("node2")), IsNot.not(this.uuidFor(source.getNode("node2"))));
        Assert.assertThat((Object)((SubgraphNode)target.getNode("node3")).getChildren(), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.uuidFor(target.getNode("node3")), IsNot.not(this.uuidFor(source.getNode("node3"))));
    }

    @Test
    public void shouldNotCloneChildrenIfUuidConflictAndFailureBehavior() throws Exception {
        String defaultWorkspaceName = this.graph.getCurrentWorkspaceName();
        String workspaceName = "copyChildrenSource";
        this.tryCreatingAWorkspaceNamed(workspaceName);
        this.graph.useWorkspace(workspaceName);
        String initialPath = "";
        int depth = 3;
        int numChildrenPerNode = 3;
        int numPropertiesPerNode = 3;
        Stopwatch sw = new Stopwatch();
        boolean batch = true;
        this.createSubgraph(this.graph, initialPath, depth, numChildrenPerNode, numPropertiesPerNode, batch, sw, this.output, null);
        this.graph.useWorkspace(defaultWorkspaceName);
        this.graph.create("/newUuids").and();
        ((Graph.WithUuids)((Graph.Into)((Graph.AsChild)this.graph.clone("/node1/node1/node1").fromWorkspace(workspaceName)).as(this.name("node1"))).into("/newUuids")).failingIfAnyUuidsMatch();
        try {
            ((Graph.WithUuids)((Graph.Into)((Graph.AsChild)this.graph.clone("/node1/node1/node1").fromWorkspace(workspaceName)).as(this.name("shouldNotWork"))).into("/newUuids")).failingIfAnyUuidsMatch();
            Assert.fail((String)"Should not be able to copy a node into a workspace if another node with the same UUID already exists in the workspace and UUID behavior is failingIfUuidsMatch");
        }
        catch (UuidAlreadyExistsException ex) {
            // empty catch block
        }
    }

    @Test
    public void shouldCloneChildrenAndRemoveExistingNodesWithSameUuidIfSpecified() throws Exception {
        String defaultWorkspaceName = this.graph.getCurrentWorkspaceName();
        String workspaceName = "copyChildrenSource";
        this.tryCreatingAWorkspaceNamed(workspaceName);
        this.graph.useWorkspace(workspaceName);
        String initialPath = "";
        int depth = 3;
        int numChildrenPerNode = 3;
        int numPropertiesPerNode = 3;
        Stopwatch sw = new Stopwatch();
        boolean batch = true;
        this.createSubgraph(this.graph, initialPath, depth, numChildrenPerNode, numPropertiesPerNode, batch, sw, this.output, null);
        Subgraph source = (Subgraph)this.graph.getSubgraphOfDepth(3).at("/node1");
        this.graph.useWorkspace(defaultWorkspaceName);
        this.graph.create("/newUuids").and();
        ((Graph.WithUuids)((Graph.Into)((Graph.AsChild)this.graph.clone("/node1").fromWorkspace(workspaceName)).as(this.name("node1"))).into("/newUuids")).replacingExistingNodesWithSameUuids();
        this.graph.useWorkspace(workspaceName);
        this.graph.getNodeAt("/node1");
        this.graph.useWorkspace(defaultWorkspaceName);
        this.graph.create("/newUuids/node1/shouldBeRemoved");
        ((Graph.WithUuids)((Graph.Into)((Graph.AsChild)this.graph.clone("/node1").fromWorkspace(workspaceName)).as(this.name("otherNode"))).into("/newUuids")).replacingExistingNodesWithSameUuids();
        Assert.assertThat((Object)this.graph.getNodeAt("/newUuids").getChildren(), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("otherNode"))));
        try {
            this.graph.getNodeAt("/newUuids/node1/shouldBeRemoved");
            Assert.fail((String)"/newUuids/node1/shouldBeRemoved should no longer exist after the copy-with-remove-conflicting-uuids operation");
        }
        catch (PathNotFoundException pnfe) {
            // empty catch block
        }
        Subgraph target = (Subgraph)this.graph.getSubgraphOfDepth(3).at("/newUuids/otherNode");
        Assert.assertThat((Object)target, Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)((SubgraphNode)target.getNode(".")).getChildren(), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.uuidFor(target.getNode(".")), Is.is(this.uuidFor(source.getNode("."))));
        Assert.assertThat((Object)((SubgraphNode)target.getNode("node1")).getChildren(), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.uuidFor(target.getNode("node1")), Is.is(this.uuidFor(source.getNode("node1"))));
        Assert.assertThat((Object)((SubgraphNode)target.getNode("node2")).getChildren(), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.uuidFor(target.getNode("node2")), Is.is(this.uuidFor(source.getNode("node2"))));
        Assert.assertThat((Object)((SubgraphNode)target.getNode("node3")).getChildren(), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.uuidFor(target.getNode("node3")), Is.is(this.uuidFor(source.getNode("node3"))));
    }

    @Test
    public void shouldCloneNodeIntoExactLocationIfSpecified() throws Exception {
        String defaultWorkspaceName = this.graph.getCurrentWorkspaceName();
        String workspaceName = "copyChildrenSource";
        this.tryCreatingAWorkspaceNamed(workspaceName);
        this.graph.useWorkspace(workspaceName);
        String initialPath = "";
        int depth = 3;
        int numChildrenPerNode = 3;
        int numPropertiesPerNode = 3;
        Stopwatch sw = new Stopwatch();
        boolean batch = true;
        this.createSubgraph(this.graph, initialPath, depth, numChildrenPerNode, numPropertiesPerNode, batch, sw, this.output, null);
        Subgraph source = (Subgraph)this.graph.getSubgraphOfDepth(3).at("/node1");
        this.graph.useWorkspace(defaultWorkspaceName);
        this.graph.create("/segmentTestUuids").and();
        ((Graph.WithUuids)((Graph.Into)((Graph.AsChild)this.graph.clone("/node1").fromWorkspace(workspaceName)).as(this.name("node1"))).into("/segmentTestUuids")).failingIfAnyUuidsMatch();
        PropertyFactory propFactory = this.context.getPropertyFactory();
        this.graph.create("/segmentTestUuids/node1", propFactory.create(this.name("identifier"), new Object[]{"backup copy"})).and();
        ((Graph.WithUuids)((Graph.Into)((Graph.AsChild)this.graph.clone("/node1").fromWorkspace(workspaceName)).as(this.segment("node1[1]"))).into("/segmentTestUuids")).replacingExistingNodesWithSameUuids();
        Assert.assertThat((Object)this.graph.getNodeAt("/segmentTestUuids").getChildren(), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node1[2]"))));
        Assert.assertThat((Object)this.graph.getNodeAt("/segmentTestUuids/node1[1]").getProperty("identifier"), Is.is(IsNull.nullValue()));
        Assert.assertThat((Object)this.graph.getNodeAt("/segmentTestUuids/node1[2]").getProperty("identifier").getFirstValue().toString(), Is.is("backup copy"));
        Subgraph target = (Subgraph)this.graph.getSubgraphOfDepth(3).at("/segmentTestUuids/node1[1]");
        Assert.assertThat((Object)target, Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)((SubgraphNode)target.getNode(".")).getChildren(), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.uuidFor(target.getNode(".")), Is.is(this.uuidFor(source.getNode("."))));
        Assert.assertThat((Object)((SubgraphNode)target.getNode("node1")).getChildren(), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.uuidFor(target.getNode("node1")), Is.is(this.uuidFor(source.getNode("node1"))));
        Assert.assertThat((Object)((SubgraphNode)target.getNode("node2")).getChildren(), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.uuidFor(target.getNode("node2")), Is.is(this.uuidFor(source.getNode("node2"))));
        Assert.assertThat((Object)((SubgraphNode)target.getNode("node3")).getChildren(), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.uuidFor(target.getNode("node3")), Is.is(this.uuidFor(source.getNode("node3"))));
    }

    protected void tryCreatingAWorkspaceNamed(String workspaceName) {
        try {
            this.graph.createWorkspace().named(workspaceName);
        }
        catch (Exception ex) {
            Assume.assumeNoException((Throwable)ex);
        }
    }

    private UUID uuidFor(Node node) {
        UUID uuid = null;
        if (node.getLocation().getUuid() != null) {
            uuid = node.getLocation().getUuid();
        }
        if (uuid == null && node.getProperty(JcrLexicon.UUID) != null) {
            uuid = (UUID)node.getProperty(JcrLexicon.UUID).getFirstValue();
        }
        return uuid;
    }

    protected void assertReference(String fromNodePath, String propertyName, String ... toNodePath) {
        Object[] values = ((Property)this.graph.getProperty(propertyName).on(fromNodePath)).getValuesAsArray();
        Assert.assertThat((Object)values.length, Is.is(toNodePath.length));
        for (int i = 0; i != values.length; ++i) {
            Object value = values[i];
            Assert.assertThat((Object)value, Is.is(IsInstanceOf.instanceOf(Reference.class)));
            Reference ref = (Reference)value;
            Assert.assertThat((Object)this.graph.resolve(ref).getLocation().getPath(), Is.is(this.graph.getNodeAt(toNodePath[i]).getLocation().getPath()));
        }
    }

    @Test
    public void shouldMoveNodeBeforeSibling() {
        String initialPath = "";
        int depth = 1;
        int numChildrenPerNode = 3;
        int numPropertiesPerNode = 3;
        Stopwatch sw = new Stopwatch();
        boolean batch = true;
        this.createSubgraph(this.graph, initialPath, depth, numChildrenPerNode, numPropertiesPerNode, batch, sw, this.output, null);
        Assert.assertThat((Object)this.graph.getChildren().of("/"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        this.graph.move("/node3").before("/node1");
        Assert.assertThat((Object)this.graph.getChildren().of("/"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node3"), this.segment("node1"), this.segment("node2"))));
        this.graph.move("/node2").before("/node3");
        Assert.assertThat((Object)this.graph.getChildren().of("/"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node2"), this.segment("node3"), this.segment("node1"))));
    }

    @Test
    public void shouldMoveNodeBeforeSelf() {
        String initialPath = "";
        int depth = 1;
        int numChildrenPerNode = 3;
        int numPropertiesPerNode = 3;
        Stopwatch sw = new Stopwatch();
        boolean batch = true;
        this.createSubgraph(this.graph, initialPath, depth, numChildrenPerNode, numPropertiesPerNode, batch, sw, this.output, null);
        this.graph.move("/node2").before("/node2");
        Assert.assertThat((Object)this.graph.getChildren().of("/"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
    }

    @Test
    public void shouldMoveNodes() {
        String initialPath = "";
        int depth = 3;
        int numChildrenPerNode = 3;
        int numPropertiesPerNode = 3;
        Stopwatch sw = new Stopwatch();
        boolean batch = true;
        this.createSubgraph(this.graph, initialPath, depth, numChildrenPerNode, numPropertiesPerNode, batch, sw, this.output, null);
        this.graph.move("/node2").into("/node3");
        Assert.assertThat((Object)this.graph.getChildren().of("/node1"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node1/node1"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node1/node2"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node1/node3"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node1/node3/node1"), (Matcher)((Object)IsNodeWithChildren.hasChildren(new Path.Segment[0])));
        Assert.assertThat((Object)this.graph.getChildren().of("/node3"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"), this.segment("node2[2]"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node3/node2"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node3/node3"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node3/node3/node1"), (Matcher)((Object)IsNodeWithChildren.hasChildren(new Path.Segment[0])));
        Assert.assertThat((Object)this.graph.getChildren().of("/node3/node2[2]"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node3/node2[2]/node1"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node3/node2[2]/node2"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node3/node2[2]/node3"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node3/node2[2]/node1/node1"), (Matcher)((Object)IsNodeWithChildren.hasChildren(new Path.Segment[0])));
        Subgraph subgraph = (Subgraph)this.graph.getSubgraphOfDepth(4).at("/node3");
        Assert.assertThat((Object)subgraph, Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode(".")).getChildren(), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)subgraph.getNode("."), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("."), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("."), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("node2[1]")).getChildren(), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)subgraph.getNode("node2[1]"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[1]"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[1]"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("node3")).getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
        Assert.assertThat((Object)subgraph.getNode("node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("node2[2]")).getChildren(), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)subgraph.getNode("node2[2]"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[2]"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[2]"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("node2[2]/node1")).getChildren(), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("node2[2]/node1/node1")).getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node1/node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node1/node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node1/node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("node2[2]/node1/node2")).getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node1/node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node1/node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node1/node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("node2[2]/node1/node3")).getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node1/node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node1/node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node1/node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("node2[2]/node2/node1")).getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node2/node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node2/node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node2/node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("node2[2]/node2/node2")).getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node2/node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node2/node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node2/node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("node2[2]/node2/node3")).getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node2/node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node2/node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node2/node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("node2[2]/node3/node1")).getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node3/node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node3/node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node3/node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("node2[2]/node3/node2")).getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node3/node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node3/node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node3/node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("node2[2]/node3/node3")).getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node3/node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node3/node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[2]/node3/node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
    }

    @Test
    public void shouldMoveAndRenameNodes() {
        String initialPath = "";
        int depth = 3;
        int numChildrenPerNode = 3;
        int numPropertiesPerNode = 3;
        Stopwatch sw = new Stopwatch();
        boolean batch = true;
        this.createSubgraph(this.graph, initialPath, depth, numChildrenPerNode, numPropertiesPerNode, batch, sw, this.output, null);
        ((Graph.Into)this.graph.move("/node2").as("node3")).into("/node3");
        Assert.assertThat((Object)this.graph.getChildren().of("/"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node1"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node1/node1"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node1/node2"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node1/node3"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node1/node3/node1"), (Matcher)((Object)IsNodeWithChildren.hasChildren(new Path.Segment[0])));
        Assert.assertThat((Object)this.graph.getChildren().of("/node3"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"), this.segment("node3[2]"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node3/node2"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node3/node3"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node3/node3/node1"), (Matcher)((Object)IsNodeWithChildren.hasChildren(new Path.Segment[0])));
        Assert.assertThat((Object)this.graph.getChildren().of("/node3/node3[2]"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node3/node3[2]/node1"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node3/node3[2]/node2"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node3/node3[2]/node3"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node3/node3[2]/node1/node1"), (Matcher)((Object)IsNodeWithChildren.hasChildren(new Path.Segment[0])));
        Subgraph subgraph = (Subgraph)this.graph.getSubgraphOfDepth(4).at("/node3");
        Assert.assertThat((Object)subgraph, Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode(".")).getChildren(), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)subgraph.getNode("."), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("."), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("."), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("node2[1]")).getChildren(), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)subgraph.getNode("node2[1]"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[1]"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[1]"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("node3")).getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
        Assert.assertThat((Object)subgraph.getNode("node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("node3[2]")).getChildren(), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)subgraph.getNode("node3[2]"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node3[2]"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node3[2]"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("node3[2]/node1")).getChildren(), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)subgraph.getNode("node3[2]/node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node3[2]/node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node3[2]/node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("node3[2]/node1/node1")).getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
        Assert.assertThat((Object)subgraph.getNode("node3[2]/node1/node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node3[2]/node1/node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node3[2]/node1/node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("node3[2]/node1/node2")).getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
        Assert.assertThat((Object)subgraph.getNode("node3[2]/node1/node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node3[2]/node1/node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node3[2]/node1/node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("node3[2]/node1/node3")).getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
        Assert.assertThat((Object)subgraph.getNode("node3[2]/node1/node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node3[2]/node1/node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node3[2]/node1/node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node3[2]/node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node3[2]/node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node3[2]/node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("node3[2]/node2/node1")).getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
        Assert.assertThat((Object)subgraph.getNode("node3[2]/node2/node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node3[2]/node2/node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node3[2]/node2/node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("node3[2]/node2/node2")).getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
        Assert.assertThat((Object)subgraph.getNode("node3[2]/node2/node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node3[2]/node2/node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node3[2]/node2/node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("node3[2]/node2/node3")).getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
        Assert.assertThat((Object)subgraph.getNode("node3[2]/node2/node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node3[2]/node2/node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node3[2]/node2/node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node3[2]/node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node3[2]/node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node3[2]/node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("node3[2]/node3/node1")).getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
        Assert.assertThat((Object)subgraph.getNode("node3[2]/node3/node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node3[2]/node3/node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node3[2]/node3/node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("node3[2]/node3/node2")).getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
        Assert.assertThat((Object)subgraph.getNode("node3[2]/node3/node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node3[2]/node3/node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node3[2]/node3/node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("node3[2]/node3/node3")).getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
        Assert.assertThat((Object)subgraph.getNode("node3[2]/node3/node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node3[2]/node3/node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node3[2]/node3/node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
    }

    @Test
    public void shouldMoveAndRenameNodesToNameWithoutSameNameSibling() {
        String initialPath = "";
        int depth = 3;
        int numChildrenPerNode = 3;
        int numPropertiesPerNode = 3;
        Stopwatch sw = new Stopwatch();
        boolean batch = true;
        this.createSubgraph(this.graph, initialPath, depth, numChildrenPerNode, numPropertiesPerNode, batch, sw, this.output, null);
        ((Graph.Into)this.graph.move("/node2").as("nodeX")).into("/node3");
        Assert.assertThat((Object)this.graph.getChildren().of("/"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node1"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node1/node1"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node1/node2"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node1/node3"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node1/node3/node1"), (Matcher)((Object)IsNodeWithChildren.hasChildren(new Path.Segment[0])));
        Assert.assertThat((Object)this.graph.getChildren().of("/node3"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"), this.segment("nodeX"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node3/node2"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node3/node3"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node3/node3/node1"), (Matcher)((Object)IsNodeWithChildren.hasChildren(new Path.Segment[0])));
        Assert.assertThat((Object)this.graph.getChildren().of("/node3/nodeX"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node3/nodeX/node1"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node3/nodeX/node2"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node3/nodeX/node3"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node3/nodeX/node1/node1"), (Matcher)((Object)IsNodeWithChildren.hasChildren(new Path.Segment[0])));
        Subgraph subgraph = (Subgraph)this.graph.getSubgraphOfDepth(4).at("/node3");
        Assert.assertThat((Object)subgraph, Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode(".")).getChildren(), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)subgraph.getNode("."), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("."), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("."), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("node2[1]")).getChildren(), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)subgraph.getNode("node2[1]"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[1]"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[1]"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("node3")).getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
        Assert.assertThat((Object)subgraph.getNode("node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("nodeX")).getChildren(), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)subgraph.getNode("nodeX"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("nodeX"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("nodeX"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("nodeX/node1")).getChildren(), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)subgraph.getNode("nodeX/node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("nodeX/node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("nodeX/node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("nodeX/node1/node1")).getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
        Assert.assertThat((Object)subgraph.getNode("nodeX/node1/node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("nodeX/node1/node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("nodeX/node1/node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("nodeX/node1/node2")).getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
        Assert.assertThat((Object)subgraph.getNode("nodeX/node1/node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("nodeX/node1/node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("nodeX/node1/node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("nodeX/node1/node3")).getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
        Assert.assertThat((Object)subgraph.getNode("nodeX/node1/node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("nodeX/node1/node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("nodeX/node1/node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("nodeX/node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("nodeX/node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("nodeX/node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("nodeX/node2/node1")).getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
        Assert.assertThat((Object)subgraph.getNode("nodeX/node2/node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("nodeX/node2/node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("nodeX/node2/node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("nodeX/node2/node2")).getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
        Assert.assertThat((Object)subgraph.getNode("nodeX/node2/node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("nodeX/node2/node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("nodeX/node2/node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("nodeX/node2/node3")).getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
        Assert.assertThat((Object)subgraph.getNode("nodeX/node2/node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("nodeX/node2/node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("nodeX/node2/node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("nodeX/node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("nodeX/node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("nodeX/node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("nodeX/node3/node1")).getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
        Assert.assertThat((Object)subgraph.getNode("nodeX/node3/node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("nodeX/node3/node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("nodeX/node3/node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("nodeX/node3/node2")).getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
        Assert.assertThat((Object)subgraph.getNode("nodeX/node3/node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("nodeX/node3/node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("nodeX/node3/node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("nodeX/node3/node3")).getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
        Assert.assertThat((Object)subgraph.getNode("nodeX/node3/node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("nodeX/node3/node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("nodeX/node3/node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
    }

    @Test
    public void shouldMoveAndRenameNodesToNameWithSameNameSibling() {
        String initialPath = "";
        int depth = 3;
        int numChildrenPerNode = 3;
        int numPropertiesPerNode = 3;
        Stopwatch sw = new Stopwatch();
        boolean batch = true;
        this.createSubgraph(this.graph, initialPath, depth, numChildrenPerNode, numPropertiesPerNode, batch, sw, this.output, null);
        this.graph.move("/node2").before("/node3/node2");
        Assert.assertThat((Object)this.graph.getChildren().of("/"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node1"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node1/node1"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node1/node2"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node1/node3"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node1/node3/node1"), (Matcher)((Object)IsNodeWithChildren.hasChildren(new Path.Segment[0])));
        Assert.assertThat((Object)this.graph.getChildren().of("/node3"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2[1]"), this.segment("node2[2]"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node3/node2[1]"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node3/node3"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node3/node3/node1"), (Matcher)((Object)IsNodeWithChildren.hasChildren(new Path.Segment[0])));
        Assert.assertThat((Object)this.graph.getChildren().of("/node3/node2[1]"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node3/node2[1]/node1"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node3/node2[1]/node2"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node3/node2[1]/node3"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)this.graph.getChildren().of("/node3/node2[1]/node1/node1"), (Matcher)((Object)IsNodeWithChildren.hasChildren(new Path.Segment[0])));
        Subgraph subgraph = (Subgraph)this.graph.getSubgraphOfDepth(4).at("/node3");
        Assert.assertThat((Object)subgraph, Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode(".")).getChildren(), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)subgraph.getNode("."), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("."), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("."), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("node2[2]")).getChildren(), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)subgraph.getNode("node2[2]"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[2]"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[2]"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("node3")).getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
        Assert.assertThat((Object)subgraph.getNode("node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("node2[1]")).getChildren(), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)subgraph.getNode("node2[1]"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[1]"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[1]"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("node2[1]/node1")).getChildren(), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"), this.segment("node2"), this.segment("node3"))));
        Assert.assertThat((Object)subgraph.getNode("node2[1]/node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[1]/node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[1]/node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("node2[1]/node1/node1")).getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
        Assert.assertThat((Object)subgraph.getNode("node2[1]/node1/node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[1]/node1/node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[1]/node1/node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("node2[1]/node1/node2")).getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
        Assert.assertThat((Object)subgraph.getNode("node2[1]/node1/node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[1]/node1/node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[1]/node1/node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("node2[1]/node1/node3")).getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
        Assert.assertThat((Object)subgraph.getNode("node2[1]/node1/node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[1]/node1/node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[1]/node1/node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[1]/node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[1]/node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[1]/node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("node2[1]/node2/node1")).getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
        Assert.assertThat((Object)subgraph.getNode("node2[1]/node2/node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[1]/node2/node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[1]/node2/node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("node2[1]/node2/node2")).getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
        Assert.assertThat((Object)subgraph.getNode("node2[1]/node2/node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[1]/node2/node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[1]/node2/node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("node2[1]/node2/node3")).getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
        Assert.assertThat((Object)subgraph.getNode("node2[1]/node2/node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[1]/node2/node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[1]/node2/node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[1]/node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[1]/node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[1]/node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("node2[1]/node3/node1")).getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
        Assert.assertThat((Object)subgraph.getNode("node2[1]/node3/node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[1]/node3/node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[1]/node3/node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("node2[1]/node3/node2")).getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
        Assert.assertThat((Object)subgraph.getNode("node2[1]/node3/node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[1]/node3/node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[1]/node3/node2"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)((SubgraphNode)subgraph.getNode("node2[1]/node3/node3")).getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
        Assert.assertThat((Object)subgraph.getNode("node2[1]/node3/node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[1]/node3/node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property2", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node2[1]/node3/node3"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property3", "The quick brown fox jumped over the moon. What? ")));
    }

    @Test
    public void shouldAddValuesToExistingProperty() {
        String initialPath = "";
        int depth = 1;
        int numChildrenPerNode = 1;
        int numPropertiesPerNode = 1;
        Stopwatch sw = new Stopwatch();
        boolean batch = true;
        this.createSubgraph(this.graph, initialPath, depth, numChildrenPerNode, numPropertiesPerNode, batch, sw, this.output, null);
        Assert.assertThat((Object)this.graph.getChildren().of("/"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"))));
        Subgraph subgraph = (Subgraph)this.graph.getSubgraphOfDepth(2).at("/");
        Assert.assertThat((Object)subgraph, Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)subgraph.getNode("node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        ((Graph.On)this.graph.addValue((Object)"foo").andValue((Object)"bar").to("property1")).on("node1");
        Assert.assertThat((Object)this.graph.getChildren().of("/"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"))));
        subgraph = (Subgraph)this.graph.getSubgraphOfDepth(2).at("/");
        Assert.assertThat((Object)subgraph, Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)subgraph.getNode("node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ", "foo", "bar")));
    }

    @Test
    public void shouldAddValuesToNonExistantProperty() {
        String initialPath = "";
        int depth = 1;
        int numChildrenPerNode = 1;
        int numPropertiesPerNode = 1;
        Stopwatch sw = new Stopwatch();
        boolean batch = true;
        this.createSubgraph(this.graph, initialPath, depth, numChildrenPerNode, numPropertiesPerNode, batch, sw, this.output, null);
        Assert.assertThat((Object)this.graph.getChildren().of("/"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"))));
        ((Graph.On)this.graph.addValue((Object)"foo").andValue((Object)"bar").to("newProperty")).on("node1");
        Assert.assertThat((Object)this.graph.getChildren().of("/"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"))));
        Subgraph subgraph = (Subgraph)this.graph.getSubgraphOfDepth(2).at("/");
        Assert.assertThat((Object)subgraph, Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)subgraph.getNode("node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
        Assert.assertThat((Object)subgraph.getNode("node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("newProperty", "foo", "bar")));
    }

    @Test
    public void shouldRemoveValuesFromExistingProperty() {
        String initialPath = "";
        int depth = 1;
        int numChildrenPerNode = 1;
        int numPropertiesPerNode = 1;
        Stopwatch sw = new Stopwatch();
        boolean batch = true;
        this.createSubgraph(this.graph, initialPath, depth, numChildrenPerNode, numPropertiesPerNode, batch, sw, this.output, null);
        Assert.assertThat((Object)this.graph.getChildren().of("/"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"))));
        ((Graph.On)this.graph.removeValue((Object)"The quick brown fox jumped over the moon. What? ").andValue((Object)"bar").from("property1")).on("node1");
        Assert.assertThat((Object)this.graph.getChildren().of("/"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"))));
        Subgraph subgraph = (Subgraph)this.graph.getSubgraphOfDepth(2).at("/");
        Assert.assertThat((Object)subgraph, Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)subgraph.getNode("node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", new Object[0])));
    }

    @Test
    public void shouldNotRemoveValuesFromNonExistantProperty() {
        String initialPath = "";
        int depth = 1;
        int numChildrenPerNode = 1;
        int numPropertiesPerNode = 1;
        Stopwatch sw = new Stopwatch();
        boolean batch = true;
        this.createSubgraph(this.graph, initialPath, depth, numChildrenPerNode, numPropertiesPerNode, batch, sw, this.output, null);
        Assert.assertThat((Object)this.graph.getChildren().of("/"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"))));
        ((Graph.On)this.graph.removeValue((Object)"The quick brown fox jumped over the moon. What? ").from("noSuchProperty")).on("node1");
        Assert.assertThat((Object)this.graph.getChildren().of("/"), (Matcher)((Object)IsNodeWithChildren.hasChildren(this.segment("node1"))));
        Subgraph subgraph = (Subgraph)this.graph.getSubgraphOfDepth(2).at("/");
        Assert.assertThat((Object)subgraph, Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)subgraph.getNode("node1"), (Matcher)((Object)IsNodeWithProperty.hasProperty("property1", "The quick brown fox jumped over the moon. What? ")));
    }

    @Test
    public void shouldLockNode() {
    }

    @Test
    public void shouldNotAllowMultipleConcurrentLocksOnSameNode() {
    }

    @Test
    public void shouldUnlockNode() {
    }

    @Test
    @FixFor(value={"MODE-788"})
    public void shouldCreateAndDeleteAndRecreateInSameOperation() {
        ((Graph.Batch)((Graph.Batch)((Graph.Batch)((Graph.Batch)((Graph.Batch)((Graph.Batch)this.graph.batch().create("/a").with("propB", new Object[]{"valueB"}).and("propC", new Object[]{"valueC"}).and()).create("/a/b").with("propA", new Object[]{"value a/b"}).and()).create("/a/b/c").with("propA", new Object[]{"value a/b/c"}).and()).delete("/a/b").and()).create("/a/b").with("propA", new Object[]{"value a/b2"}).and()).create("/a/b/c").with("propA", new Object[]{"value a/b2/c"}).and()).execute();
        Node root = this.graph.getNodeAt("/");
        Assert.assertThat((Object)root, Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)root, (Matcher)((Object)IsNodeWithProperty.hasProperty(ModeShapeLexicon.UUID, this.getRootNodeUuid())));
        Assert.assertThat((Object)root.getChildren(), (Matcher)((Object)IsNodeWithChildren.hasChild(this.segment("a"))));
        Node nodeA = this.graph.getNodeAt("/a");
        Assert.assertThat((Object)nodeA, Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)nodeA, (Matcher)((Object)IsNodeWithProperty.hasProperty("propB", "valueB")));
        Assert.assertThat((Object)nodeA, (Matcher)((Object)IsNodeWithProperty.hasProperty("propC", "valueC")));
        Assert.assertThat((Object)nodeA.getChildren(), (Matcher)((Object)IsNodeWithChildren.hasChild(this.segment("b"))));
        Node nodeB = this.graph.getNodeAt("/a/b");
        Assert.assertThat((Object)nodeB, Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)nodeB, (Matcher)((Object)IsNodeWithProperty.hasProperty("propA", "value a/b2")));
        Assert.assertThat((Object)nodeB.getChildren(), (Matcher)((Object)IsNodeWithChildren.hasChild(this.segment("c"))));
        Node nodeC = this.graph.getNodeAt("/a/b/c");
        Assert.assertThat((Object)nodeC, Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)nodeC, (Matcher)((Object)IsNodeWithProperty.hasProperty("propA", "value a/b2/c")));
        Assert.assertThat((Object)nodeC.getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
    }

    @Test
    @FixFor(value={"MODE-788"})
    public void shouldCreateSubgraphAndDeletePartOfThatSubgraphInSameOperation() {
        ((Graph.Batch)((Graph.Batch)((Graph.Batch)((Graph.Batch)this.graph.batch().create("/a").with("propB", new Object[]{"valueB"}).and("propC", new Object[]{"valueC"}).and()).create("/a/b").with("propA", new Object[]{"value a/b"}).and()).create("/a/b/c").with("propA", new Object[]{"valueA a/b/c"}).and()).delete("/a/b").and()).execute();
        Node root = this.graph.getNodeAt("/");
        Assert.assertThat((Object)root, Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)root, (Matcher)((Object)IsNodeWithProperty.hasProperty(ModeShapeLexicon.UUID, this.getRootNodeUuid())));
        Assert.assertThat((Object)root.getChildren(), (Matcher)((Object)IsNodeWithChildren.hasChild(this.segment("a"))));
        Node nodeA = this.graph.getNodeAt("/a");
        Assert.assertThat((Object)nodeA, Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)nodeA, (Matcher)((Object)IsNodeWithProperty.hasProperty("propB", "valueB")));
        Assert.assertThat((Object)nodeA, (Matcher)((Object)IsNodeWithProperty.hasProperty("propC", "valueC")));
        Assert.assertThat((Object)nodeA.getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
    }

    @Test
    @FixFor(value={"MODE-788"})
    public void shouldCreateAndDeleteSubgraphInSameOperation() {
        ((Graph.Batch)((Graph.Batch)((Graph.Batch)((Graph.Batch)this.graph.batch().create("/a").with("propB", new Object[]{"valueB"}).and("propC", new Object[]{"valueC"}).and()).create("/a/b").with("propA", new Object[]{"value a/b"}).and()).create("/a/b/c").with("propA", new Object[]{"valueA a/b/c"}).and()).delete("/a").and()).execute();
        Node root = this.graph.getNodeAt("/");
        Assert.assertThat((Object)root, Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)root, (Matcher)((Object)IsNodeWithProperty.hasProperty(ModeShapeLexicon.UUID, this.getRootNodeUuid())));
        Assert.assertThat((Object)root.getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
    }

    @Test
    @FixFor(value={"MODE-788"})
    public void shouldCreateAndDeleteTwoNodeSubgraphInSameOperation() {
        Node root = this.graph.getNodeAt("/");
        Assert.assertThat((Object)root, Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)root, (Matcher)((Object)IsNodeWithProperty.hasProperty(ModeShapeLexicon.UUID, this.getRootNodeUuid())));
        Assert.assertThat((Object)root.getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
        ((Graph.Batch)((Graph.Batch)((Graph.Batch)this.graph.batch().create("/a").and()).create("/a/b").and()).delete("/a").and()).execute();
        root = this.graph.getNodeAt("/");
        Assert.assertThat((Object)root, Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)root, (Matcher)((Object)IsNodeWithProperty.hasProperty(ModeShapeLexicon.UUID, this.getRootNodeUuid())));
        Assert.assertThat((Object)root.getChildren(), (Matcher)((Object)IsNodeWithChildren.isEmpty()));
    }

    @Test
    @FixFor(value={"MODE-788"})
    public void shouldCreateAndDeleteNodeInSameOperation() {
        ((Graph.Batch)((Graph.Batch)this.graph.batch().create("/a").with("propB", new Object[]{"valueB"}).and("propC", new Object[]{"valueC"}).and()).delete("/a").and()).execute();
    }
}

