/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.io;

import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.transaction.xa.XAResource;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.Location;
import org.modeshape.graph.cache.CachePolicy;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositoryConnectionFactory;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.io.GraphImporter;
import org.modeshape.graph.observe.ChangeObserver;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.request.CompositeRequest;
import org.modeshape.graph.request.CreateNodeRequest;
import org.modeshape.graph.request.Request;
import org.modeshape.graph.request.SetPropertyRequest;
import org.modeshape.graph.request.UpdatePropertiesRequest;
import org.modeshape.graph.request.VerifyWorkspaceRequest;

public class GraphImporterTest {
    private Graph graph;
    private GraphImporter importer;
    private String sourceName;
    private ExecutionContext context;
    private URI xmlContent;
    private MockRepositoryConnection connection;
    private Request lastExecutedRequest;
    private Path destinationPath;
    @Mock
    private RepositoryConnectionFactory sources;

    @Before
    public void beforeEach() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.xmlContent = new File("src/test/resources/repositoryImporterTestData1.xml").toURI();
        this.context = new ExecutionContext();
        this.context.getNamespaceRegistry().register("mode", "http://www.modeshape.org/1.0");
        this.context.getNamespaceRegistry().register("jcr", "http://www.jcp.org/jcr/1.0");
        this.context.getNamespaceRegistry().register("nt", "http://www.jcp.org/jcr/nt/1.0");
        this.sourceName = "sourceA";
        this.destinationPath = (Path)this.context.getValueFactories().getPathFactory().create("/a/b");
        this.graph = Graph.create((String)this.sourceName, (RepositoryConnectionFactory)this.sources, (ExecutionContext)this.context);
        this.importer = new GraphImporter(this.graph);
        this.connection = new MockRepositoryConnection();
        Mockito.when((Object)this.sources.createConnection(this.sourceName)).thenReturn((Object)this.connection);
    }

    @Test
    public void shouldImportXmlContentAndGenerateTheCorrectCommands() throws Exception {
        Graph.Batch batch = this.importer.importXml(this.xmlContent, Location.create((Path)this.destinationPath));
        batch.execute();
        Assert.assertThat((Object)this.lastExecutedRequest, Is.is(IsInstanceOf.instanceOf(CompositeRequest.class)));
        Iterator iter = ((CompositeRequest)this.lastExecutedRequest).iterator();
        this.assertCreateNode(iter, "/a/b/mode:system[1]", new String[0]);
        this.assertCreateNode(iter, "/a/b/mode:system[1]/mode:sources[1]", new String[0]);
        this.assertCreateNode(iter, "/a/b/mode:system[1]/mode:sources[1]/sourceA[1]", "repositoryName=repositoryA", "retryLimit=3", "jcr:primaryType={http://www.modeshape.org/1.0}xyz", "mode:classname=org.modeshape.connector.inmemory.InMemoryRepositorySource");
        this.assertCreateNode(iter, "/a/b/mode:system[1]/mode:sources[1]/sourceB[1]", "repositoryName=repositoryB", "jcr:primaryType={http://www.jcp.org/jcr/nt/1.0}unstructured", "mode:classname=org.modeshape.connector.inmemory.InMemoryRepositorySource");
        this.assertCreateProperties(iter, "/a/b/mode:system[1]/mode:sources[1]", "jcr:primaryType={http://www.jcp.org/jcr/nt/1.0}unstructured");
        this.assertCreateProperties(iter, "/a/b/mode:system[1]", "jcr:primaryType={http://www.jcp.org/jcr/nt/1.0}unstructured");
        Assert.assertThat((Object)iter.hasNext(), Is.is(false));
    }

    public void assertCreateNode(Iterator<Request> iterator, String path, String ... properties) {
        Request nextCommand = iterator.next();
        Assert.assertThat((Object)nextCommand, Is.is(IsInstanceOf.instanceOf(CreateNodeRequest.class)));
        CreateNodeRequest createNode = (CreateNodeRequest)nextCommand;
        Path expectedPath = (Path)this.context.getValueFactories().getPathFactory().create(path);
        Path parentPath = createNode.under().getPath();
        Assert.assertThat((Object)parentPath, Is.is(expectedPath.getParent()));
        Assert.assertThat((Object)createNode.named(), Is.is(expectedPath.getLastSegment().getName()));
        if (properties.length > 0) {
            HashMap<Name, Property> propertiesByName = new HashMap<Name, Property>();
            for (Property prop : createNode.properties()) {
                propertiesByName.put(prop.getName(), prop);
            }
            for (String propertyStr : properties) {
                if (propertyStr == "any properties") {
                    propertiesByName.clear();
                    break;
                }
                Matcher matcher = Pattern.compile("([^=]+)=(.*)").matcher(propertyStr);
                if (!matcher.matches()) continue;
                Name propertyName = (Name)this.context.getValueFactories().getNameFactory().create(matcher.group(1));
                String value = matcher.group(2);
                if (value.trim().length() == 0) {
                    value = null;
                }
                Property actual = (Property)propertiesByName.remove(propertyName);
                Property expectedProperty = this.context.getPropertyFactory().create(propertyName, new Object[]{value});
                Assert.assertThat((String)("missing property " + propertyName), (Object)actual, Is.is(expectedProperty));
            }
            if (!propertiesByName.isEmpty()) {
                // empty if block
            }
            Assert.assertThat((Object)propertiesByName.isEmpty(), Is.is(true));
        }
    }

    public void assertCreateProperties(Iterator<Request> iterator, String path, String ... properties) {
        Request nextCommand = iterator.next();
        if (nextCommand instanceof UpdatePropertiesRequest) {
            this.assertUpdateProperties((UpdatePropertiesRequest)nextCommand, path, properties);
        } else if (nextCommand instanceof SetPropertyRequest) {
            this.assertSetProperty((SetPropertyRequest)nextCommand, path, properties);
        } else {
            Assert.fail((String)("Invalid next request type: " + nextCommand.getClass().getName()));
        }
    }

    public void assertUpdateProperties(UpdatePropertiesRequest createNode, String path, String ... properties) {
        Path expectedPath = (Path)this.context.getValueFactories().getPathFactory().create(path);
        Path parentPath = createNode.changedLocation().getPath().getParent();
        Assert.assertThat((Object)parentPath, Is.is(expectedPath.getParent()));
        Assert.assertThat((Object)createNode.changedLocation().getPath().getLastSegment().getName(), Is.is(expectedPath.getLastSegment().getName()));
        HashMap<Name, Property> propertiesByName = new HashMap<Name, Property>();
        for (Property prop : createNode.properties().values()) {
            propertiesByName.put(prop.getName(), prop);
        }
        for (String propertyStr : properties) {
            if (propertyStr == "any properties") {
                propertiesByName.clear();
                break;
            }
            Matcher matcher = Pattern.compile("([^=]+)=(.*)").matcher(propertyStr);
            if (!matcher.matches()) continue;
            Name propertyName = (Name)this.context.getValueFactories().getNameFactory().create(matcher.group(1));
            String value = matcher.group(2);
            if (value.trim().length() == 0) {
                value = null;
            }
            Property actual = (Property)propertiesByName.remove(propertyName);
            Property expectedProperty = this.context.getPropertyFactory().create(propertyName, new Object[]{value});
            Assert.assertThat((String)("missing property " + propertyName), (Object)actual, Is.is(expectedProperty));
        }
        if (!propertiesByName.isEmpty()) {
            // empty if block
        }
        Assert.assertThat((Object)propertiesByName.isEmpty(), Is.is(true));
    }

    public void assertSetProperty(SetPropertyRequest createNode, String path, String ... properties) {
        Path expectedPath = (Path)this.context.getValueFactories().getPathFactory().create(path);
        Path parentPath = createNode.changedLocation().getPath().getParent();
        Assert.assertThat((Object)parentPath, Is.is(expectedPath.getParent()));
        Assert.assertThat((Object)createNode.changedLocation().getPath().getLastSegment().getName(), Is.is(expectedPath.getLastSegment().getName()));
        HashMap<Name, Property> propertiesByName = new HashMap<Name, Property>();
        Property prop = createNode.property();
        propertiesByName.put(prop.getName(), prop);
        for (String propertyStr : properties) {
            if (propertyStr == "any properties") {
                propertiesByName.clear();
                break;
            }
            Matcher matcher = Pattern.compile("([^=]+)=(.*)").matcher(propertyStr);
            if (!matcher.matches()) continue;
            Name propertyName = (Name)this.context.getValueFactories().getNameFactory().create(matcher.group(1));
            String value = matcher.group(2);
            if (value.trim().length() == 0) {
                value = null;
            }
            Property actual = (Property)propertiesByName.remove(propertyName);
            Property expectedProperty = this.context.getPropertyFactory().create(propertyName, new Object[]{value});
            Assert.assertThat((String)("missing property " + propertyName), (Object)actual, Is.is(expectedProperty));
        }
        if (!propertiesByName.isEmpty()) {
            // empty if block
        }
        Assert.assertThat((Object)propertiesByName.isEmpty(), Is.is(true));
    }

    protected class MockRepositoryConnection
    implements RepositoryConnection {
        protected MockRepositoryConnection() {
        }

        public void close() {
        }

        public void execute(ExecutionContext context, Request request) throws RepositorySourceException {
            GraphImporterTest.this.lastExecutedRequest = request;
            if (request instanceof VerifyWorkspaceRequest) {
                VerifyWorkspaceRequest workspaceRequest = (VerifyWorkspaceRequest)request;
                workspaceRequest.setActualRootLocation(Location.create((Path)context.getValueFactories().getPathFactory().createRootPath()));
                workspaceRequest.setActualWorkspaceName("default");
            }
        }

        public CachePolicy getDefaultCachePolicy() {
            return null;
        }

        public String getSourceName() {
            return GraphImporterTest.this.sourceName;
        }

        public XAResource getXAResource() {
            return null;
        }

        public boolean ping(long time, TimeUnit unit) {
            return true;
        }

        public void setObserver(ChangeObserver observer) {
        }
    }
}

