/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.property.basic;

import java.util.ArrayList;
import java.util.Iterator;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.text.TextDecoder;
import org.modeshape.common.text.TextEncoder;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.graph.property.ValueFormatException;
import org.modeshape.graph.property.basic.NameValueFactory;
import org.modeshape.graph.property.basic.SimpleNamespaceRegistry;
import org.modeshape.graph.property.basic.StringValueFactory;

public class NameValueFactoryTest {
    public static final TextEncoder NO_OP_ENCODER = Path.NO_OP_ENCODER;
    private NamespaceRegistry registry;
    private ValueFactory<String> stringValueFactory;
    private NameValueFactory factory;
    private TextEncoder encoder;
    private TextDecoder decoder;
    private Name name;

    @Before
    public void beforeEach() {
        this.registry = new SimpleNamespaceRegistry();
        this.registry.register("dna", "http://www.modeshape.org/namespace");
        this.encoder = Path.DEFAULT_ENCODER;
        this.decoder = Path.DEFAULT_DECODER;
        this.stringValueFactory = new StringValueFactory(this.registry, this.decoder, this.encoder);
        this.factory = new NameValueFactory(this.registry, this.decoder, this.stringValueFactory);
    }

    @Test
    public void shouldCreateNameFromSingleStringInPrefixedNamespaceFormatWithoutPrefix() {
        this.name = this.factory.create("a");
        Assert.assertThat((Object)this.name.getLocalName(), Is.is("a"));
        Assert.assertThat((Object)this.name.getNamespaceUri(), Is.is(this.registry.getNamespaceForPrefix("")));
    }

    @Test
    public void shouldCreateNameFromSingleStringInPrefixedNamespaceFormat() {
        this.name = this.factory.create("dna:something");
        Assert.assertThat((Object)this.name.getLocalName(), Is.is("something"));
        Assert.assertThat((Object)this.name.getNamespaceUri(), Is.is("http://www.modeshape.org/namespace"));
        Assert.assertThat((Object)this.name.getString(NO_OP_ENCODER), Is.is("{http://www.modeshape.org/namespace}something"));
    }

    @Test
    public void shouldCreateNameFromSingleEncodedStringInPrefixedNamespaceFormat() {
        this.name = this.factory.create(this.encoder.encode("dna") + ":" + this.encoder.encode("some/thing"));
        Assert.assertThat((Object)this.name.getLocalName(), Is.is("some/thing"));
        Assert.assertThat((Object)this.name.getNamespaceUri(), Is.is("http://www.modeshape.org/namespace"));
        Assert.assertThat((Object)this.name.getString(NO_OP_ENCODER), Is.is("{http://www.modeshape.org/namespace}some/thing"));
    }

    @Test
    public void shouldCreateNameFromSingleStringInStandardFullNamespaceFormat() {
        this.name = this.factory.create("{http://www.modeshape.org/namespace}something");
        Assert.assertThat((Object)this.name.getLocalName(), Is.is("something"));
        Assert.assertThat((Object)this.name.getNamespaceUri(), Is.is("http://www.modeshape.org/namespace"));
        Assert.assertThat((Object)this.name.getString(NO_OP_ENCODER), Is.is("{http://www.modeshape.org/namespace}something"));
    }

    @Test
    public void shouldCreateNameFromSingleEncodedStringInStandardFullNamespaceFormat() {
        this.name = this.factory.create("{" + this.encoder.encode("http://www.modeshape.org/namespace") + "}" + this.encoder.encode("some/thing"));
        Assert.assertThat((Object)this.name.getLocalName(), Is.is("some/thing"));
        Assert.assertThat((Object)this.name.getNamespaceUri(), Is.is("http://www.modeshape.org/namespace"));
        Assert.assertThat((Object)this.name.getString(NO_OP_ENCODER), Is.is("{http://www.modeshape.org/namespace}some/thing"));
    }

    @Test
    public void shouldProvideAccessToNamespaceRegistryPassedInConstructor() {
        Assert.assertThat((Object)this.factory.getNamespaceRegistry(), Is.is(this.registry));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowNullLocalName() {
        this.factory.create("a", (String)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowNullLocalNameWithEncoder() {
        this.factory.create("a", null, this.decoder);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowEmptyLocalName() {
        this.factory.create("a", "");
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowEmptyLocalNameWithEncoder() {
        this.factory.create("a", "", this.decoder);
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotCreateNameFromStringWithMultipleNonEscapedColons() {
        this.factory.create("a:b:c");
    }

    @Test
    public void shouldCreateIteratorOverValuesWhenSuppliedIteratorOfUnknownObjects() {
        ArrayList<String> values = new ArrayList<String>();
        for (int i = 0; i != 10; ++i) {
            values.add("dna:something" + i);
        }
        Iterator iter = this.factory.create(values.iterator());
        Iterator valueIter = values.iterator();
        while (iter.hasNext()) {
            Assert.assertThat(iter.next(), Is.is(this.factory.create((String)valueIter.next())));
        }
    }
}

