/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.process;

import java.util.ArrayList;
import java.util.List;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Location;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PropertyType;
import org.modeshape.graph.query.QueryResults;
import org.modeshape.graph.query.model.Column;
import org.modeshape.graph.query.model.SelectorName;
import org.modeshape.graph.query.process.JoinComponent;
import org.modeshape.graph.query.process.QueryResultColumns;

public class JoinComponentTest {
    private ExecutionContext context;
    private QueryResults.Columns mergedColumns;
    private QueryResults.Columns leftColumns;
    private QueryResults.Columns rightColumns;
    private boolean print = false;

    @Before
    public void beforeEach() {
        this.context = new ExecutionContext();
    }

    protected QueryResults.Columns columns(String tableName, String ... columnNames) {
        List<Column> columnList = this.columnList(tableName, columnNames);
        List<String> columnTypes = this.typesFor(columnList);
        return new QueryResultColumns(columnList, columnTypes, false);
    }

    protected QueryResults.Columns columnsWithScores(String tableName, String ... columnNames) {
        List<Column> columnList = this.columnList(tableName, columnNames);
        List<String> columnTypes = this.typesFor(columnList);
        return new QueryResultColumns(columnList, columnTypes, true);
    }

    protected List<String> typesFor(List<Column> columns) {
        ArrayList<String> types = new ArrayList<String>();
        for (int i = 0; i != columns.size(); ++i) {
            types.add(PropertyType.STRING.getName());
        }
        return types;
    }

    protected List<Column> columnList(String tableName, String ... columnNames) {
        ArrayList<Column> columns = new ArrayList<Column>();
        SelectorName selectorName = new SelectorName(tableName);
        for (String columnName : columnNames) {
            columns.add(new Column(selectorName, columnName, columnName));
        }
        return columns;
    }

    protected Path path(String path) {
        return (Path)this.context.getValueFactories().getPathFactory().create(path);
    }

    protected Location location(String path) {
        return Location.create((Path)this.path(path));
    }

    protected String toString(Object[] tuple) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        boolean first = true;
        for (Object value : tuple) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(value);
        }
        sb.append(']');
        return sb.toString();
    }

    protected void print(Object object) {
        if (this.print) {
            if (object instanceof Object[]) {
                System.out.println(this.toString((Object[])object));
            } else {
                System.out.println(object);
            }
        }
    }

    @Test
    public void shouldCreateMergerAndThenMergeTuplesForColumnsWithoutFullTextScore() {
        List<Column> columns = this.columnList("t1", "c11", "c12", "c13");
        columns.addAll(this.columnList("t2", "c21", "c22", "c23"));
        this.mergedColumns = new QueryResultColumns(columns, this.typesFor(columns), false);
        this.leftColumns = this.columns("t1", "c11", "c12", "c13");
        this.rightColumns = this.columns("t2", "c21", "c22", "c23");
        this.print(this.mergedColumns);
        this.print(this.leftColumns);
        this.print(this.rightColumns);
        JoinComponent.TupleMerger merger = JoinComponent.createMerger((QueryResults.Columns)this.mergedColumns, (QueryResults.Columns)this.leftColumns, (QueryResults.Columns)this.rightColumns);
        Assert.assertThat((Object)merger, Is.is(IsNull.notNullValue()));
        Location leftLocation = this.location("/a/b/c");
        Location rightLocation = this.location("/a/b/c/d");
        Object[] leftTuple = new Object[]{"vc11", "vc12", "vc3", leftLocation};
        Object[] rightTuple = new Object[]{"vc21", "vc22", "vc3", rightLocation};
        Object[] merged = merger.merge(leftTuple, rightTuple);
        this.print(merged);
        Object[] expectedTuple = new Object[]{"vc11", "vc12", "vc3", "vc21", "vc22", "vc3", leftLocation, rightLocation};
        Assert.assertThat((Object)merged, Is.is(expectedTuple));
    }

    @Test
    public void shouldCreateMergerAndThenMergeTuplesForColumnsWithFullTextScore() {
        List<Column> columns = this.columnList("t1", "c11", "c12", "c13");
        columns.addAll(this.columnList("t2", "c21", "c22", "c23"));
        this.mergedColumns = new QueryResultColumns(columns, this.typesFor(columns), true);
        this.leftColumns = this.columnsWithScores("t1", "c11", "c12", "c13");
        this.rightColumns = this.columnsWithScores("t2", "c21", "c22", "c23");
        this.print(this.mergedColumns);
        this.print(this.leftColumns);
        this.print(this.rightColumns);
        JoinComponent.TupleMerger merger = JoinComponent.createMerger((QueryResults.Columns)this.mergedColumns, (QueryResults.Columns)this.leftColumns, (QueryResults.Columns)this.rightColumns);
        Assert.assertThat((Object)merger, Is.is(IsNull.notNullValue()));
        Location leftLocation = this.location("/a/b/c");
        Location rightLocation = this.location("/a/b/c/d");
        Object[] leftTuple = new Object[]{"vc11", "vc12", "vc3", leftLocation, 1.0};
        Object[] rightTuple = new Object[]{"vc21", "vc22", "vc3", rightLocation, 2.0};
        Object[] merged = merger.merge(leftTuple, rightTuple);
        this.print(merged);
        Object[] expectedTuple = new Object[]{"vc11", "vc12", "vc3", "vc21", "vc22", "vc3", leftLocation, rightLocation, 1.0, 2.0};
        Assert.assertThat((Object)merged, Is.is(expectedTuple));
    }
}

