/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.request;

import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.hamcrest.core.IsSame;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.graph.request.AbstractRequestTest;
import org.modeshape.graph.request.CopyBranchRequest;
import org.modeshape.graph.request.Request;

public class CopyBranchRequestTest
extends AbstractRequestTest {
    private CopyBranchRequest request;

    @Override
    @Before
    public void beforeEach() {
        super.beforeEach();
    }

    @Override
    protected Request createRequest() {
        return new CopyBranchRequest(this.validPathLocation1, this.workspace1, this.validPathLocation2, this.workspace2);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowCreatingRequestWithNullFromLocation() {
        new CopyBranchRequest(null, this.workspace1, this.validPathLocation2, this.workspace2);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowCreatingRequestWithNullToLocation() {
        new CopyBranchRequest(this.validPathLocation1, this.workspace1, null, this.workspace2);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowCreatingRequestWithNullFromWorkspace() {
        new CopyBranchRequest(this.validPathLocation1, null, this.validPathLocation2, this.workspace2);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowCreatingRequestWithNullToWorkspace() {
        new CopyBranchRequest(this.validPathLocation1, this.workspace1, this.validPathLocation2, null);
    }

    @Test
    public void shouldConsiderRequestsToBeInSameWorkspaceIfFromAndToWorkspaceNamesMatch() {
        this.request = new CopyBranchRequest(this.validPathLocation1, this.workspace1, this.validPathLocation2, new String(this.workspace1));
        Assert.assertThat((Object)this.request.isSameWorkspace(), Is.is(true));
    }

    @Test
    public void shouldConsiderRequestsToNotBeInSameWorkspaceIfFromAndToWorkspaceNamesDoNotMatch() {
        this.request = new CopyBranchRequest(this.validPathLocation1, this.workspace1, this.validPathLocation2, this.workspace2);
        Assert.assertThat((Object)this.request.isSameWorkspace(), Is.is(false));
    }

    @Test
    public void shouldCreateValidRequestWithValidFromLocationAndValidToLocation() {
        this.request = new CopyBranchRequest(this.validPathLocation1, this.workspace1, this.validPathLocation2, this.workspace2);
        Assert.assertThat((Object)this.request.from(), Is.is(IsSame.sameInstance(this.validPathLocation1)));
        Assert.assertThat((Object)this.request.into(), Is.is(IsSame.sameInstance(this.validPathLocation2)));
        Assert.assertThat((Object)this.request.fromWorkspace(), Is.is(IsSame.sameInstance(this.workspace1)));
        Assert.assertThat((Object)this.request.intoWorkspace(), Is.is(IsSame.sameInstance(this.workspace2)));
        Assert.assertThat((Object)this.request.hasError(), Is.is(false));
        Assert.assertThat((Object)this.request.getError(), Is.is(IsNull.nullValue()));
    }

    @Test
    public void shouldConsiderEqualTwoRequestsWithSameLocations() {
        this.request = new CopyBranchRequest(this.validPathLocation1, this.workspace1, this.validPathLocation2, this.workspace2);
        CopyBranchRequest request2 = new CopyBranchRequest(this.validPathLocation1, this.workspace1, this.validPathLocation2, this.workspace2);
        Assert.assertThat((Object)this.request, Is.is(request2));
    }

    @Test
    public void shouldConsiderNotEqualTwoRequestsWithDifferentLocations() {
        this.request = new CopyBranchRequest(this.validPathLocation1, this.workspace1, this.validPathLocation2, this.workspace2);
        CopyBranchRequest request2 = new CopyBranchRequest(this.validPathLocation2, this.workspace1, this.validPathLocation1, this.workspace2);
        Assert.assertThat((Object)this.request.equals((Object)request2), Is.is(false));
    }

    @Test
    public void shouldConsiderNotEqualTwoRequestsWithDifferentFromWorkspaceName() {
        this.request = new CopyBranchRequest(this.validPathLocation1, this.workspace1 + "a", this.validPathLocation2, this.workspace2);
        CopyBranchRequest request2 = new CopyBranchRequest(this.validPathLocation1, this.workspace1, this.validPathLocation2, this.workspace2);
        Assert.assertThat((Object)this.request.equals((Object)request2), Is.is(false));
    }

    @Test
    public void shouldConsiderNotEqualTwoRequestsWithDifferentToWorkspaceName() {
        this.request = new CopyBranchRequest(this.validPathLocation1, this.workspace1, this.validPathLocation2, this.workspace2 + "a");
        CopyBranchRequest request2 = new CopyBranchRequest(this.validPathLocation1, this.workspace1, this.validPathLocation2, this.workspace2);
        Assert.assertThat((Object)this.request.equals((Object)request2), Is.is(false));
    }
}

