/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.request;

import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.hamcrest.core.IsSame;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.graph.request.AbstractRequestTest;
import org.modeshape.graph.request.ReadBlockOfChildrenRequest;
import org.modeshape.graph.request.Request;

public class ReadBlockOfChildrenRequestTest
extends AbstractRequestTest {
    private ReadBlockOfChildrenRequest request;

    @Override
    @Before
    public void beforeEach() {
        super.beforeEach();
    }

    @Override
    protected Request createRequest() {
        return new ReadBlockOfChildrenRequest(this.validPathLocation1, this.workspace1, 2, 10);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowCreatingRequestWithNullFromLocation() {
        new ReadBlockOfChildrenRequest(null, this.workspace1, 0, 1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowCreatingRequestWithNullWorkspaceName() {
        new ReadBlockOfChildrenRequest(this.validPathLocation1, null, 0, 1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowCreatingRequestWithNegativeStartingIndex() {
        new ReadBlockOfChildrenRequest(this.validPathLocation1, this.workspace1, -1, 1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowCreatingRequestWithNegativeCount() {
        new ReadBlockOfChildrenRequest(this.validPathLocation1, this.workspace1, 1, -1);
    }

    @Test
    public void shouldCreateValidRequestWithValidLocation() {
        this.request = new ReadBlockOfChildrenRequest(this.validPathLocation1, this.workspace1, 2, 10);
        Assert.assertThat((Object)this.request.of(), Is.is(IsSame.sameInstance(this.validPathLocation1)));
        Assert.assertThat((Object)this.request.hasError(), Is.is(false));
        Assert.assertThat((Object)this.request.getError(), Is.is(IsNull.nullValue()));
    }

    @Test
    public void shouldConsiderEqualTwoRequestsWithSameLocations() {
        this.request = new ReadBlockOfChildrenRequest(this.validPathLocation1, this.workspace1, 2, 20);
        ReadBlockOfChildrenRequest request2 = new ReadBlockOfChildrenRequest(this.validPathLocation1, new String(this.workspace1), 2, 20);
        Assert.assertThat((Object)this.request, Is.is(request2));
    }

    @Test
    public void shouldConsiderNotEqualTwoRequestsWithDifferentLocations() {
        this.request = new ReadBlockOfChildrenRequest(this.validPathLocation1, this.workspace1, 20, 20);
        ReadBlockOfChildrenRequest request2 = new ReadBlockOfChildrenRequest(this.validPathLocation2, this.workspace1, 2, 20);
        Assert.assertThat((Object)this.request.equals((Object)request2), Is.is(false));
    }

    @Test
    public void shouldConsiderNotEqualTwoRequestsWithDifferentWorkspaceNames() {
        this.request = new ReadBlockOfChildrenRequest(this.validPathLocation1, this.workspace1, 20, 20);
        ReadBlockOfChildrenRequest request2 = new ReadBlockOfChildrenRequest(this.validPathLocation1, this.workspace2, 2, 20);
        Assert.assertThat((Object)this.request.equals((Object)request2), Is.is(false));
    }

    @Test
    public void shouldConsiderNotEqualTwoRequestsWithSameLocationsButDifferentStartingIndexes() {
        this.request = new ReadBlockOfChildrenRequest(this.validPathLocation1, this.workspace1, 20, 20);
        ReadBlockOfChildrenRequest request2 = new ReadBlockOfChildrenRequest(this.validPathLocation1, this.workspace1, 2, 20);
        Assert.assertThat((Object)this.request.equals((Object)request2), Is.is(false));
    }

    @Test
    public void shouldConsiderNotEqualTwoRequestsWithSameLocationsButDifferentBlockSizes() {
        this.request = new ReadBlockOfChildrenRequest(this.validPathLocation1, this.workspace1, 2, 2);
        ReadBlockOfChildrenRequest request2 = new ReadBlockOfChildrenRequest(this.validPathLocation1, this.workspace1, 2, 20);
        Assert.assertThat((Object)this.request.equals((Object)request2), Is.is(false));
    }
}

