/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.sequencer;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.modeshape.common.collection.Problem;
import org.modeshape.common.collection.Problems;
import org.modeshape.common.collection.SimpleProblems;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.sequencer.MockSequencerOutput;
import org.modeshape.graph.sequencer.SequencerOutput;
import org.modeshape.graph.sequencer.StreamSequencer;
import org.modeshape.graph.sequencer.StreamSequencerContext;

public abstract class AbstractStreamSequencerTest {
    protected ExecutionContext context;
    protected StreamSequencer sequencer;
    protected MockSequencerOutput output;
    protected StreamSequencerContext sequencerContext;
    protected boolean print = false;

    @Before
    public void beforeEach() {
        this.print = false;
        this.context = new ExecutionContext();
        this.sequencer = this.createSequencer();
    }

    protected abstract StreamSequencer createSequencer();

    protected Path path(String path) {
        return (Path)this.context.getValueFactories().getPathFactory().create(path);
    }

    protected InputStream content(String pathOfResourceOnClasspath) throws IOException {
        URL url = this.getClass().getClassLoader().getResource(pathOfResourceOnClasspath);
        Assert.assertThat((Object)url, Is.is(IsNull.notNullValue()));
        InputStream stream = url.openStream();
        Assert.assertThat((Object)stream, Is.is(IsNull.notNullValue()));
        return stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sequence(String pathOfResourceOnClasspath) throws IOException {
        InputStream content = this.content(pathOfResourceOnClasspath);
        try {
            this.sequencerContext = this.createSequencerContext(pathOfResourceOnClasspath);
            this.output = new MockSequencerOutput(this.sequencerContext, true);
            this.sequencer.sequence(content, (SequencerOutput)this.output, this.sequencerContext);
        }
        finally {
            if (content != null) {
                try {
                    content.close();
                }
                finally {
                    content = null;
                }
            }
        }
    }

    protected StreamSequencerContext createSequencerContext(String pathStr) {
        return new StreamSequencerContext(this.context, this.path("/" + pathStr), null, null, (Problems)new SimpleProblems());
    }

    protected void assertNoProblems() {
        Assert.assertThat((String)"Must be called only after 'sequence(String)' is called", (Object)this.sequencerContext, Is.is(IsNull.notNullValue()));
        Problems problems = this.sequencerContext.getProblems();
        if (!this.sequencerContext.getProblems().isEmpty()) {
            for (Problem problem : problems) {
                System.out.println(problem);
            }
        }
        Assert.assertThat((Object)this.sequencerContext.getProblems().isEmpty(), Is.is(true));
    }

    protected void printOutput() {
        if (this.print) {
            System.out.println(this.output);
        }
    }
}

