/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.jcip.annotations.Immutable;
import org.modeshape.common.util.HashCode;
import org.modeshape.graph.Location;
import org.modeshape.graph.ModeShapeLexicon;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.basic.BasicSingleValueProperty;

@Immutable
final class LocationWithUuid
extends Location {
    private static final long serialVersionUID = 1L;
    private final UUID uuid;
    private final int hashCode;
    private final List<Property> properties;

    LocationWithUuid(UUID uuid) {
        assert (uuid != null);
        this.uuid = uuid;
        BasicSingleValueProperty uuidProperty = new BasicSingleValueProperty(ModeShapeLexicon.UUID, uuid);
        this.properties = Collections.singletonList(uuidProperty);
        this.hashCode = HashCode.compute(null, this.properties);
    }

    @Override
    public List<Property> getIdProperties() {
        return this.properties;
    }

    @Override
    public Path getPath() {
        return null;
    }

    @Override
    public final boolean hasIdProperties() {
        return true;
    }

    @Override
    public boolean hasPath() {
        return false;
    }

    @Override
    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    public Location with(Property newIdProperty) {
        return Location.create(this.getIdProperties().get(0), newIdProperty);
    }

    @Override
    public Location with(Path newPath) {
        return Location.create(newPath, this.uuid);
    }

    @Override
    public Location with(UUID uuid) {
        return Location.create(uuid);
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }
}

