/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.base;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.jcip.annotations.ThreadSafe;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.connector.RepositoryContext;
import org.modeshape.graph.connector.base.BaseRepositorySource;
import org.modeshape.graph.connector.base.Node;
import org.modeshape.graph.connector.base.Processor;
import org.modeshape.graph.connector.base.Transaction;
import org.modeshape.graph.connector.base.Workspace;
import org.modeshape.graph.observe.Observer;
import org.modeshape.graph.request.CreateWorkspaceRequest;
import org.modeshape.graph.request.InvalidWorkspaceException;
import org.modeshape.graph.request.processor.RequestProcessor;

@ThreadSafe
public abstract class Repository<NodeType extends Node, WorkspaceType extends Workspace> {
    protected final BaseRepositorySource source;
    protected final UUID rootNodeUuid;
    protected final ExecutionContext context;
    private final String sourceName;
    private final String defaultWorkspaceName;
    private final Map<String, WorkspaceType> workspaces = new HashMap<String, WorkspaceType>();
    private final ReadWriteLock workspacesLock = new ReentrantReadWriteLock();

    protected Repository(BaseRepositorySource source) {
        CheckArg.isNotNull(source, "source");
        CheckArg.isNotEmpty(source.getName(), "source.getName()");
        CheckArg.isNotNull(source.getRepositoryContext(), "source.getRepositoryContext()");
        CheckArg.isNotNull(source.getRepositoryContext().getExecutionContext(), "source.getRepositoryContext().getExecutionContext()");
        CheckArg.isNotNull(source.getRootNodeUuidObject(), "source.getRootNodeUuid()");
        this.source = source;
        this.context = source.getRepositoryContext().getExecutionContext();
        this.rootNodeUuid = source.getRootNodeUuidObject();
        this.sourceName = source.getName();
        this.defaultWorkspaceName = source.getDefaultWorkspaceName() != null ? source.getDefaultWorkspaceName() : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize() {
        Transaction<NodeType, WorkspaceType> txn = this.startTransaction(this.context, false);
        try {
            this.workspaces.put(this.defaultWorkspaceName, this.createWorkspace(txn, this.defaultWorkspaceName, CreateWorkspaceRequest.CreateConflictBehavior.DO_NOT_CREATE, null));
        }
        finally {
            txn.commit();
        }
    }

    public ExecutionContext getContext() {
        return this.context;
    }

    protected String getDefaultWorkspaceName() {
        return this.defaultWorkspaceName;
    }

    public final UUID getRootNodeUuid() {
        return this.rootNodeUuid;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getWorkspaceNames() {
        try {
            this.workspacesLock.readLock().lock();
            Set<String> set = Collections.unmodifiableSet(new HashSet<String>(this.workspaces.keySet()));
            return set;
        }
        finally {
            this.workspacesLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkspaceType getWorkspace(Transaction<NodeType, WorkspaceType> txn, String name) {
        if (name == null) {
            name = this.defaultWorkspaceName;
        }
        Lock lock = this.workspacesLock.readLock();
        try {
            lock.lock();
            Workspace workspace = (Workspace)this.workspaces.get(name);
            if (workspace == null && this.getWorkspaceNames().contains(name)) {
                workspace = txn.getWorkspace(name, null);
                this.workspaces.put(name, workspace);
            }
            Workspace workspace2 = workspace;
            return (WorkspaceType)workspace2;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkspaceType createWorkspace(Transaction<NodeType, WorkspaceType> txn, String name, CreateWorkspaceRequest.CreateConflictBehavior existingWorkspaceBehavior, String nameOfWorkspaceToClone) throws InvalidWorkspaceException {
        String newName = name;
        Lock lock = this.workspacesLock.writeLock();
        try {
            lock.lock();
            boolean conflictingName = this.workspaces.containsKey(newName);
            if (conflictingName) {
                switch (existingWorkspaceBehavior) {
                    case DO_NOT_CREATE: {
                        WorkspaceType WorkspaceType = null;
                        return WorkspaceType;
                    }
                    case CREATE_WITH_ADJUSTED_NAME: {
                        int counter = 0;
                        while (this.workspaces.containsKey(newName = name + ++counter)) {
                        }
                        break;
                    }
                }
            }
            assert (!this.workspaces.containsKey(newName));
            Object original = nameOfWorkspaceToClone != null ? (Object)this.getWorkspace(txn, nameOfWorkspaceToClone) : null;
            WorkspaceType workspace = txn.getWorkspace(name, original);
            this.workspaces.put(name, workspace);
            WorkspaceType WorkspaceType = workspace;
            return WorkspaceType;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean destroyWorkspace(String name) {
        try {
            this.workspacesLock.writeLock().lock();
            boolean bl = this.workspaces.remove(name) != null;
            return bl;
        }
        finally {
            this.workspacesLock.writeLock().unlock();
        }
    }

    public RequestProcessor createRequestProcessor(Transaction<NodeType, WorkspaceType> txn) {
        RepositoryContext repositoryContext = this.source.getRepositoryContext();
        Observer observer = repositoryContext != null ? repositoryContext.getObserver() : null;
        return new Processor<NodeType, WorkspaceType>(txn, this, observer, this.source.areUpdatesAllowed());
    }

    public abstract Transaction<NodeType, WorkspaceType> startTransaction(ExecutionContext var1, boolean var2);
}

