/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.request;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.HashCode;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.Location;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.request.CacheableRequest;
import org.modeshape.graph.request.RequestType;

public class ReadAllChildrenRequest
extends CacheableRequest
implements Iterable<Location> {
    private static final long serialVersionUID = 1L;
    private final Location of;
    private final String workspaceName;
    private final List<Location> children = new LinkedList<Location>();
    private Location actualOf;

    public ReadAllChildrenRequest(Location of, String workspaceName) {
        CheckArg.isNotNull(of, "of");
        CheckArg.isNotNull(workspaceName, "workspaceName");
        this.of = of;
        this.workspaceName = workspaceName;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    public Location of() {
        return this.of;
    }

    public String inWorkspace() {
        return this.workspaceName;
    }

    public List<Location> getChildren() {
        return this.children;
    }

    @Override
    public Iterator<Location> iterator() {
        return this.children.iterator();
    }

    public void addChildren(Iterable<Location> children) {
        this.checkNotFrozen();
        CheckArg.isNotNull(children, "children");
        for (Location child : children) {
            if (child == null) continue;
            this.children.add(child);
        }
    }

    public void addChild(Location child) {
        this.checkNotFrozen();
        CheckArg.isNotNull(child, "child");
        this.children.add(child);
    }

    public void addChild(Path pathToChild, Property firstIdProperty, Property ... remainingIdProperties) {
        this.checkNotFrozen();
        Location child = Location.create(pathToChild, firstIdProperty, remainingIdProperties);
        this.children.add(child);
    }

    public void addChild(Path pathToChild, Property idProperty) {
        this.checkNotFrozen();
        Location child = Location.create(pathToChild, idProperty);
        this.children.add(child);
    }

    public void setActualLocationOfNode(Location actualLocation) {
        this.checkNotFrozen();
        CheckArg.isNotNull(actualLocation, "actualLocation");
        assert (actualLocation != null);
        if (!actualLocation.hasPath()) {
            throw new IllegalArgumentException(GraphI18n.actualLocationMustHavePath.text(actualLocation));
        }
        this.actualOf = actualLocation;
    }

    public Location getActualLocationOfNode() {
        return this.actualOf;
    }

    @Override
    public void cancel() {
        super.cancel();
        this.actualOf = null;
    }

    public int hashCode() {
        return HashCode.compute(this.of, this.workspaceName);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (this.getClass().isInstance(obj)) {
            ReadAllChildrenRequest that = (ReadAllChildrenRequest)obj;
            if (!this.of().isSame(that.of())) {
                return false;
            }
            return this.inWorkspace().equals(that.inWorkspace());
        }
        return false;
    }

    public String toString() {
        String workspaceName = this.workspaceName != null ? "'" + this.workspaceName + "'" : "default";
        return "read   " + this.printable(this.of()) + " (in '" + workspaceName + "' workspace) all children";
    }

    @Override
    public RequestType getType() {
        return RequestType.READ_ALL_CHILDREN;
    }
}

