/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph;

import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.collection.IsCollectionContaining;
import org.modeshape.graph.Location;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.basic.BasicPathSegment;

public class IsNodeWithChildren
extends TypeSafeMatcher<List<Location>> {
    private final Matcher<Iterable<Path.Segment>> childMatcher;

    public IsNodeWithChildren(Matcher<Iterable<Path.Segment>> childMatcher) {
        this.childMatcher = childMatcher;
    }

    public boolean matchesSafely(List<Location> children) {
        ArrayList<Path.Segment> childSegments = new ArrayList<Path.Segment>(children.size());
        for (Location child : children) {
            childSegments.add(child.getPath().getLastSegment());
        }
        return this.childMatcher.matches(childSegments);
    }

    public void describeTo(Description description) {
        description.appendText("children").appendDescriptionOf(this.childMatcher);
    }

    @Factory
    public static IsNodeWithChildren hasChild(Name name, int sameNameSiblingIndex) {
        BasicPathSegment segment = new BasicPathSegment(name, sameNameSiblingIndex);
        return new IsNodeWithChildren((Matcher<Iterable<Path.Segment>>)IsCollectionContaining.hasItem((Object)segment));
    }

    @Factory
    public static IsNodeWithChildren hasChild(Path.Segment child) {
        return new IsNodeWithChildren((Matcher<Iterable<Path.Segment>>)IsCollectionContaining.hasItem((Object)child));
    }

    @Factory
    public static IsNodeWithChildren hasChildren(Path.Segment ... childSegments) {
        return new IsNodeWithChildren((Matcher<Iterable<Path.Segment>>)IsCollectionContaining.hasItems((Object[])childSegments));
    }

    @Factory
    public static IsNodeWithChildren isEmpty() {
        Object[] childSegments = new Path.Segment[]{};
        return new IsNodeWithChildren((Matcher<Iterable<Path.Segment>>)IsCollectionContaining.hasItems((Object[])childSegments));
    }
}

