/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector;

import java.util.ArrayList;
import java.util.Queue;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Location;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.query.QueryResults;
import org.modeshape.graph.query.process.FullTextSearchResultColumns;
import org.modeshape.graph.request.AccessQueryRequest;
import org.modeshape.graph.request.ChangeRequest;
import org.modeshape.graph.request.CloneBranchRequest;
import org.modeshape.graph.request.CloneWorkspaceRequest;
import org.modeshape.graph.request.CopyBranchRequest;
import org.modeshape.graph.request.CreateNodeRequest;
import org.modeshape.graph.request.CreateWorkspaceRequest;
import org.modeshape.graph.request.DeleteBranchRequest;
import org.modeshape.graph.request.DestroyWorkspaceRequest;
import org.modeshape.graph.request.FullTextSearchRequest;
import org.modeshape.graph.request.GetWorkspacesRequest;
import org.modeshape.graph.request.LockBranchRequest;
import org.modeshape.graph.request.MoveBranchRequest;
import org.modeshape.graph.request.ReadAllChildrenRequest;
import org.modeshape.graph.request.ReadAllPropertiesRequest;
import org.modeshape.graph.request.ReadBlockOfChildrenRequest;
import org.modeshape.graph.request.ReadBranchRequest;
import org.modeshape.graph.request.ReadNextBlockOfChildrenRequest;
import org.modeshape.graph.request.ReadNodeRequest;
import org.modeshape.graph.request.ReadPropertyRequest;
import org.modeshape.graph.request.RemovePropertyRequest;
import org.modeshape.graph.request.RenameNodeRequest;
import org.modeshape.graph.request.Request;
import org.modeshape.graph.request.SetPropertyRequest;
import org.modeshape.graph.request.UnlockBranchRequest;
import org.modeshape.graph.request.UpdatePropertiesRequest;
import org.modeshape.graph.request.VerifyNodeExistsRequest;
import org.modeshape.graph.request.VerifyWorkspaceRequest;
import org.modeshape.graph.request.processor.RequestProcessor;

public class MockRepositoryRequestProcessor
extends RequestProcessor {
    private static final String DEFAULT_WORKSPACE_NAME = "default";
    private final Queue<Request> processed;
    private final Location defaultWorkspaceRoot;

    public MockRepositoryRequestProcessor(String sourceName, ExecutionContext context, Queue<Request> processed) {
        super(sourceName, context, null);
        assert (processed != null);
        this.processed = processed;
        this.defaultWorkspaceRoot = Location.create((Path)context.getValueFactories().getPathFactory().createRootPath());
    }

    protected void record(Request request) {
        this.processed.add(request);
    }

    public void process(VerifyWorkspaceRequest request) {
        this.record((Request)request);
        request.setActualWorkspaceName(request.getActualWorkspaceName() == null ? DEFAULT_WORKSPACE_NAME : request.getActualWorkspaceName());
        request.setActualRootLocation(request.getActualLocationOfRoot() == null ? this.defaultWorkspaceRoot : request.getActualLocationOfRoot());
    }

    public void process(GetWorkspacesRequest request) {
        this.record((Request)request);
    }

    public void process(CreateWorkspaceRequest request) {
        this.recordChange((ChangeRequest)request);
    }

    public void process(CloneWorkspaceRequest request) {
        this.recordChange((ChangeRequest)request);
    }

    public void process(DestroyWorkspaceRequest request) {
        this.recordChange((ChangeRequest)request);
    }

    public void process(CopyBranchRequest request) {
        this.recordChange((ChangeRequest)request);
    }

    public void process(CloneBranchRequest request) {
        this.recordChange((ChangeRequest)request);
    }

    public void process(CreateNodeRequest request) {
        this.recordChange((ChangeRequest)request);
    }

    public void process(DeleteBranchRequest request) {
        this.recordChange((ChangeRequest)request);
    }

    public void process(MoveBranchRequest request) {
        this.recordChange((ChangeRequest)request);
    }

    public void process(LockBranchRequest request) {
        this.record((Request)request);
    }

    public void process(UnlockBranchRequest request) {
        this.record((Request)request);
    }

    public void process(ReadAllChildrenRequest request) {
        this.record((Request)request);
    }

    public void process(ReadAllPropertiesRequest request) {
        this.record((Request)request);
    }

    public void process(UpdatePropertiesRequest request) {
        this.recordChange((ChangeRequest)request);
    }

    public void process(ReadBlockOfChildrenRequest request) {
        this.record((Request)request);
    }

    public void process(ReadBranchRequest request) {
        this.record((Request)request);
    }

    public void process(ReadNextBlockOfChildrenRequest request) {
        this.record((Request)request);
    }

    public void process(ReadNodeRequest request) {
        this.record((Request)request);
    }

    public void process(ReadPropertyRequest request) {
        this.record((Request)request);
    }

    public void process(RemovePropertyRequest request) {
        this.recordChange((ChangeRequest)request);
    }

    public void process(RenameNodeRequest request) {
        this.recordChange((ChangeRequest)request);
    }

    public void process(SetPropertyRequest request) {
        this.recordChange((ChangeRequest)request);
    }

    public void process(VerifyNodeExistsRequest request) {
        this.record((Request)request);
    }

    public void process(AccessQueryRequest request) {
        this.record((Request)request);
        ArrayList tuples = new ArrayList();
        QueryResults.Statistics stats = new QueryResults.Statistics();
        request.setResults(tuples, stats);
    }

    public void process(FullTextSearchRequest request) {
        this.record((Request)request);
        ArrayList tuples = new ArrayList();
        QueryResults.Statistics stats = new QueryResults.Statistics();
        request.setResults((QueryResults.Columns)new FullTextSearchResultColumns(), tuples, stats);
    }

    protected void processUnknownRequest(Request request) {
        this.record(request);
    }
}

