/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.base;

import java.util.HashMap;
import java.util.Map;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.connector.base.BaseRepositorySource;
import org.modeshape.graph.connector.base.MockPathNode;
import org.modeshape.graph.connector.base.MockPathWorkspace;
import org.modeshape.graph.connector.base.PathTransaction;
import org.modeshape.graph.connector.base.Repository;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.request.InvalidWorkspaceException;

public class MockPathRepository
extends Repository<MockPathNode, MockPathWorkspace> {
    protected final Map<String, MockPathWorkspace> workspaces = new HashMap<String, MockPathWorkspace>();

    public MockPathRepository(BaseRepositorySource source) {
        super(source);
        this.initialize();
    }

    public PathTransaction<MockPathNode, MockPathWorkspace> startTransaction(ExecutionContext context, boolean readonly) {
        return new MockPathTransaction(this);
    }

    public class MockPathTransaction
    extends PathTransaction<MockPathNode, MockPathWorkspace> {
        protected MockPathNode createNode(Path.Segment name, Path parentPath, Iterable<Property> properties) {
            return new MockPathNode(null, parentPath, name, properties, null);
        }

        public MockPathTransaction(Repository<MockPathNode, MockPathWorkspace> repository) {
            super(repository, repository.getRootNodeUuid());
        }

        public boolean destroyWorkspace(MockPathWorkspace workspace) throws InvalidWorkspaceException {
            return false;
        }

        public MockPathWorkspace getWorkspace(String name, MockPathWorkspace originalToClone) throws InvalidWorkspaceException {
            MockPathWorkspace workspace = MockPathRepository.this.workspaces.get(name);
            if (workspace != null) {
                return workspace;
            }
            workspace = originalToClone != null ? new MockPathWorkspace(name, originalToClone) : new MockPathWorkspace(name, this.getRepository().getRootNodeUuid());
            MockPathRepository.this.workspaces.put(name, workspace);
            return workspace;
        }
    }
}

