/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.base;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.UUID;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Location;
import org.modeshape.graph.ModeShapeLexicon;
import org.modeshape.graph.connector.RepositoryContext;
import org.modeshape.graph.connector.base.BaseRepositorySource;
import org.modeshape.graph.connector.base.MockPathNode;
import org.modeshape.graph.connector.base.MockPathRepository;
import org.modeshape.graph.connector.base.MockPathWorkspace;
import org.modeshape.graph.connector.base.PathNode;
import org.modeshape.graph.connector.base.Repository;
import org.modeshape.graph.connector.base.Transaction;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.request.CreateWorkspaceRequest;

public class PathRepositoryTest {
    private ExecutionContext context;
    private UUID rootNodeUuid;
    private String sourceName;
    private String defaultWorkspaceName;
    private Repository<MockPathNode, MockPathWorkspace> repository;
    private BaseRepositorySource source;

    @Before
    public void beforeEach() throws Exception {
        this.context = new ExecutionContext();
        this.rootNodeUuid = UUID.randomUUID();
        this.sourceName = "Path Source";
        this.defaultWorkspaceName = "default";
        RepositoryContext repositoryContext = (RepositoryContext)Mockito.mock(RepositoryContext.class);
        Mockito.when((Object)repositoryContext.getExecutionContext()).thenReturn((Object)this.context);
        this.source = (BaseRepositorySource)Mockito.mock(BaseRepositorySource.class);
        Mockito.when((Object)this.source.areUpdatesAllowed()).thenReturn((Object)true);
        Mockito.when((Object)this.source.getRootNodeUuidObject()).thenReturn((Object)this.rootNodeUuid);
        Mockito.when((Object)this.source.getDefaultWorkspaceName()).thenReturn((Object)this.defaultWorkspaceName);
        Mockito.when((Object)this.source.getName()).thenReturn((Object)this.sourceName);
        Mockito.when((Object)this.source.getRepositoryContext()).thenReturn((Object)repositoryContext);
        this.repository = new MockPathRepository(this.source);
    }

    private MockPathRepository.MockPathTransaction beginTransaction() {
        return (MockPathRepository.MockPathTransaction)this.repository.startTransaction(this.context, false);
    }

    private MockPathWorkspace defaultWorkspaceFor(MockPathRepository.MockPathTransaction txn) {
        return txn.getWorkspace(this.defaultWorkspaceName, (MockPathWorkspace)null);
    }

    private Name name(String name) {
        return (Name)this.context.getValueFactories().getNameFactory().create(name);
    }

    private Path.Segment segment(String name) {
        return this.context.getValueFactories().getPathFactory().createSegment(name);
    }

    private PathFactory pathFactory() {
        return this.context.getValueFactories().getPathFactory();
    }

    @Test
    public void shouldHaveDefaultWorkspace() {
        Assert.assertThat((Object)this.repository.getWorkspaceNames(), (Matcher)Is.is(Collections.singleton(this.defaultWorkspaceName)));
    }

    @Test
    public void shouldBeAbleToStartTransaction() {
        Assert.assertThat((Object)this.repository.startTransaction(this.context, false), (Matcher)Is.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void shouldBeAbleToCreateWorkspaceWithNoClone() {
        MockPathRepository.MockPathTransaction txn = this.beginTransaction();
        String newWorkspaceName = "new workspace";
        this.repository.createWorkspace((Transaction)txn, newWorkspaceName, CreateWorkspaceRequest.CreateConflictBehavior.DO_NOT_CREATE, null);
        txn.commit();
        HashSet<String> workspaceNames = new HashSet<String>(Arrays.asList(this.defaultWorkspaceName, newWorkspaceName));
        Assert.assertThat((Object)this.repository.getWorkspaceNames(), (Matcher)Is.is(workspaceNames));
    }

    @Test
    public void shouldBeAbleToReadRootNode() {
        MockPathRepository.MockPathTransaction txn = this.beginTransaction();
        MockPathWorkspace workspace = this.defaultWorkspaceFor(txn);
        Location location = Location.create((UUID)this.rootNodeUuid);
        PathNode rootNode = txn.getNode(workspace, location);
        Assert.assertThat((Object)rootNode, (Matcher)Is.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)rootNode.getParent(), (Matcher)Is.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)rootNode.getUuid(), (Matcher)Is.is((Object)this.rootNodeUuid));
        Assert.assertThat((Object)rootNode.getName(), (Matcher)Is.is((Matcher)CoreMatchers.nullValue()));
    }

    private Property property(Name name, Object ... values) {
        return this.context.getPropertyFactory().create(name, values);
    }

    @Test
    public void shouldBeAbleToSetPropertyOnRootNode() {
        MockPathRepository.MockPathTransaction txn = this.beginTransaction();
        MockPathWorkspace workspace = this.defaultWorkspaceFor(txn);
        Location location = Location.create((UUID)this.rootNodeUuid);
        MockPathNode rootNode = (MockPathNode)txn.getNode(workspace, location);
        Property property = this.property(ModeShapeLexicon.ROOT, true);
        rootNode = (MockPathNode)txn.setProperties(workspace, rootNode, Collections.singleton(property), null, false);
        Assert.assertThat((Object)rootNode.getProperty(ModeShapeLexicon.ROOT), (Matcher)Is.is((Matcher)CoreMatchers.notNullValue()));
        txn.commit();
        txn = this.beginTransaction();
        workspace = this.defaultWorkspaceFor(txn);
        rootNode = (MockPathNode)txn.getNode(workspace, location);
        Assert.assertThat((Object)rootNode.getProperty(ModeShapeLexicon.ROOT), (Matcher)Is.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void shouldBeAbleToAddChildToRootNode() {
        MockPathRepository.MockPathTransaction txn = this.beginTransaction();
        MockPathWorkspace workspace = this.defaultWorkspaceFor(txn);
        Location location = Location.create((UUID)this.rootNodeUuid);
        MockPathNode rootNode = (MockPathNode)txn.getNode(workspace, location);
        PathNode newNode = txn.addChild(workspace, rootNode, this.name("child"), -1, null, null);
        rootNode = (MockPathNode)txn.getNode(workspace, Location.create((Path)newNode.getParent()));
        Assert.assertThat((Object)rootNode.getChildren().contains(this.segment("child")), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)newNode.getParent().isRoot(), (Matcher)Is.is((Object)true));
        txn.commit();
        txn = this.beginTransaction();
        workspace = this.defaultWorkspaceFor(txn);
        rootNode = (MockPathNode)txn.getNode(workspace, location);
        newNode = txn.getNode(workspace, Location.create((Path)((Path)this.pathFactory().create("/child"))));
        Assert.assertThat((Object)newNode, (Matcher)Is.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)newNode.getParent(), (Matcher)Is.is((Object)this.pathFactory().createRootPath()));
    }

    @Test
    public void shouldBeAbleToCopyChildToNewParent() {
        MockPathRepository.MockPathTransaction txn = this.beginTransaction();
        MockPathWorkspace workspace = this.defaultWorkspaceFor(txn);
        Location location = Location.create((UUID)this.rootNodeUuid);
        MockPathNode rootNode = (MockPathNode)txn.getNode(workspace, location);
        MockPathNode aNode = (MockPathNode)txn.addChild(workspace, rootNode, this.name("a"), -1, null, null);
        MockPathNode bNode = (MockPathNode)txn.addChild(workspace, aNode, this.name("b"), -1, null, null);
        MockPathNode cNode = (MockPathNode)txn.addChild(workspace, bNode, this.name("c"), -1, null, null);
        MockPathNode newNode = (MockPathNode)txn.addChild(workspace, rootNode, this.name("new"), -1, null, null);
        rootNode = (MockPathNode)txn.getNode(workspace, Location.create((Path)newNode.getParent()));
        Assert.assertThat((Object)rootNode.getChildren().contains(this.segment("a")), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)rootNode.getChildren().contains(this.segment("new")), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)cNode.getParent(), (Matcher)Is.is((Object)this.pathFactory().create("/a/b")));
        Assert.assertThat((Object)txn.getNode(workspace, Location.create((Path)((Path)this.pathFactory().create("/a/b/c")))), (Matcher)Is.is((Matcher)CoreMatchers.notNullValue()));
        bNode = (MockPathNode)txn.getNode(workspace, Location.create((Path)((Path)this.pathFactory().create("/a/b"))));
        MockPathNode newBNode = (MockPathNode)txn.copyNode(workspace, bNode, workspace, newNode, null, true);
        newNode = (MockPathNode)txn.getNode(workspace, Location.create((Path)newBNode.getParent()));
        Assert.assertThat((Object)rootNode.getChildren().contains(this.segment("a")), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)rootNode.getChildren().contains(this.segment("new")), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)newNode.getChildren().contains(this.segment("b")), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)newBNode.getChildren().contains(this.segment("c")), (Matcher)Is.is((Object)true));
        txn.commit();
        txn = this.beginTransaction();
        workspace = this.defaultWorkspaceFor(txn);
        rootNode = (MockPathNode)txn.getNode(workspace, location);
        newNode = (MockPathNode)txn.getNode(workspace, Location.create((Path)((Path)this.pathFactory().create("/new"))));
        Assert.assertThat((Object)((Object)newNode), (Matcher)Is.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)newNode.getParent(), (Matcher)Is.is((Object)this.pathFactory().createRootPath()));
    }

    @Test
    public void shouldBeAbleToMoveChildToNewParent() {
        MockPathRepository.MockPathTransaction txn = this.beginTransaction();
        MockPathWorkspace workspace = this.defaultWorkspaceFor(txn);
        Location location = Location.create((UUID)this.rootNodeUuid);
        MockPathNode rootNode = (MockPathNode)txn.getNode(workspace, location);
        MockPathNode aNode = (MockPathNode)txn.addChild(workspace, rootNode, this.name("a"), -1, null, null);
        MockPathNode bNode = (MockPathNode)txn.addChild(workspace, aNode, this.name("b"), -1, null, null);
        MockPathNode cNode = (MockPathNode)txn.addChild(workspace, bNode, this.name("c"), -1, null, null);
        MockPathNode newNode = (MockPathNode)txn.addChild(workspace, rootNode, this.name("new"), -1, null, null);
        rootNode = (MockPathNode)txn.getNode(workspace, Location.create((Path)newNode.getParent()));
        Assert.assertThat((Object)rootNode.getChildren().contains(this.segment("a")), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)rootNode.getChildren().contains(this.segment("new")), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)cNode.getParent(), (Matcher)Is.is((Object)this.pathFactory().create("/a/b")));
        Assert.assertThat((Object)txn.getNode(workspace, Location.create((Path)((Path)this.pathFactory().create("/a/b/c")))), (Matcher)Is.is((Matcher)CoreMatchers.notNullValue()));
        txn.commit();
        txn = this.beginTransaction();
        bNode = (MockPathNode)txn.getNode(workspace, Location.create((Path)((Path)this.pathFactory().create("/a/b"))));
        Location newBLocation = txn.addChild(workspace, newNode, bNode, null, null);
        MockPathNode newBNode = (MockPathNode)txn.getNode(workspace, newBLocation);
        newNode = (MockPathNode)txn.getNode(workspace, Location.create((Path)((Path)this.pathFactory().create("/new"))));
        cNode = (MockPathNode)txn.getNode(workspace, Location.create((Path)((Path)this.pathFactory().create("/new/b/c"))));
        Assert.assertThat((Object)cNode.getParent(), (Matcher)Is.is((Object)this.pathFactory().create("/new/b")));
        Assert.assertThat((Object)rootNode.getChildren().contains(this.segment("a")), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)rootNode.getChildren().contains(this.segment("new")), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)newNode.getChildren().contains(this.segment("b")), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)newBNode.getChildren().contains(this.segment("c")), (Matcher)Is.is((Object)true));
        txn.commit();
        txn = this.beginTransaction();
        workspace = this.defaultWorkspaceFor(txn);
        rootNode = (MockPathNode)txn.getNode(workspace, location);
        newNode = (MockPathNode)txn.getNode(workspace, Location.create((Path)((Path)this.pathFactory().create("/new"))));
        Assert.assertThat((Object)((Object)newNode), (Matcher)Is.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)newNode.getParent(), (Matcher)Is.is((Object)this.pathFactory().createRootPath()));
    }

    @Test
    public void shouldBeAbleToStackMoves() {
        MockPathRepository.MockPathTransaction txn = this.beginTransaction();
        MockPathWorkspace workspace = this.defaultWorkspaceFor(txn);
        Location location = Location.create((UUID)this.rootNodeUuid);
        MockPathNode rootNode = (MockPathNode)txn.getNode(workspace, location);
        MockPathNode aNode = (MockPathNode)txn.addChild(workspace, rootNode, this.name("a"), -1, null, null);
        MockPathNode bNode = (MockPathNode)txn.addChild(workspace, aNode, this.name("b"), -1, null, null);
        MockPathNode cNode = (MockPathNode)txn.addChild(workspace, bNode, this.name("c"), -1, null, null);
        MockPathNode newNode = (MockPathNode)txn.addChild(workspace, rootNode, this.name("new"), -1, null, null);
        MockPathNode dNode = (MockPathNode)txn.addChild(workspace, rootNode, this.name("d"), -1, null, null);
        MockPathNode eNode = (MockPathNode)txn.addChild(workspace, dNode, this.name("e"), -1, null, null);
        txn.commit();
        txn = this.beginTransaction();
        bNode = (MockPathNode)txn.getNode(workspace, Location.create((Path)((Path)this.pathFactory().create("/a/b"))));
        Location newBLocation = txn.addChild(workspace, newNode, bNode, null, null);
        MockPathNode newBNode = (MockPathNode)txn.getNode(workspace, newBLocation);
        newNode = (MockPathNode)txn.getNode(workspace, Location.create((Path)((Path)this.pathFactory().create("/new"))));
        cNode = (MockPathNode)txn.getNode(workspace, Location.create((Path)((Path)this.pathFactory().create("/new/b/c"))));
        dNode = (MockPathNode)txn.getNode(workspace, Location.create((Path)((Path)this.pathFactory().create("/d"))));
        Location newDLocation = txn.addChild(workspace, cNode, dNode, null, null);
        txn.getNode(workspace, newDLocation);
        eNode = (MockPathNode)txn.getNode(workspace, Location.create((Path)((Path)this.pathFactory().create("/new/b/c/d/e"))));
        Assert.assertThat((Object)eNode.getParent(), (Matcher)Is.is((Object)this.pathFactory().create("/new/b/c/d")));
        rootNode = (MockPathNode)txn.getNode(workspace, location);
        Assert.assertThat((Object)rootNode.getChildren().contains(this.segment("new")), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)newNode.getChildren().contains(this.segment("b")), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)newBNode.getChildren().contains(this.segment("c")), (Matcher)Is.is((Object)true));
        txn.commit();
        txn = this.beginTransaction();
        workspace = this.defaultWorkspaceFor(txn);
        rootNode = (MockPathNode)txn.getNode(workspace, location);
        newNode = (MockPathNode)txn.getNode(workspace, Location.create((Path)((Path)this.pathFactory().create("/new"))));
        Assert.assertThat((Object)((Object)newNode), (Matcher)Is.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)newNode.getParent(), (Matcher)Is.is((Object)this.pathFactory().createRootPath()));
    }
}

