/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.federation;

import org.junit.Before;
import org.junit.Test;
import org.modeshape.graph.Graph;
import org.modeshape.graph.connector.federation.AbstractFederatedRepositorySourceIntegrationTest;

public class FederatedRepositorySourceProjectionTest
extends AbstractFederatedRepositorySourceIntegrationTest {
    private String offsetSourceName;
    private String offsetWorkspaceName;

    @Override
    @Before
    public void beforeEach() throws Exception {
        super.beforeEach();
        this.offsetSourceName = "Offset Source";
        this.offsetWorkspaceName = "Offset Workspace";
        Graph source = this.graphFor(this.offsetSourceName, this.offsetWorkspaceName);
        source.importXmlFrom(this.getClass().getClassLoader().getResource("cars.xml").toURI()).into("/");
    }

    protected void assertSameNode(String federatedPath, String pathToSourceNode) {
        this.assertSameNode(federatedPath, pathToSourceNode, this.offsetSourceName, this.offsetWorkspaceName, new String[0]);
    }

    protected void assertNotFederated(String federatedPath, String pathToSourceNode) {
        this.assertNotFederated(federatedPath, pathToSourceNode, this.offsetSourceName, this.offsetWorkspaceName);
    }

    @Test
    public void shouldProjectRootNodeInSourceIntoFederatedUsingOffset() throws Exception {
        this.addProjection("fedSpace", "Offset Projection", this.offsetSourceName, this.offsetWorkspaceName, "/v1/v2 => /");
        this.assertSameNode("/v1/v2/Cars", "/Cars");
        this.assertSameNode("/v1/v2/Cars/Hybrid", "/Cars/Hybrid");
        this.assertSameNode("/v1/v2/Cars/Hybrid/Toyota Prius", "/Cars/Hybrid/Toyota Prius");
        this.assertSameNode("/v1/v2/Cars/Hybrid/Toyota Highlander", "/Cars/Hybrid/Toyota Highlander");
        this.assertSameNode("/v1/v2/Cars/Hybrid/Nissan Altima", "/Cars/Hybrid/Nissan Altima");
        this.assertSameNode("/v1/v2/Cars/Sports/Aston Martin DB9", "/Cars/Sports/Aston Martin DB9");
        this.assertSameNode("/v1/v2/Cars/Sports/Infiniti G37", "/Cars/Sports/Infiniti G37");
        this.assertSameNode("/v1/v2/Cars/Luxury/Cadillac DTS", "/Cars/Luxury/Cadillac DTS");
        this.assertSameNode("/v1/v2/Cars/Luxury/Bentley Continental", "/Cars/Luxury/Bentley Continental");
        this.assertSameNode("/v1/v2/Cars/Luxury/Lexus IS350", "/Cars/Luxury/Lexus IS350");
        this.assertSameNode("/v1/v2/Cars/Utility/Land Rover LR2", "/Cars/Utility/Land Rover LR2");
        this.assertSameNode("/v1/v2/Cars/Utility/Land Rover LR3", "/Cars/Utility/Land Rover LR3");
        this.assertSameNode("/v1/v2/Cars/Utility/Hummer H3", "/Cars/Utility/Hummer H3");
        this.assertSameNode("/v1/v2/Cars/Utility/Ford F-150", "/Cars/Utility/Ford F-150");
    }

    @Test
    public void shouldProjectNonRootNodeInSourceIntoFederatedUsingOffset() throws Exception {
        this.addProjection("fedSpace", "Offset Projection", this.offsetSourceName, this.offsetWorkspaceName, "/v1/v2/Cars => /Cars");
        this.assertSameNode("/v1/v2/Cars", "/Cars");
        this.assertSameNode("/v1/v2/Cars/Hybrid", "/Cars/Hybrid");
        this.assertSameNode("/v1/v2/Cars/Hybrid/Toyota Prius", "/Cars/Hybrid/Toyota Prius");
        this.assertSameNode("/v1/v2/Cars/Hybrid/Toyota Highlander", "/Cars/Hybrid/Toyota Highlander");
        this.assertSameNode("/v1/v2/Cars/Hybrid/Nissan Altima", "/Cars/Hybrid/Nissan Altima");
        this.assertSameNode("/v1/v2/Cars/Sports/Aston Martin DB9", "/Cars/Sports/Aston Martin DB9");
        this.assertSameNode("/v1/v2/Cars/Sports/Infiniti G37", "/Cars/Sports/Infiniti G37");
        this.assertSameNode("/v1/v2/Cars/Luxury/Cadillac DTS", "/Cars/Luxury/Cadillac DTS");
        this.assertSameNode("/v1/v2/Cars/Luxury/Bentley Continental", "/Cars/Luxury/Bentley Continental");
        this.assertSameNode("/v1/v2/Cars/Luxury/Lexus IS350", "/Cars/Luxury/Lexus IS350");
        this.assertSameNode("/v1/v2/Cars/Utility/Land Rover LR2", "/Cars/Utility/Land Rover LR2");
        this.assertSameNode("/v1/v2/Cars/Utility/Land Rover LR3", "/Cars/Utility/Land Rover LR3");
        this.assertSameNode("/v1/v2/Cars/Utility/Hummer H3", "/Cars/Utility/Hummer H3");
        this.assertSameNode("/v1/v2/Cars/Utility/Ford F-150", "/Cars/Utility/Ford F-150");
    }

    @Test
    public void shouldProjectNonRootNodeWithSiblingsInSourceIntoFederatedUsingOffset() throws Exception {
        this.addProjection("fedSpace", "Offset Projection", this.offsetSourceName, this.offsetWorkspaceName, "/v1/v2/Lux => /Cars/Luxury");
        this.assertSameNode("/v1/v2/Lux/Cadillac DTS", "/Cars/Luxury/Cadillac DTS");
        this.assertSameNode("/v1/v2/Lux/Bentley Continental", "/Cars/Luxury/Bentley Continental");
        this.assertSameNode("/v1/v2/Lux/Lexus IS350", "/Cars/Luxury/Lexus IS350");
        this.assertNotFederated("/v1/Car", "/Cars");
        this.assertNotFederated("/v1/v2/Car", "/Cars");
        this.assertNotFederated("/v1/v2/Hybrid", "/Cars/Hybrid");
        this.assertNotFederated("/v1/v2/Sports", "/Cars/Sports");
        this.assertNotFederated("/v1/v2/Utility", "/Cars/Utility");
    }
}

