/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.federation;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsSame;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Location;
import org.modeshape.graph.ModeShapeLexicon;
import org.modeshape.graph.cache.CachePolicy;
import org.modeshape.graph.connector.federation.FederatedRepository;
import org.modeshape.graph.connector.federation.FederatedRequest;
import org.modeshape.graph.connector.federation.JoinRequestProcessor;
import org.modeshape.graph.connector.federation.NoMoreFederatedRequests;
import org.modeshape.graph.connector.federation.Projection;
import org.modeshape.graph.property.DateTime;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.request.ReadNodeRequest;
import org.modeshape.graph.request.Request;
import org.modeshape.graph.request.RequestType;

public class JoinRequestProcessorTest {
    private JoinRequestProcessor joinProcessor;
    private ExecutionContext context;
    private DateTime now;
    private String sourceName;
    protected List<Request> unknownRequests;
    protected BlockingQueue<FederatedRequest> joinQueue;
    private Projection mirrorProjection;
    private Projection projectionA;
    @Mock
    private FederatedRepository repository;
    @Mock
    private CachePolicy cachePolicy;

    @Before
    public void beforeEach() {
        MockitoAnnotations.initMocks((Object)this);
        this.sourceName = "MySource";
        Mockito.when((Object)this.repository.getDefaultCachePolicy()).thenReturn((Object)this.cachePolicy);
        Mockito.when((Object)this.repository.getSourceName()).thenReturn((Object)this.sourceName);
        this.unknownRequests = new ArrayList<Request>();
        this.context = new ExecutionContext();
        this.now = this.context.getValueFactories().getDateFactory().create();
        this.joinProcessor = new JoinRequestProcessorWithUnknownHandler(this.repository, this.context, this.now);
        this.joinQueue = new LinkedBlockingQueue<FederatedRequest>();
        this.mirrorProjection = new Projection("sourceA", "workspaceM", false, this.rules("/ => /"));
        this.projectionA = new Projection("sourceA", "workspaceA", false, this.rules("/a => /"));
    }

    protected Projection.Rule[] rules(String ... rule) {
        Projection.Rule[] rules = new Projection.Rule[rule.length];
        for (int i = 0; i != rule.length; ++i) {
            rules[i] = Projection.fromString((String)rule[i], (ExecutionContext)this.context);
        }
        return rules;
    }

    public Name name(String name) {
        return (Name)this.context.getValueFactories().getNameFactory().create(name);
    }

    public Path path(String path) {
        return (Path)this.context.getValueFactories().getPathFactory().create(path);
    }

    public Path.Segment segment(String segment) {
        return this.context.getValueFactories().getPathFactory().createSegment(segment);
    }

    public Location location(String path) {
        return Location.create((Path)this.path(path));
    }

    public Property property(String name, Object ... values) {
        return this.context.getPropertyFactory().create(this.name(name), values);
    }

    public Location child(Location parent, String childName) {
        Path path = this.context.getValueFactories().getPathFactory().create(parent.getPath(), new Path.Segment[]{this.segment(childName)});
        return Location.create((Path)path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pause(long millis) {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            try {
                Assert.fail((String)"Interrupted while sleeping");
            }
            finally {
                Thread.interrupted();
            }
        }
    }

    @Test
    public void shouldProcessFederatedRequestsUsingIteratable() {
        ArrayList<FederatedRequest> requests = new ArrayList<FederatedRequest>();
        Request original = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)original.getType()).thenReturn((Object)RequestType.INVALID);
        FederatedRequest request = (FederatedRequest)Mockito.mock(FederatedRequest.class);
        Mockito.when((Object)request.original()).thenReturn((Object)original);
        requests.add(request);
        this.joinProcessor.process(requests);
        Assert.assertThat((Object)this.joinProcessor.federatedRequest, (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)request)));
        Assert.assertThat((Object)this.unknownRequests.size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.unknownRequests.get(0), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)original)));
    }

    @Test
    public void shouldProcessFederatedRequestsUsingBlockingQueue() {
        Request original = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)original.getType()).thenReturn((Object)RequestType.INVALID);
        FederatedRequest request = new FederatedRequest(original);
        request.add(original, false, false, this.projectionA);
        request.freeze();
        request.getLatch().countDown();
        Assert.assertThat((Object)request.getLatch().getCount(), (Matcher)Is.is((Object)0L));
        LinkedBlockingQueue<Object> queue = new LinkedBlockingQueue<Object>();
        queue.add(request);
        queue.add(new NoMoreFederatedRequests());
        this.joinProcessor.process(queue);
        Assert.assertThat((Object)this.joinProcessor.federatedRequest, (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)request)));
        Assert.assertThat((Object)this.unknownRequests.size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.unknownRequests.get(0), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)original)));
    }

    @Test
    public void shouldProcessFederatedRequestsUsingBlockingQueueThatIsTerminatedAfterProcessingBegins() {
        final Request original = (Request)Mockito.mock(Request.class);
        Mockito.when((Object)original.getType()).thenReturn((Object)RequestType.INVALID);
        final FederatedRequest request = new FederatedRequest(original);
        Thread thread = new Thread(){

            @Override
            public void run() {
                Projection projection = (Projection)Mockito.mock(Projection.class);
                request.add(original, false, false, projection);
                request.freeze();
                JoinRequestProcessorTest.this.joinQueue.add(request);
                JoinRequestProcessorTest.pause(100L);
                request.getLatch().countDown();
                Assert.assertThat((Object)request.getLatch().getCount(), (Matcher)Is.is((Object)0L));
                JoinRequestProcessorTest.pause(100L);
                JoinRequestProcessorTest.this.joinQueue.add((FederatedRequest)new NoMoreFederatedRequests());
            }
        };
        thread.start();
        this.joinProcessor.process(this.joinQueue);
        Assert.assertThat((Object)this.joinProcessor.federatedRequest, (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)request)));
        Assert.assertThat((Object)this.unknownRequests.size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.unknownRequests.get(0), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)original)));
    }

    @Test
    public void shouldJoinSingleMirroredReadNodeRequest() {
        ReadNodeRequest original = new ReadNodeRequest(this.location("/a/b/c"), "workspaceM");
        FederatedRequest request = new FederatedRequest((Request)original);
        ReadNodeRequest projected = new ReadNodeRequest(this.location("/a/b/c"), "workspaceM");
        projected.setActualLocationOfNode(Location.create((Path)projected.at().getPath(), (UUID)UUID.randomUUID()));
        projected.addProperty(this.property("propA", "valueA"));
        projected.addProperty(this.property("propB", "valueB"));
        projected.addChild(this.child(projected.getActualLocationOfNode(), "child1"));
        projected.addChild(this.child(projected.getActualLocationOfNode(), "child2"));
        request.add((Request)projected, true, false, this.mirrorProjection);
        request.freeze();
        request.getLatch().countDown();
        this.joinQueue.add(request);
        this.joinQueue.add((FederatedRequest)new NoMoreFederatedRequests());
        this.joinProcessor.process(this.joinQueue);
        Assert.assertThat((Object)original.getChildren(), (Matcher)Is.is((Object)projected.getChildren()));
        Assert.assertThat((Object)original.getPropertiesByName(), (Matcher)Is.is((Object)projected.getPropertiesByName()));
        Assert.assertThat((Object)original.getActualLocationOfNode(), (Matcher)Is.is((Object)projected.getActualLocationOfNode()));
    }

    @Test
    public void shouldJoinSingleOffsetReadNodeRequest() {
        ReadNodeRequest original = new ReadNodeRequest(this.location("/a/b/c"), "workspaceM");
        FederatedRequest request = new FederatedRequest((Request)original);
        ReadNodeRequest projected = new ReadNodeRequest(this.location("/b/c"), "workspaceM");
        projected.setActualLocationOfNode(Location.create((Path)projected.at().getPath(), (UUID)UUID.randomUUID()));
        projected.addProperty(this.property("propA", "valueA"));
        projected.addProperty(this.property("propB", "valueB"));
        projected.addChild(this.child(projected.getActualLocationOfNode(), "child1"));
        projected.addChild(this.child(projected.getActualLocationOfNode(), "child2"));
        request.add((Request)projected, false, false, this.projectionA);
        request.freeze();
        request.getLatch().countDown();
        this.joinQueue.add(request);
        this.joinQueue.add((FederatedRequest)new NoMoreFederatedRequests());
        this.joinProcessor.process(this.joinQueue);
        Assert.assertThat((Object)original.getPropertiesByName(), (Matcher)Is.is((Object)projected.getPropertiesByName()));
        Assert.assertThat((Object)original.getActualLocationOfNode().getPath(), (Matcher)Is.is((Object)this.path("/a/b/c")));
        Assert.assertThat((Object)((Location)original.getChildren().get(0)).getPath(), (Matcher)Is.is((Object)this.path("/a/b/c/child1")));
        Assert.assertThat((Object)((Location)original.getChildren().get(1)).getPath(), (Matcher)Is.is((Object)this.path("/a/b/c/child2")));
    }

    @Test
    public void shouldJoinMultipleReadNodeRequest() {
        ReadNodeRequest original = new ReadNodeRequest(this.location("/a/b/c"), "workspaceM");
        FederatedRequest request = new FederatedRequest((Request)original);
        ReadNodeRequest projected1 = new ReadNodeRequest(this.location("/b/c"), "workspaceM");
        projected1.setActualLocationOfNode(Location.create((Path)projected1.at().getPath(), (UUID)UUID.randomUUID()));
        projected1.addProperty(this.property("propA", "valueA"));
        projected1.addProperty(this.property("propB", "valueB"));
        projected1.addChild(this.child(projected1.getActualLocationOfNode(), "child1"));
        projected1.addChild(this.child(projected1.getActualLocationOfNode(), "child2"));
        request.add((Request)projected1, false, false, this.projectionA);
        ReadNodeRequest projected2 = new ReadNodeRequest(this.location("/a/b/c"), "workspaceM");
        projected2.setActualLocationOfNode(Location.create((Path)projected2.at().getPath(), (UUID)UUID.randomUUID()));
        projected2.addProperty(this.property("propC", "valueC"));
        projected2.addProperty(this.property("propD", "valueD"));
        projected2.addChild(this.child(projected2.getActualLocationOfNode(), "child2"));
        projected2.addChild(this.child(projected2.getActualLocationOfNode(), "child3"));
        request.add((Request)projected2, true, false, this.mirrorProjection);
        request.freeze();
        request.getLatch().countDown();
        request.getLatch().countDown();
        this.joinQueue.add(request);
        this.joinQueue.add((FederatedRequest)new NoMoreFederatedRequests());
        this.joinProcessor.process(this.joinQueue);
        Assert.assertThat((Object)original.getProperties().containsAll(projected1.getProperties()), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)original.getProperties().containsAll(projected2.getProperties()), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)original.getActualLocationOfNode().getPath(), (Matcher)Is.is((Object)this.path("/a/b/c")));
        Assert.assertThat((Object)original.getActualLocationOfNode().getUuid(), (Matcher)Is.is((Object)projected1.getActualLocationOfNode().getUuid()));
        Assert.assertThat((Object)original.getActualLocationOfNode().getIdProperty(ModeShapeLexicon.UUID).isMultiple(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)original.getActualLocationOfNode().getIdProperty(ModeShapeLexicon.UUID).getValuesAsArray()[0], (Matcher)Is.is((Object)projected1.getActualLocationOfNode().getUuid()));
        Assert.assertThat((Object)original.getActualLocationOfNode().getIdProperty(ModeShapeLexicon.UUID).getValuesAsArray()[1], (Matcher)Is.is((Object)projected2.getActualLocationOfNode().getUuid()));
        Assert.assertThat((Object)((Location)original.getChildren().get(0)).getPath(), (Matcher)Is.is((Object)this.path("/a/b/c/child1")));
        Assert.assertThat((Object)((Location)original.getChildren().get(1)).getPath(), (Matcher)Is.is((Object)this.path("/a/b/c/child2")));
        Assert.assertThat((Object)((Location)original.getChildren().get(2)).getPath(), (Matcher)Is.is((Object)this.path("/a/b/c/child2[2]")));
        Assert.assertThat((Object)((Location)original.getChildren().get(3)).getPath(), (Matcher)Is.is((Object)this.path("/a/b/c/child3")));
    }

    @Test
    public void shouldCancelFederatedRequestIfOneOfSeveralMultipleReadNodeRequestIsCancelled() {
        ReadNodeRequest original = new ReadNodeRequest(this.location("/a/b/c"), "workspaceM");
        FederatedRequest request = new FederatedRequest((Request)original);
        ReadNodeRequest projected1 = new ReadNodeRequest(this.location("/b/c"), "workspaceM");
        projected1.setActualLocationOfNode(Location.create((Path)projected1.at().getPath(), (UUID)UUID.randomUUID()));
        projected1.addProperty(this.property("propA", "valueA"));
        projected1.addProperty(this.property("propB", "valueB"));
        projected1.addChild(this.child(projected1.getActualLocationOfNode(), "child1"));
        projected1.addChild(this.child(projected1.getActualLocationOfNode(), "child2"));
        request.add((Request)projected1, false, false, this.projectionA);
        ReadNodeRequest projected2 = new ReadNodeRequest(this.location("/a/b/c"), "workspaceM");
        projected2.cancel();
        request.add((Request)projected2, true, false, this.mirrorProjection);
        request.freeze();
        request.getLatch().countDown();
        request.getLatch().countDown();
        this.joinQueue.add(request);
        this.joinQueue.add((FederatedRequest)new NoMoreFederatedRequests());
        this.joinProcessor.process(this.joinQueue);
        Assert.assertThat((Object)original.getProperties().isEmpty(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)original.getChildren().isEmpty(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)original.isCancelled(), (Matcher)Is.is((Object)true));
    }

    protected class JoinRequestProcessorWithUnknownHandler
    extends JoinRequestProcessor {
        protected JoinRequestProcessorWithUnknownHandler(FederatedRepository repository, ExecutionContext context, DateTime now) {
            super(repository, context, null, now);
        }

        protected void processUnknownRequest(Request request) {
            JoinRequestProcessorTest.this.unknownRequests.add(request);
        }
    }
}

