/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.inmemory;

import org.junit.Test;
import org.modeshape.common.statistic.Stopwatch;
import org.modeshape.graph.Graph;
import org.modeshape.graph.Location;
import org.modeshape.graph.Subgraph;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;
import org.modeshape.graph.connector.test.ReadableConnectorTest;

public class InMemoryConnectorReadableTest
extends ReadableConnectorTest {
    @Override
    protected RepositorySource setUpSource() {
        InMemoryRepositorySource source = new InMemoryRepositorySource();
        source.setName("Test Repository");
        return source;
    }

    @Override
    protected void initializeContent(Graph graph) {
        String initialPath = "";
        int depth = 3;
        int numChildrenPerNode = 4;
        int numPropertiesPerNode = 7;
        Stopwatch sw = new Stopwatch();
        boolean batch = true;
        this.createSubgraph(graph, initialPath, depth, numChildrenPerNode, numPropertiesPerNode, batch, sw, this.output, null);
    }

    @Test
    public void shouldReturnSameStructureForRepeatedReadBranchRequestsOnLargeRepository() {
        String initialPath = "";
        int depth = 4;
        int numChildrenPerNode = 10;
        int numPropertiesPerNode = 7;
        Stopwatch sw = new Stopwatch();
        boolean batch = true;
        this.createSubgraph(this.graph, initialPath, depth, numChildrenPerNode, numPropertiesPerNode, batch, sw, this.output, null);
        Location root = this.graph.getCurrentWorkspace().getRoot();
        Subgraph subgraph1 = (Subgraph)this.graph.getSubgraphOfDepth(10).at(root);
        Subgraph subgraph2 = (Subgraph)this.graph.getSubgraphOfDepth(10).at(root);
        InMemoryConnectorReadableTest.assertEquivalentSubgraphs(subgraph1, subgraph2, true, true);
    }
}

