/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.inmemory;

import java.util.UUID;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.connector.RepositoryContext;
import org.modeshape.graph.connector.inmemory.InMemoryRepository;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;

public class InMemoryRepositoryTest {
    private InMemoryRepositorySource source;
    private RepositoryContext repositoryContext;
    private ExecutionContext context;

    @Before
    public void beforeEach() throws Exception {
        this.context = new ExecutionContext();
        this.repositoryContext = (RepositoryContext)Mockito.mock(RepositoryContext.class);
        Mockito.when((Object)this.repositoryContext.getExecutionContext()).thenReturn((Object)this.context);
        this.source = new InMemoryRepositorySource();
        this.source.setName("SomeName");
        this.source.setRootNodeUuid(UUID.randomUUID());
        this.source.initialize(this.repositoryContext);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowNullSourceInConstructor() {
        new InMemoryRepository(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowSourceWithBlankNameInConstructor() {
        this.source.setName("   \t ");
        new InMemoryRepository(this.source);
    }

    @Test
    public void shouldAllowValidSourceInConstructor() {
        new InMemoryRepository(this.source);
    }
}

