/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.path;

import javax.naming.Reference;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositorySourceCapabilities;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.connector.path.AbstractPathRepositorySource;
import org.modeshape.graph.connector.path.PathNode;
import org.modeshape.graph.connector.path.cache.CacheStatistics;
import org.modeshape.graph.connector.path.cache.PathCachePolicy;
import org.modeshape.graph.connector.path.cache.PathRepositoryCache;
import org.modeshape.graph.connector.path.cache.WorkspaceCache;
import org.modeshape.graph.property.Path;

public class AbstractPathRepositorySourceTest {
    private AbstractPathRepositorySource source;

    @Before
    public void beforeEach() throws Exception {
        this.source = new AbstractPathRepositorySource(){

            public String getDefaultWorkspaceName() {
                return null;
            }

            public void setUpdatesAllowed(boolean updatesAllowed) {
            }

            public RepositorySourceCapabilities getCapabilities() {
                return null;
            }

            public RepositoryConnection getConnection() throws RepositorySourceException {
                return null;
            }

            public Reference getReference() {
                return null;
            }
        };
    }

    @Test
    public void shouldProvideDefaultCachePolicy() throws Exception {
        Assert.assertThat((Object)this.source.getCachePolicy(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldProvideDefaultPathRepositoryCache() throws Exception {
        Assert.assertThat((Object)this.source.getPathRepositoryCache(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldMakeNewRepositoryCacheWhenCachePolicyIsChanged() throws Exception {
        MockCachePolicy policy1 = new MockCachePolicy();
        this.source.setCachePolicy((PathCachePolicy)policy1);
        PathRepositoryCache cache1 = this.source.getPathRepositoryCache();
        Assert.assertThat((Object)cache1, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        MockCachePolicy policy2 = new MockCachePolicy();
        this.source.setCachePolicy((PathCachePolicy)policy2);
        Assert.assertThat((Object)this.source.getCachePolicy(), (Matcher)Is.is((Object)policy2));
        Assert.assertThat((Object)this.source.getCachePolicy(), (Matcher)Is.is((Matcher)IsNot.not((Object)policy1)));
        PathRepositoryCache cache2 = this.source.getPathRepositoryCache();
        Assert.assertThat((Object)cache2, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)cache2, (Matcher)Is.is((Matcher)IsNot.not((Object)cache1)));
    }

    @Test
    public void shouldCloseOldWorkspaceCacheWhenCachePolicyIsChanged() throws Exception {
        MockCachePolicy policy1 = new MockCachePolicy();
        this.source.setCachePolicy((PathCachePolicy)policy1);
        PathRepositoryCache repositoryCache = this.source.getPathRepositoryCache();
        MockWorkspaceCache cache = (MockWorkspaceCache)repositoryCache.getCache("foo");
        Assert.assertThat((Object)cache, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.source.setCachePolicy((PathCachePolicy)new MockCachePolicy());
        Assert.assertThat((Object)cache.closed, (Matcher)Is.is((Object)true));
    }

    public static class MockWorkspaceCache
    implements WorkspaceCache {
        boolean closed = false;
        PathCachePolicy policy;

        public void initialize(PathCachePolicy policy, String workspaceName) {
            this.policy = policy;
        }

        public void clearStatistics() {
        }

        public void close() {
            this.closed = true;
        }

        public PathNode get(Path path) {
            return null;
        }

        public CacheStatistics getStatistics() {
            return null;
        }

        public void invalidate(Path path) {
        }

        public void set(PathNode node) {
        }
    }

    class MockCachePolicy
    implements PathCachePolicy {
        MockCachePolicy() {
        }

        public Class<? extends WorkspaceCache> getCacheClass() {
            return MockWorkspaceCache.class;
        }

        public boolean shouldCache(PathNode node) {
            return false;
        }

        public long getTimeToLive() {
            return 0L;
        }
    }
}

