/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.mimetype;

import java.io.File;
import java.io.InputStream;
import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.graph.mimetype.MimeTypeDetector;
import org.modeshape.graph.mimetype.MimeTypeDetectorConfig;
import org.modeshape.graph.mimetype.MimeTypeDetectors;

public abstract class AbstractMimeTypeTest {
    private final MimeTypeDetectorConfig config;
    private MimeTypeDetectors detectors;

    protected AbstractMimeTypeTest(Class<? extends MimeTypeDetector> detector) {
        Assert.assertThat(detector, (Matcher)IsNull.notNullValue());
        this.config = new MimeTypeDetectorConfig("MIME-Type Detector", "MIME-Type Detector", Collections.emptyMap(), detector.getName(), null);
    }

    @Before
    public void before() throws Exception {
        this.detectors = new MimeTypeDetectors();
        this.detectors.addDetector(this.config);
    }

    @After
    public void after() {
        this.detectors.removeDetector(this.config);
    }

    protected void testMimeType(String name, String mimeType) throws Exception {
        File file = this.getFile(name);
        InputStream content = file.toURI().toURL().openStream();
        Assert.assertThat((Object)this.detectors.mimeTypeOf(name, content), (Matcher)Is.is((Object)mimeType));
    }

    protected abstract File getFile(String var1);

    protected abstract String expectedMimeTypeForText_test_txt();

    protected abstract String expectedMimeTypeForText_plain_text_txt();

    protected abstract String expectedMimeTypeForText_plain_text_ansi_txt();

    protected abstract String expectedMimeTypeForText_plain_text_empty_txt();

    protected abstract String expectedMimeTypeForText_plain_text_utf16be_txt();

    protected abstract String expectedMimeTypeForText_plain_text_utf16le_txt();

    protected abstract String expectedMimeTypeForText_plain_text_utf8_txt();

    protected abstract String expectedMimeTypeForText_plain_text_with_null_character_txt();

    protected abstract String expectedMimeTypeForText_plain_text_without_extension();

    protected abstract String expectedMimeTypeForRtf_test_rtf();

    protected abstract String expectedMimeTypeForRtf_rtf_openoffice_1_1_5_rtf();

    protected abstract String expectedMimeTypeForRtf_rtf_openoffice_2_0_rtf();

    protected abstract String expectedMimeTypeForRtf_rtf_staroffice_5_2_rtf();

    protected abstract String expectedMimeTypeForRtf_rtf_word_2000_rtf();

    protected abstract String expectedMimeTypeForMp3_test_mp3();

    protected abstract String expectedMimeTypeForMp3_test_128_44_jstereo_mp3();

    protected abstract String expectedMimeTypeForMp3_jingle1_mp3();

    protected abstract String expectedMimeTypeForMp3_jingle2_mp3();

    protected abstract String expectedMimeTypeForMp3_jingle3_mp3();

    protected abstract String expectedMimeTypeForWav();

    protected abstract String expectedMimeTypeForBmp();

    protected abstract String expectedMimeTypeForGif();

    protected abstract String expectedMimeTypeForIcon();

    protected abstract String expectedMimeTypeForJpeg_test_jpg();

    protected abstract String expectedMimeTypeForJpeg_jpg_exif_img_9367_JPG();

    protected abstract String expectedMimeTypeForJpeg_jpg_exif_zerolength_jpg();

    protected abstract String expectedMimeTypeForJpeg_jpg_geotagged_jpg();

    protected abstract String expectedMimeTypeForJpeg_jpg_geotagged_ipanema_jpg();

    protected abstract String expectedMimeTypeForPortablePixelMap_test_ppm();

    protected abstract String expectedMimeTypeForPortablePixelMap_test_pnm();

    protected abstract String expectedMimeTypeForPng();

    protected abstract String expectedMimeTypeForTiff();

    protected abstract String expectedMimeTypeForTga();

    protected abstract String expectedMimeTypeForWmf();

    protected abstract String expectedMimeTypeForXcf();

    protected abstract String expectedMimeTypeForXpm();

    protected abstract String expectedMimeTypeForXml_test_xml();

    protected abstract String expectedMimeTypeForXml_test_excel_spreadsheet_xml();

    protected abstract String expectedMimeTypeForXml_CurrencyFormatterExample_mxml();

    protected abstract String expectedMimeTypeForXml_xml_handwritten_xml();

    protected abstract String expectedMimeTypeForXml_xml_nonexistent_dtd_xml();

    protected abstract String expectedMimeTypeForXml_xml_nonexistent_remote_dtd_xml();

    protected abstract String expectedMimeTypeForXml_xml_nonexistent_remote_xsd_xml();

    protected abstract String expectedMimeTypeForXml_xml_nonexistent_xsd_xml();

    protected abstract String expectedMimeTypeForXml_xml_utf8_bom();

    protected abstract String expectedMimeTypeForXsd();

    protected abstract String expectedMimeTypeForDtd();

    protected abstract String expectedMimeTypeForHtml_master_xml();

    protected abstract String expectedMimeTypeForHtml_html_condenast_html();

    protected abstract String expectedMimeTypeForHtml_html_handwritten_html();

    protected abstract String expectedMimeTypeForHtml_html_handwritten_with_wrong_file_extension_txt();

    protected abstract String expectedMimeTypeForHtml_html_quelle_de_html();

    protected abstract String expectedMimeTypeForHtml_html_utf16_leading_whitespace_wrong_extension_doc();

    protected abstract String expectedMimeTypeForJava();

    protected abstract String expectedMimeTypeFor1_2Class();

    protected abstract String expectedMimeTypeFor1_3Class();

    protected abstract String expectedMimeTypeFor1_4Class();

    protected abstract String expectedMimeTypeForPerl();

    protected abstract String expectedMimeTypeForPython();

    protected abstract String expectedMimeTypeForPdf_test_pdf();

    protected abstract String expectedMimeTypeForPdf_pdf_distiller_6_weirdchars_pdf();

    protected abstract String expectedMimeTypeForPdf_pdf_no_author_pdf();

    protected abstract String expectedMimeTypeForPdf_pdf_openoffice_1_1_5_writer_pdf();

    protected abstract String expectedMimeTypeForPdf_pdf_openoffice_2_0_writer_pdf();

    protected abstract String expectedMimeTypeForPdf_pdf_word_2000_pdfcreator_0_8_0_pdf();

    protected abstract String expectedMimeTypeForPdf_pdf_word_2000_pdfmaker_7_0_pdf();

    protected abstract String expectedMimeTypeForPdf_pdf_word_2000_pdfwriter_7_0_pdf();

    protected abstract String expectedMimeTypeForPostscript_test_ps();

    protected abstract String expectedMimeTypeForPostscript_test_eps();

    protected abstract String expectedMimeTypeForJar();

    protected abstract String expectedMimeTypeForJavaManifest();

    protected abstract String expectedMimeTypeForGZip_test_tar_gz();

    protected abstract String expectedMimeTypeForGZip_test_txt_gz();

    protected abstract String expectedMimeTypeForZip();

    protected abstract String expectedMimeTypeForBash();

    protected abstract String expectedMimeTypeForOgg();

    protected abstract String expectedMimeTypeForOpenDocumentFormula();

    protected abstract String expectedMimeTypeForOpenDocumentGraphics();

    protected abstract String expectedMimeTypeForOpenDocumentGraphicsTemplate();

    protected abstract String expectedMimeTypeForOpenDocumentPresentation_component_architecture_odp();

    protected abstract String expectedMimeTypeForOpenDocumentPresentation_openoffice_2_0_impress_odp();

    protected abstract String expectedMimeTypeForOpenDocumentPresentationTemplate();

    protected abstract String expectedMimeTypeForOpenDocumentSpreadsheet();

    protected abstract String expectedMimeTypeForOpenDocumentSpreadsheetTemplate();

    protected abstract String expectedMimeTypeForOpenDocumentText();

    protected abstract String expectedMimeTypeForOpenDocumentTextTemplate();

    protected abstract String expectedMimeTypeForOpenOfficeCalc();

    protected abstract String expectedMimeTypeForOpenOfficeCalcTemplate();

    protected abstract String expectedMimeTypeForOpenOfficeDraw();

    protected abstract String expectedMimeTypeForOpenOfficeDrawTemplate();

    protected abstract String expectedMimeTypeForOpenOfficeImpress();

    protected abstract String expectedMimeTypeForOpenOfficeImpressTemplate();

    protected abstract String expectedMimeTypeForOpenOfficeWriter();

    protected abstract String expectedMimeTypeForOpenOfficeWriterTemplate();

    protected abstract String expectedMimeTypeForStarOfficeCalc();

    protected abstract String expectedMimeTypeForStarOfficeDraw();

    protected abstract String expectedMimeTypeForStarOfficeImpress();

    protected abstract String expectedMimeTypeForStarOfficeWriter();

    protected abstract String expectedMimeTypeForStarOfficeCalcTemplate();

    protected abstract String expectedMimeTypeForStarOfficeDrawTemplate();

    protected abstract String expectedMimeTypeForStarOfficeImpressTemplate();

    protected abstract String expectedMimeTypeForStarOfficeWriterTemplate();

    protected abstract String expectedMimeTypeForWord_test_word_2000_doc();

    protected abstract String expectedMimeTypeForWord_test_word_6_0_95_doc();

    protected abstract String expectedMimeTypeForWord_microsoft_word_2000_doc();

    protected abstract String expectedMimeTypeForWord_microsoft_word_2000_with_wrong_file_extension_pdf();

    protected abstract String expectedMimeTypeForWord_microsoft_word_2007beta2_docm();

    protected abstract String expectedMimeTypeForWord_microsoft_word_2007beta2_docx();

    protected abstract String expectedMimeTypeForWord_microsoft_word_2007beta2_dotm();

    protected abstract String expectedMimeTypeForWord_microsoft_word_2007beta2_dotx();

    protected abstract String expectedMimeTypeForWorks_microsoft_works_spreadsheet_4_0_2000_wks();

    protected abstract String expectedMimeTypeForWorks_microsoft_works_spreadsheet_7_0_xlr();

    protected abstract String expectedMimeTypeForWorks_microsoft_works_word_processor_2000_wps();

    protected abstract String expectedMimeTypeForWorks_microsoft_works_word_processor_3_0_wps();

    protected abstract String expectedMimeTypeForWorks_microsoft_works_word_processor_4_0_wps();

    protected abstract String expectedMimeTypeForWorks_microsoft_works_word_processor_7_0_wps();

    protected abstract String expectedMimeTypeForWorkbook_corel_quattro_pro_6_wb2();

    protected abstract String expectedMimeTypeForWorkbook_microsoft_works_spreadsheet_3_0_wks();

    protected abstract String expectedMimeTypeForExcel_test_excel_2000_xls();

    protected abstract String expectedMimeTypeForExcel_microsoft_excel_2000_xls();

    protected abstract String expectedMimeTypeForExcel_microsoft_excel_2007beta2_xlam();

    protected abstract String expectedMimeTypeForExcel_microsoft_excel_2007beta2_xlsb();

    protected abstract String expectedMimeTypeForExcel_microsoft_excel_2007beta2_xlsm();

    protected abstract String expectedMimeTypeForExcel_microsoft_excel_2007beta2_xlsx();

    protected abstract String expectedMimeTypeForExcel_microsoft_excel_2007beta2_xltm();

    protected abstract String expectedMimeTypeForExcel_microsoft_excel_2007beta2_xltx();

    protected abstract String expectedMimeTypeForPowerpoint_test_ppt();

    protected abstract String expectedMimeTypeForPowerpoint_microsoft_powerpoint_2000_ppt();

    protected abstract String expectedMimeTypeForPowerpoint_microsoft_powerpoint_2007beta2_potm();

    protected abstract String expectedMimeTypeForPowerpoint_microsoft_powerpoint_2007beta2_potx();

    protected abstract String expectedMimeTypeForPowerpoint_microsoft_powerpoint_2007beta2_ppsm();

    protected abstract String expectedMimeTypeForPowerpoint_microsoft_powerpoint_2007beta2_ppsx();

    protected abstract String expectedMimeTypeForPowerpoint_microsoft_powerpoint_2007beta2_pptm();

    protected abstract String expectedMimeTypeForPowerpoint_microsoft_powerpoint_2007beta2_pptx();

    protected abstract String expectedMimeTypeForPublisher();

    protected abstract String expectedMimeTypeForVisio();

    protected abstract String expectedMimeTypeForOutlook();

    protected abstract String expectedMimeTypeForShw_corel_presentations_3_0_shw();

    protected abstract String expectedMimeTypeForShw_corel_presentations_x3_shw();

    protected abstract String expectedMimeTypeForPro_corel_quattro_pro_7_wb3();

    protected abstract String expectedMimeTypeForPro_corel_quattro_pro_x3_qpw();

    protected abstract String expectedMimeTypeForWordperfect_corel_wordperfect_4_2_wp();

    protected abstract String expectedMimeTypeForWordperfect_corel_wordperfect_5_0_wp();

    protected abstract String expectedMimeTypeForWordperfect_corel_wordperfect_5_1_wp();

    protected abstract String expectedMimeTypeForWordperfect_corel_wordperfect_5_1_far_east_wp();

    protected abstract String expectedMimeTypeForWordperfect_corel_wordperfect_x3_wpd();

    protected abstract String expectedMimeTypeForMail_test_excel_web_archive_mht();

    protected abstract String expectedMimeTypeForMail_mail_thunderbird_1_5_eml();

    protected abstract String expectedMimeTypeForMail_mhtml_firefox_mht();

    protected abstract String expectedMimeTypeForMail_mhtml_internet_explorer_mht();

    protected abstract String expectedMimeTypeForAddressBook();

    protected abstract String expectedMimeTypeForVCard_vcard_antoni_kontact_vcf();

    protected abstract String expectedMimeTypeForVCard_vcard_antoni_outlook2003_vcf();

    protected abstract String expectedMimeTypeForVCard_vcard_dirk_vcf();

    protected abstract String expectedMimeTypeForVCard_vcard_rfc2426_vcf();

    protected abstract String expectedMimeTypeForVCard_vcard_vCards_SAP_vcf();

    protected abstract String expectedMimeTypeForCalendar_basicCalendar_ics();

    protected abstract String expectedMimeTypeForCalendar_cal01_ics();

    protected abstract String expectedMimeTypeForCalendar_cal01_1_ics();

    protected abstract String expectedMimeTypeForCalendar_cal01_2_ics();

    protected abstract String expectedMimeTypeForCalendar_cal01_3_ics();

    protected abstract String expectedMimeTypeForCalendar_cal01_4_ics();

    protected abstract String expectedMimeTypeForCalendar_cal01_5_ics();

    protected abstract String expectedMimeTypeForCalendar_cal01_6_ics();

    protected abstract String expectedMimeTypeForCalendar_cal01_exrule_ics();

    protected abstract String expectedMimeTypeForCalendar_calconnect7_ics();

    protected abstract String expectedMimeTypeForCalendar_calconnect9_ics();

    protected abstract String expectedMimeTypeForCalendar_combined_multiplevcalendar_ics();

    protected abstract String expectedMimeTypeForCalendar_combined_onevcalendar_ics();

    protected abstract String expectedMimeTypeForCalendar_extendedCalendar_ics();

    protected abstract String expectedMimeTypeForCalendar_freebusy_ics();

    protected abstract String expectedMimeTypeForCalendar_geol_ics();

    protected abstract String expectedMimeTypeForCalendar_gkexample_ics();

    protected abstract String expectedMimeTypeForCalendar_incoming_ics();

    protected abstract String expectedMimeTypeForCalendar_korganizer_jicaltest_vjournal_ics();

    protected abstract String expectedMimeTypeForCalendar_korganizer_jicaltest_ics();

    protected abstract String expectedMimeTypeForCalendar_php_flp_ics();

    protected abstract String expectedMimeTypeForCalendar_simplevevent_ics();

    protected abstract String expectedMimeTypeForCalendar_sunbird_sample_ics();

    protected abstract String expectedMimeTypeForCalendar_tag_bug_ics();

    protected abstract String expectedMimeTypeForCalendar_test_created_ics();

    protected abstract String expectedMimeTypeForCalendar_Todos1_ics();

    protected abstract String expectedMimeTypeForAu();

    protected abstract String expectedMimeTypeForBin();

    protected abstract String expectedMimeTypeForEmf();

    protected abstract String expectedMimeTypeForFli();

    protected abstract String expectedMimeTypeForPcx();

    protected abstract String expectedMimeTypeForPict();

    protected abstract String expectedMimeTypeForPsd();

    protected abstract String expectedMimeTypeForTar();

    @Test
    public void shouldProvideMimeTypeForText_test_txt() throws Exception {
        this.testMimeType("test.txt", this.expectedMimeTypeForText_test_txt());
    }

    @Test
    public void shouldProvideMimeTypeForText_plain_text_txt() throws Exception {
        this.testMimeType("docs/plain-text.txt", this.expectedMimeTypeForText_plain_text_txt());
    }

    @Test
    public void shouldProvideMimeTypeForText_plain_text_ansi_txt() throws Exception {
        this.testMimeType("docs/plain-text-ansi.txt", this.expectedMimeTypeForText_plain_text_ansi_txt());
    }

    @Test
    public void shouldProvideMimeTypeForText_plain_text_empty_txt() throws Exception {
        this.testMimeType("docs/plain-text-empty.txt", this.expectedMimeTypeForText_plain_text_empty_txt());
    }

    @Test
    public void shouldProvideMimeTypeForText_plain_text_utf16be_txt() throws Exception {
        this.testMimeType("docs/plain-text-utf16be.txt", this.expectedMimeTypeForText_plain_text_utf16be_txt());
    }

    @Test
    public void shouldProvideMimeTypeForText_plain_text_utf16le_txt() throws Exception {
        this.testMimeType("docs/plain-text-utf16le.txt", this.expectedMimeTypeForText_plain_text_utf16le_txt());
    }

    @Test
    public void shouldProvideMimeTypeForText_plain_text_utf8_txt() throws Exception {
        this.testMimeType("docs/plain-text-utf8.txt", this.expectedMimeTypeForText_plain_text_utf8_txt());
    }

    @Test
    public void shouldProvideMimeTypeForText_plain_text_with_null_character_txt() throws Exception {
        this.testMimeType("docs/plain-text-with-null-character.txt", this.expectedMimeTypeForText_plain_text_with_null_character_txt());
    }

    @Test
    public void shouldProvideMimeTypeForText_plain_text_without_extension() throws Exception {
        this.testMimeType("docs/plain-text-without-extension", this.expectedMimeTypeForText_plain_text_without_extension());
    }

    @Test
    public void shouldProvideMimeTypeForRtf_test_rtf() throws Exception {
        this.testMimeType("test.rtf", this.expectedMimeTypeForRtf_test_rtf());
    }

    @Test
    public void shouldProvideMimeTypeForRtf_rtf_openoffice_1_1_5_rtf() throws Exception {
        this.testMimeType("docs/rtf-openoffice-1.1.5.rtf", this.expectedMimeTypeForRtf_rtf_openoffice_1_1_5_rtf());
    }

    @Test
    public void shouldProvideMimeTypeForRtf_rtf_openoffice_2_0_rtf() throws Exception {
        this.testMimeType("docs/rtf-openoffice-2.0.rtf", this.expectedMimeTypeForRtf_rtf_openoffice_2_0_rtf());
    }

    @Test
    public void shouldProvideMimeTypeForRtf_rtf_staroffice_5_2_rtf() throws Exception {
        this.testMimeType("docs/rtf-staroffice-5.2.rtf", this.expectedMimeTypeForRtf_rtf_staroffice_5_2_rtf());
    }

    @Test
    public void shouldProvideMimeTypeForRtf_rtf_word_2000_rtf() throws Exception {
        this.testMimeType("docs/rtf-word-2000.rtf", this.expectedMimeTypeForRtf_rtf_word_2000_rtf());
    }

    @Test
    public void shouldProvideMimeTypeForMp3_test_mp3() throws Exception {
        this.testMimeType("test.mp3", this.expectedMimeTypeForMp3_test_mp3());
    }

    @Test
    public void shouldProvideMimeTypeForMp3_test_128_44_jstereo_mp3() throws Exception {
        this.testMimeType("test_128_44_jstereo.mp3", this.expectedMimeTypeForMp3_test_128_44_jstereo_mp3());
    }

    @Test
    public void shouldProvideMimeTypeForMp3_jingle1_mp3() throws Exception {
        this.testMimeType("docs/jingle1.mp3", this.expectedMimeTypeForMp3_jingle1_mp3());
    }

    @Test
    public void shouldProvideMimeTypeForMp3_jingle2_mp3() throws Exception {
        this.testMimeType("docs/jingle2.mp3", this.expectedMimeTypeForMp3_jingle2_mp3());
    }

    @Test
    public void shouldProvideMimeTypeForMp3_jingle3_mp3() throws Exception {
        this.testMimeType("docs/jingle3.mp3", this.expectedMimeTypeForMp3_jingle3_mp3());
    }

    @Test
    public void shouldProvideMimeTypeForWav() throws Exception {
        this.testMimeType("test.wav", this.expectedMimeTypeForWav());
    }

    @Test
    public void shouldProvideMimeTypeForBmp() throws Exception {
        this.testMimeType("test.bmp", this.expectedMimeTypeForBmp());
    }

    @Test
    public void shouldProvideMimeTypeForGif() throws Exception {
        this.testMimeType("test.gif", this.expectedMimeTypeForGif());
    }

    @Test
    public void shouldProvideMimeTypeForIcon() throws Exception {
        this.testMimeType("test.ico", this.expectedMimeTypeForIcon());
    }

    @Test
    public void shouldProvideMimeTypeForJpeg_test_jpg() throws Exception {
        this.testMimeType("test.jpg", this.expectedMimeTypeForJpeg_test_jpg());
    }

    @Test
    public void shouldProvideMimeTypeForJpeg_jpg_exif_img_9367_JPG() throws Exception {
        this.testMimeType("docs/jpg-exif-img_9367.JPG", this.expectedMimeTypeForJpeg_jpg_exif_img_9367_JPG());
    }

    @Test
    public void shouldProvideMimeTypeForJpeg_jpg_exif_zerolength_jpg() throws Exception {
        this.testMimeType("docs/jpg-exif-zerolength.jpg", this.expectedMimeTypeForJpeg_jpg_exif_zerolength_jpg());
    }

    @Test
    public void shouldProvideMimeTypeForJpeg_jpg_geotagged_jpg() throws Exception {
        this.testMimeType("docs/jpg-geotagged.jpg", this.expectedMimeTypeForJpeg_jpg_geotagged_jpg());
    }

    @Test
    public void shouldProvideMimeTypeForJpeg_jpg_geotagged_ipanema_jpg() throws Exception {
        this.testMimeType("docs/jpg-geotagged-ipanema.jpg", this.expectedMimeTypeForJpeg_jpg_geotagged_ipanema_jpg());
    }

    @Test
    public void shouldProvideMimeTypeForPortablePixelMap_test_ppm() throws Exception {
        this.testMimeType("test.ppm", this.expectedMimeTypeForPortablePixelMap_test_ppm());
    }

    @Test
    public void shouldProvideMimeTypeForPortablePixelMap_test_pnm() throws Exception {
        this.testMimeType("test.pnm", this.expectedMimeTypeForPortablePixelMap_test_pnm());
    }

    @Test
    public void shouldProvideMimeTypeForPng() throws Exception {
        this.testMimeType("test.png", this.expectedMimeTypeForPng());
    }

    @Test
    public void shouldProvideMimeTypeForTiff() throws Exception {
        this.testMimeType("test_nocompress.tif", this.expectedMimeTypeForTiff());
    }

    @Test
    public void shouldProvideMimeTypeForTga() throws Exception {
        this.testMimeType("test.tga", this.expectedMimeTypeForTga());
    }

    @Test
    public void shouldProvideMimeTypeForWmf() throws Exception {
        this.testMimeType("test.wmf", this.expectedMimeTypeForWmf());
    }

    @Test
    public void shouldProvideMimeTypeForXcf() throws Exception {
        this.testMimeType("test.xcf", this.expectedMimeTypeForXcf());
    }

    @Test
    public void shouldProvideMimeTypeForXpm() throws Exception {
        this.testMimeType("test.xpm", this.expectedMimeTypeForXpm());
    }

    @Test
    public void shouldProvideMimeTypeForXml_test_xml() throws Exception {
        this.testMimeType("test.xml", this.expectedMimeTypeForXml_test_xml());
    }

    @Test
    public void shouldProvideMimeTypeForXml_test_excel_spreadsheet_xml() throws Exception {
        this.testMimeType("test_excel_spreadsheet.xml", this.expectedMimeTypeForXml_test_excel_spreadsheet_xml());
    }

    @Test
    public void shouldProvideMimeTypeForXml_CurrencyFormatterExample_mxml() throws Exception {
        this.testMimeType("CurrencyFormatterExample.mxml", this.expectedMimeTypeForXml_CurrencyFormatterExample_mxml());
    }

    @Test
    public void shouldProvideMimeTypeForXml_xml_handwritten_xml() throws Exception {
        this.testMimeType("docs/xml-handwritten.xml", this.expectedMimeTypeForXml_xml_handwritten_xml());
    }

    @Test
    public void shouldProvideMimeTypeForXml_xml_nonexistent_dtd_xml() throws Exception {
        this.testMimeType("docs/xml-nonexistent-dtd.xml", this.expectedMimeTypeForXml_xml_nonexistent_dtd_xml());
    }

    @Test
    public void shouldProvideMimeTypeForXml_xml_nonexistent_remote_dtd_xml() throws Exception {
        this.testMimeType("docs/xml-nonexistent-remote-dtd.xml", this.expectedMimeTypeForXml_xml_nonexistent_remote_dtd_xml());
    }

    @Test
    public void shouldProvideMimeTypeForXml_xml_nonexistent_remote_xsd_xml() throws Exception {
        this.testMimeType("docs/xml-nonexistent-remote-xsd.xml", this.expectedMimeTypeForXml_xml_nonexistent_remote_xsd_xml());
    }

    @Test
    public void shouldProvideMimeTypeForXml_xml_nonexistent_xsd_xml() throws Exception {
        this.testMimeType("docs/xml-nonexistent-xsd.xml", this.expectedMimeTypeForXml_xml_nonexistent_xsd_xml());
    }

    @Test
    public void shouldProvideMimeTypeForXml_xml_utf8_bom() throws Exception {
        this.testMimeType("docs/xml-utf8-bom", this.expectedMimeTypeForXml_xml_utf8_bom());
    }

    @Test
    public void shouldProvideMimeTypeForXsd() throws Exception {
        this.testMimeType("Descriptor.1.0.xsd", this.expectedMimeTypeForXsd());
    }

    @Test
    public void shouldProvideMimeTypeForDtd() throws Exception {
        this.testMimeType("test.dtd", this.expectedMimeTypeForDtd());
    }

    @Test
    public void shouldProvideMimeTypeForHtml_master_xml() throws Exception {
        this.testMimeType("master.xml", this.expectedMimeTypeForHtml_master_xml());
    }

    @Test
    public void shouldProvideMimeTypeForHtml_html_condenast_html() throws Exception {
        this.testMimeType("docs/html-condenast.html", this.expectedMimeTypeForHtml_html_condenast_html());
    }

    @Test
    public void shouldProvideMimeTypeForHtml_html_handwritten_html() throws Exception {
        this.testMimeType("docs/html-handwritten.html", this.expectedMimeTypeForHtml_html_handwritten_html());
    }

    @Test
    public void shouldProvideMimeTypeForHtml_html_handwritten_with_wrong_file_extension_txt() throws Exception {
        this.testMimeType("docs/html-handwritten-with-wrong-file-extension.txt", this.expectedMimeTypeForHtml_html_handwritten_with_wrong_file_extension_txt());
    }

    @Test
    public void shouldProvideMimeTypeForHtml_html_quelle_de_html() throws Exception {
        this.testMimeType("docs/html-quelle.de.html", this.expectedMimeTypeForHtml_html_quelle_de_html());
    }

    @Test
    public void shouldProvideMimeTypeForHtml_html_utf16_leading_whitespace_wrong_extension_doc() throws Exception {
        this.testMimeType("docs/html-utf16-leading-whitespace-wrong-extension.doc", this.expectedMimeTypeForHtml_html_utf16_leading_whitespace_wrong_extension_doc());
    }

    @Test
    public void shouldProvideMimeTypeForJava() throws Exception {
        this.testMimeType("test.java", this.expectedMimeTypeForJava());
    }

    @Test
    public void shouldProvideMimeTypeFor1_2Class() throws Exception {
        this.testMimeType("test_1.2.class", this.expectedMimeTypeFor1_2Class());
    }

    @Test
    public void shouldProvideMimeTypeFor1_3Class() throws Exception {
        this.testMimeType("test_1.3.class", this.expectedMimeTypeFor1_3Class());
    }

    @Test
    public void shouldProvideMimeTypeFor1_4Class() throws Exception {
        this.testMimeType("test_1.4.class", this.expectedMimeTypeFor1_4Class());
    }

    @Test
    public void shouldProvideMimeTypeForPerl() throws Exception {
        this.testMimeType("test.pl", this.expectedMimeTypeForPerl());
    }

    @Test
    public void shouldProvideMimeTypeForPython() throws Exception {
        this.testMimeType("test.py", this.expectedMimeTypeForPython());
    }

    @Test
    public void shouldProvideMimeTypeForPdf_test_pdf() throws Exception {
        this.testMimeType("test.pdf", this.expectedMimeTypeForPdf_test_pdf());
    }

    @Test
    public void shouldProvideMimeTypeForPdf_pdf_distiller_6_weirdchars_pdf() throws Exception {
        this.testMimeType("docs/pdf-distiller-6-weirdchars.pdf", this.expectedMimeTypeForPdf_pdf_distiller_6_weirdchars_pdf());
    }

    @Test
    public void shouldProvideMimeTypeForPdf_pdf_no_author_pdf() throws Exception {
        this.testMimeType("docs/pdf-no-author.pdf", this.expectedMimeTypeForPdf_pdf_no_author_pdf());
    }

    @Test
    public void shouldProvideMimeTypeForPdf_pdf_openoffice_1_1_5_writer_pdf() throws Exception {
        this.testMimeType("docs/pdf-openoffice-1.1.5-writer.pdf", this.expectedMimeTypeForPdf_pdf_openoffice_1_1_5_writer_pdf());
    }

    @Test
    public void shouldProvideMimeTypeForPdf_pdf_openoffice_2_0_writer_pdf() throws Exception {
        this.testMimeType("docs/pdf-openoffice-2.0-writer.pdf", this.expectedMimeTypeForPdf_pdf_openoffice_2_0_writer_pdf());
    }

    @Test
    public void shouldProvideMimeTypeForPdf_pdf_word_2000_pdfcreator_0_8_0_pdf() throws Exception {
        this.testMimeType("docs/pdf-word-2000-pdfcreator-0.8.0.pdf", this.expectedMimeTypeForPdf_pdf_word_2000_pdfcreator_0_8_0_pdf());
    }

    @Test
    public void shouldProvideMimeTypeForPdf_pdf_word_2000_pdfmaker_7_0_pdf() throws Exception {
        this.testMimeType("docs/pdf-word-2000-pdfmaker-7.0.pdf", this.expectedMimeTypeForPdf_pdf_word_2000_pdfmaker_7_0_pdf());
    }

    @Test
    public void shouldProvideMimeTypeForPdf_pdf_word_2000_pdfwriter_7_0_pdf() throws Exception {
        this.testMimeType("docs/pdf-word-2000-pdfwriter-7.0.pdf", this.expectedMimeTypeForPdf_pdf_word_2000_pdfwriter_7_0_pdf());
    }

    @Test
    public void shouldProvideMimeTypeForPostscript_test_ps() throws Exception {
        this.testMimeType("test.ps", this.expectedMimeTypeForPostscript_test_ps());
    }

    @Test
    public void shouldProvideMimeTypeForPostscript_test_eps() throws Exception {
        this.testMimeType("test.eps", this.expectedMimeTypeForPostscript_test_eps());
    }

    @Test
    public void shouldProvideMimeTypeForJar() throws Exception {
        this.testMimeType("dna-repository-0.2-SNAPSHOT.jar", this.expectedMimeTypeForJar());
    }

    @Test
    public void shouldProvideMimeTypeForJavaManifest() throws Exception {
        this.testMimeType("aperture.example.manifest.mf", this.expectedMimeTypeForJavaManifest());
    }

    @Test
    public void shouldProvideMimeTypeForGZip_test_tar_gz() throws Exception {
        this.testMimeType("test.tar.gz", this.expectedMimeTypeForGZip_test_tar_gz());
    }

    @Test
    public void shouldProvideMimeTypeForGZip_test_txt_gz() throws Exception {
        this.testMimeType("test.txt.gz", this.expectedMimeTypeForGZip_test_txt_gz());
    }

    @Test
    public void shouldProvideMimeTypeForZip() throws Exception {
        this.testMimeType("docs/counting-input-stream-test-file.dat", this.expectedMimeTypeForZip());
    }

    @Test
    public void shouldProvideMimeTypeForBash() throws Exception {
        this.testMimeType("test.sh", this.expectedMimeTypeForBash());
    }

    @Test
    public void shouldProvideMimeTypeForOgg() throws Exception {
        this.testMimeType("test.ogg", this.expectedMimeTypeForOgg());
    }

    @Test
    public void shouldProvideMimeTypeForOpenDocumentFormula() throws Exception {
        this.testMimeType("docs/openoffice-2.0-formula.odf", this.expectedMimeTypeForOpenDocumentFormula());
    }

    @Test
    public void shouldProvideMimeTypeForOpenDocumentGraphics() throws Exception {
        this.testMimeType("docs/openoffice-2.0-draw.odg", this.expectedMimeTypeForOpenDocumentGraphics());
    }

    @Test
    public void shouldProvideMimeTypeForOpenDocumentGraphicsTemplate() throws Exception {
        this.testMimeType("docs/openoffice-2.0-draw-template.otg", this.expectedMimeTypeForOpenDocumentGraphicsTemplate());
    }

    @Test
    public void shouldProvideMimeTypeForOpenDocumentPresentation_component_architecture_odp() throws Exception {
        this.testMimeType("component-architecture.odp", this.expectedMimeTypeForOpenDocumentPresentation_component_architecture_odp());
    }

    @Test
    public void shouldProvideMimeTypeForOpenDocumentPresentation_openoffice_2_0_impress_odp() throws Exception {
        this.testMimeType("docs/openoffice-2.0-impress.odp", this.expectedMimeTypeForOpenDocumentPresentation_openoffice_2_0_impress_odp());
    }

    @Test
    public void shouldProvideMimeTypeForOpenDocumentPresentationTemplate() throws Exception {
        this.testMimeType("docs/openoffice-2.0-impress-template.otp", this.expectedMimeTypeForOpenDocumentPresentationTemplate());
    }

    @Test
    public void shouldProvideMimeTypeForOpenDocumentSpreadsheet() throws Exception {
        this.testMimeType("docs/openoffice-2.0-calc.ods", this.expectedMimeTypeForOpenDocumentSpreadsheet());
    }

    @Test
    public void shouldProvideMimeTypeForOpenDocumentSpreadsheetTemplate() throws Exception {
        this.testMimeType("docs/openoffice-2.0-calc-template.ots", this.expectedMimeTypeForOpenDocumentSpreadsheetTemplate());
    }

    @Test
    public void shouldProvideMimeTypeForOpenDocumentText() throws Exception {
        this.testMimeType("docs/openoffice-2.0-writer.odt", this.expectedMimeTypeForOpenDocumentText());
    }

    @Test
    public void shouldProvideMimeTypeForOpenDocumentTextTemplate() throws Exception {
        this.testMimeType("docs/openoffice-2.0-writer-template.ott", this.expectedMimeTypeForOpenDocumentTextTemplate());
    }

    @Test
    public void shouldProvideMimeTypeForOpenOfficeCalc() throws Exception {
        this.testMimeType("docs/openoffice-1.1.5-calc.sxc", this.expectedMimeTypeForOpenOfficeCalc());
    }

    @Test
    public void shouldProvideMimeTypeForOpenOfficeCalcTemplate() throws Exception {
        this.testMimeType("docs/openoffice-1.1.5-calc-template.stc", this.expectedMimeTypeForOpenOfficeCalcTemplate());
    }

    @Test
    public void shouldProvideMimeTypeForOpenOfficeDraw() throws Exception {
        this.testMimeType("docs/openoffice-1.1.5-draw.sxd", this.expectedMimeTypeForOpenOfficeDraw());
    }

    @Test
    public void shouldProvideMimeTypeForOpenOfficeDrawTemplate() throws Exception {
        this.testMimeType("docs/openoffice-1.1.5-draw-template.std", this.expectedMimeTypeForOpenOfficeDrawTemplate());
    }

    @Test
    public void shouldProvideMimeTypeForOpenOfficeImpress() throws Exception {
        this.testMimeType("docs/openoffice-1.1.5-impress.sxi", this.expectedMimeTypeForOpenOfficeImpress());
    }

    @Test
    public void shouldProvideMimeTypeForOpenOfficeImpressTemplate() throws Exception {
        this.testMimeType("docs/openoffice-1.1.5-impress-template.sti", this.expectedMimeTypeForOpenOfficeImpressTemplate());
    }

    @Test
    public void shouldProvideMimeTypeForOpenOfficeWriter() throws Exception {
        this.testMimeType("docs/openoffice-1.1.5-writer.sxw", this.expectedMimeTypeForOpenOfficeWriter());
    }

    @Test
    public void shouldProvideMimeTypeForOpenOfficeWriterTemplate() throws Exception {
        this.testMimeType("docs/openoffice-1.1.5-writer-template.stw", this.expectedMimeTypeForOpenOfficeWriterTemplate());
    }

    @Test
    public void shouldProvideMimeTypeForStarOfficeCalc() throws Exception {
        this.testMimeType("docs/staroffice-5.2-calc.sdc", this.expectedMimeTypeForStarOfficeCalc());
    }

    @Test
    public void shouldProvideMimeTypeForStarOfficeDraw() throws Exception {
        this.testMimeType("docs/staroffice-5.2-draw.sda", this.expectedMimeTypeForStarOfficeDraw());
    }

    @Test
    public void shouldProvideMimeTypeForStarOfficeImpress() throws Exception {
        this.testMimeType("docs/staroffice-5.2-impress.sdd", this.expectedMimeTypeForStarOfficeImpress());
    }

    @Test
    public void shouldProvideMimeTypeForStarOfficeWriter() throws Exception {
        this.testMimeType("docs/staroffice-5.2-writer.sdw", this.expectedMimeTypeForStarOfficeWriter());
    }

    @Test
    public void shouldProvideMimeTypeForStarOfficeCalcTemplate() throws Exception {
        this.testMimeType("docs/staroffice-5.2-calc-template.vor", this.expectedMimeTypeForStarOfficeCalcTemplate());
    }

    @Test
    public void shouldProvideMimeTypeForStarOfficeDrawTemplate() throws Exception {
        this.testMimeType("docs/staroffice-5.2-draw-template.vor", this.expectedMimeTypeForStarOfficeDrawTemplate());
    }

    @Test
    public void shouldProvideMimeTypeForStarOfficeImpressTemplate() throws Exception {
        this.testMimeType("docs/staroffice-5.2-impress-template.vor", this.expectedMimeTypeForStarOfficeImpressTemplate());
    }

    @Test
    public void shouldProvideMimeTypeForStarOfficeWriterTemplate() throws Exception {
        this.testMimeType("docs/staroffice-5.2-writer-template.vor", this.expectedMimeTypeForStarOfficeWriterTemplate());
    }

    @Test
    public void shouldProvideMimeTypeForWord_test_word_2000_doc() throws Exception {
        this.testMimeType("test_word_2000.doc", this.expectedMimeTypeForWord_test_word_2000_doc());
    }

    @Test
    public void shouldProvideMimeTypeForWord_test_word_6_0_95_doc() throws Exception {
        this.testMimeType("test_word_6.0_95.doc", this.expectedMimeTypeForWord_test_word_6_0_95_doc());
    }

    @Test
    public void shouldProvideMimeTypeForWord_microsoft_word_2000_doc() throws Exception {
        this.testMimeType("docs/microsoft-word-2000.doc", this.expectedMimeTypeForWord_microsoft_word_2000_doc());
    }

    @Test
    public void shouldProvideMimeTypeForWord_microsoft_word_2000_with_wrong_file_extension_pdf() throws Exception {
        this.testMimeType("docs/microsoft-word-2000-with-wrong-file-extension.pdf", this.expectedMimeTypeForWord_microsoft_word_2000_with_wrong_file_extension_pdf());
    }

    @Test
    public void shouldProvideMimeTypeForWord_microsoft_word_2007beta2_docm() throws Exception {
        this.testMimeType("docs/microsoft-word-2007beta2.docm", this.expectedMimeTypeForWord_microsoft_word_2007beta2_docm());
    }

    @Test
    public void shouldProvideMimeTypeForWord_microsoft_word_2007beta2_docx() throws Exception {
        this.testMimeType("docs/microsoft-word-2007beta2.docx", this.expectedMimeTypeForWord_microsoft_word_2007beta2_docx());
    }

    @Test
    public void shouldProvideMimeTypeForWord_microsoft_word_2007beta2_dotm() throws Exception {
        this.testMimeType("docs/microsoft-word-2007beta2.dotm", this.expectedMimeTypeForWord_microsoft_word_2007beta2_dotm());
    }

    @Test
    public void shouldProvideMimeTypeForWord_microsoft_word_2007beta2_dotx() throws Exception {
        this.testMimeType("docs/microsoft-word-2007beta2.dotx", this.expectedMimeTypeForWord_microsoft_word_2007beta2_dotx());
    }

    @Test
    public void shouldProvideMimeTypeForWorks_microsoft_works_spreadsheet_4_0_2000_wks() throws Exception {
        this.testMimeType("docs/microsoft-works-spreadsheet-4.0-2000.wks", this.expectedMimeTypeForWorks_microsoft_works_spreadsheet_4_0_2000_wks());
    }

    @Test
    public void shouldProvideMimeTypeForWorks_microsoft_works_spreadsheet_7_0_xlr() throws Exception {
        this.testMimeType("docs/microsoft-works-spreadsheet-7.0.xlr", this.expectedMimeTypeForWorks_microsoft_works_spreadsheet_7_0_xlr());
    }

    @Test
    public void shouldProvideMimeTypeForWorks_microsoft_works_word_processor_2000_wps() throws Exception {
        this.testMimeType("docs/microsoft-works-word-processor-2000.wps", this.expectedMimeTypeForWorks_microsoft_works_word_processor_2000_wps());
    }

    @Test
    public void shouldProvideMimeTypeForWorks_microsoft_works_word_processor_3_0_wps() throws Exception {
        this.testMimeType("docs/microsoft-works-word-processor-3.0.wps", this.expectedMimeTypeForWorks_microsoft_works_word_processor_3_0_wps());
    }

    @Test
    public void shouldProvideMimeTypeForWorks_microsoft_works_word_processor_4_0_wps() throws Exception {
        this.testMimeType("docs/microsoft-works-word-processor-4.0.wps", this.expectedMimeTypeForWorks_microsoft_works_word_processor_4_0_wps());
    }

    @Test
    public void shouldProvideMimeTypeForWorks_microsoft_works_word_processor_7_0_wps() throws Exception {
        this.testMimeType("docs/microsoft-works-word-processor-7.0.wps", this.expectedMimeTypeForWorks_microsoft_works_word_processor_7_0_wps());
    }

    @Test
    public void shouldProvideMimeTypeForWorkbook_corel_quattro_pro_6_wb2() throws Exception {
        this.testMimeType("docs/corel-quattro-pro-6.wb2", this.expectedMimeTypeForWorkbook_corel_quattro_pro_6_wb2());
    }

    @Test
    public void shouldProvideMimeTypeForWorkbook_microsoft_works_spreadsheet_3_0_wks() throws Exception {
        this.testMimeType("docs/microsoft-works-spreadsheet-3.0.wks", this.expectedMimeTypeForWorkbook_microsoft_works_spreadsheet_3_0_wks());
    }

    @Test
    public void shouldProvideMimeTypeForExcel_test_excel_2000_xls() throws Exception {
        this.testMimeType("test_excel_2000.xls", this.expectedMimeTypeForExcel_test_excel_2000_xls());
    }

    @Test
    public void shouldProvideMimeTypeForExcel_microsoft_excel_2000_xls() throws Exception {
        this.testMimeType("docs/microsoft-excel-2000.xls", this.expectedMimeTypeForExcel_microsoft_excel_2000_xls());
    }

    @Test
    public void shouldProvideMimeTypeForExcel_microsoft_excel_2007beta2_xlam() throws Exception {
        this.testMimeType("docs/microsoft-excel-2007beta2.xlam", this.expectedMimeTypeForExcel_microsoft_excel_2007beta2_xlam());
    }

    @Test
    public void shouldProvideMimeTypeForExcel_microsoft_excel_2007beta2_xlsb() throws Exception {
        this.testMimeType("docs/microsoft-excel-2007beta2.xlsb", this.expectedMimeTypeForExcel_microsoft_excel_2007beta2_xlsb());
    }

    @Test
    public void shouldProvideMimeTypeForExcel_microsoft_excel_2007beta2_xlsm() throws Exception {
        this.testMimeType("docs/microsoft-excel-2007beta2.xlsm", this.expectedMimeTypeForExcel_microsoft_excel_2007beta2_xlsm());
    }

    @Test
    public void shouldProvideMimeTypeForExcel_microsoft_excel_2007beta2_xlsx() throws Exception {
        this.testMimeType("docs/microsoft-excel-2007beta2.xlsx", this.expectedMimeTypeForExcel_microsoft_excel_2007beta2_xlsx());
    }

    @Test
    public void shouldProvideMimeTypeForExcel_microsoft_excel_2007beta2_xltm() throws Exception {
        this.testMimeType("docs/microsoft-excel-2007beta2.xltm", this.expectedMimeTypeForExcel_microsoft_excel_2007beta2_xltm());
    }

    @Test
    public void shouldProvideMimeTypeForExcel_microsoft_excel_2007beta2_xltx() throws Exception {
        this.testMimeType("docs/microsoft-excel-2007beta2.xltx", this.expectedMimeTypeForExcel_microsoft_excel_2007beta2_xltx());
    }

    @Test
    public void shouldProvideMimeTypeForPowerpoint_test_ppt() throws Exception {
        this.testMimeType("test.ppt", this.expectedMimeTypeForPowerpoint_test_ppt());
    }

    @Test
    public void shouldProvideMimeTypeForPowerpoint_microsoft_powerpoint_2000_ppt() throws Exception {
        this.testMimeType("docs/microsoft-powerpoint-2000.ppt", this.expectedMimeTypeForPowerpoint_microsoft_powerpoint_2000_ppt());
    }

    @Test
    public void shouldProvideMimeTypeForPowerpoint_microsoft_powerpoint_2007beta2_potm() throws Exception {
        this.testMimeType("docs/microsoft-powerpoint-2007beta2.potm", this.expectedMimeTypeForPowerpoint_microsoft_powerpoint_2007beta2_potm());
    }

    @Test
    public void shouldProvideMimeTypeForPowerpoint_microsoft_powerpoint_2007beta2_potx() throws Exception {
        this.testMimeType("docs/microsoft-powerpoint-2007beta2.potx", this.expectedMimeTypeForPowerpoint_microsoft_powerpoint_2007beta2_potx());
    }

    @Test
    public void shouldProvideMimeTypeForPowerpoint_microsoft_powerpoint_2007beta2_ppsm() throws Exception {
        this.testMimeType("docs/microsoft-powerpoint-2007beta2.ppsm", this.expectedMimeTypeForPowerpoint_microsoft_powerpoint_2007beta2_ppsm());
    }

    @Test
    public void shouldProvideMimeTypeForPowerpoint_microsoft_powerpoint_2007beta2_ppsx() throws Exception {
        this.testMimeType("docs/microsoft-powerpoint-2007beta2.ppsx", this.expectedMimeTypeForPowerpoint_microsoft_powerpoint_2007beta2_ppsx());
    }

    @Test
    public void shouldProvideMimeTypeForPowerpoint_microsoft_powerpoint_2007beta2_pptm() throws Exception {
        this.testMimeType("docs/microsoft-powerpoint-2007beta2.pptm", this.expectedMimeTypeForPowerpoint_microsoft_powerpoint_2007beta2_pptm());
    }

    @Test
    public void shouldProvideMimeTypeForPowerpoint_microsoft_powerpoint_2007beta2_pptx() throws Exception {
        this.testMimeType("docs/microsoft-powerpoint-2007beta2.pptx", this.expectedMimeTypeForPowerpoint_microsoft_powerpoint_2007beta2_pptx());
    }

    @Test
    public void shouldProvideMimeTypeForPublisher() throws Exception {
        this.testMimeType("docs/microsoft-publisher-2003.pub", this.expectedMimeTypeForPublisher());
    }

    @Test
    public void shouldProvideMimeTypeForVisio() throws Exception {
        this.testMimeType("docs/microsoft-visio.vsd", this.expectedMimeTypeForVisio());
    }

    @Test
    public void shouldProvideMimeTypeForOutlook() throws Exception {
        this.testMimeType("TestData.pst", this.expectedMimeTypeForOutlook());
    }

    @Test
    public void shouldProvideMimeTypeForShw_corel_presentations_3_0_shw() throws Exception {
        this.testMimeType("docs/corel-presentations-3.0.shw", this.expectedMimeTypeForShw_corel_presentations_3_0_shw());
    }

    @Test
    public void shouldProvideMimeTypeForShw_corel_presentations_x3_shw() throws Exception {
        this.testMimeType("docs/corel-presentations-x3.shw", this.expectedMimeTypeForShw_corel_presentations_x3_shw());
    }

    @Test
    public void shouldProvideMimeTypeForQuattroPro_corel_quattro_pro_7_wb3() throws Exception {
        this.testMimeType("docs/corel-quattro-pro-7.wb3", this.expectedMimeTypeForPro_corel_quattro_pro_7_wb3());
    }

    @Test
    public void shouldProvideMimeTypeForQuattroPro_corel_quattro_pro_x3_qpw() throws Exception {
        this.testMimeType("docs/corel-quattro-pro-x3.qpw", this.expectedMimeTypeForPro_corel_quattro_pro_x3_qpw());
    }

    @Test
    public void shouldProvideMimeTypeForWordperfect_corel_wordperfect_4_2_wp() throws Exception {
        this.testMimeType("docs/corel-wordperfect-4.2.wp", this.expectedMimeTypeForWordperfect_corel_wordperfect_4_2_wp());
    }

    @Test
    public void shouldProvideMimeTypeForWordperfect_corel_wordperfect_5_0_wp() throws Exception {
        this.testMimeType("docs/corel-wordperfect-5.0.wp", this.expectedMimeTypeForWordperfect_corel_wordperfect_5_0_wp());
    }

    @Test
    public void shouldProvideMimeTypeForWordperfect_corel_wordperfect_5_1_wp() throws Exception {
        this.testMimeType("docs/corel-wordperfect-5.1.wp", this.expectedMimeTypeForWordperfect_corel_wordperfect_5_1_wp());
    }

    @Test
    public void shouldProvideMimeTypeForWordperfect_corel_wordperfect_5_1_far_east_wp() throws Exception {
        this.testMimeType("docs/corel-wordperfect-5.1-far-east.wp", this.expectedMimeTypeForWordperfect_corel_wordperfect_5_1_far_east_wp());
    }

    @Test
    public void shouldProvideMimeTypeForWordperfect_corel_wordperfect_x3_wpd() throws Exception {
        this.testMimeType("docs/corel-wordperfect-x3.wpd", this.expectedMimeTypeForWordperfect_corel_wordperfect_x3_wpd());
    }

    @Test
    public void shouldProvideMimeTypeForMail_test_excel_web_archive_mht() throws Exception {
        this.testMimeType("test_excel_web_archive.mht", this.expectedMimeTypeForMail_test_excel_web_archive_mht());
    }

    @Test
    public void shouldProvideMimeTypeForMail_mail_thunderbird_1_5_eml() throws Exception {
        this.testMimeType("docs/mail-thunderbird-1.5.eml", this.expectedMimeTypeForMail_mail_thunderbird_1_5_eml());
    }

    @Test
    public void shouldProvideMimeTypeForMail_mhtml_firefox_mht() throws Exception {
        this.testMimeType("docs/mhtml-firefox.mht", this.expectedMimeTypeForMail_mhtml_firefox_mht());
    }

    @Test
    public void shouldProvideMimeTypeForMail_mhtml_internet_explorer_mht() throws Exception {
        this.testMimeType("docs/mhtml-internet-explorer.mht", this.expectedMimeTypeForMail_mhtml_internet_explorer_mht());
    }

    @Test
    public void shouldProvideMimeTypeForAddressBook() throws Exception {
        this.testMimeType("docs/thunderbird-addressbook.mab", this.expectedMimeTypeForAddressBook());
    }

    @Test
    public void shouldProvideMimeTypeForVCard_vcard_antoni_kontact_vcf() throws Exception {
        this.testMimeType("docs/vcard-antoni-kontact.vcf", this.expectedMimeTypeForVCard_vcard_antoni_kontact_vcf());
    }

    @Test
    public void shouldProvideMimeTypeForVCard_vcard_antoni_outlook2003_vcf() throws Exception {
        this.testMimeType("docs/vcard-antoni-outlook2003.vcf", this.expectedMimeTypeForVCard_vcard_antoni_outlook2003_vcf());
    }

    @Test
    public void shouldProvideMimeTypeForVCard_vcard_dirk_vcf() throws Exception {
        this.testMimeType("docs/vcard-dirk.vcf", this.expectedMimeTypeForVCard_vcard_dirk_vcf());
    }

    @Test
    public void shouldProvideMimeTypeForVCard_vcard_rfc2426_vcf() throws Exception {
        this.testMimeType("docs/vcard-rfc2426.vcf", this.expectedMimeTypeForVCard_vcard_rfc2426_vcf());
    }

    @Test
    public void shouldProvideMimeTypeForVCard_vcard_vCards_SAP_vcf() throws Exception {
        this.testMimeType("docs/vcard-vCards-SAP.vcf", this.expectedMimeTypeForVCard_vcard_vCards_SAP_vcf());
    }

    @Test
    public void shouldProvideMimeTypeForCalendar_basicCalendar_ics() throws Exception {
        this.testMimeType("docs/icaltestdata/basicCalendar.ics", this.expectedMimeTypeForCalendar_basicCalendar_ics());
    }

    @Test
    public void shouldProvideMimeTypeForCalendar_cal01_ics() throws Exception {
        this.testMimeType("docs/icaltestdata/cal01.ics", this.expectedMimeTypeForCalendar_cal01_ics());
    }

    @Test
    public void shouldProvideMimeTypeForCalendar_cal01_1_ics() throws Exception {
        this.testMimeType("docs/icaltestdata/cal01-1.ics", this.expectedMimeTypeForCalendar_cal01_1_ics());
    }

    @Test
    public void shouldProvideMimeTypeForCalendar_cal01_2_ics() throws Exception {
        this.testMimeType("docs/icaltestdata/cal01-2.ics", this.expectedMimeTypeForCalendar_cal01_2_ics());
    }

    @Test
    public void shouldProvideMimeTypeForCalendar_cal01_3_ics() throws Exception {
        this.testMimeType("docs/icaltestdata/cal01-3.ics", this.expectedMimeTypeForCalendar_cal01_3_ics());
    }

    @Test
    public void shouldProvideMimeTypeForCalendar_cal01_4_ics() throws Exception {
        this.testMimeType("docs/icaltestdata/cal01-4.ics", this.expectedMimeTypeForCalendar_cal01_4_ics());
    }

    @Test
    public void shouldProvideMimeTypeForCalendar_cal01_5_ics() throws Exception {
        this.testMimeType("docs/icaltestdata/cal01-5.ics", this.expectedMimeTypeForCalendar_cal01_5_ics());
    }

    @Test
    public void shouldProvideMimeTypeForCalendar_cal01_6_ics() throws Exception {
        this.testMimeType("docs/icaltestdata/cal01-6.ics", this.expectedMimeTypeForCalendar_cal01_6_ics());
    }

    @Test
    public void shouldProvideMimeTypeForCalendar_cal01_exrule_ics() throws Exception {
        this.testMimeType("docs/icaltestdata/cal01-exrule.ics", this.expectedMimeTypeForCalendar_cal01_exrule_ics());
    }

    @Test
    public void shouldProvideMimeTypeForCalendar_calconnect7_ics() throws Exception {
        this.testMimeType("docs/icaltestdata/calconnect7.ics", this.expectedMimeTypeForCalendar_calconnect7_ics());
    }

    @Test
    public void shouldProvideMimeTypeForCalendar_calconnect9_ics() throws Exception {
        this.testMimeType("docs/icaltestdata/calconnect9.ics", this.expectedMimeTypeForCalendar_calconnect9_ics());
    }

    @Test
    public void shouldProvideMimeTypeForCalendar_combined_multiplevcalendar_ics() throws Exception {
        this.testMimeType("docs/icaltestdata/combined_multiplevcalendar.ics", this.expectedMimeTypeForCalendar_combined_multiplevcalendar_ics());
    }

    @Test
    public void shouldProvideMimeTypeForCalendar_combined_onevcalendar_ics() throws Exception {
        this.testMimeType("docs/icaltestdata/combined_onevcalendar.ics", this.expectedMimeTypeForCalendar_combined_onevcalendar_ics());
    }

    @Test
    public void shouldProvideMimeTypeForCalendar_extendedCalendar_ics() throws Exception {
        this.testMimeType("docs/icaltestdata/extendedCalendar.ics", this.expectedMimeTypeForCalendar_extendedCalendar_ics());
    }

    @Test
    public void shouldProvideMimeTypeForCalendar_freebusy_ics() throws Exception {
        this.testMimeType("docs/icaltestdata/freebusy.ics", this.expectedMimeTypeForCalendar_freebusy_ics());
    }

    @Test
    public void shouldProvideMimeTypeForCalendar_geol_ics() throws Exception {
        this.testMimeType("docs/icaltestdata/geo1.ics", this.expectedMimeTypeForCalendar_geol_ics());
    }

    @Test
    public void shouldProvideMimeTypeForCalendar_gkexample_ics() throws Exception {
        this.testMimeType("docs/icaltestdata/gkexample.ics", this.expectedMimeTypeForCalendar_gkexample_ics());
    }

    @Test
    public void shouldProvideMimeTypeForCalendar_incoming_ics() throws Exception {
        this.testMimeType("docs/icaltestdata/incoming.ics", this.expectedMimeTypeForCalendar_incoming_ics());
    }

    @Test
    public void shouldProvideMimeTypeForCalendar_korganizer_jicaltest_vjournal_ics() throws Exception {
        this.testMimeType("docs/icaltestdata/korganizer-jicaltest-vjournal.ics", this.expectedMimeTypeForCalendar_korganizer_jicaltest_vjournal_ics());
    }

    @Test
    public void shouldProvideMimeTypeForCalendar_korganizer_jicaltest_ics() throws Exception {
        this.testMimeType("docs/icaltestdata/korganizer-jicaltest.ics", this.expectedMimeTypeForCalendar_korganizer_jicaltest_ics());
    }

    @Test
    public void shouldProvideMimeTypeForCalendar_php_flp_ics() throws Exception {
        this.testMimeType("docs/icaltestdata/php-flp.ics", this.expectedMimeTypeForCalendar_php_flp_ics());
    }

    @Test
    public void shouldProvideMimeTypeForCalendar_simplevevent_ics() throws Exception {
        this.testMimeType("docs/icaltestdata/simplevevent.ics", this.expectedMimeTypeForCalendar_simplevevent_ics());
    }

    @Test
    public void shouldProvideMimeTypeForCalendar_sunbird_sample_ics() throws Exception {
        this.testMimeType("docs/icaltestdata/sunbird_sample.ics", this.expectedMimeTypeForCalendar_sunbird_sample_ics());
    }

    @Test
    public void shouldProvideMimeTypeForCalendar_tag_bug_ics() throws Exception {
        this.testMimeType("docs/icaltestdata/tag-bug.ics", this.expectedMimeTypeForCalendar_tag_bug_ics());
    }

    @Test
    public void shouldProvideMimeTypeForCalendar_test_created_ics() throws Exception {
        this.testMimeType("docs/icaltestdata/test-created.ics", this.expectedMimeTypeForCalendar_test_created_ics());
    }

    @Test
    public void shouldProvideMimeTypeForCalendar_Todos1_ics() throws Exception {
        this.testMimeType("docs/icaltestdata/Todos1.ics", this.expectedMimeTypeForCalendar_Todos1_ics());
    }

    @Test
    public void shouldProvideMimeTypeForAu() throws Exception {
        this.testMimeType("test.au", this.expectedMimeTypeForAu());
    }

    @Test
    public void shouldProvideMimeTypeForBin() throws Exception {
        this.testMimeType("test.bin", this.expectedMimeTypeForBin());
    }

    @Test
    public void shouldProvideMimeTypeForEmf() throws Exception {
        this.testMimeType("test.emf", this.expectedMimeTypeForEmf());
    }

    @Test
    public void shouldProvideMimeTypeForFli() throws Exception {
        this.testMimeType("test.fli", this.expectedMimeTypeForFli());
    }

    @Test
    public void shouldProvideMimeTypeForPcx() throws Exception {
        this.testMimeType("test.pcx", this.expectedMimeTypeForPcx());
    }

    @Test
    public void shouldProvideMimeTypeForPict() throws Exception {
        this.testMimeType("test.pict", this.expectedMimeTypeForPict());
    }

    @Test
    public void shouldProvideMimeTypeForPsd() throws Exception {
        this.testMimeType("test.psd", this.expectedMimeTypeForPsd());
    }

    @Test
    public void shouldProvideMimeTypeForTar() throws Exception {
        this.testMimeType("test.tar", this.expectedMimeTypeForTar());
    }
}

