/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.property.basic;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.matchers.JUnitMatchers;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.basic.SimpleNamespaceRegistry;

public abstract class AbstractNamespaceRegistryTest<NamespaceRegistryType extends NamespaceRegistry> {
    protected String validNamespaceUri1;
    protected String validNamespaceUri2;
    protected String validNamespaceUri3;
    protected String validPrefix1;
    protected String validPrefix2;
    protected NamespaceRegistryType namespaceRegistry;

    @Before
    public void setUp() {
        this.validNamespaceUri1 = "http://example.com/foo";
        this.validNamespaceUri2 = "http://acme.com/something";
        this.validNamespaceUri3 = "http://www.redhat.com";
        this.validPrefix1 = "foo";
        this.validPrefix2 = "acme";
        this.namespaceRegistry = this.createNamespaceRegistry();
    }

    protected abstract NamespaceRegistryType createNamespaceRegistry();

    @Test
    public void shouldReturnNullForNamespaceUriIfPrefixIsNotRegistered() {
        Assert.assertThat((Object)this.namespaceRegistry.getNamespaceForPrefix("notfound"), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        this.namespaceRegistry.register(this.validPrefix1, this.validNamespaceUri1);
        this.namespaceRegistry.register(this.validPrefix2, this.validNamespaceUri2);
        Assert.assertThat((Object)this.namespaceRegistry.getNamespaceForPrefix("notfound"), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldReturnNamespaceUriForPrefixThatIsRegistered() {
        this.namespaceRegistry.register(this.validPrefix1, this.validNamespaceUri1);
        this.namespaceRegistry.register(this.validPrefix2, this.validNamespaceUri2);
        Assert.assertThat((Object)this.namespaceRegistry.getNamespaceForPrefix(this.validPrefix1), (Matcher)Is.is((Object)this.validNamespaceUri1));
        Assert.assertThat((Object)this.namespaceRegistry.getNamespaceForPrefix(this.validPrefix2), (Matcher)Is.is((Object)this.validNamespaceUri2));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowNullPrefixParameterWhenGettingNamespaceUri() {
        this.namespaceRegistry.getNamespaceForPrefix(null);
    }

    @Test
    public void shouldReturnNullForPrefixIfNamespaceUriIsNotRegistered() {
        Assert.assertThat((Object)this.namespaceRegistry.getPrefixForNamespaceUri(this.validNamespaceUri3, false), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        this.namespaceRegistry.register(this.validPrefix1, this.validNamespaceUri1);
        this.namespaceRegistry.register(this.validPrefix2, this.validNamespaceUri2);
        Assert.assertThat((Object)this.namespaceRegistry.getPrefixForNamespaceUri(this.validNamespaceUri3, false), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldReturnPrefixForNamespaceUriThatIsRegistered() {
        this.namespaceRegistry.register(this.validPrefix1, this.validNamespaceUri1);
        this.namespaceRegistry.register(this.validPrefix2, this.validNamespaceUri2);
        Assert.assertThat((Object)this.namespaceRegistry.getPrefixForNamespaceUri(this.validNamespaceUri1, false), (Matcher)Is.is((Object)this.validPrefix1));
        Assert.assertThat((Object)this.namespaceRegistry.getPrefixForNamespaceUri(this.validNamespaceUri2, false), (Matcher)Is.is((Object)this.validPrefix2));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowNullNamespaceUriParameterWhenGettingPrefix() {
        this.namespaceRegistry.getPrefixForNamespaceUri(null, false);
    }

    @Test
    public void shouldAlwaysHaveDefaultNamespaceRegistered() {
        Assert.assertThat((Object)this.namespaceRegistry.getDefaultNamespaceUri(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.namespaceRegistry.register(this.validPrefix1, this.validNamespaceUri1);
        this.namespaceRegistry.register(this.validPrefix2, this.validNamespaceUri2);
        Assert.assertThat((Object)this.namespaceRegistry.getDefaultNamespaceUri(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldReturnNonNullDefaultNamespaceUriWhenThereAreNamespacesRegisteredIncludineOneWithZeroLengthPrefix() {
        this.namespaceRegistry.register(this.validPrefix1, this.validNamespaceUri1);
        this.namespaceRegistry.register("", this.validNamespaceUri2);
        Assert.assertThat((Object)this.namespaceRegistry.getDefaultNamespaceUri(), (Matcher)Is.is((Object)this.validNamespaceUri2));
        Assert.assertThat((Object)this.namespaceRegistry.getNamespaceForPrefix(""), (Matcher)Is.is((Object)this.validNamespaceUri2));
        Assert.assertThat((Object)this.namespaceRegistry.getRegisteredNamespaceUris(), (Matcher)JUnitMatchers.hasItem((Object)this.validNamespaceUri2));
        Assert.assertThat((Object)this.namespaceRegistry.getPrefixForNamespaceUri(this.validNamespaceUri2, false), (Matcher)Is.is((Object)""));
    }

    @Test
    public void shouldNotFindRegisteredNamespaceIfNamespaceNotRegistered() {
        Assert.assertThat((Object)this.namespaceRegistry.isRegisteredNamespaceUri(this.validNamespaceUri1), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.namespaceRegistry.isRegisteredNamespaceUri(this.validNamespaceUri2), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.namespaceRegistry.isRegisteredNamespaceUri(this.validNamespaceUri3), (Matcher)Is.is((Object)false));
        this.namespaceRegistry.register(this.validPrefix1, this.validNamespaceUri1);
        this.namespaceRegistry.register(this.validPrefix2, this.validNamespaceUri2);
        Assert.assertThat((Object)this.namespaceRegistry.isRegisteredNamespaceUri(this.validNamespaceUri1), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.namespaceRegistry.isRegisteredNamespaceUri(this.validNamespaceUri2), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.namespaceRegistry.isRegisteredNamespaceUri(this.validNamespaceUri3), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldFindRegisteredNamespace() {
        this.namespaceRegistry.register(this.validPrefix1, this.validNamespaceUri1);
        this.namespaceRegistry.register(this.validPrefix2, this.validNamespaceUri2);
        Assert.assertThat((Object)this.namespaceRegistry.isRegisteredNamespaceUri(this.validNamespaceUri1), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.namespaceRegistry.isRegisteredNamespaceUri(this.validNamespaceUri2), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldBeAbleToCopyNamespacesToAnotherRegistry() {
        this.namespaceRegistry.register(this.validPrefix1, this.validNamespaceUri1);
        this.namespaceRegistry.register(this.validPrefix2, this.validNamespaceUri2);
        this.namespaceRegistry.register("", this.validNamespaceUri3);
        Assert.assertThat((Object)this.namespaceRegistry.isRegisteredNamespaceUri(this.validNamespaceUri1), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.namespaceRegistry.isRegisteredNamespaceUri(this.validNamespaceUri2), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.namespaceRegistry.isRegisteredNamespaceUri(this.validNamespaceUri3), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.namespaceRegistry.getPrefixForNamespaceUri(this.validNamespaceUri1, false), (Matcher)Is.is((Object)this.validPrefix1));
        Assert.assertThat((Object)this.namespaceRegistry.getPrefixForNamespaceUri(this.validNamespaceUri2, false), (Matcher)Is.is((Object)this.validPrefix2));
        Assert.assertThat((Object)this.namespaceRegistry.getPrefixForNamespaceUri(this.validNamespaceUri3, false), (Matcher)Is.is((Object)""));
        Assert.assertThat((Object)this.namespaceRegistry.getNamespaceForPrefix(this.validPrefix1), (Matcher)Is.is((Object)this.validNamespaceUri1));
        Assert.assertThat((Object)this.namespaceRegistry.getNamespaceForPrefix(this.validPrefix2), (Matcher)Is.is((Object)this.validNamespaceUri2));
        Assert.assertThat((Object)this.namespaceRegistry.getNamespaceForPrefix(""), (Matcher)Is.is((Object)this.validNamespaceUri3));
        SimpleNamespaceRegistry newRegistry = new SimpleNamespaceRegistry();
        for (String uri : this.namespaceRegistry.getRegisteredNamespaceUris()) {
            String prefix = this.namespaceRegistry.getPrefixForNamespaceUri(uri, false);
            newRegistry.register(prefix, uri);
        }
        Assert.assertThat((Object)newRegistry.isRegisteredNamespaceUri(this.validNamespaceUri1), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)newRegistry.isRegisteredNamespaceUri(this.validNamespaceUri2), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)newRegistry.isRegisteredNamespaceUri(this.validNamespaceUri3), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)newRegistry.getPrefixForNamespaceUri(this.validNamespaceUri1, false), (Matcher)Is.is((Object)this.validPrefix1));
        Assert.assertThat((Object)newRegistry.getPrefixForNamespaceUri(this.validNamespaceUri2, false), (Matcher)Is.is((Object)this.validPrefix2));
        Assert.assertThat((Object)newRegistry.getPrefixForNamespaceUri(this.validNamespaceUri3, false), (Matcher)Is.is((Object)""));
        Assert.assertThat((Object)newRegistry.getNamespaceForPrefix(this.validPrefix1), (Matcher)Is.is((Object)this.validNamespaceUri1));
        Assert.assertThat((Object)newRegistry.getNamespaceForPrefix(this.validPrefix2), (Matcher)Is.is((Object)this.validNamespaceUri2));
        Assert.assertThat((Object)newRegistry.getNamespaceForPrefix(""), (Matcher)Is.is((Object)this.validNamespaceUri3));
    }
}

