/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.query.QueryBuilder;
import org.modeshape.graph.query.model.QueryCommand;
import org.modeshape.graph.query.model.Visitable;
import org.modeshape.graph.query.model.Visitors;

public class QueryBuilderTest {
    private QueryBuilder builder;
    private QueryCommand query;

    @Before
    public void beforeEach() {
        this.builder = new QueryBuilder(new ExecutionContext().getValueFactories().getTypeSystem());
    }

    protected void assertThatSql(QueryCommand query, Matcher<String> expected) {
        Assert.assertThat((Object)Visitors.readable((Visitable)query), expected);
    }

    @Test
    public void shouldBuildSelectStarFromAllNodes() {
        this.query = this.builder.selectStar().fromAllNodes().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM __ALLNODES__"));
    }

    @Test
    public void shouldBuildSelectStarFromAllNodesAs() {
        this.query = this.builder.selectStar().fromAllNodesAs("nodes").query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM __ALLNODES__ AS nodes"));
    }

    @Test
    public void shouldBuildSelectStarWithoutOtherClausesAsFromAllNodes() {
        this.query = this.builder.selectStar().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM __ALLNODES__"));
    }

    @Test
    public void shouldBuildSelectColumnsFromAllNodes() {
        this.query = this.builder.select(new String[]{"col1", "col2"}).fromAllNodes().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT __ALLNODES__.col1,__ALLNODES__.col2 FROM __ALLNODES__"));
    }

    @Test
    public void shouldBuildSelectColumnsFromAllNodesAs() {
        this.query = this.builder.select(new String[]{"col1", "col2"}).fromAllNodesAs("nodes").query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT nodes.col1,nodes.col2 FROM __ALLNODES__ AS nodes"));
    }

    @Test
    public void shouldBuildSelectColumnsUsingAliasFromAllNodesAs() {
        this.query = this.builder.select(new String[]{"col1", "nodes.col2"}).fromAllNodesAs("nodes").query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT nodes.col1,nodes.col2 FROM __ALLNODES__ AS nodes"));
    }

    @Test
    public void shouldBuildSelectStarFromOneTable() {
        this.query = this.builder.selectStar().from("table").query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table"));
    }

    @Test
    public void shouldBuildSelectStarFromOneTableAs() {
        this.query = this.builder.selectStar().from("table AS nodes").query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes"));
    }

    @Test
    public void shouldBuildSelectColumnsFromOneTable() {
        this.query = this.builder.select(new String[]{"col1", "col2"}).from("table").query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT table.col1,table.col2 FROM table"));
    }

    @Test
    public void shouldBuildSelectColumnsFromOneTableAs() {
        this.query = this.builder.select(new String[]{"col1", "col2"}).from("table AS nodes").query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT nodes.col1,nodes.col2 FROM table AS nodes"));
    }

    @Test
    public void shouldBuildSelectColumnsUsingAliasFromOneTableAs() {
        this.query = this.builder.select(new String[]{"col1", "nodes.col2"}).from("table AS  nodes").query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT nodes.col1,nodes.col2 FROM table AS nodes"));
    }

    @Test
    public void shouldBuildUnionFromTwoSimpleSelects() {
        this.query = this.builder.select(new String[]{"col1", "nodes.col2"}).from("table1 AS  nodes").union().select(new String[]{"col3", "edges.col4"}).from("table2 AS  edges").query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT nodes.col1,nodes.col2 FROM table1 AS nodes UNION SELECT edges.col3,edges.col4 FROM table2 AS edges"));
    }

    @Test
    public void shouldBuildUnionAllFromTwoSimpleSelects() {
        this.query = this.builder.select(new String[]{"col1", "nodes.col2"}).from("table1 AS  nodes").unionAll().select(new String[]{"col3", "edges.col4"}).from("table2 AS  edges").query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT nodes.col1,nodes.col2 FROM table1 AS nodes UNION ALL SELECT edges.col3,edges.col4 FROM table2 AS edges"));
    }

    @Test
    public void shouldBuildUnionAllFromThreeSimpleSelects() {
        this.query = this.builder.select(new String[]{"col1", "nodes.col2"}).from("table1 AS  nodes").union().select(new String[]{"col3", "edges.col4"}).from("table2 AS  edges").unionAll().select(new String[]{"col5", "col6"}).from("table3").query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT nodes.col1,nodes.col2 FROM table1 AS nodes UNION SELECT edges.col3,edges.col4 FROM table2 AS edges UNION ALL SELECT table3.col5,table3.col6 FROM table3"));
    }

    @Test
    public void shouldBuildIntersectFromTwoSimpleSelects() {
        this.query = this.builder.select(new String[]{"col1", "nodes.col2"}).from("table1 AS  nodes").intersect().select(new String[]{"col3", "edges.col4"}).from("table2 AS  edges").query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT nodes.col1,nodes.col2 FROM table1 AS nodes INTERSECT SELECT edges.col3,edges.col4 FROM table2 AS edges"));
    }

    @Test
    public void shouldBuildIntersectAllFromTwoSimpleSelects() {
        this.query = this.builder.select(new String[]{"col1", "nodes.col2"}).from("table1 AS  nodes").intersectAll().select(new String[]{"col3", "edges.col4"}).from("table2 AS  edges").query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT nodes.col1,nodes.col2 FROM table1 AS nodes INTERSECT ALL SELECT edges.col3,edges.col4 FROM table2 AS edges"));
    }

    @Test
    public void shouldBuildExceptFromTwoSimpleSelects() {
        this.query = this.builder.select(new String[]{"col1", "nodes.col2"}).from("table1 AS  nodes").intersect().select(new String[]{"col3", "edges.col4"}).from("table2 AS  edges").query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT nodes.col1,nodes.col2 FROM table1 AS nodes INTERSECT SELECT edges.col3,edges.col4 FROM table2 AS edges"));
    }

    @Test
    public void shouldBuildExceptAllFromTwoSimpleSelects() {
        this.query = this.builder.select(new String[]{"col1", "nodes.col2"}).from("table1 AS  nodes").intersectAll().select(new String[]{"col3", "edges.col4"}).from("table2 AS  edges").query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT nodes.col1,nodes.col2 FROM table1 AS nodes INTERSECT ALL SELECT edges.col3,edges.col4 FROM table2 AS edges"));
    }

    @Test
    public void shouldBuildEquiJoin() {
        this.query = this.builder.select(new String[]{"t1.c1", "t2.c2"}).from("table1 AS  t1").join("table2 as t2").on(" t1.c0= t2. c0").query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT t1.c1,t2.c2 FROM table1 AS t1 INNER JOIN table2 as t2 ON t1.c0 = t2.c0"));
    }

    @Test
    public void shouldBuildInnerEquiJoin() {
        this.query = this.builder.select(new String[]{"t1.c1", "t2.c2"}).from("table1 AS  t1").innerJoin("table2 as t2").on(" t1.c0= t2. c0").query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT t1.c1,t2.c2 FROM table1 AS t1 INNER JOIN table2 as t2 ON t1.c0 = t2.c0"));
    }

    @Test
    public void shouldBuildLeftOuterEquiJoin() {
        this.query = this.builder.select(new String[]{"t1.c1", "t2.c2"}).from("table1 AS  t1").leftOuterJoin("table2 as t2").on(" t1.c0= t2. c0").query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT t1.c1,t2.c2 FROM table1 AS t1 LEFT OUTER JOIN table2 as t2 ON t1.c0 = t2.c0"));
    }

    @Test
    public void shouldBuildRightOuterEquiJoin() {
        this.query = this.builder.select(new String[]{"t1.c1", "t2.c2"}).from("table1 AS  t1").rightOuterJoin("table2 as t2").on(" t1.c0= t2. c0").query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT t1.c1,t2.c2 FROM table1 AS t1 RIGHT OUTER JOIN table2 as t2 ON t1.c0 = t2.c0"));
    }

    @Test
    public void shouldBuildFullOuterEquiJoin() {
        this.query = this.builder.select(new String[]{"t1.c1", "t2.c2"}).from("table1 AS  t1").fullOuterJoin("table2 as t2").on(" t1.c0= t2. c0").query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT t1.c1,t2.c2 FROM table1 AS t1 FULL OUTER JOIN table2 as t2 ON t1.c0 = t2.c0"));
    }

    @Test
    public void shouldBuildCrossEquiJoin() {
        this.query = this.builder.select(new String[]{"t1.c1", "t2.c2"}).from("table1 AS  t1").crossJoin("table2 as t2").on(" t1.c0= t2. c0").query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT t1.c1,t2.c2 FROM table1 AS t1 CROSS JOIN table2 as t2 ON t1.c0 = t2.c0"));
    }

    @Test
    public void shouldBuildMultiJoinUsingEquiJoinCriteria() {
        this.query = this.builder.select(new String[]{"t1.c1", "t2.c2"}).from("table1 AS  t1").join("table2 as t2").on(" t1.c0= t2. c0").join("table3 as t3").on(" t1.c0= t3. c0").query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT t1.c1,t2.c2 FROM table1 AS t1 INNER JOIN table2 as t2 ON t1.c0 = t2.c0 INNER JOIN table3 as t3 ON t1.c0 = t3.c0"));
    }

    @Test
    public void shouldBuildMultiJoinAndCrossUsingEquiJoinCriteria() {
        this.query = this.builder.select(new String[]{"t1.c1", "t2.c2"}).from("table1 AS  t1").join("table2 as t2").on(" t1.c0= t2. c0").crossJoin("table3 as t3").on(" t1.c0= t3. c0").query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT t1.c1,t2.c2 FROM table1 AS t1 INNER JOIN table2 as t2 CROSS JOIN table3 as t3 ON t1.c0 = t3.c0 ON t1.c0 = t2.c0"));
    }

    @Test
    public void shouldAddNoConstraintsIfConstraintBuilderIsNotUsedButIsEnded() {
        this.query = this.builder.selectStar().from("table AS nodes").where().end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes"));
    }

    @Test
    public void shouldBuildQueryWithBetweenRange() {
        this.query = ((QueryBuilder.UpperBoundary)this.builder.selectStar().from("table AS nodes").where().propertyValue("nodes", "col1").isBetween().literal("lower").and()).literal(true).end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE nodes.col1 BETWEEN 'lower' AND true"));
        this.query = ((QueryBuilder.UpperBoundary)this.builder.selectStar().from("table AS nodes").where().propertyValue("nodes", "col1").isBetween().literal("lower").and()).literal("upper").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE nodes.col1 BETWEEN 'lower' AND 'upper'"));
    }

    @Test
    public void shouldBuildQueryWithBetweenRangeWithCast() {
        this.query = ((QueryBuilder.ConstraintBuilder)((QueryBuilder.UpperBoundary)((QueryBuilder.AndBuilder)this.builder.selectStar().from("table AS nodes").where().propertyValue("nodes", "col1").isBetween().cast("true").asBoolean()).and()).cast("false").asBoolean()).end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE nodes.col1 BETWEEN true AND false"));
    }

    @Test
    public void shouldBuildQueryWithOneHasPropertyConstraint() {
        this.query = this.builder.selectStar().from("table AS nodes").where().hasProperty("nodes", "col1").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE nodes.col1 IS NOT NULL"));
    }

    @Test
    public void shouldBuildQueryWithChildConstraint() {
        this.query = this.builder.selectStar().from("table AS nodes").where().isChild("nodes", "/parent/path").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE ISCHILDNODE(nodes,/parent/path)"));
    }

    @Test
    public void shouldBuildQueryWithDescendantConstraint() {
        this.query = this.builder.selectStar().from("table AS nodes").where().isBelowPath("nodes", "/parent/path").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE ISDESCENDANTNODE(nodes,/parent/path)"));
    }

    @Test
    public void shouldBuildQueryWithSameNodeConstraint() {
        this.query = this.builder.selectStar().from("table AS nodes").where().isSameNode("nodes", "/other/path").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE ISSAMENODE(nodes,/other/path)"));
    }

    @Test
    public void shouldBuildQueryWithFullTextSearchConstraint() {
        this.query = this.builder.selectStar().from("table AS nodes").where().search("nodes", "expression").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE CONTAINS(nodes,'expression')"));
    }

    @Test
    public void shouldBuildQueryWithPropertyFullTextSearchConstraint() {
        this.query = this.builder.selectStar().from("table AS nodes").where().search("nodes", "property", "expression").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE CONTAINS(nodes.property,'expression')"));
    }

    @Test
    public void shouldBuildQueryWithTwoHasPropertyConstraint() {
        this.query = this.builder.selectStar().from("table AS nodes").where().hasProperty("nodes", "col1").and().hasProperty("nodes", "col2").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE (nodes.col1 IS NOT NULL AND nodes.col2 IS NOT NULL)"));
    }

    @Test
    public void shouldBuildQueryWithThreeHasPropertyConstraint() {
        this.query = this.builder.selectStar().from("table AS nodes").where().hasProperty("nodes", "col1").and().hasProperty("nodes", "col2").and().hasProperty("nodes", "col3").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE ((nodes.col1 IS NOT NULL AND nodes.col2 IS NOT NULL) AND nodes.col3 IS NOT NULL)"));
    }

    @Test
    public void shouldBuildQueryWithCorrectPrecedenceWithAndAndOr() {
        this.query = this.builder.selectStar().from("table AS nodes").where().hasProperty("nodes", "col1").or().hasProperty("nodes", "col2").and().hasProperty("nodes", "col3").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE (nodes.col1 IS NOT NULL OR (nodes.col2 IS NOT NULL AND nodes.col3 IS NOT NULL))"));
        this.query = this.builder.selectStar().from("table AS nodes").where().hasProperty("nodes", "col1").and().hasProperty("nodes", "col2").or().hasProperty("nodes", "col3").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE ((nodes.col1 IS NOT NULL AND nodes.col2 IS NOT NULL) OR nodes.col3 IS NOT NULL)"));
    }

    @Test
    public void shouldBuildQueryWithMixtureOfLogicalWithExplicitParenthesesWithHasPropertyConstraint() {
        this.query = this.builder.selectStar().from("table AS nodes").where().hasProperty("nodes", "col1").and().openParen().hasProperty("nodes", "col2").and().hasProperty("nodes", "col3").closeParen().end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE (nodes.col1 IS NOT NULL AND (nodes.col2 IS NOT NULL AND nodes.col3 IS NOT NULL))"));
    }

    @Test
    public void shouldBuildQueryWithCorrectPrecedenceWithExplicitParentheses() {
        this.query = this.builder.selectStar().from("table AS nodes").where().openParen().hasProperty("nodes", "col1").or().hasProperty("nodes", "col2").closeParen().and().hasProperty("nodes", "col3").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE ((nodes.col1 IS NOT NULL OR nodes.col2 IS NOT NULL) AND nodes.col3 IS NOT NULL)"));
    }

    @Test
    public void shouldBuildQueryWithCorrectPrecedenceWithExplicitParenthesesWithAndFirst() {
        this.query = this.builder.selectStar().from("table AS nodes").where().hasProperty("nodes", "col1").and().openParen().hasProperty("nodes", "col2").or().hasProperty("nodes", "col3").closeParen().end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE (nodes.col1 IS NOT NULL AND (nodes.col2 IS NOT NULL OR nodes.col3 IS NOT NULL))"));
    }

    @Test
    public void shouldBuildQueryWithMixureOfLogicalWithMultipleExplicitParenthesesWithHasPropertyConstraint() {
        this.query = this.builder.selectStar().from("table AS nodes").where().hasProperty("nodes", "col1").and().openParen().openParen().hasProperty("nodes", "col2").and().hasProperty("nodes", "col3").closeParen().and().search("nodes", "expression").closeParen().end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE (nodes.col1 IS NOT NULL AND ((nodes.col2 IS NOT NULL AND nodes.col3 IS NOT NULL) AND CONTAINS(nodes,'expression')))"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingPlus() {
        this.query = this.builder.selectStar().from("table AS nodes").where().depth("nodes").plus().depth("nodes").plus().depth("nodes").isEqualTo((Object)3).end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE ((DEPTH(nodes) + DEPTH(nodes)) + DEPTH(nodes)) = 3"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingPlusAndMinus() {
        this.query = this.builder.selectStar().from("table AS nodes").where().depth("nodes").minus().depth("nodes").plus().fullTextSearchScore("nodes").isEqualTo((Object)3).end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE (DEPTH(nodes) - (DEPTH(nodes) + SCORE(nodes))) = 3"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingLengthEqualTo() {
        this.query = this.builder.selectStar().from("table AS nodes").where().length("nodes", "property").isEqualTo((Object)"literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE LENGTH(nodes.property) = 'literal'"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingLengthEqualToVariable() {
        this.query = this.builder.selectStar().from("table AS nodes").where().length("nodes", "property").isEqualToVariable("literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE LENGTH(nodes.property) = $literal"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingLengthNotEqualTo() {
        this.query = this.builder.selectStar().from("table AS nodes").where().length("nodes", "property").isNotEqualTo((Object)"literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE LENGTH(nodes.property) != 'literal'"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingLengthNotEqualToVariable() {
        this.query = this.builder.selectStar().from("table AS nodes").where().length("nodes", "property").isNotEqualToVariable("literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE LENGTH(nodes.property) != $literal"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingLengthLessThan() {
        this.query = this.builder.selectStar().from("table AS nodes").where().length("nodes", "property").isLessThan((Object)"literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE LENGTH(nodes.property) < 'literal'"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingLengthLessThanVariable() {
        this.query = this.builder.selectStar().from("table AS nodes").where().length("nodes", "property").isLessThanVariable("literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE LENGTH(nodes.property) < $literal"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingLengthLessThanOrEqualTo() {
        this.query = this.builder.selectStar().from("table AS nodes").where().length("nodes", "property").isLessThanOrEqualTo((Object)"literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE LENGTH(nodes.property) <= 'literal'"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingLengthLessThanOrEqualToVariable() {
        this.query = this.builder.selectStar().from("table AS nodes").where().length("nodes", "property").isLessThanOrEqualToVariable("literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE LENGTH(nodes.property) <= $literal"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingLengthGreaterThan() {
        this.query = this.builder.selectStar().from("table AS nodes").where().length("nodes", "property").isGreaterThan((Object)"literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE LENGTH(nodes.property) > 'literal'"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingLengthGreaterThanVariable() {
        this.query = this.builder.selectStar().from("table AS nodes").where().length("nodes", "property").isGreaterThanVariable("literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE LENGTH(nodes.property) > $literal"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingLengthGreaterThanOrEqualTo() {
        this.query = this.builder.selectStar().from("table AS nodes").where().length("nodes", "property").isGreaterThanOrEqualTo((Object)"literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE LENGTH(nodes.property) >= 'literal'"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingLengthGreaterThanOrEqualToVariable() {
        this.query = this.builder.selectStar().from("table AS nodes").where().length("nodes", "property").isGreaterThanOrEqualToVariable("literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE LENGTH(nodes.property) >= $literal"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingLengthLike() {
        this.query = this.builder.selectStar().from("table AS nodes").where().length("nodes", "property").isLike((Object)"literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE LENGTH(nodes.property) LIKE 'literal'"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingLengthLikeVariable() {
        this.query = this.builder.selectStar().from("table AS nodes").where().length("nodes", "property").isLikeVariable("literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE LENGTH(nodes.property) LIKE $literal"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingNodeDepthEqualToLiteral() {
        this.query = this.builder.selectStar().from("table AS nodes").where().depth("nodes").isEqualTo((Object)3).end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE DEPTH(nodes) = 3"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingNodeDepthLessThanOrEqualToLongLiteral() {
        this.query = this.builder.selectStar().from("table AS nodes").where().depth("nodes").isLessThanOrEqualTo((Object)3).end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE DEPTH(nodes) <= 3"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingNodeDepthLessThanOrEqualToStringLiteral() {
        this.query = this.builder.selectStar().from("table AS nodes").where().depth("nodes").isLessThanOrEqualTo((Object)3).end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE DEPTH(nodes) <= 3"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingNodeDepthLessThanOrEqualToVariable() {
        this.query = this.builder.selectStar().from("table AS nodes").where().depth("nodes").isLessThanOrEqualToVariable("value").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE DEPTH(nodes) <= $value"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingNodeNameEqualTo() {
        this.query = this.builder.selectStar().from("table AS nodes").where().nodeName("nodes").isEqualTo((Object)"literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE NAME(nodes) = 'literal'"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingNodeNameEqualToVariable() {
        this.query = this.builder.selectStar().from("table AS nodes").where().nodeName("nodes").isEqualToVariable("literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE NAME(nodes) = $literal"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingNodeNameNotEqualTo() {
        this.query = this.builder.selectStar().from("table AS nodes").where().nodeName("nodes").isNotEqualTo((Object)"literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE NAME(nodes) != 'literal'"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingNodeNameNotEqualToVariable() {
        this.query = this.builder.selectStar().from("table AS nodes").where().nodeName("nodes").isNotEqualToVariable("literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE NAME(nodes) != $literal"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingNodeNameLessThan() {
        this.query = this.builder.selectStar().from("table AS nodes").where().nodeName("nodes").isLessThan((Object)"literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE NAME(nodes) < 'literal'"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingNodeNameLessThanVariable() {
        this.query = this.builder.selectStar().from("table AS nodes").where().nodeName("nodes").isLessThanVariable("literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE NAME(nodes) < $literal"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingNodeNameLessThanOrEqualTo() {
        this.query = this.builder.selectStar().from("table AS nodes").where().nodeName("nodes").isLessThanOrEqualTo((Object)"literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE NAME(nodes) <= 'literal'"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingNodeNameLessThanOrEqualToVariable() {
        this.query = this.builder.selectStar().from("table AS nodes").where().nodeName("nodes").isLessThanOrEqualToVariable("literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE NAME(nodes) <= $literal"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingNodeNameGreaterThan() {
        this.query = this.builder.selectStar().from("table AS nodes").where().nodeName("nodes").isGreaterThan((Object)"literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE NAME(nodes) > 'literal'"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingNodeNameGreaterThanVariable() {
        this.query = this.builder.selectStar().from("table AS nodes").where().nodeName("nodes").isGreaterThanVariable("literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE NAME(nodes) > $literal"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingNodeNameGreaterThanOrEqualTo() {
        this.query = this.builder.selectStar().from("table AS nodes").where().nodeName("nodes").isGreaterThanOrEqualTo((Object)"literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE NAME(nodes) >= 'literal'"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingNodeNameGreaterThanOrEqualToVariable() {
        this.query = this.builder.selectStar().from("table AS nodes").where().nodeName("nodes").isGreaterThanOrEqualToVariable("literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE NAME(nodes) >= $literal"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingNodeNameLike() {
        this.query = this.builder.selectStar().from("table AS nodes").where().nodeName("nodes").isLike((Object)"literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE NAME(nodes) LIKE 'literal'"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingNodeNameLikeVariable() {
        this.query = this.builder.selectStar().from("table AS nodes").where().nodeName("nodes").isLikeVariable("literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE NAME(nodes) LIKE $literal"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingNodeLocalNameEqualTo() {
        this.query = this.builder.selectStar().from("table AS nodes").where().nodeLocalName("nodes").isEqualTo((Object)"literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE LOCALNAME(nodes) = 'literal'"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingNodeLocalNameEqualToVariable() {
        this.query = this.builder.selectStar().from("table AS nodes").where().nodeLocalName("nodes").isEqualToVariable("literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE LOCALNAME(nodes) = $literal"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingNodeLocalNameNotEqualTo() {
        this.query = this.builder.selectStar().from("table AS nodes").where().nodeLocalName("nodes").isNotEqualTo((Object)"literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE LOCALNAME(nodes) != 'literal'"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingNodeLocalNameNotEqualToVariable() {
        this.query = this.builder.selectStar().from("table AS nodes").where().nodeLocalName("nodes").isNotEqualToVariable("literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE LOCALNAME(nodes) != $literal"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingNodeLocalNameLessThan() {
        this.query = this.builder.selectStar().from("table AS nodes").where().nodeLocalName("nodes").isLessThan((Object)"literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE LOCALNAME(nodes) < 'literal'"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingNodeLocalNameLessThanVariable() {
        this.query = this.builder.selectStar().from("table AS nodes").where().nodeLocalName("nodes").isLessThanVariable("literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE LOCALNAME(nodes) < $literal"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingNodeLocalNameLessThanOrEqualTo() {
        this.query = this.builder.selectStar().from("table AS nodes").where().nodeLocalName("nodes").isLessThanOrEqualTo((Object)"literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE LOCALNAME(nodes) <= 'literal'"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingNodeLocalNameLessThanOrEqualToVariable() {
        this.query = this.builder.selectStar().from("table AS nodes").where().nodeLocalName("nodes").isLessThanOrEqualToVariable("literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE LOCALNAME(nodes) <= $literal"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingNodeLocalNameGreaterThan() {
        this.query = this.builder.selectStar().from("table AS nodes").where().nodeLocalName("nodes").isGreaterThan((Object)"literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE LOCALNAME(nodes) > 'literal'"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingNodeLocalNameGreaterThanVariable() {
        this.query = this.builder.selectStar().from("table AS nodes").where().nodeLocalName("nodes").isGreaterThanVariable("literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE LOCALNAME(nodes) > $literal"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingNodeLocalNameGreaterThanOrEqualTo() {
        this.query = this.builder.selectStar().from("table AS nodes").where().nodeLocalName("nodes").isGreaterThanOrEqualTo((Object)"literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE LOCALNAME(nodes) >= 'literal'"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingNodeLocalNameGreaterThanOrEqualToVariable() {
        this.query = this.builder.selectStar().from("table AS nodes").where().nodeLocalName("nodes").isGreaterThanOrEqualToVariable("literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE LOCALNAME(nodes) >= $literal"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingNodeLocalNameLike() {
        this.query = this.builder.selectStar().from("table AS nodes").where().nodeLocalName("nodes").isLike((Object)"literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE LOCALNAME(nodes) LIKE 'literal'"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingNodeLocalNameLikeVariable() {
        this.query = this.builder.selectStar().from("table AS nodes").where().nodeLocalName("nodes").isLikeVariable("literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE LOCALNAME(nodes) LIKE $literal"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingUppercaseOfNodeNameEqualTo() {
        this.query = this.builder.selectStar().from("table AS nodes").where().upperCaseOf().nodeName("nodes").isEqualTo((Object)"literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE UPPER(NAME(nodes)) = 'literal'"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingUppercaseOfNodeNameEqualToVariable() {
        this.query = this.builder.selectStar().from("table AS nodes").where().upperCaseOf().nodeName("nodes").isEqualToVariable("literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE UPPER(NAME(nodes)) = $literal"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingUppercaseOfNodeNameNotEqualTo() {
        this.query = this.builder.selectStar().from("table AS nodes").where().upperCaseOf().nodeName("nodes").isNotEqualTo((Object)"literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE UPPER(NAME(nodes)) != 'literal'"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingUppercaseOfNodeNameNotEqualToVariable() {
        this.query = this.builder.selectStar().from("table AS nodes").where().upperCaseOf().nodeName("nodes").isNotEqualToVariable("literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE UPPER(NAME(nodes)) != $literal"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingUppercaseOfNodeNameLessThan() {
        this.query = this.builder.selectStar().from("table AS nodes").where().upperCaseOf().nodeName("nodes").isLessThan((Object)"literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE UPPER(NAME(nodes)) < 'literal'"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingUppercaseOfNodeNameLessThanVariable() {
        this.query = this.builder.selectStar().from("table AS nodes").where().upperCaseOf().nodeName("nodes").isLessThanVariable("literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE UPPER(NAME(nodes)) < $literal"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingUppercaseOfNodeNameLessThanOrEqualTo() {
        this.query = this.builder.selectStar().from("table AS nodes").where().upperCaseOf().nodeName("nodes").isLessThanOrEqualTo((Object)"literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE UPPER(NAME(nodes)) <= 'literal'"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingUppercaseOfNodeNameLessThanOrEqualToVariable() {
        this.query = this.builder.selectStar().from("table AS nodes").where().upperCaseOf().nodeName("nodes").isLessThanOrEqualToVariable("literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE UPPER(NAME(nodes)) <= $literal"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingUppercaseOfNodeNameGreaterThan() {
        this.query = this.builder.selectStar().from("table AS nodes").where().upperCaseOf().nodeName("nodes").isGreaterThan((Object)"literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE UPPER(NAME(nodes)) > 'literal'"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingUppercaseOfNodeNameGreaterThanVariable() {
        this.query = this.builder.selectStar().from("table AS nodes").where().upperCaseOf().nodeName("nodes").isGreaterThanVariable("literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE UPPER(NAME(nodes)) > $literal"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingUppercaseOfNodeNameGreaterThanOrEqualTo() {
        this.query = this.builder.selectStar().from("table AS nodes").where().upperCaseOf().nodeName("nodes").isGreaterThanOrEqualTo((Object)"literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE UPPER(NAME(nodes)) >= 'literal'"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingUppercaseOfNodeNameGreaterThanOrEqualToVariable() {
        this.query = this.builder.selectStar().from("table AS nodes").where().upperCaseOf().nodeName("nodes").isGreaterThanOrEqualToVariable("literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE UPPER(NAME(nodes)) >= $literal"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingUppercaseOfNodeNameLike() {
        this.query = this.builder.selectStar().from("table AS nodes").where().upperCaseOf().nodeName("nodes").isLike((Object)"literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE UPPER(NAME(nodes)) LIKE 'literal'"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingUppercaseOfNodeNameLikeVariable() {
        this.query = this.builder.selectStar().from("table AS nodes").where().upperCaseOf().nodeName("nodes").isLikeVariable("literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE UPPER(NAME(nodes)) LIKE $literal"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingLowercaseOfNodeNameEqualTo() {
        this.query = this.builder.selectStar().from("table AS nodes").where().lowerCaseOf().nodeName("nodes").isEqualTo((Object)"literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE LOWER(NAME(nodes)) = 'literal'"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingLowercaseOfNodeNameEqualToVariable() {
        this.query = this.builder.selectStar().from("table AS nodes").where().lowerCaseOf().nodeName("nodes").isEqualToVariable("literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE LOWER(NAME(nodes)) = $literal"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingLowercaseOfNodeNameNotEqualTo() {
        this.query = this.builder.selectStar().from("table AS nodes").where().lowerCaseOf().nodeName("nodes").isNotEqualTo((Object)"literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE LOWER(NAME(nodes)) != 'literal'"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingLowercaseOfNodeNameNotEqualToVariable() {
        this.query = this.builder.selectStar().from("table AS nodes").where().lowerCaseOf().nodeName("nodes").isNotEqualToVariable("literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE LOWER(NAME(nodes)) != $literal"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingLowercaseOfNodeNameLessThan() {
        this.query = this.builder.selectStar().from("table AS nodes").where().lowerCaseOf().nodeName("nodes").isLessThan((Object)"literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE LOWER(NAME(nodes)) < 'literal'"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingLowercaseOfNodeNameLessThanVariable() {
        this.query = this.builder.selectStar().from("table AS nodes").where().lowerCaseOf().nodeName("nodes").isLessThanVariable("literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE LOWER(NAME(nodes)) < $literal"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingLowercaseOfNodeNameLessThanOrEqualTo() {
        this.query = this.builder.selectStar().from("table AS nodes").where().lowerCaseOf().nodeName("nodes").isLessThanOrEqualTo((Object)"literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE LOWER(NAME(nodes)) <= 'literal'"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingLowercaseOfNodeNameLessThanOrEqualToVariable() {
        this.query = this.builder.selectStar().from("table AS nodes").where().lowerCaseOf().nodeName("nodes").isLessThanOrEqualToVariable("literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE LOWER(NAME(nodes)) <= $literal"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingLowercaseOfNodeNameGreaterThan() {
        this.query = this.builder.selectStar().from("table AS nodes").where().lowerCaseOf().nodeName("nodes").isGreaterThan((Object)"literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE LOWER(NAME(nodes)) > 'literal'"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingLowercaseOfNodeNameGreaterThanVariable() {
        this.query = this.builder.selectStar().from("table AS nodes").where().lowerCaseOf().nodeName("nodes").isGreaterThanVariable("literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE LOWER(NAME(nodes)) > $literal"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingLowercaseOfNodeNameGreaterThanOrEqualTo() {
        this.query = this.builder.selectStar().from("table AS nodes").where().lowerCaseOf().nodeName("nodes").isGreaterThanOrEqualTo((Object)"literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE LOWER(NAME(nodes)) >= 'literal'"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingLowercaseOfNodeNameGreaterThanOrEqualToVariable() {
        this.query = this.builder.selectStar().from("table AS nodes").where().lowerCaseOf().nodeName("nodes").isGreaterThanOrEqualToVariable("literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE LOWER(NAME(nodes)) >= $literal"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingLowercaseOfNodeNameLike() {
        this.query = this.builder.selectStar().from("table AS nodes").where().lowerCaseOf().nodeName("nodes").isLike((Object)"literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE LOWER(NAME(nodes)) LIKE 'literal'"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingLowercaseOfNodeNameLikeVariable() {
        this.query = this.builder.selectStar().from("table AS nodes").where().lowerCaseOf().nodeName("nodes").isLikeVariable("literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE LOWER(NAME(nodes)) LIKE $literal"));
    }

    @Test
    public void shouldBuildQueryWithCriteriaUsingLowercaseOfUppercaseOfNodeNameEqualTo() {
        this.query = this.builder.selectStar().from("table AS nodes").where().lowerCaseOf().upperCaseOf().nodeName("nodes").isEqualTo((Object)"literal").end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE LOWER(UPPER(NAME(nodes))) = 'literal'"));
    }

    @Test
    public void shouldBuildQueryWithSetCriteria() {
        this.query = this.builder.selectStar().from("table AS nodes").where().nodeName("nodes").isIn(new Object[]{"value1", "value2", "value3"}).end().query();
        this.assertThatSql(this.query, (Matcher<String>)Is.is((Object)"SELECT * FROM table AS nodes WHERE NAME(nodes) IN ('value1','value2','value3')"));
    }

    @Test
    public void shouldBuildQueryWithOneOrderByClause() {
        this.query = this.builder.selectStar().from("table AS nodes").orderBy().ascending().fullTextSearchScore("nodes").then().descending().length("nodes", "column").end().query();
    }
}

