/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.optimize;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.query.AbstractQueryTest;
import org.modeshape.graph.query.QueryContext;
import org.modeshape.graph.query.model.Column;
import org.modeshape.graph.query.model.Comparison;
import org.modeshape.graph.query.model.DynamicOperand;
import org.modeshape.graph.query.model.Literal;
import org.modeshape.graph.query.model.Operator;
import org.modeshape.graph.query.model.PropertyValue;
import org.modeshape.graph.query.model.SelectorName;
import org.modeshape.graph.query.model.StaticOperand;
import org.modeshape.graph.query.model.TypeSystem;
import org.modeshape.graph.query.optimize.ReplaceViews;
import org.modeshape.graph.query.plan.PlanNode;
import org.modeshape.graph.query.validate.ImmutableSchemata;
import org.modeshape.graph.query.validate.Schemata;

public class ReplaceViewsTest
extends AbstractQueryTest {
    private ReplaceViews rule;
    private QueryContext context;
    private Schemata schemata;
    private ImmutableSchemata.Builder builder;

    @Before
    public void beforeEach() {
        TypeSystem typeSystem = new ExecutionContext().getValueFactories().getTypeSystem();
        this.rule = ReplaceViews.INSTANCE;
        this.builder = ImmutableSchemata.createBuilder((TypeSystem)typeSystem);
        this.builder.addTable("t1", new String[]{"c11", "c12", "c13"});
        this.builder.addTable("t2", new String[]{"c21", "c22", "c23"});
        this.builder.addView("v1", "SELECT c11, c12 FROM t1 WHERE c13 < CAST('3' AS LONG)");
        this.builder.addView("v2", "SELECT t1.c11, t1.c12, t2.c23 FROM t1 JOIN t2 ON t1.c11 = t2.c21");
        this.schemata = this.builder.build();
        this.context = new QueryContext(this.schemata, typeSystem);
    }

    @Test
    public void shouldReplaceViewWithPlanForViewWithSingleTable() {
        PlanNode project = new PlanNode(PlanNode.Type.PROJECT, new SelectorName[]{this.selector("v1")});
        PlanNode select1 = new PlanNode(PlanNode.Type.SELECT, project, new SelectorName[]{this.selector("v1")});
        PlanNode select2 = new PlanNode(PlanNode.Type.SELECT, select1, new SelectorName[]{this.selector("v1")});
        PlanNode select3 = new PlanNode(PlanNode.Type.SELECT, select2, new SelectorName[]{this.selector("v1")});
        PlanNode source = new PlanNode(PlanNode.Type.SOURCE, select3, new SelectorName[]{this.selector("v1")});
        source.setProperty(PlanNode.Property.SOURCE_NAME, (Object)this.selector("v1"));
        PlanNode viewProject = new PlanNode(PlanNode.Type.PROJECT, new SelectorName[]{this.selector("t1")});
        PlanNode viewSelect = new PlanNode(PlanNode.Type.SELECT, viewProject, new SelectorName[]{this.selector("t1")});
        PlanNode viewSource = new PlanNode(PlanNode.Type.SOURCE, viewSelect, new SelectorName[]{this.selector("t1")});
        viewProject.setProperty(PlanNode.Property.PROJECT_COLUMNS, this.columns(this.column("t1", "c11"), this.column("t1", "c12")));
        viewSelect.setProperty(PlanNode.Property.SELECT_CRITERIA, (Object)new Comparison((DynamicOperand)new PropertyValue(this.selector("t1"), "c13"), Operator.LESS_THAN, (StaticOperand)new Literal((Object)3L)));
        viewSource.setProperty(PlanNode.Property.SOURCE_NAME, (Object)this.selector("t1"));
        viewSource.setProperty(PlanNode.Property.SOURCE_COLUMNS, (Object)this.schemata.getTable(this.selector("t1")).getColumns());
        PlanNode result = this.rule.execute(this.context, project, new LinkedList());
        Assert.assertThat((Object)result.isSameAs(project), (Matcher)Is.is((Object)true));
        this.assertChildren(project, select1);
        this.assertChildren(select1, select2);
        this.assertChildren(select2, select3);
    }

    protected List<Column> columns(Column ... columns) {
        return Arrays.asList(columns);
    }

    protected Column column(String table, String columnName) {
        return new Column(new SelectorName(table), columnName, columnName);
    }

    protected Column column(String table, String columnName, String alias) {
        return new Column(new SelectorName(table), columnName, alias);
    }
}

