/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.parse;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.query.model.QueryCommand;
import org.modeshape.graph.query.model.TypeSystem;
import org.modeshape.graph.query.parse.InvalidQueryException;
import org.modeshape.graph.query.parse.QueryParser;
import org.modeshape.graph.query.parse.QueryParsers;

public class QueryParsersTest {
    private QueryParsers parsers;
    private QueryParser parser1;
    private QueryParser parser2;
    private QueryParser parser3;

    @Before
    public void beforeEach() {
        this.parsers = new QueryParsers(new QueryParser[0]);
        this.parser1 = new MockParser("language 1");
        this.parser2 = new MockParser("language 2");
        this.parser3 = new MockParser("language 3");
    }

    @Test
    public void shouldAllowNullArrayInConstructor() {
        this.parsers = new QueryParsers((QueryParser[])null);
        Assert.assertThat((Object)this.parsers.getLanguages().isEmpty(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldAllowNullIterableInConstructor() {
        this.parsers = new QueryParsers((Iterable)null);
        Assert.assertThat((Object)this.parsers.getLanguages().isEmpty(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldAllowOneQueryParserReferenceInConstructor() {
        this.parsers = new QueryParsers(new QueryParser[]{this.parser1});
        Assert.assertThat((Object)this.parsers.getLanguages().size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.parsers.getLanguages().contains(this.parser1.getLanguage()), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldAllowTwoQueryParserReferencesInConstructor() {
        this.parsers = new QueryParsers(new QueryParser[]{this.parser1, this.parser2});
        Assert.assertThat((Object)this.parsers.getLanguages().size(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)this.parsers.getLanguages().contains(this.parser1.getLanguage()), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.parsers.getLanguages().contains(this.parser2.getLanguage()), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldAllowThreeQueryParserReferencesInConstructor() {
        this.parsers = new QueryParsers(new QueryParser[]{this.parser1, this.parser2, this.parser3});
        Assert.assertThat((Object)this.parsers.getLanguages().size(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)this.parsers.getLanguages().contains(this.parser1.getLanguage()), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.parsers.getLanguages().contains(this.parser2.getLanguage()), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.parsers.getLanguages().contains(this.parser3.getLanguage()), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldOverwriteQueryParsersWithSameLanguageInConstructor() {
        this.parser2 = new MockParser(this.parser1.getLanguage());
        this.parsers = new QueryParsers(new QueryParser[]{this.parser1, this.parser2, this.parser3});
        Assert.assertThat((Object)this.parsers.getLanguages().size(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)this.parsers.getLanguages().contains(this.parser2.getLanguage()), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.parsers.getLanguages().contains(this.parser3.getLanguage()), (Matcher)Is.is((Object)true));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowNullQueryParserReferenceInAddLanguagesMethod() {
        this.parsers.addLanguages((QueryParser)null, new QueryParser[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldAllowNullIterableInAddLanguagesMethod() {
        this.parsers.addLanguages((Iterable)null);
    }

    @Test
    public void shouldAddOneQueryParserReference() {
        this.parsers.addLanguage(this.parser1);
        Assert.assertThat((Object)this.parsers.getLanguages().size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.parsers.getLanguages().contains(this.parser1.getLanguage()), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldAddTwoQueryParserReferences() {
        this.parsers.addLanguages(this.parser1, new QueryParser[]{this.parser2});
        Assert.assertThat((Object)this.parsers.getLanguages().size(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)this.parsers.getLanguages().contains(this.parser1.getLanguage()), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.parsers.getLanguages().contains(this.parser2.getLanguage()), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldAddThreeQueryParserReferences() {
        this.parsers.addLanguages(this.parser1, new QueryParser[]{this.parser2, this.parser3});
        Assert.assertThat((Object)this.parsers.getLanguages().size(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)this.parsers.getLanguages().contains(this.parser1.getLanguage()), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.parsers.getLanguages().contains(this.parser2.getLanguage()), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.parsers.getLanguages().contains(this.parser3.getLanguage()), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldOverwriteQueryParsersWithSameLanguageWhenAddingQueryParser() {
        this.parser2 = new MockParser(this.parser1.getLanguage());
        this.parsers.addLanguages(this.parser1, new QueryParser[]{this.parser2, this.parser3});
        Assert.assertThat((Object)this.parsers.getLanguages().size(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)this.parsers.getLanguages().contains(this.parser2.getLanguage()), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.parsers.getLanguages().contains(this.parser3.getLanguage()), (Matcher)Is.is((Object)true));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailToParseUnknownLanguage() {
        TypeSystem typeSystem = new ExecutionContext().getValueFactories().getTypeSystem();
        this.parsers.parse(typeSystem, "unknown language", "This is a bogus query");
    }

    protected static class MockParser
    implements QueryParser {
        private final String language;

        protected MockParser(String language) {
            this.language = language;
            assert (this.language != null);
        }

        public String getLanguage() {
            return this.language;
        }

        public QueryCommand parseQuery(String query, TypeSystem typeSystem) throws InvalidQueryException {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "Mock parser for " + this.language;
        }
    }
}

