/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.plan;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.FixFor;
import org.modeshape.common.collection.Problems;
import org.modeshape.common.collection.SimpleProblems;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.query.QueryBuilder;
import org.modeshape.graph.query.QueryContext;
import org.modeshape.graph.query.model.And;
import org.modeshape.graph.query.model.BindVariableName;
import org.modeshape.graph.query.model.Column;
import org.modeshape.graph.query.model.Comparison;
import org.modeshape.graph.query.model.Constraint;
import org.modeshape.graph.query.model.DynamicOperand;
import org.modeshape.graph.query.model.Literal;
import org.modeshape.graph.query.model.NodePath;
import org.modeshape.graph.query.model.Operator;
import org.modeshape.graph.query.model.PropertyValue;
import org.modeshape.graph.query.model.QueryCommand;
import org.modeshape.graph.query.model.SelectorName;
import org.modeshape.graph.query.model.SetCriteria;
import org.modeshape.graph.query.model.StaticOperand;
import org.modeshape.graph.query.model.TypeSystem;
import org.modeshape.graph.query.plan.CanonicalPlanner;
import org.modeshape.graph.query.plan.PlanHints;
import org.modeshape.graph.query.plan.PlanNode;
import org.modeshape.graph.query.validate.ImmutableSchemata;
import org.modeshape.graph.query.validate.Schemata;

public class CanonicalPlannerTest {
    private CanonicalPlanner planner;
    private TypeSystem typeSystem;
    private QueryBuilder builder;
    private PlanHints hints;
    private QueryCommand query;
    private PlanNode plan;
    private Problems problems;
    private Schemata schemata;
    private ImmutableSchemata.Builder schemataBuilder;
    private QueryContext queryContext;
    private boolean print;

    @Before
    public void beforeEach() {
        this.planner = new CanonicalPlanner();
        this.typeSystem = new ExecutionContext().getValueFactories().getTypeSystem();
        this.hints = new PlanHints();
        this.builder = new QueryBuilder(this.typeSystem);
        this.problems = new SimpleProblems();
        this.schemataBuilder = ImmutableSchemata.createBuilder((TypeSystem)this.typeSystem);
        this.print = false;
    }

    protected void print(PlanNode plan) {
        if (this.print) {
            System.out.println(plan);
        }
    }

    protected SelectorName selector(String name) {
        return new SelectorName(name);
    }

    protected Set<SelectorName> selectors(String ... names) {
        HashSet<SelectorName> selectors = new HashSet<SelectorName>();
        for (String name : names) {
            selectors.add(this.selector(name));
        }
        return selectors;
    }

    protected void assertProjectNode(PlanNode node, String ... columnNames) {
        Assert.assertThat((Object)node.getType(), (Matcher)Is.is((Object)PlanNode.Type.PROJECT));
        if (columnNames.length != 0) {
            Assert.assertThat((Object)node.hasCollectionProperty(PlanNode.Property.PROJECT_COLUMNS), (Matcher)Is.is((Object)true));
        }
        List columns = (List)node.getProperty(PlanNode.Property.PROJECT_COLUMNS, List.class);
        Assert.assertThat((Object)columns.size(), (Matcher)Is.is((Object)columnNames.length));
        for (int i = 0; i != columns.size(); ++i) {
            Column column = (Column)columns.get(i);
            Assert.assertThat((Object)column.columnName(), (Matcher)Is.is((Object)columnNames[i]));
        }
    }

    protected void assertSourceNode(PlanNode node, String sourceName, String sourceAlias, String ... availableColumns) {
        Assert.assertThat((Object)node.getType(), (Matcher)Is.is((Object)PlanNode.Type.SOURCE));
        Assert.assertThat((Object)node.getProperty(PlanNode.Property.SOURCE_NAME, SelectorName.class), (Matcher)Is.is((Object)this.selector(sourceName)));
        if (sourceAlias != null) {
            Assert.assertThat((Object)node.getProperty(PlanNode.Property.SOURCE_ALIAS, SelectorName.class), (Matcher)Is.is((Object)this.selector(sourceAlias)));
        } else {
            Assert.assertThat((Object)node.hasProperty(PlanNode.Property.SOURCE_ALIAS), (Matcher)Is.is((Object)false));
        }
        Collection columns = (Collection)node.getProperty(PlanNode.Property.SOURCE_COLUMNS);
        Assert.assertThat((Object)columns.size(), (Matcher)Is.is((Object)availableColumns.length));
        int i = 0;
        for (Schemata.Column column : columns) {
            String expectedName = availableColumns[i++];
            Assert.assertThat((Object)column.getName(), (Matcher)Is.is((Object)expectedName));
        }
    }

    @Test
    public void shouldProducePlanForSelectStarFromTable() {
        this.schemata = this.schemataBuilder.addTable("__ALLNODES__", new String[]{"column1", "column2", "column3"}).build();
        this.query = this.builder.selectStar().fromAllNodes().query();
        this.queryContext = new QueryContext(this.schemata, this.typeSystem, this.hints, this.problems);
        this.plan = this.planner.createPlan(this.queryContext, this.query);
        Assert.assertThat((Object)this.problems.isEmpty(), (Matcher)Is.is((Object)true));
        this.assertProjectNode(this.plan, "column1", "column2", "column3");
        Assert.assertThat((Object)this.plan.getType(), (Matcher)Is.is((Object)PlanNode.Type.PROJECT));
        Assert.assertThat((Object)this.plan.getChildCount(), (Matcher)Is.is((Object)1));
        PlanNode source = this.plan.getFirstChild();
        this.assertSourceNode(source, "__ALLNODES__", null, "column1", "column2", "column3");
        Assert.assertThat((Object)source.getChildCount(), (Matcher)Is.is((Object)0));
        this.print(this.plan);
    }

    @Test
    public void shouldProduceErrorWhenSelectingNonExistantTable() {
        this.schemata = this.schemataBuilder.addTable("someTable", new String[]{"column1", "column2", "column3"}).build();
        this.query = this.builder.selectStar().fromAllNodes().query();
        this.queryContext = new QueryContext(this.schemata, this.typeSystem, this.hints, this.problems);
        this.plan = this.planner.createPlan(this.queryContext, this.query);
        Assert.assertThat((Object)this.problems.hasErrors(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldProduceErrorWhenSelectingNonExistantColumnOnExistingTable() {
        this.schemata = this.schemataBuilder.addTable("someTable", new String[]{"column1", "column2", "column3"}).build();
        this.query = this.builder.select(new String[]{"column1", "column4"}).from("someTable").query();
        this.queryContext = new QueryContext(this.schemata, this.typeSystem, this.hints, this.problems);
        this.plan = this.planner.createPlan(this.queryContext, this.query);
        Assert.assertThat((Object)this.problems.hasErrors(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldProducePlanWhenSelectingAllColumnsOnExistingTable() {
        this.schemata = this.schemataBuilder.addTable("someTable", new String[]{"column1", "column2", "column3"}).build();
        this.query = this.builder.selectStar().from("someTable").query();
        this.queryContext = new QueryContext(this.schemata, this.typeSystem, this.hints, this.problems);
        this.plan = this.planner.createPlan(this.queryContext, this.query);
        this.print(this.plan);
        Assert.assertThat((Object)this.problems.hasErrors(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.problems.isEmpty(), (Matcher)Is.is((Object)true));
        this.assertProjectNode(this.plan, "column1", "column2", "column3");
        Assert.assertThat((Object)this.plan.getType(), (Matcher)Is.is((Object)PlanNode.Type.PROJECT));
        Assert.assertThat((Object)this.plan.getChildCount(), (Matcher)Is.is((Object)1));
        PlanNode source = this.plan.getFirstChild();
        this.assertSourceNode(source, "someTable", null, "column1", "column2", "column3");
        Assert.assertThat((Object)source.getChildCount(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldProducePlanWhenSelectingColumnsFromTableWithoutAlias() {
        this.schemata = this.schemataBuilder.addTable("someTable", new String[]{"column1", "column2", "column3"}).build();
        this.query = this.builder.select(new String[]{"column1", "column2"}).from("someTable").where().path("someTable").isEqualTo((Object)1L).end().query();
        this.queryContext = new QueryContext(this.schemata, this.typeSystem, this.hints, this.problems);
        this.plan = this.planner.createPlan(this.queryContext, this.query);
        Assert.assertThat((Object)this.problems.hasErrors(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.plan.getType(), (Matcher)Is.is((Object)PlanNode.Type.PROJECT));
        Assert.assertThat((Object)this.plan.getSelectors(), (Matcher)Is.is(this.selectors("someTable")));
    }

    @Test
    public void shouldProducePlanWhenSelectingColumnsFromTableWithAlias() {
        this.schemata = this.schemataBuilder.addTable("dna:someTable", new String[]{"column1", "column2", "column3"}).build();
        this.query = this.builder.select(new String[]{"column1", "column2"}).from("dna:someTable AS t1").where().path("t1").isEqualTo((Object)1L).end().query();
        this.queryContext = new QueryContext(this.schemata, this.typeSystem, this.hints, this.problems);
        this.plan = this.planner.createPlan(this.queryContext, this.query);
        Assert.assertThat((Object)this.problems.hasErrors(), (Matcher)Is.is((Object)false));
        this.print(this.plan);
        Assert.assertThat((Object)this.plan.getType(), (Matcher)Is.is((Object)PlanNode.Type.PROJECT));
        Assert.assertThat((Object)this.plan.getSelectors(), (Matcher)Is.is(this.selectors("t1")));
    }

    @Test
    public void shouldProducePlanWhenSelectingAllColumnsFromTableWithAlias() {
        this.schemata = this.schemataBuilder.addTable("dna:someTable", new String[]{"column1", "column2", "column3"}).build();
        this.query = this.builder.selectStar().from("dna:someTable AS t1").where().path("t1").isEqualTo((Object)1L).end().query();
        this.queryContext = new QueryContext(this.schemata, this.typeSystem, this.hints, this.problems);
        this.plan = this.planner.createPlan(this.queryContext, this.query);
        Assert.assertThat((Object)this.problems.hasErrors(), (Matcher)Is.is((Object)false));
        this.print(this.plan);
        Assert.assertThat((Object)this.plan.getType(), (Matcher)Is.is((Object)PlanNode.Type.PROJECT));
        Assert.assertThat((Object)this.plan.getSelectors(), (Matcher)Is.is(this.selectors("t1")));
    }

    @Test
    public void shouldProduceErrorWhenFullTextSearchingTableWithNoSearchableColumns() {
        this.schemata = this.schemataBuilder.addTable("someTable", new String[]{"column1", "column2", "column3"}).build();
        this.query = this.builder.select(new String[]{"column1", "column2"}).from("someTable").query();
        this.queryContext = new QueryContext(this.schemata, this.typeSystem, this.hints, this.problems);
        this.plan = this.planner.createPlan(this.queryContext, this.query);
        Assert.assertThat((Object)this.problems.hasErrors(), (Matcher)Is.is((Object)false));
        this.query = this.builder.select(new String[]{"column1", "column2"}).from("someTable").where().search("someTable", "term1").end().query();
        this.queryContext = new QueryContext(this.schemata, this.typeSystem, this.hints, this.problems);
        this.plan = this.planner.createPlan(this.queryContext, this.query);
        Assert.assertThat((Object)this.problems.hasErrors(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldProducePlanWhenFullTextSearchingTableWithAtLeastOneSearchableColumn() {
        this.schemata = this.schemataBuilder.addTable("someTable", new String[]{"column1", "column2", "column3"}).makeSearchable("someTable", "column1").build();
        this.query = this.builder.select(new String[]{"column1", "column4"}).from("someTable").where().search("someTable", "term1").end().query();
        this.queryContext = new QueryContext(this.schemata, this.typeSystem, this.hints, this.problems);
        this.plan = this.planner.createPlan(this.queryContext, this.query);
        Assert.assertThat((Object)this.problems.hasErrors(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldProduceErrorWhenFullTextSearchingColumnThatIsNotSearchable() {
        this.schemata = this.schemataBuilder.addTable("someTable", new String[]{"column1", "column2", "column3"}).build();
        this.query = this.builder.select(new String[]{"column1", "column2"}).from("someTable").query();
        this.queryContext = new QueryContext(this.schemata, this.typeSystem, this.hints, this.problems);
        this.plan = this.planner.createPlan(this.queryContext, this.query);
        Assert.assertThat((Object)this.problems.hasErrors(), (Matcher)Is.is((Object)false));
        this.query = this.builder.select(new String[]{"column1", "column2"}).from("someTable").where().search("someTable", "column2", "term1").end().query();
        this.queryContext = new QueryContext(this.schemata, this.typeSystem, this.hints, this.problems);
        this.plan = this.planner.createPlan(this.queryContext, this.query);
        Assert.assertThat((Object)this.problems.hasErrors(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldProducePlanWhenFullTextSearchingColumnThatIsSearchable() {
        this.schemata = this.schemataBuilder.addTable("someTable", new String[]{"column1", "column2", "column3"}).makeSearchable("someTable", "column1").build();
        this.query = this.builder.select(new String[]{"column1", "column4"}).from("someTable").where().search("someTable", "column1", "term1").end().query();
        this.queryContext = new QueryContext(this.schemata, this.typeSystem, this.hints, this.problems);
        this.plan = this.planner.createPlan(this.queryContext, this.query);
        Assert.assertThat((Object)this.problems.hasErrors(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldProducePlanWhenOrderByClauseIsUsed() {
        this.schemata = this.schemataBuilder.addTable("dna:someTable", new String[]{"column1", "column2", "column3"}).build();
        this.query = this.builder.selectStar().from("dna:someTable AS t1").where().path("t1").isEqualTo((Object)1L).end().orderBy().ascending().propertyValue("t1", "column1").end().query();
        this.queryContext = new QueryContext(this.schemata, this.typeSystem, this.hints, this.problems);
        this.plan = this.planner.createPlan(this.queryContext, this.query);
        Assert.assertThat((Object)this.problems.hasErrors(), (Matcher)Is.is((Object)false));
        this.print(this.plan);
        Assert.assertThat((Object)this.plan.getType(), (Matcher)Is.is((Object)PlanNode.Type.SORT));
        Assert.assertThat((Object)this.plan.getSelectors(), (Matcher)Is.is(this.selectors("t1")));
    }

    @Test
    public void shouldProducePlanWhenOrderByClauseWithScoreIsUsed() {
        this.schemata = this.schemataBuilder.addTable("dna:someTable", new String[]{"column1", "column2", "column3"}).build();
        this.query = this.builder.selectStar().from("dna:someTable AS t1").where().path("t1").isEqualTo((Object)1L).end().orderBy().ascending().fullTextSearchScore("t1").end().query();
        this.queryContext = new QueryContext(this.schemata, this.typeSystem, this.hints, this.problems);
        this.plan = this.planner.createPlan(this.queryContext, this.query);
        Assert.assertThat((Object)this.problems.hasErrors(), (Matcher)Is.is((Object)false));
        this.print(this.plan);
        Assert.assertThat((Object)this.plan.getType(), (Matcher)Is.is((Object)PlanNode.Type.SORT));
        Assert.assertThat((Object)this.plan.getSelectors(), (Matcher)Is.is(this.selectors("t1")));
    }

    @Test
    @FixFor(value={"MODE-869"})
    public void shouldProducePlanWhenUsingSubquery() {
        this.schemata = this.schemataBuilder.addTable("someTable", new String[]{"column1", "column2", "column3"}).addTable("otherTable", new String[]{"columnA", "columnB"}).build();
        QueryCommand subquery = this.builder.select(new String[]{"columnA"}).from("otherTable").query();
        this.builder = new QueryBuilder(this.typeSystem);
        this.query = this.builder.selectStar().from("someTable").where().path("someTable").isLike((Object)subquery).end().query();
        this.queryContext = new QueryContext(this.schemata, this.typeSystem, this.hints, this.problems);
        this.plan = this.planner.createPlan(this.queryContext, this.query);
        this.print(this.plan);
        Assert.assertThat((Object)this.problems.hasErrors(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.problems.isEmpty(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.plan.getType(), (Matcher)Is.is((Object)PlanNode.Type.DEPENDENT_QUERY));
        Assert.assertThat((Object)this.plan.getChildCount(), (Matcher)Is.is((Object)2));
        PlanNode subqueryPlan = this.plan.getFirstChild();
        this.assertProjectNode(subqueryPlan, "columnA");
        Assert.assertThat((Object)subqueryPlan.getProperty(PlanNode.Property.VARIABLE_NAME, String.class), (Matcher)Is.is((Object)"__subquery1"));
        Assert.assertThat((Object)subqueryPlan.getChildCount(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)subqueryPlan.getSelectors(), (Matcher)Is.is(this.selectors("otherTable")));
        PlanNode subquerySource = subqueryPlan.getFirstChild();
        this.assertSourceNode(subquerySource, "otherTable", null, "columnA", "columnB");
        Assert.assertThat((Object)subquerySource.getChildCount(), (Matcher)Is.is((Object)0));
        PlanNode queryPlan = this.plan.getLastChild();
        this.assertProjectNode(queryPlan, "column1", "column2", "column3");
        Assert.assertThat((Object)queryPlan.getType(), (Matcher)Is.is((Object)PlanNode.Type.PROJECT));
        Assert.assertThat((Object)queryPlan.getChildCount(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)queryPlan.getSelectors(), (Matcher)Is.is(this.selectors("someTable")));
        PlanNode criteriaNode = queryPlan.getFirstChild();
        Assert.assertThat((Object)criteriaNode.getType(), (Matcher)Is.is((Object)PlanNode.Type.SELECT));
        Assert.assertThat((Object)criteriaNode.getChildCount(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)criteriaNode.getSelectors(), (Matcher)Is.is(this.selectors("someTable")));
        Assert.assertThat((Object)criteriaNode.getProperty(PlanNode.Property.SELECT_CRITERIA), (Matcher)Is.is((Object)this.like((DynamicOperand)this.nodePath("someTable"), (StaticOperand)this.var("__subquery1"))));
        PlanNode source = criteriaNode.getFirstChild();
        this.assertSourceNode(source, "someTable", null, "column1", "column2", "column3");
        Assert.assertThat((Object)source.getChildCount(), (Matcher)Is.is((Object)0));
    }

    @Test
    @FixFor(value={"MODE-869"})
    public void shouldProducePlanWhenUsingSubqueryInSubquery() {
        this.schemata = this.schemataBuilder.addTable("someTable", new String[]{"column1", "column2", "column3"}).addTable("otherTable", new String[]{"columnA", "columnB"}).addTable("stillOther", new String[]{"columnX", "columnY"}).build();
        QueryCommand subquery2 = ((QueryBuilder.ConstraintBuilder)this.builder.select(new String[]{"columnY"}).from("stillOther").where().propertyValue("stillOther", "columnX").isLessThan().cast(3).asLong()).end().query();
        this.builder = new QueryBuilder(this.typeSystem);
        QueryCommand subquery1 = this.builder.select(new String[]{"columnA"}).from("otherTable").where().propertyValue("otherTable", "columnB").isEqualTo((Object)subquery2).end().query();
        this.builder = new QueryBuilder(this.typeSystem);
        this.query = this.builder.selectStar().from("someTable").where().path("someTable").isLike((Object)subquery1).end().query();
        this.queryContext = new QueryContext(this.schemata, this.typeSystem, this.hints, this.problems);
        this.plan = this.planner.createPlan(this.queryContext, this.query);
        this.print(this.plan);
        Assert.assertThat((Object)this.problems.hasErrors(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.problems.isEmpty(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.plan.getType(), (Matcher)Is.is((Object)PlanNode.Type.DEPENDENT_QUERY));
        Assert.assertThat((Object)this.plan.getChildCount(), (Matcher)Is.is((Object)2));
        PlanNode depQuery1 = this.plan.getFirstChild();
        Assert.assertThat((Object)depQuery1.getType(), (Matcher)Is.is((Object)PlanNode.Type.DEPENDENT_QUERY));
        Assert.assertThat((Object)depQuery1.getChildCount(), (Matcher)Is.is((Object)2));
        PlanNode subqueryPlan2 = depQuery1.getFirstChild();
        this.assertProjectNode(subqueryPlan2, "columnY");
        Assert.assertThat((Object)subqueryPlan2.getProperty(PlanNode.Property.VARIABLE_NAME, String.class), (Matcher)Is.is((Object)"__subquery2"));
        Assert.assertThat((Object)subqueryPlan2.getChildCount(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)subqueryPlan2.getSelectors(), (Matcher)Is.is(this.selectors("stillOther")));
        PlanNode criteriaNode2 = subqueryPlan2.getFirstChild();
        Assert.assertThat((Object)criteriaNode2.getType(), (Matcher)Is.is((Object)PlanNode.Type.SELECT));
        Assert.assertThat((Object)criteriaNode2.getChildCount(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)criteriaNode2.getSelectors(), (Matcher)Is.is(this.selectors("stillOther")));
        Assert.assertThat((Object)criteriaNode2.getProperty(PlanNode.Property.SELECT_CRITERIA), (Matcher)Is.is((Object)this.lessThan((DynamicOperand)this.property("stillOther", "columnX"), (StaticOperand)this.literal(3L))));
        PlanNode subquerySource2 = criteriaNode2.getFirstChild();
        this.assertSourceNode(subquerySource2, "stillOther", null, "columnX", "columnY");
        Assert.assertThat((Object)subquerySource2.getChildCount(), (Matcher)Is.is((Object)0));
        PlanNode subqueryPlan1 = depQuery1.getLastChild();
        this.assertProjectNode(subqueryPlan1, "columnA");
        Assert.assertThat((Object)subqueryPlan1.getProperty(PlanNode.Property.VARIABLE_NAME, String.class), (Matcher)Is.is((Object)"__subquery1"));
        Assert.assertThat((Object)subqueryPlan1.getChildCount(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)subqueryPlan1.getSelectors(), (Matcher)Is.is(this.selectors("otherTable")));
        PlanNode criteriaNode1 = subqueryPlan1.getFirstChild();
        Assert.assertThat((Object)criteriaNode1.getType(), (Matcher)Is.is((Object)PlanNode.Type.SELECT));
        Assert.assertThat((Object)criteriaNode1.getChildCount(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)criteriaNode1.getSelectors(), (Matcher)Is.is(this.selectors("otherTable")));
        Assert.assertThat((Object)criteriaNode1.getProperty(PlanNode.Property.SELECT_CRITERIA), (Matcher)Is.is((Object)this.equals((DynamicOperand)this.property("otherTable", "columnB"), (StaticOperand)this.var("__subquery2"))));
        PlanNode subquerySource1 = criteriaNode1.getFirstChild();
        this.assertSourceNode(subquerySource1, "otherTable", null, "columnA", "columnB");
        Assert.assertThat((Object)subquerySource1.getChildCount(), (Matcher)Is.is((Object)0));
        PlanNode queryPlan = this.plan.getLastChild();
        this.assertProjectNode(queryPlan, "column1", "column2", "column3");
        Assert.assertThat((Object)queryPlan.getType(), (Matcher)Is.is((Object)PlanNode.Type.PROJECT));
        Assert.assertThat((Object)queryPlan.getChildCount(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)queryPlan.getSelectors(), (Matcher)Is.is(this.selectors("someTable")));
        PlanNode criteriaNode = queryPlan.getFirstChild();
        Assert.assertThat((Object)criteriaNode.getType(), (Matcher)Is.is((Object)PlanNode.Type.SELECT));
        Assert.assertThat((Object)criteriaNode.getChildCount(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)criteriaNode.getSelectors(), (Matcher)Is.is(this.selectors("someTable")));
        Assert.assertThat((Object)criteriaNode.getProperty(PlanNode.Property.SELECT_CRITERIA), (Matcher)Is.is((Object)this.like((DynamicOperand)this.nodePath("someTable"), (StaticOperand)this.var("__subquery1"))));
        PlanNode source = criteriaNode.getFirstChild();
        this.assertSourceNode(source, "someTable", null, "column1", "column2", "column3");
        Assert.assertThat((Object)source.getChildCount(), (Matcher)Is.is((Object)0));
    }

    @Test
    @FixFor(value={"MODE-869"})
    public void shouldProducePlanWhenUsingTwoSubqueries() {
        this.schemata = this.schemataBuilder.addTable("someTable", new String[]{"column1", "column2", "column3"}).addTable("otherTable", new String[]{"columnA", "columnB"}).addTable("stillOther", new String[]{"columnX", "columnY"}).build();
        QueryCommand subquery1 = this.builder.select(new String[]{"columnA"}).from("otherTable").where().propertyValue("otherTable", "columnB").isEqualTo((Object)"winner").end().query();
        this.builder = new QueryBuilder(this.typeSystem);
        QueryCommand subquery2 = ((QueryBuilder.ConstraintBuilder)this.builder.select(new String[]{"columnY"}).from("stillOther").where().propertyValue("stillOther", "columnX").isLessThan().cast(3).asLong()).end().query();
        this.builder = new QueryBuilder(this.typeSystem);
        this.query = this.builder.selectStar().from("someTable").where().path("someTable").isLike((Object)subquery2).and().propertyValue("someTable", "column3").isInSubquery(subquery1).end().query();
        this.queryContext = new QueryContext(this.schemata, this.typeSystem, this.hints, this.problems);
        this.plan = this.planner.createPlan(this.queryContext, this.query);
        this.print(this.plan);
        Assert.assertThat((Object)this.problems.hasErrors(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.problems.isEmpty(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.plan.getType(), (Matcher)Is.is((Object)PlanNode.Type.DEPENDENT_QUERY));
        Assert.assertThat((Object)this.plan.getChildCount(), (Matcher)Is.is((Object)2));
        PlanNode subqueryPlan1 = this.plan.getFirstChild();
        this.assertProjectNode(subqueryPlan1, "columnA");
        Assert.assertThat((Object)subqueryPlan1.getProperty(PlanNode.Property.VARIABLE_NAME, String.class), (Matcher)Is.is((Object)"__subquery1"));
        Assert.assertThat((Object)subqueryPlan1.getChildCount(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)subqueryPlan1.getSelectors(), (Matcher)Is.is(this.selectors("otherTable")));
        PlanNode criteriaNode1 = subqueryPlan1.getFirstChild();
        Assert.assertThat((Object)criteriaNode1.getType(), (Matcher)Is.is((Object)PlanNode.Type.SELECT));
        Assert.assertThat((Object)criteriaNode1.getChildCount(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)criteriaNode1.getSelectors(), (Matcher)Is.is(this.selectors("otherTable")));
        Assert.assertThat((Object)criteriaNode1.getProperty(PlanNode.Property.SELECT_CRITERIA), (Matcher)Is.is((Object)this.equals((DynamicOperand)this.property("otherTable", "columnB"), (StaticOperand)this.literal("winner"))));
        PlanNode subquerySource1 = criteriaNode1.getFirstChild();
        this.assertSourceNode(subquerySource1, "otherTable", null, "columnA", "columnB");
        Assert.assertThat((Object)subquerySource1.getChildCount(), (Matcher)Is.is((Object)0));
        PlanNode depQuery2 = this.plan.getLastChild();
        Assert.assertThat((Object)depQuery2.getType(), (Matcher)Is.is((Object)PlanNode.Type.DEPENDENT_QUERY));
        Assert.assertThat((Object)depQuery2.getChildCount(), (Matcher)Is.is((Object)2));
        PlanNode subqueryPlan2 = depQuery2.getFirstChild();
        this.assertProjectNode(subqueryPlan2, "columnY");
        Assert.assertThat((Object)subqueryPlan2.getProperty(PlanNode.Property.VARIABLE_NAME, String.class), (Matcher)Is.is((Object)"__subquery2"));
        Assert.assertThat((Object)subqueryPlan2.getChildCount(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)subqueryPlan2.getSelectors(), (Matcher)Is.is(this.selectors("stillOther")));
        PlanNode criteriaNode2 = subqueryPlan2.getFirstChild();
        Assert.assertThat((Object)criteriaNode2.getType(), (Matcher)Is.is((Object)PlanNode.Type.SELECT));
        Assert.assertThat((Object)criteriaNode2.getChildCount(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)criteriaNode2.getSelectors(), (Matcher)Is.is(this.selectors("stillOther")));
        Assert.assertThat((Object)criteriaNode2.getProperty(PlanNode.Property.SELECT_CRITERIA), (Matcher)Is.is((Object)this.lessThan((DynamicOperand)this.property("stillOther", "columnX"), (StaticOperand)this.literal(3L))));
        PlanNode subquerySource2 = criteriaNode2.getFirstChild();
        this.assertSourceNode(subquerySource2, "stillOther", null, "columnX", "columnY");
        Assert.assertThat((Object)subquerySource2.getChildCount(), (Matcher)Is.is((Object)0));
        PlanNode queryPlan = depQuery2.getLastChild();
        this.assertProjectNode(queryPlan, "column1", "column2", "column3");
        Assert.assertThat((Object)queryPlan.getType(), (Matcher)Is.is((Object)PlanNode.Type.PROJECT));
        Assert.assertThat((Object)queryPlan.getChildCount(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)queryPlan.getSelectors(), (Matcher)Is.is(this.selectors("someTable")));
        PlanNode criteriaNode3 = queryPlan.getFirstChild();
        Assert.assertThat((Object)criteriaNode3.getType(), (Matcher)Is.is((Object)PlanNode.Type.SELECT));
        Assert.assertThat((Object)criteriaNode3.getChildCount(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)criteriaNode3.getSelectors(), (Matcher)Is.is(this.selectors("someTable")));
        Assert.assertThat((Object)criteriaNode3.getProperty(PlanNode.Property.SELECT_CRITERIA), (Matcher)Is.is((Object)this.like((DynamicOperand)this.nodePath("someTable"), (StaticOperand)this.var("__subquery2"))));
        PlanNode criteriaNode4 = criteriaNode3.getFirstChild();
        Assert.assertThat((Object)criteriaNode4.getProperty(PlanNode.Property.SELECT_CRITERIA), (Matcher)Is.is((Object)this.in((DynamicOperand)this.property("someTable", "column3"), new StaticOperand[]{this.var("__subquery1")})));
        PlanNode source = criteriaNode4.getFirstChild();
        this.assertSourceNode(source, "someTable", null, "column1", "column2", "column3");
        Assert.assertThat((Object)source.getChildCount(), (Matcher)Is.is((Object)0));
    }

    protected NodePath nodePath(String selectorName) {
        return this.nodePath(this.selector(selectorName));
    }

    protected NodePath nodePath(SelectorName selectorName) {
        return new NodePath(selectorName);
    }

    protected PropertyValue property(String selectorName, String columnName) {
        return this.property(this.selector(selectorName), columnName);
    }

    protected PropertyValue property(SelectorName selectorName, String columnName) {
        return new PropertyValue(selectorName, columnName);
    }

    protected BindVariableName var(String variableName) {
        return new BindVariableName(variableName);
    }

    protected Literal literal(Object value) {
        return new Literal(value);
    }

    protected And and(Constraint left, Constraint right) {
        return new And(left, right);
    }

    protected Comparison like(DynamicOperand left, StaticOperand right) {
        return new Comparison(left, Operator.LIKE, right);
    }

    protected Comparison lessThan(DynamicOperand left, StaticOperand right) {
        return new Comparison(left, Operator.LESS_THAN, right);
    }

    protected Comparison equals(DynamicOperand left, StaticOperand right) {
        return new Comparison(left, Operator.EQUAL_TO, right);
    }

    protected SetCriteria in(DynamicOperand left, StaticOperand ... right) {
        return new SetCriteria(left, right);
    }
}

