/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.request;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.graph.request.AbstractRequestTest;
import org.modeshape.graph.request.CloneWorkspaceRequest;
import org.modeshape.graph.request.CreateWorkspaceRequest;
import org.modeshape.graph.request.Request;

public class CloneWorkspaceRequestTest
extends AbstractRequestTest {
    private CloneWorkspaceRequest request;

    @Override
    @Before
    public void beforeEach() {
        super.beforeEach();
    }

    @Override
    protected Request createRequest() {
        return new CloneWorkspaceRequest(this.workspace1, this.workspace2, CreateWorkspaceRequest.CreateConflictBehavior.DO_NOT_CREATE, CloneWorkspaceRequest.CloneConflictBehavior.SKIP_CLONE);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowCreatingRequestWithNullCloneWorkspaceName() {
        new CloneWorkspaceRequest(null, this.workspace2, CreateWorkspaceRequest.CreateConflictBehavior.DO_NOT_CREATE, CloneWorkspaceRequest.CloneConflictBehavior.SKIP_CLONE);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowCreatingRequestWithNullTargetWorkspaceName() {
        new CloneWorkspaceRequest(this.workspace1, null, CreateWorkspaceRequest.CreateConflictBehavior.DO_NOT_CREATE, CloneWorkspaceRequest.CloneConflictBehavior.SKIP_CLONE);
    }

    @Test
    public void shouldAllowCreatingRequestWithNullCreateCreateConflictBehavior() {
        this.request = new CloneWorkspaceRequest(this.workspace1, this.workspace2, null, CloneWorkspaceRequest.CloneConflictBehavior.SKIP_CLONE);
        Assert.assertThat((Object)this.request.targetConflictBehavior(), (Matcher)Is.is((Object)CloneWorkspaceRequest.DEFAULT_CREATE_CONFLICT_BEHAVIOR));
        Assert.assertThat((Object)this.request.cloneConflictBehavior(), (Matcher)Is.is((Object)CloneWorkspaceRequest.CloneConflictBehavior.SKIP_CLONE));
    }

    @Test
    public void shouldAllowCreatingRequestWithNullCreateCloneConflictBehavior() {
        this.request = new CloneWorkspaceRequest(this.workspace1, this.workspace2, CreateWorkspaceRequest.CreateConflictBehavior.CREATE_WITH_ADJUSTED_NAME, null);
        Assert.assertThat((Object)this.request.targetConflictBehavior(), (Matcher)Is.is((Object)CreateWorkspaceRequest.CreateConflictBehavior.CREATE_WITH_ADJUSTED_NAME));
        Assert.assertThat((Object)this.request.cloneConflictBehavior(), (Matcher)Is.is((Object)CloneWorkspaceRequest.DEFAULT_CLONE_CONFLICT_BEHAVIOR));
    }

    @Test
    public void shouldCreateValidRequestWithValidLocation() {
        this.request = new CloneWorkspaceRequest(this.workspace1, this.workspace2, CreateWorkspaceRequest.CreateConflictBehavior.CREATE_WITH_ADJUSTED_NAME, CloneWorkspaceRequest.CloneConflictBehavior.SKIP_CLONE);
        Assert.assertThat((Object)this.request.nameOfWorkspaceToBeCloned(), (Matcher)Is.is((Object)this.workspace1));
        Assert.assertThat((Object)this.request.desiredNameOfTargetWorkspace(), (Matcher)Is.is((Object)this.workspace2));
        Assert.assertThat((Object)this.request.targetConflictBehavior(), (Matcher)Is.is((Object)CreateWorkspaceRequest.CreateConflictBehavior.CREATE_WITH_ADJUSTED_NAME));
        Assert.assertThat((Object)this.request.cloneConflictBehavior(), (Matcher)Is.is((Object)CloneWorkspaceRequest.CloneConflictBehavior.SKIP_CLONE));
        Assert.assertThat((Object)this.request.hasError(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.request.getError(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldConsiderEqualTwoRequestsWithSameLocations() {
        CloneWorkspaceRequest request1 = null;
        CloneWorkspaceRequest request2 = null;
        request1 = new CloneWorkspaceRequest(this.workspace1, this.workspace2, CreateWorkspaceRequest.CreateConflictBehavior.DO_NOT_CREATE, CloneWorkspaceRequest.CloneConflictBehavior.SKIP_CLONE);
        request2 = new CloneWorkspaceRequest(this.workspace1, this.workspace2, CreateWorkspaceRequest.CreateConflictBehavior.DO_NOT_CREATE, CloneWorkspaceRequest.CloneConflictBehavior.SKIP_CLONE);
        Assert.assertThat((Object)request1, (Matcher)Is.is((Object)request2));
    }

    @Test
    public void shouldConsiderEqualTwoRequestsWithDifferentCreateConflictBehaviors() {
        CloneWorkspaceRequest request1 = null;
        CloneWorkspaceRequest request2 = null;
        request1 = new CloneWorkspaceRequest(this.workspace1, this.workspace2, CreateWorkspaceRequest.CreateConflictBehavior.CREATE_WITH_ADJUSTED_NAME, CloneWorkspaceRequest.CloneConflictBehavior.SKIP_CLONE);
        request2 = new CloneWorkspaceRequest(this.workspace1, this.workspace2, CreateWorkspaceRequest.CreateConflictBehavior.DO_NOT_CREATE, CloneWorkspaceRequest.CloneConflictBehavior.SKIP_CLONE);
        Assert.assertThat((Object)request1, (Matcher)Is.is((Object)request2));
    }

    @Test
    public void shouldConsiderEqualTwoRequestsWithDifferentCloneConflictBehaviors() {
        CloneWorkspaceRequest request1 = null;
        CloneWorkspaceRequest request2 = null;
        request1 = new CloneWorkspaceRequest(this.workspace1, this.workspace2, CreateWorkspaceRequest.CreateConflictBehavior.DO_NOT_CREATE, CloneWorkspaceRequest.CloneConflictBehavior.SKIP_CLONE);
        request2 = new CloneWorkspaceRequest(this.workspace1, this.workspace2, CreateWorkspaceRequest.CreateConflictBehavior.DO_NOT_CREATE, CloneWorkspaceRequest.CloneConflictBehavior.DO_NOT_CLONE);
        Assert.assertThat((Object)request1, (Matcher)Is.is((Object)request2));
    }

    @Test
    public void shouldConsiderNotEqualTwoRequestsWithDifferentDesiredWorkspaceNames() {
        CloneWorkspaceRequest request1 = null;
        CloneWorkspaceRequest request2 = null;
        request1 = new CloneWorkspaceRequest(this.workspace1, this.workspace2, CreateWorkspaceRequest.CreateConflictBehavior.DO_NOT_CREATE, CloneWorkspaceRequest.CloneConflictBehavior.SKIP_CLONE);
        request2 = new CloneWorkspaceRequest(this.workspace2, this.workspace1, CreateWorkspaceRequest.CreateConflictBehavior.DO_NOT_CREATE, CloneWorkspaceRequest.CloneConflictBehavior.DO_NOT_CLONE);
        Assert.assertThat((Object)request1.equals((Object)request2), (Matcher)Is.is((Object)false));
    }
}

