/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.request;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsSame;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.matchers.JUnitMatchers;
import org.modeshape.graph.request.AbstractRequestTest;
import org.modeshape.graph.request.CompositeRequest;
import org.modeshape.graph.request.ReadAllChildrenRequest;
import org.modeshape.graph.request.ReadPropertyRequest;
import org.modeshape.graph.request.Request;

public class CompositeRequestTest
extends AbstractRequestTest {
    private Request request;
    private Request[] requests;
    private List<Request> requestList;

    @Override
    @Before
    public void beforeEach() {
        super.beforeEach();
        ReadPropertyRequest request1 = new ReadPropertyRequest(this.validPathLocation1, "workspace1", this.createName("property"));
        ReadPropertyRequest request2 = new ReadPropertyRequest(this.validPathLocation2, "workspace1", this.createName("property"));
        ReadAllChildrenRequest request3 = new ReadAllChildrenRequest(this.validPathLocation, "workspace1");
        this.requests = new Request[]{request1, request2, request3};
        this.requestList = Arrays.asList(this.requests);
    }

    @Override
    protected Request createRequest() {
        return CompositeRequest.with((Request[])this.requests);
    }

    @Test
    public void shouldCancelAllNestedRequestsAndCompositeAfterCallingCancel() {
        Request composite = CompositeRequest.with((Request[])this.requests);
        Assert.assertThat((Object)composite.isCancelled(), (Matcher)Is.is((Object)false));
        for (Request request : this.requests) {
            Assert.assertThat((Object)request.isCancelled(), (Matcher)Is.is((Object)false));
        }
        composite.cancel();
        Assert.assertThat((Object)composite.isCancelled(), (Matcher)Is.is((Object)true));
        for (Request request : this.requests) {
            Assert.assertThat((Object)request.isCancelled(), (Matcher)Is.is((Object)true));
        }
    }

    @Test
    public void shouldCancelAllNestedRequestsAndCompositeAfterCallingCancelOnNestedRequest() {
        Request composite = CompositeRequest.with((Request[])this.requests);
        Assert.assertThat((Object)composite.isCancelled(), (Matcher)Is.is((Object)false));
        for (Request request : this.requests) {
            Assert.assertThat((Object)request.isCancelled(), (Matcher)Is.is((Object)false));
        }
        this.requests[0].cancel();
        Assert.assertThat((Object)composite.isCancelled(), (Matcher)Is.is((Object)true));
        for (Request request : this.requests) {
            Assert.assertThat((Object)request.isCancelled(), (Matcher)Is.is((Object)true));
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowCreatingCompositeRequestWithNullRequest() {
        CompositeRequest.with((Request[])new Request[]{null});
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowCreatingCompositeRequestWithNullRequestArray() {
        CompositeRequest.with((Request[])null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowCreatingCompositeRequestWithNullRequestIterator() {
        CompositeRequest.with((Iterator)null);
    }

    @Test
    public void shouldReturnRequestWhenCreatingCompositeFromSingleRequest() {
        this.request = CompositeRequest.with((Request[])new Request[]{this.requests[0]});
        Assert.assertThat((Object)this.request, (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.requests[0])));
    }

    @Test
    public void shouldReturnRequestWhenCreatingCompositeFromIteratorOverSingleRequest() {
        this.requestList = Collections.singletonList(this.requests[0]);
        this.request = CompositeRequest.with(this.requestList.iterator());
        Assert.assertThat((Object)this.request, (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.requestList.get(0))));
    }

    @Test
    public void shouldCreateCompositeFromMultipleRequests() {
        this.request = CompositeRequest.with((Request[])this.requests);
        Assert.assertThat((Object)this.request, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(CompositeRequest.class)));
        CompositeRequest composite = (CompositeRequest)this.request;
        Assert.assertThat((Object)composite.size(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)composite.size(), (Matcher)Is.is((Object)this.requests.length));
        Assert.assertThat((Object)composite.getRequests(), (Matcher)JUnitMatchers.hasItems((Object[])this.requests));
        Iterator actual = composite.iterator();
        Iterator<Request> expected = this.requestList.iterator();
        while (actual.hasNext() && expected.hasNext()) {
            Assert.assertThat(actual.next(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)expected.next())));
        }
        Assert.assertThat((Object)actual.hasNext(), (Matcher)Is.is((Object)expected.hasNext()));
        Assert.assertThat((Object)composite.hasError(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldCreateCompositeFromIteratorOverRequests() {
        this.request = CompositeRequest.with(this.requestList.iterator());
        Assert.assertThat((Object)this.request, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(CompositeRequest.class)));
        CompositeRequest composite = (CompositeRequest)this.request;
        Assert.assertThat((Object)composite.size(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)composite.size(), (Matcher)Is.is((Object)this.requestList.size()));
        Assert.assertThat((Object)composite.getRequests(), (Matcher)JUnitMatchers.hasItems((Object[])this.requests));
        Iterator actual = composite.iterator();
        Iterator<Request> expected = this.requestList.iterator();
        while (actual.hasNext() && expected.hasNext()) {
            Assert.assertThat(actual.next(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)expected.next())));
        }
        Assert.assertThat((Object)actual.hasNext(), (Matcher)Is.is((Object)expected.hasNext()));
        Assert.assertThat((Object)composite.hasError(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldConsiderTwoCompositesOfSameRequestsToBeEqual() {
        this.request = CompositeRequest.with((Request[])this.requests);
        Request request2 = CompositeRequest.with((Request[])this.requests);
        Assert.assertThat((Object)this.request, (Matcher)Is.is((Object)request2));
        Assert.assertThat((Object)this.request.hasError(), (Matcher)Is.is((Object)false));
    }
}

