/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.request;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.hamcrest.core.IsSame;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.graph.request.AbstractRequestTest;
import org.modeshape.graph.request.DeleteBranchRequest;
import org.modeshape.graph.request.Request;

public class DeleteBranchRequestTest
extends AbstractRequestTest {
    private DeleteBranchRequest request;

    @Override
    @Before
    public void beforeEach() {
        super.beforeEach();
    }

    @Override
    protected Request createRequest() {
        return new DeleteBranchRequest(this.validPathLocation1, this.workspace1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowCreatingRequestWithNullFromLocation() {
        new DeleteBranchRequest(null, this.workspace1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowCreatingRequestWithNullWorkspaceName() {
        new DeleteBranchRequest(this.validPathLocation1, null);
    }

    @Test
    public void shouldCreateValidRequestWithValidLocation() {
        this.request = new DeleteBranchRequest(this.validPathLocation1, this.workspace1);
        Assert.assertThat((Object)this.request.at(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.validPathLocation1)));
        Assert.assertThat((Object)this.request.inWorkspace(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.workspace1)));
        Assert.assertThat((Object)this.request.hasError(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.request.getError(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldConsiderEqualTwoRequestsWithSameLocations() {
        this.request = new DeleteBranchRequest(this.validPathLocation1, this.workspace1);
        DeleteBranchRequest request2 = new DeleteBranchRequest(this.validPathLocation1, this.workspace1);
        Assert.assertThat((Object)this.request, (Matcher)Is.is((Object)request2));
    }

    @Test
    public void shouldConsiderNotEqualTwoRequestsWithDifferentLocations() {
        this.request = new DeleteBranchRequest(this.validPathLocation1, this.workspace1);
        DeleteBranchRequest request2 = new DeleteBranchRequest(this.validPathLocation2, this.workspace1);
        Assert.assertThat((Object)this.request.equals((Object)request2), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldConsiderNotEqualTwoRequestsWithDifferentWorkspaceNames() {
        this.request = new DeleteBranchRequest(this.validPathLocation1, this.workspace1);
        DeleteBranchRequest request2 = new DeleteBranchRequest(this.validPathLocation1, this.workspace2);
        Assert.assertThat((Object)this.request.equals((Object)request2), (Matcher)Is.is((Object)false));
    }
}

