/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.request;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.hamcrest.core.IsSame;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.graph.NodeConflictBehavior;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.basic.BasicName;
import org.modeshape.graph.request.AbstractRequestTest;
import org.modeshape.graph.request.MoveBranchRequest;
import org.modeshape.graph.request.Request;

public class MoveBranchRequestTest
extends AbstractRequestTest {
    private MoveBranchRequest request;

    @Override
    @Before
    public void beforeEach() {
        super.beforeEach();
    }

    @Override
    protected Request createRequest() {
        return new MoveBranchRequest(this.validPathLocation1, this.validPathLocation2, this.workspace2);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowCreatingRequestWithNullFromLocation() {
        new MoveBranchRequest(null, this.validPathLocation2, this.workspace2);
    }

    @Test
    public void shouldAllowCreatingRequestWithNullToLocation() {
        new MoveBranchRequest(this.validPathLocation1, null, this.workspace2);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowCreatingRequestWithNullWorkspaceName() {
        new MoveBranchRequest(this.validPathLocation1, this.validPathLocation2, null);
    }

    @Test
    public void shouldCreateValidRequestWithValidFromLocationAndValidToLocation() {
        this.request = new MoveBranchRequest(this.validPathLocation1, this.validPathLocation2, this.workspace1);
        Assert.assertThat((Object)this.request.from(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.validPathLocation1)));
        Assert.assertThat((Object)this.request.into(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.validPathLocation2)));
        Assert.assertThat((Object)this.request.inWorkspace(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.workspace1)));
        Assert.assertThat((Object)this.request.hasError(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.request.getError(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldCreateValidRequestWithValidFromLocationAndValidToLocationAndValidBeforeLocation() {
        BasicName newName = new BasicName("", "newName");
        this.request = new MoveBranchRequest(this.validPathLocation1, this.validPathLocation2, this.validPathLocation, this.workspace1, (Name)newName, NodeConflictBehavior.DO_NOT_REPLACE);
        Assert.assertThat((Object)this.request.from(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.validPathLocation1)));
        Assert.assertThat((Object)this.request.into(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.validPathLocation2)));
        Assert.assertThat((Object)this.request.before(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.validPathLocation)));
        Assert.assertThat((Object)this.request.inWorkspace(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.workspace1)));
        Assert.assertThat((Object)this.request.hasError(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.request.getError(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldConsiderEqualTwoRequestsWithSameLocations() {
        this.request = new MoveBranchRequest(this.validPathLocation1, this.validPathLocation2, this.workspace2);
        MoveBranchRequest request2 = new MoveBranchRequest(this.validPathLocation1, this.validPathLocation2, this.workspace2);
        Assert.assertThat((Object)this.request, (Matcher)Is.is((Object)request2));
    }

    @Test
    public void shouldConsiderNotEqualTwoRequestsWithDifferentLocations() {
        this.request = new MoveBranchRequest(this.validPathLocation1, this.validPathLocation2, this.workspace2);
        MoveBranchRequest request2 = new MoveBranchRequest(this.validPathLocation2, this.validPathLocation1, this.workspace2);
        Assert.assertThat((Object)this.request.equals((Object)request2), (Matcher)Is.is((Object)false));
    }
}

