/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.request;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.hamcrest.core.IsSame;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.matchers.JUnitMatchers;
import org.modeshape.graph.Location;
import org.modeshape.graph.request.AbstractRequestTest;
import org.modeshape.graph.request.ReadAllChildrenRequest;
import org.modeshape.graph.request.Request;

public class ReadAllChildrenRequestTest
extends AbstractRequestTest {
    private ReadAllChildrenRequest request;

    @Override
    @Before
    public void beforeEach() {
        super.beforeEach();
    }

    @Override
    protected Request createRequest() {
        return new ReadAllChildrenRequest(this.validPathLocation1, this.workspace1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowCreatingRequestWithNullFromLocation() {
        new ReadAllChildrenRequest(null, this.workspace1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowCreatingRequestWithNullWorkspaceName() {
        new ReadAllChildrenRequest(this.validPathLocation1, null);
    }

    @Test
    public void shouldCreateValidRequestWithValidLocation() {
        this.request = new ReadAllChildrenRequest(this.validPathLocation1, this.workspace1);
        Assert.assertThat((Object)this.request.of(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.validPathLocation1)));
        Assert.assertThat((Object)this.request.inWorkspace(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.workspace1)));
        Assert.assertThat((Object)this.request.hasError(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.request.getError(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldConsiderEqualTwoRequestsWithSameLocationsAndWorkspaceNames() {
        this.request = new ReadAllChildrenRequest(this.validPathLocation1, this.workspace1);
        ReadAllChildrenRequest request2 = new ReadAllChildrenRequest(this.validPathLocation1, this.workspace1);
        Assert.assertThat((Object)this.request, (Matcher)Is.is((Object)request2));
    }

    @Test
    public void shouldConsiderNotEqualTwoRequestsWithDifferentLocations() {
        this.request = new ReadAllChildrenRequest(this.validPathLocation1, this.workspace1);
        ReadAllChildrenRequest request2 = new ReadAllChildrenRequest(this.validPathLocation2, this.workspace1);
        Assert.assertThat((Object)this.request.equals((Object)request2), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldConsiderNotEqualTwoRequestsWithDifferentWorkspaces() {
        this.request = new ReadAllChildrenRequest(this.validPathLocation1, this.workspace1);
        ReadAllChildrenRequest request2 = new ReadAllChildrenRequest(this.validPathLocation1, this.workspace2);
        Assert.assertThat((Object)this.request.equals((Object)request2), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldAllowAddingChildren() {
        this.request = new ReadAllChildrenRequest(this.validPathLocation1, this.workspace1);
        this.request.addChild(this.validPathLocation1);
        this.request.addChild(this.validPathLocation2);
        Assert.assertThat((Object)this.request.getChildren().size(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)this.request.getChildren(), (Matcher)JUnitMatchers.hasItems((Object[])new Location[]{this.validPathLocation1, this.validPathLocation2}));
    }
}

