/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.request;

import java.util.Iterator;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.hamcrest.core.IsSame;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.graph.Location;
import org.modeshape.graph.request.AbstractRequestTest;
import org.modeshape.graph.request.ReadBranchRequest;
import org.modeshape.graph.request.Request;

public class ReadBranchRequestTest
extends AbstractRequestTest {
    private ReadBranchRequest request;

    @Override
    @Before
    public void beforeEach() {
        super.beforeEach();
    }

    @Override
    protected Request createRequest() {
        return new ReadBranchRequest(this.validPathLocation1, this.workspace1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowCreatingRequestWithNullFromLocation() {
        new ReadBranchRequest(null, this.workspace1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowCreatingRequestWithNullWorkspaceName() {
        new ReadBranchRequest(this.validPathLocation1, null);
    }

    @Test
    public void shouldCreateValidRequestWithValidLocation() {
        this.request = new ReadBranchRequest(this.validPathLocation1, this.workspace1);
        Assert.assertThat((Object)this.request.at(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.validPathLocation1)));
        Assert.assertThat((Object)this.request.inWorkspace(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.workspace1)));
        Assert.assertThat((Object)this.request.hasError(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.request.getError(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.request.maximumDepth(), (Matcher)Is.is((Object)2));
    }

    @Test
    public void shouldCreateValidRequestWithValidLocationAndMaximumDepth() {
        this.request = new ReadBranchRequest(this.validPathLocation1, this.workspace1, 10);
        Assert.assertThat((Object)this.request.at(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.validPathLocation1)));
        Assert.assertThat((Object)this.request.hasError(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.request.getError(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.request.maximumDepth(), (Matcher)Is.is((Object)10));
    }

    @Test
    public void shouldConsiderEqualTwoRequestsWithSameLocations() {
        this.request = new ReadBranchRequest(this.validPathLocation1, this.workspace1);
        ReadBranchRequest request2 = new ReadBranchRequest(this.validPathLocation1, new String(this.workspace1));
        Assert.assertThat((Object)this.request, (Matcher)Is.is((Object)request2));
    }

    @Test
    public void shouldConsiderNotEqualTwoRequestsWithDifferentLocations() {
        this.request = new ReadBranchRequest(this.validPathLocation1, this.workspace1, 20);
        ReadBranchRequest request2 = new ReadBranchRequest(this.validPathLocation2, this.workspace1, 20);
        Assert.assertThat((Object)this.request.equals((Object)request2), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldConsiderNotEqualTwoRequestsWithDifferentWorkspaceNames() {
        this.request = new ReadBranchRequest(this.validPathLocation1, this.workspace1, 20);
        ReadBranchRequest request2 = new ReadBranchRequest(this.validPathLocation1, this.workspace2, 20);
        Assert.assertThat((Object)this.request.equals((Object)request2), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldConsiderNotEqualTwoRequestsWithSameLocationsButDifferentMaximumDepths() {
        this.request = new ReadBranchRequest(this.validPathLocation1, this.workspace1, 20);
        ReadBranchRequest request2 = new ReadBranchRequest(this.validPathLocation1, this.workspace1, 2);
        Assert.assertThat((Object)this.request.equals((Object)request2), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldIterateOverNodesInBranchOfDepthOne() {
        this.request = new ReadBranchRequest(this.location("/a"), this.workspace1, 1);
        this.request.setActualLocationOfNode(this.request.at());
        this.request.setChildren(this.location("/a"), new Location[]{this.location("/a/b"), this.location("/a/c")});
        Iterator actual = this.request.iterator();
        Assert.assertThat((Object)actual.hasNext(), (Matcher)Is.is((Object)true));
        Assert.assertThat(actual.next(), (Matcher)Is.is((Object)this.location("/a")));
        Assert.assertThat((Object)actual.hasNext(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldIterateOverNodesInBranchOfDepthTwo() {
        this.request = new ReadBranchRequest(this.location("/a"), this.workspace1, 2);
        this.request.setActualLocationOfNode(this.request.at());
        this.request.setChildren(this.location("/a"), new Location[]{this.location("/a/b"), this.location("/a/c"), this.location("/a/d")});
        this.request.setChildren(this.location("/a/b"), new Location[]{this.location("/a/b/j"), this.location("/a/b/k")});
        this.request.setChildren(this.location("/a/c"), new Location[]{this.location("/a/c/j"), this.location("/a/c/k")});
        this.request.setChildren(this.location("/a/d"), new Location[0]);
        Iterator actual = this.request.iterator();
        Assert.assertThat((Object)actual.hasNext(), (Matcher)Is.is((Object)true));
        Assert.assertThat(actual.next(), (Matcher)Is.is((Object)this.location("/a")));
        Assert.assertThat((Object)actual.hasNext(), (Matcher)Is.is((Object)true));
        Assert.assertThat(actual.next(), (Matcher)Is.is((Object)this.location("/a/b")));
        Assert.assertThat((Object)actual.hasNext(), (Matcher)Is.is((Object)true));
        Assert.assertThat(actual.next(), (Matcher)Is.is((Object)this.location("/a/c")));
        Assert.assertThat((Object)actual.hasNext(), (Matcher)Is.is((Object)true));
        Assert.assertThat(actual.next(), (Matcher)Is.is((Object)this.location("/a/d")));
        Assert.assertThat((Object)actual.hasNext(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldIterateOverNodesInBranchOfDepthThree() {
        this.request = new ReadBranchRequest(this.location("/a"), this.workspace1, 3);
        this.request.setActualLocationOfNode(this.request.at());
        this.request.setChildren(this.location("/a"), new Location[]{this.location("/a/b"), this.location("/a/c"), this.location("/a/d")});
        this.request.setChildren(this.location("/a/b"), new Location[]{this.location("/a/b/j"), this.location("/a/b/k")});
        this.request.setChildren(this.location("/a/c"), new Location[]{this.location("/a/c/j"), this.location("/a/c/k")});
        this.request.setChildren(this.location("/a/c/j"), new Location[]{this.location("/a/c/j/j1"), this.location("/a/c/j/j2")});
        this.request.setChildren(this.location("/a/c/k"), new Location[]{this.location("/a/c/k/k1"), this.location("/a/c/k/k2")});
        this.request.setChildren(this.location("/a/b/j"), new Location[]{this.location("/a/b/j/m"), this.location("/a/b/j/n")});
        this.request.setChildren(this.location("/a/b/k"), new Location[0]);
        this.request.setChildren(this.location("/a/d"), new Location[0]);
        Iterator actual = this.request.iterator();
        Assert.assertThat((Object)actual.hasNext(), (Matcher)Is.is((Object)true));
        Assert.assertThat(actual.next(), (Matcher)Is.is((Object)this.location("/a")));
        Assert.assertThat((Object)actual.hasNext(), (Matcher)Is.is((Object)true));
        Assert.assertThat(actual.next(), (Matcher)Is.is((Object)this.location("/a/b")));
        Assert.assertThat((Object)actual.hasNext(), (Matcher)Is.is((Object)true));
        Assert.assertThat(actual.next(), (Matcher)Is.is((Object)this.location("/a/b/j")));
        Assert.assertThat((Object)actual.hasNext(), (Matcher)Is.is((Object)true));
        Assert.assertThat(actual.next(), (Matcher)Is.is((Object)this.location("/a/b/k")));
        Assert.assertThat((Object)actual.hasNext(), (Matcher)Is.is((Object)true));
        Assert.assertThat(actual.next(), (Matcher)Is.is((Object)this.location("/a/c")));
        Assert.assertThat((Object)actual.hasNext(), (Matcher)Is.is((Object)true));
        Assert.assertThat(actual.next(), (Matcher)Is.is((Object)this.location("/a/c/j")));
        Assert.assertThat((Object)actual.hasNext(), (Matcher)Is.is((Object)true));
        Assert.assertThat(actual.next(), (Matcher)Is.is((Object)this.location("/a/c/k")));
        Assert.assertThat((Object)actual.hasNext(), (Matcher)Is.is((Object)true));
        Assert.assertThat(actual.next(), (Matcher)Is.is((Object)this.location("/a/d")));
        Assert.assertThat((Object)actual.hasNext(), (Matcher)Is.is((Object)false));
    }
}

