/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.request;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.hamcrest.core.IsSame;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.matchers.JUnitMatchers;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.request.AbstractRequestTest;
import org.modeshape.graph.request.Request;
import org.modeshape.graph.request.UpdatePropertiesRequest;

public class UpdatePropertiesRequestTest
extends AbstractRequestTest {
    private UpdatePropertiesRequest request;
    private Map<Name, Property> validProperties;

    @Override
    @Before
    public void beforeEach() {
        super.beforeEach();
        this.validProperties = new HashMap<Name, Property>();
        this.validProperties.put(this.validProperty1.getName(), this.validProperty1);
        this.validProperties.put(this.validProperty2.getName(), this.validProperty2);
    }

    @Override
    protected Request createRequest() {
        return new UpdatePropertiesRequest(this.validPathLocation1, this.workspace1, this.validProperties);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowCreatingRequestWithNullFromLocation() {
        new UpdatePropertiesRequest(null, this.workspace1, this.validProperties);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowCreatingRequestWithNullWorkspaceName() {
        new UpdatePropertiesRequest(this.validPathLocation1, null, this.validProperties);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowCreatingRequestWithNullPropertyName() {
        new UpdatePropertiesRequest(this.validPathLocation, this.workspace1, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowCreatingRequestWithEmptyPropertyMap() {
        new UpdatePropertiesRequest(this.validPathLocation, this.workspace1, Collections.emptyMap());
    }

    @Test
    public void shouldCreateValidRequestWithValidLocationAndValidProperty() {
        this.request = new UpdatePropertiesRequest(this.validPathLocation1, this.workspace1, this.validProperties);
        Assert.assertThat((Object)this.request.on(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.validPathLocation1)));
        Assert.assertThat((Object)this.request.inWorkspace(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.workspace1)));
        Assert.assertThat((Object)this.request.hasError(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.request.getError(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat(this.request.properties().values(), (Matcher)JUnitMatchers.hasItems((Object[])new Property[]{this.validProperty1, this.validProperty2}));
    }

    @Test
    public void shouldConsiderEqualTwoRequestsWithSameLocationsAndSameProperties() {
        this.request = new UpdatePropertiesRequest(this.validPathLocation1, new String(this.workspace1), this.validProperties);
        UpdatePropertiesRequest request2 = new UpdatePropertiesRequest(this.validPathLocation1, this.workspace1, this.validProperties);
        Assert.assertThat((Object)this.request, (Matcher)Is.is((Object)request2));
    }

    @Test
    public void shouldConsiderNotEqualTwoRequestsWithDifferentLocations() {
        this.request = new UpdatePropertiesRequest(this.validPathLocation1, this.workspace1, this.validProperties);
        UpdatePropertiesRequest request2 = new UpdatePropertiesRequest(this.validPathLocation2, this.workspace1, this.validProperties);
        Assert.assertThat((Object)this.request.equals((Object)request2), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldConsiderNotEqualTwoRequestsWithDifferentWorkspaceNames() {
        this.request = new UpdatePropertiesRequest(this.validPathLocation1, this.workspace1, this.validProperties);
        UpdatePropertiesRequest request2 = new UpdatePropertiesRequest(this.validPathLocation1, this.workspace2, this.validProperties);
        Assert.assertThat((Object)this.request.equals((Object)request2), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldConsiderNotEqualTwoRequestsWithSameLocationButDifferentProperties() {
        this.request = new UpdatePropertiesRequest(this.validPathLocation1, this.workspace1, this.validProperties);
        Map<Name, Property> otherValidProperties = Collections.singletonMap(this.validProperty1.getName(), this.validProperty1);
        UpdatePropertiesRequest request2 = new UpdatePropertiesRequest(this.validPathLocation2, this.workspace1, otherValidProperties);
        Assert.assertThat((Object)this.request.equals((Object)request2), (Matcher)Is.is((Object)false));
    }
}

