/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.sequencer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import net.jcip.annotations.NotThreadSafe;
import org.modeshape.common.SystemFailureException;
import org.modeshape.common.util.StringUtil;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.sequencer.SequencerOutput;
import org.modeshape.graph.sequencer.StreamSequencerContext;

@NotThreadSafe
public class MockSequencerOutput
implements SequencerOutput,
Iterable<Path> {
    private final Map<Path, Map<Name, Property>> propertiesByPath;
    private final StreamSequencerContext context;
    private final LinkedList<Path> nodePathsInCreationOrder;

    public MockSequencerOutput(StreamSequencerContext context) {
        this(context, false);
    }

    public MockSequencerOutput(StreamSequencerContext context, boolean recordOrderOfNodeCreation) {
        this.context = context;
        this.propertiesByPath = new HashMap<Path, Map<Name, Property>>();
        this.nodePathsInCreationOrder = recordOrderOfNodeCreation ? new LinkedList() : null;
    }

    public void setProperty(Path nodePath, Name propertyName, Object ... values) {
        Map<Name, Property> properties = this.propertiesByPath.get(nodePath);
        if (values == null || values.length == 0 || values.length == 1 && values[0] == null) {
            if (properties != null) {
                properties.remove(propertyName);
                if (properties.isEmpty()) {
                    this.propertiesByPath.remove(nodePath);
                    if (this.nodePathsInCreationOrder != null) {
                        this.nodePathsInCreationOrder.remove(nodePath);
                    }
                }
            }
        } else {
            if (properties == null) {
                properties = new HashMap<Name, Property>();
                this.propertiesByPath.put(nodePath, properties);
                if (this.nodePathsInCreationOrder != null) {
                    this.nodePathsInCreationOrder.add(nodePath);
                }
            }
            for (Object value : values) {
                if (value instanceof Property || value instanceof Iterator) {
                    SystemFailureException t = new SystemFailureException("Value of property is another property object");
                    t.printStackTrace();
                    throw t;
                }
                if (!(value instanceof Object[])) continue;
                for (Object nestedValue : (Object[])value) {
                    if (!(nestedValue instanceof Property) && !(value instanceof Iterator)) continue;
                    SystemFailureException t = new SystemFailureException("Value of property is another property object");
                    t.printStackTrace();
                    throw t;
                }
            }
            Property property = this.context.getPropertyFactory().create(propertyName, values);
            properties.put(propertyName, property);
        }
    }

    public void setProperty(String nodePath, String propertyName, Object ... values) {
        Path path = (Path)this.context.getValueFactories().getPathFactory().create(nodePath);
        Name name = (Name)this.context.getValueFactories().getNameFactory().create(propertyName);
        this.setProperty(path, name, values);
    }

    public void setReference(String nodePath, String propertyName, String ... paths) {
        PathFactory pathFactory = this.context.getValueFactories().getPathFactory();
        Path path = (Path)pathFactory.create(nodePath);
        Name name = (Name)this.context.getValueFactories().getNameFactory().create(propertyName);
        Path[] values = null;
        if (paths != null && paths.length != 0) {
            values = new Path[paths.length];
            int len = paths.length;
            for (int i = 0; i != len; ++i) {
                String pathValue = paths[i];
                values[i] = pathFactory.create(pathValue);
            }
        }
        this.setProperty(path, name, values);
    }

    public LinkedList<Path> getOrderOfCreation() {
        return this.nodePathsInCreationOrder;
    }

    public boolean exists(Path nodePath) {
        return this.propertiesByPath.containsKey(nodePath);
    }

    @Override
    public Iterator<Path> iterator() {
        if (this.nodePathsInCreationOrder != null) {
            return this.nodePathsInCreationOrder.iterator();
        }
        LinkedList<Path> paths = new LinkedList<Path>(this.propertiesByPath.keySet());
        Collections.sort(paths);
        return paths.iterator();
    }

    public Map<Name, Property> getProperties(Path nodePath) {
        Map<Name, Property> properties = this.propertiesByPath.get(nodePath);
        if (properties == null) {
            return null;
        }
        return Collections.unmodifiableMap(properties);
    }

    public Property getProperty(String nodePath, String propertyName) {
        Path path = (Path)this.context.getValueFactories().getPathFactory().create(nodePath);
        Name name = (Name)this.context.getValueFactories().getNameFactory().create(propertyName);
        return this.getProperty(path, name);
    }

    public Property getProperty(Path nodePath, Name propertyName) {
        Map<Name, Property> properties = this.propertiesByPath.get(nodePath);
        if (properties == null) {
            return null;
        }
        return properties.get(propertyName);
    }

    public Object[] getPropertyValues(String nodePath, String propertyName) {
        Path path = (Path)this.context.getValueFactories().getPathFactory().create(nodePath);
        return this.getPropertyValues(path, propertyName);
    }

    public Object[] getPropertyValues(Path path, String propertyName) {
        Name name = (Name)this.context.getValueFactories().getNameFactory().create(propertyName);
        Property prop = this.getProperty(path, name);
        if (prop != null) {
            return prop.getValuesAsArray();
        }
        return null;
    }

    public boolean hasProperty(String nodePath, String property) {
        return this.getProperty(nodePath, property) != null;
    }

    public boolean hasProperties() {
        return this.propertiesByPath.size() > 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Path path : this) {
            Property uuid;
            Property mixinTypes;
            if (path == null) continue;
            if (!path.isRoot()) {
                sb.append(StringUtil.createString((char)' ', (int)(path.size() * 2)));
                sb.append(path.getLastSegment().getString(this.context.getNamespaceRegistry()));
            } else {
                sb.append("/");
            }
            Property primaryType = this.getProperty(path, JcrLexicon.PRIMARY_TYPE);
            if (primaryType != null) {
                sb.append(" " + primaryType.getString(this.context.getNamespaceRegistry()));
            }
            if ((mixinTypes = this.getProperty(path, JcrLexicon.MIXIN_TYPES)) != null) {
                sb.append(" " + mixinTypes.getString(this.context.getNamespaceRegistry()));
            }
            if ((uuid = this.getProperty(path, JcrLexicon.UUID)) != null) {
                sb.append(" " + uuid.getString(this.context.getNamespaceRegistry()));
            }
            sb.append("\n");
            ArrayList<Property> props = new ArrayList<Property>(this.getProperties(path).values());
            Collections.sort(props);
            for (Property property : props) {
                if (property.equals(primaryType) || property.equals(mixinTypes) || property.equals(uuid)) continue;
                sb.append(StringUtil.createString((char)' ', (int)(path.size() * 2))).append("  - ");
                sb.append(property.getString(this.context.getNamespaceRegistry()));
                sb.append("\n");
            }
        }
        return sb.toString();
    }
}

