/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.map;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.connector.map.MapNode;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.PropertyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMapNode
implements MapNode {
    private final UUID uuid;
    private MapNode parent;
    private Path.Segment name;
    private final Map<Name, Property> properties = new HashMap<Name, Property>();
    private final LinkedList<MapNode> children = new LinkedList();
    final Set<Name> existingNames = new HashSet<Name>();

    public DefaultMapNode(UUID uuid) {
        assert (uuid != null);
        this.uuid = uuid;
    }

    @Override
    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    public Path.Segment getName() {
        return this.name;
    }

    @Override
    public void setName(Path.Segment name) {
        this.name = name;
    }

    @Override
    public Set<Name> getUniqueChildNames() {
        return this.existingNames;
    }

    @Override
    public MapNode getParent() {
        return this.parent;
    }

    @Override
    public void setParent(MapNode parent) {
        this.parent = parent;
    }

    public LinkedList<MapNode> getChildren() {
        return this.children;
    }

    @Override
    public Map<Name, Property> getProperties() {
        return this.properties;
    }

    @Override
    public void addChild(int index, MapNode child) {
        this.children.add(index, child);
    }

    @Override
    public void addChild(MapNode child) {
        this.children.add(child);
    }

    @Override
    public void clearChildren() {
        this.children.clear();
    }

    @Override
    public boolean removeChild(MapNode child) {
        return this.children.remove(child);
    }

    @Override
    public MapNode removeProperty(Name propertyName) {
        this.properties.remove(propertyName);
        return this;
    }

    @Override
    public MapNode setProperties(Iterable<Property> properties) {
        for (Property property : properties) {
            this.properties.put(property.getName(), property);
        }
        return this;
    }

    @Override
    public MapNode setProperty(Property property) {
        if (property != null) {
            this.properties.put(property.getName(), property);
        }
        return this;
    }

    @Override
    public MapNode setProperty(ExecutionContext context, String name, Object ... values) {
        PropertyFactory propertyFactory = context.getPropertyFactory();
        Name propertyName = (Name)context.getValueFactories().getNameFactory().create(name);
        return this.setProperty(propertyFactory.create(propertyName, values));
    }

    @Override
    public Property getProperty(ExecutionContext context, String name) {
        Name propertyName = (Name)context.getValueFactories().getNameFactory().create(name);
        return this.getProperty(propertyName);
    }

    @Override
    public Property getProperty(Name name) {
        return this.properties.get(name);
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof MapNode) {
            MapNode that = (MapNode)obj;
            return this.getUuid().equals(that.getUuid());
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.name == null) {
            sb.append("");
        } else {
            sb.append(this.name);
        }
        sb.append(" (").append(this.uuid).append(")");
        return sb.toString();
    }
}

