/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.io;

import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.NodeConflictBehavior;
import org.modeshape.graph.io.Destination;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class GraphBatchDestination
implements Destination {
    protected final Graph.Batch batch;
    protected final boolean ignoreSubmit;

    public GraphBatchDestination(Graph.Batch batch) {
        this(batch, false);
    }

    public GraphBatchDestination(Graph.Batch batch, boolean ignoreSubmit) {
        assert (batch != null);
        this.batch = batch;
        this.ignoreSubmit = ignoreSubmit;
    }

    public boolean isSubmitIgnored() {
        return this.ignoreSubmit;
    }

    @Override
    public ExecutionContext getExecutionContext() {
        return this.batch.getGraph().getContext();
    }

    @Override
    public void create(Path path, Iterable<Property> properties) {
        assert (properties != null);
        Graph.Create<Graph.Batch> create = this.batch.create(path, properties);
        assert (create != null);
        NodeConflictBehavior behavior = this.createBehaviorFor(path);
        if (behavior != null) {
            switch (behavior) {
                case APPEND: {
                    create.byAppending();
                    break;
                }
                case REPLACE: {
                    create.orReplace();
                    break;
                }
                case UPDATE: {
                    create.orUpdate();
                    break;
                }
                case DO_NOT_REPLACE: {
                    create.ifAbsent();
                }
            }
        }
        create.and();
    }

    @Override
    public void create(Path path, Property firstProperty, Property ... additionalProperties) {
        this.create(this.createBehaviorFor(path), path, firstProperty, additionalProperties);
    }

    @Override
    public void create(NodeConflictBehavior behavior, Path path, Property firstProperty, Property ... additionalProperties) {
        if (behavior == null) {
            behavior = this.createBehaviorFor(path);
        }
        Graph.Create<Graph.Batch> create = null;
        create = firstProperty == null ? this.batch.create(path) : this.batch.create(path, firstProperty, additionalProperties);
        assert (create != null);
        if (behavior != null) {
            switch (behavior) {
                case APPEND: {
                    create.byAppending();
                    break;
                }
                case REPLACE: {
                    create.orReplace();
                    break;
                }
                case UPDATE: {
                    create.orUpdate();
                    break;
                }
                case DO_NOT_REPLACE: {
                    create.ifAbsent();
                }
            }
        }
        create.and();
    }

    @Override
    public void setProperties(Path path, Property ... properties) {
        if (properties == null) {
            return;
        }
        this.batch.set(properties).on(path);
    }

    @Override
    public void setProperties(Path path, Iterable<Property> properties) {
        if (properties == null) {
            return;
        }
        this.batch.set(properties).on(path);
    }

    @Override
    public void submit() {
        if (!this.ignoreSubmit && !this.batch.hasExecuted()) {
            this.batch.execute();
        }
    }

    protected NodeConflictBehavior createBehaviorFor(Path path) {
        return null;
    }
}

