/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.property.basic;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.property.basic.AbstractBinary;

@Immutable
public class InMemoryBinary
extends AbstractBinary {
    private static final long serialVersionUID = 2L;
    private final byte[] bytes;
    private byte[] sha1hash;
    private int hc;

    public InMemoryBinary(byte[] bytes) {
        CheckArg.isNotNull(bytes, "bytes");
        this.bytes = bytes;
    }

    public int hashCode() {
        if (this.sha1hash == null) {
            this.sha1hash = this.computeHash(this.bytes);
            this.hc = this.sha1hash.hashCode();
        }
        return this.hc;
    }

    public long getSize() {
        return this.bytes.length;
    }

    public byte[] getHash() {
        if (this.sha1hash == null) {
            this.sha1hash = this.computeHash(this.bytes);
            this.hc = this.sha1hash.hashCode();
        }
        return this.sha1hash;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public InputStream getStream() {
        return new ByteArrayInputStream(this.bytes);
    }

    public void acquire() {
    }

    public void release() {
    }
}

