/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.model;

import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.HashCode;
import org.modeshape.graph.query.model.JoinCondition;
import org.modeshape.graph.query.model.SelectorName;
import org.modeshape.graph.query.model.Visitor;
import org.modeshape.graph.query.model.Visitors;

@Immutable
public class ChildNodeJoinCondition
implements JoinCondition {
    private static final long serialVersionUID = 1L;
    private final SelectorName childSelectorName;
    private final SelectorName parentSelectorName;
    private final int hc;

    public ChildNodeJoinCondition(SelectorName parentSelectorName, SelectorName childSelectorName) {
        CheckArg.isNotNull(childSelectorName, "childSelectorName");
        CheckArg.isNotNull(parentSelectorName, "parentSelectorName");
        this.childSelectorName = childSelectorName;
        this.parentSelectorName = parentSelectorName;
        this.hc = HashCode.compute(this.childSelectorName, this.parentSelectorName);
    }

    public final SelectorName childSelectorName() {
        return this.childSelectorName;
    }

    public final SelectorName parentSelectorName() {
        return this.parentSelectorName;
    }

    public String toString() {
        return Visitors.readable(this);
    }

    public int hashCode() {
        return this.hc;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ChildNodeJoinCondition) {
            ChildNodeJoinCondition that = (ChildNodeJoinCondition)obj;
            if (this.hc != that.hc) {
                return false;
            }
            if (!this.childSelectorName.equals(that.childSelectorName)) {
                return false;
            }
            return this.parentSelectorName.equals(that.parentSelectorName);
        }
        return false;
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

