/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.parse;

import java.util.ArrayList;
import java.util.Iterator;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.text.ParsingException;
import org.modeshape.graph.query.model.FullTextSearch;
import org.modeshape.graph.query.parse.FullTextSearchParser;

public class FullTextSearchParserTest {
    private FullTextSearchParser parser;

    @Before
    public void beforeEach() {
        this.parser = new FullTextSearchParser();
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailToParseNullString() {
        this.parser.parse((String)null);
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseEmptyString() {
        this.parser.parse("");
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseBlankString() {
        this.parser.parse("   ");
    }

    @Test
    public void shouldParseStringWithOneUnquotedTerm() {
        FullTextSearch.Term result = this.parser.parse("term1");
        FullTextSearchParserTest.assertSimpleTerm(result, "term1", false, false);
    }

    @Test
    public void shouldParseStringWithOneSingleQuotedTermWithOneWord() {
        FullTextSearch.Term result = this.parser.parse("'term1'");
        FullTextSearchParserTest.assertSimpleTerm(result, "term1", false, false);
    }

    @Test
    public void shouldParseStringWithOneSingleQuotedTermWithMultipleWords() {
        FullTextSearch.Term result = this.parser.parse("'term1 has two words'");
        FullTextSearchParserTest.assertSimpleTerm(result, "term1 has two words", false, true);
    }

    @Test
    public void shouldParseStringWithOneDoubleQuotedTermWithOneWord() {
        FullTextSearch.Term result = this.parser.parse("\"term1\"");
        FullTextSearchParserTest.assertSimpleTerm(result, "term1", false, false);
    }

    @Test
    public void shouldParseStringWithOneDoubleQuotedTermWithMultipleWords() {
        FullTextSearch.Term result = this.parser.parse("\"term1 has two words\"");
        FullTextSearchParserTest.assertSimpleTerm(result, "term1 has two words", false, true);
    }

    @Test
    public void shouldParseStringWithMultipleUnquotedTerms() {
        FullTextSearch.Term result = this.parser.parse("term1 term2 term3");
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(FullTextSearch.Conjunction.class)));
        FullTextSearch.Conjunction conjunction = (FullTextSearch.Conjunction)result;
        FullTextSearchParserTest.assertHasSimpleTerms((FullTextSearch.CompoundTerm)conjunction, "term1", "term2", "term3");
    }

    @Test
    public void shouldParseStringWithMultipleUnquotedTermsWithNegatedTerms() {
        FullTextSearch.Term result = this.parser.parse("term1 term2 -term3");
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(FullTextSearch.Conjunction.class)));
        FullTextSearch.Conjunction conjunction = (FullTextSearch.Conjunction)result;
        FullTextSearchParserTest.assertHasSimpleTerms((FullTextSearch.CompoundTerm)conjunction, "term1", "term2", "-term3");
    }

    @Test
    public void shouldParseStringWithMultipleQuotedAndUnquotedTermsWithNegatedTerms() {
        FullTextSearch.Term result = this.parser.parse("term1 \"term2 and 2a\" -term3 -'term 4'");
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(FullTextSearch.Conjunction.class)));
        FullTextSearch.Conjunction conjunction = (FullTextSearch.Conjunction)result;
        FullTextSearchParserTest.assertHasSimpleTerms((FullTextSearch.CompoundTerm)conjunction, "term1", "term2 and 2a", "-term3", "-term 4");
    }

    @Test
    public void shouldParseStringWithMultipleUnquotedORedTerms() {
        FullTextSearch.Term result = this.parser.parse("term1 OR term2 OR term3");
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(FullTextSearch.Disjunction.class)));
        FullTextSearch.Disjunction disjunction = (FullTextSearch.Disjunction)result;
        FullTextSearchParserTest.assertHasSimpleTerms((FullTextSearch.CompoundTerm)disjunction, "term1", "term2", "term3");
    }

    @Test
    public void shouldParseStringWithMultipleUnquotedORedTermsWithNegatedTerms() {
        FullTextSearch.Term result = this.parser.parse("term1 OR term2 OR -term3");
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(FullTextSearch.Disjunction.class)));
        FullTextSearch.Disjunction disjunction = (FullTextSearch.Disjunction)result;
        FullTextSearchParserTest.assertHasSimpleTerms((FullTextSearch.CompoundTerm)disjunction, "term1", "term2", "-term3");
    }

    @Test
    public void shouldParseStringWithMultipleUnquotedANDedTermsORedTogether() {
        FullTextSearch.Term result = this.parser.parse("term1 term2 OR -term3 -term4");
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(FullTextSearch.Disjunction.class)));
        FullTextSearch.Disjunction disjunction = (FullTextSearch.Disjunction)result;
        Assert.assertThat((Object)disjunction.getTerms().size(), (Matcher)Is.is((Object)2));
        FullTextSearch.Conjunction conjunction1 = (FullTextSearch.Conjunction)disjunction.getTerms().get(0);
        FullTextSearch.Conjunction conjunction2 = (FullTextSearch.Conjunction)disjunction.getTerms().get(1);
        FullTextSearchParserTest.assertHasSimpleTerms((FullTextSearch.CompoundTerm)conjunction1, "term1", "term2");
        FullTextSearchParserTest.assertHasSimpleTerms((FullTextSearch.CompoundTerm)conjunction2, "-term3", "term4");
    }

    @Test
    public void shouldParseStringWithTwoANDedUnquotedTermsORedWithMultipleUnquotedTerms() {
        FullTextSearch.Term result = this.parser.parse("term1 term2 OR -term3 OR -term4 OR term5");
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(FullTextSearch.Disjunction.class)));
        FullTextSearch.Disjunction disjunction = (FullTextSearch.Disjunction)result;
        Assert.assertThat((Object)disjunction.getTerms().size(), (Matcher)Is.is((Object)4));
        FullTextSearch.Conjunction conjunction1 = (FullTextSearch.Conjunction)disjunction.getTerms().get(0);
        FullTextSearch.Term term3 = (FullTextSearch.Term)disjunction.getTerms().get(1);
        FullTextSearch.Term term4 = (FullTextSearch.Term)disjunction.getTerms().get(2);
        FullTextSearch.Term term5 = (FullTextSearch.Term)disjunction.getTerms().get(3);
        FullTextSearchParserTest.assertHasSimpleTerms((FullTextSearch.CompoundTerm)conjunction1, "term1", "term2");
        FullTextSearchParserTest.assertSimpleTerm(term3, "term3", true, false);
        FullTextSearchParserTest.assertSimpleTerm(term4, "term4", true, false);
        FullTextSearchParserTest.assertSimpleTerm(term5, "term5", false, false);
    }

    @Test
    public void shouldParseStringWithWildcardCharactersAtEndOfSingleTerm() {
        FullTextSearch.Term result = this.parser.parse("term*");
        FullTextSearchParserTest.assertSimpleTerm(result, "term*", false, false);
    }

    @Test
    public void shouldParseStringWithWildcardCharactersAtBeginningOfSingleTerm() {
        FullTextSearch.Term result = this.parser.parse("*term");
        FullTextSearchParserTest.assertSimpleTerm(result, "*term", false, false);
    }

    @Test
    public void shouldParseStringWithWildcardCharactersInsideSingleTerm() {
        FullTextSearch.Term result = this.parser.parse("te*rm");
        FullTextSearchParserTest.assertSimpleTerm(result, "te*rm", false, false);
    }

    @Test
    public void shouldParseStringWithWildcardCharactersInMultipleTerms() {
        FullTextSearch.Term result = this.parser.parse("term* term? *term*");
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(FullTextSearch.Conjunction.class)));
        FullTextSearch.Conjunction conjunction = (FullTextSearch.Conjunction)result;
        FullTextSearchParserTest.assertHasSimpleTerms((FullTextSearch.CompoundTerm)conjunction, "term*", "term?", "*term*");
    }

    @Test
    public void shouldParseStringWithWildcardCharactersInSingleQuotedTerm() {
        FullTextSearch.Term result = this.parser.parse("'term* term? *term*'");
        FullTextSearchParserTest.assertSimpleTerm(result, "term* term? *term*", false, true);
    }

    @Test
    public void shouldParseStringWithSqlStyleWildcardCharactersInMultipleTerms() {
        FullTextSearch.Term result = this.parser.parse("term% term_ %term_");
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(FullTextSearch.Conjunction.class)));
        FullTextSearch.Conjunction conjunction = (FullTextSearch.Conjunction)result;
        FullTextSearchParserTest.assertHasSimpleTerms((FullTextSearch.CompoundTerm)conjunction, "term%", "term_", "%term_");
    }

    @Test
    public void shouldParseStringWithSqlStyleWildcardCharactersInSingleQuotedTerm() {
        FullTextSearch.Term result = this.parser.parse("'term% term_ %term_'");
        FullTextSearchParserTest.assertSimpleTerm(result, "term% term_ %term_", false, true);
    }

    @Test
    public void shouldParseStringWithEscapedWildcardCharacterInSingleTerm() {
        FullTextSearch.Term result = this.parser.parse("term\\*");
        FullTextSearchParserTest.assertSimpleTerm(result, "term\\*", false, false);
    }

    public static void assertHasSimpleTerms(FullTextSearch.CompoundTerm compoundTerm, String ... terms) {
        ArrayList<Object> expectedTerms = new ArrayList<Object>();
        for (String term : terms) {
            if (term.startsWith("-")) {
                term = term.substring(1);
                expectedTerms.add(new FullTextSearch.NegationTerm((FullTextSearch.Term)new FullTextSearch.SimpleTerm(term)));
                continue;
            }
            expectedTerms.add(new FullTextSearch.SimpleTerm(term));
        }
        FullTextSearchParserTest.assertHasTerms(compoundTerm, expectedTerms.toArray(new FullTextSearch.Term[expectedTerms.size()]));
    }

    public static void assertSimpleTerm(FullTextSearch.Term term, String value, boolean excluded, boolean quotingRequired) {
        Assert.assertThat((Object)term, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        if (excluded) {
            Assert.assertThat((Object)term, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(FullTextSearch.NegationTerm.class)));
            FullTextSearch.NegationTerm negationTerm = (FullTextSearch.NegationTerm)term;
            FullTextSearch.Term negated = negationTerm.getNegatedTerm();
            Assert.assertThat((Object)negated, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(FullTextSearch.SimpleTerm.class)));
            FullTextSearch.SimpleTerm simpleTerm = (FullTextSearch.SimpleTerm)negated;
            Assert.assertThat((Object)simpleTerm.getValue(), (Matcher)Is.is((Object)value));
            Assert.assertThat((Object)simpleTerm.isQuotingRequired(), (Matcher)Is.is((Object)quotingRequired));
        } else {
            Assert.assertThat((Object)term, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(FullTextSearch.SimpleTerm.class)));
            FullTextSearch.SimpleTerm simpleTerm = (FullTextSearch.SimpleTerm)term;
            Assert.assertThat((Object)simpleTerm.getValue(), (Matcher)Is.is((Object)value));
            Assert.assertThat((Object)simpleTerm.isQuotingRequired(), (Matcher)Is.is((Object)quotingRequired));
        }
    }

    public static void assertHasTerms(FullTextSearch.CompoundTerm compoundTerm, FullTextSearch.Term ... terms) {
        Iterator iterator = compoundTerm.iterator();
        for (int i = 0; i != 0; ++i) {
            FullTextSearch.Term expected = terms[i];
            Assert.assertThat((Object)iterator.hasNext(), (Matcher)Is.is((Object)true));
            FullTextSearch.Term term = (FullTextSearch.Term)iterator.next();
            Assert.assertThat((Object)term, (Matcher)Is.is((Object)expected));
        }
    }
}

