/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.base;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.naming.BinaryRefAddr;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.modeshape.common.annotation.Category;
import org.modeshape.common.annotation.Description;
import org.modeshape.common.annotation.Label;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.cache.CachePolicy;
import org.modeshape.graph.connector.RepositoryContext;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.connector.base.BaseRepositorySource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRepositorySource
implements BaseRepositorySource {
    public static final String DEFAULT_ROOT_NODE_UUID = "cafebabe-cafe-babe-cafe-babecafebabe";
    public static final int DEFAULT_RETRY_LIMIT = 0;
    public static final CachePolicy DEFAULT_CACHE_POLICY = null;
    @Description(i18n=GraphI18n.class, value="retryLimitPropertyDescription")
    @Label(i18n=GraphI18n.class, value="retryLimitPropertyLabel")
    @Category(i18n=GraphI18n.class, value="retryLimitPropertyCategory")
    protected int retryLimit = 0;
    @Description(i18n=GraphI18n.class, value="namePropertyDescription")
    @Label(i18n=GraphI18n.class, value="namePropertyLabel")
    @Category(i18n=GraphI18n.class, value="namePropertyCategory")
    private volatile String name;
    @Description(i18n=GraphI18n.class, value="rootNodeUuidWithDefaultPropertyDescription")
    @Label(i18n=GraphI18n.class, value="rootNodeUuidPropertyLabel")
    @Category(i18n=GraphI18n.class, value="rootNodeUuidPropertyCategory")
    protected transient UUID rootNodeUuid = UUID.fromString("cafebabe-cafe-babe-cafe-babecafebabe");
    protected transient RepositoryContext repositoryContext;
    protected transient CachePolicy cachePolicy = DEFAULT_CACHE_POLICY;

    @Override
    public boolean areUpdatesAllowed() {
        return false;
    }

    @Override
    public RepositoryContext getRepositoryContext() {
        return this.repositoryContext;
    }

    @Override
    public void initialize(RepositoryContext context) throws RepositorySourceException {
        CheckArg.isNotNull((Object)context, (String)"context");
        this.repositoryContext = context;
    }

    @Override
    public CachePolicy getDefaultCachePolicy() {
        return this.cachePolicy;
    }

    public void setCachePolicy(CachePolicy cachePolicy) {
        CheckArg.isNotNull((Object)cachePolicy, (String)"cachePolicy");
        this.cachePolicy = cachePolicy;
    }

    @Override
    public UUID getRootNodeUuidObject() {
        return this.rootNodeUuid;
    }

    public void setRootNodeUuidObject(String rootNodeUuid) {
        if (rootNodeUuid != null && rootNodeUuid.trim().length() == 0) {
            rootNodeUuid = DEFAULT_ROOT_NODE_UUID;
        }
        this.rootNodeUuid = UUID.fromString(rootNodeUuid);
    }

    public String getRootNodeUuid() {
        return this.rootNodeUuid.toString();
    }

    public synchronized void setRootNodeUuid(String rootNodeUuid) {
        UUID uuid = null;
        uuid = rootNodeUuid == null ? UUID.randomUUID() : UUID.fromString(rootNodeUuid);
        if (this.rootNodeUuid.equals(uuid)) {
            return;
        }
        this.rootNodeUuid = uuid;
    }

    @Override
    public void close() {
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name != null && (name = name.trim()).length() == 0) {
            name = null;
        }
        this.name = name;
    }

    @Override
    public int getRetryLimit() {
        return this.retryLimit;
    }

    @Override
    public void setRetryLimit(int limit) {
        this.retryLimit = limit < 0 ? 0 : limit;
    }

    protected Map<String, Object> valuesFrom(Reference ref) throws IOException, ClassNotFoundException {
        HashMap<String, Object> values = new HashMap<String, Object>();
        Enumeration<RefAddr> en = ref.getAll();
        while (en.hasMoreElements()) {
            Object value;
            String key;
            RefAddr subref = en.nextElement();
            if (subref instanceof StringRefAddr) {
                key = subref.getType();
                value = subref.getContent();
                if (value == null) continue;
                values.put(key, value.toString());
                continue;
            }
            if (!(subref instanceof BinaryRefAddr)) continue;
            key = subref.getType();
            value = subref.getContent();
            if (!(value instanceof byte[])) continue;
            ByteArrayInputStream bais = new ByteArrayInputStream((byte[])value);
            ObjectInputStream ois = new ObjectInputStream(bais);
            value = ois.readObject();
            values.put(key, value);
        }
        return values;
    }
}

