/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;
import java.util.UUID;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.util.StringUtil;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.Location;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.connector.UuidAlreadyExistsException;
import org.modeshape.graph.connector.base.BaseTransaction;
import org.modeshape.graph.connector.base.MapNode;
import org.modeshape.graph.connector.base.MapWorkspace;
import org.modeshape.graph.connector.base.Repository;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathNotFoundException;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.PropertyType;
import org.modeshape.graph.property.ReferenceFactory;
import org.modeshape.graph.property.UuidFactory;
import org.modeshape.graph.query.QueryResults;
import org.modeshape.graph.request.AccessQueryRequest;
import org.modeshape.graph.request.FullTextSearchRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public abstract class MapTransaction<NodeType extends MapNode, WorkspaceType extends MapWorkspace<NodeType>>
extends BaseTransaction<NodeType, WorkspaceType> {
    private Map<String, WorkspaceChanges> changesByWorkspaceName;
    private Map<WorkspaceType, Map<UUID, NodeType>> nodesByWorkspaceName;

    protected MapTransaction(ExecutionContext context, Repository<NodeType, WorkspaceType> repository, UUID rootNodeUuid) {
        super(context, repository, rootNodeUuid);
    }

    protected WorkspaceChanges getChangesFor(WorkspaceType workspace, boolean createIfMissing) {
        if (this.changesByWorkspaceName == null) {
            if (!createIfMissing) {
                return null;
            }
            WorkspaceChanges changes = new WorkspaceChanges(this, workspace);
            this.changesByWorkspaceName = new HashMap<String, WorkspaceChanges>();
            this.changesByWorkspaceName.put(((MapWorkspace)workspace).getName(), changes);
            return changes;
        }
        WorkspaceChanges changes = this.changesByWorkspaceName.get(((MapWorkspace)workspace).getName());
        if (changes == null && createIfMissing) {
            changes = new WorkspaceChanges(this, workspace);
            this.changesByWorkspaceName.put(((MapWorkspace)workspace).getName(), changes);
        }
        return changes;
    }

    protected Map<UUID, NodeType> getCachedNodesfor(WorkspaceType workspace) {
        Map<UUID, NodeType> cachedNodes;
        if (this.nodesByWorkspaceName == null) {
            this.nodesByWorkspaceName = new HashMap<WorkspaceType, Map<UUID, NodeType>>();
        }
        if ((cachedNodes = this.nodesByWorkspaceName.get(workspace)) == null) {
            cachedNodes = new HashMap<UUID, NodeType>();
            this.nodesByWorkspaceName.put(workspace, cachedNodes);
        }
        return cachedNodes;
    }

    private NodeType getNode(WorkspaceType workspace, UUID uuid) {
        Map<UUID, NodeType> cachedNodes = this.getCachedNodesfor(workspace);
        MapNode cachedNode = (MapNode)cachedNodes.get(uuid);
        if (cachedNode == null) {
            cachedNode = ((MapWorkspace)workspace).getNode(uuid);
            cachedNodes.put(uuid, cachedNode);
        }
        return (NodeType)cachedNode;
    }

    @Override
    public NodeType getNode(WorkspaceType workspace, Location location) {
        assert (location != null);
        UUID uuid = location.getUuid();
        if (uuid != null) {
            WorkspaceChanges changes = this.getChangesFor(workspace, false);
            NodeType node = null;
            if (changes != null) {
                if (changes.isRemoved(uuid)) {
                    Path lowestExisting = null;
                    if (location.hasPath()) {
                        this.getNode(workspace, location.getPath(), location);
                        assert (false);
                    }
                    lowestExisting = this.pathFactory.createRootPath();
                    throw new PathNotFoundException(location, lowestExisting, GraphI18n.nodeDoesNotExist.text(new Object[]{this.readable(location)}));
                }
                node = changes.getChangedOrAdded(uuid);
                if (node != null) {
                    return node;
                }
            }
            if ((node = (NodeType)this.getNode(workspace, uuid)) != null) {
                return node;
            }
        }
        if (location.hasPath()) {
            return (NodeType)((MapNode)this.getNode(workspace, location.getPath(), location));
        }
        Path lowestExisting = this.pathFactory.createRootPath();
        throw new PathNotFoundException(location, lowestExisting, GraphI18n.nodeDoesNotExist.text(new Object[]{this.readable(location)}));
    }

    @Override
    public Location verifyNodeExists(WorkspaceType workspace, Location location) {
        NodeType node = this.getNode(workspace, location);
        if (location.hasPath() && location.getUuid() != null) {
            return location;
        }
        if (location.hasPath()) {
            if (location.getUuid() != null) {
                return location;
            }
            return location.with(((MapNode)node).getUuid());
        }
        Path path = this.pathFor(workspace, node);
        return location.with(path);
    }

    protected NodeType findLatest(WorkspaceType workspace, NodeType node) {
        if (((MapNode)node).hasChanges()) {
            return node;
        }
        return this.findNode(workspace, ((MapNode)node).getUuid());
    }

    protected NodeType findNode(WorkspaceType workspace, UUID uuid) {
        WorkspaceChanges changes = this.getChangesFor(workspace, false);
        NodeType node = null;
        if (changes != null) {
            if (changes.isRemoved(uuid)) {
                return null;
            }
            node = changes.getChangedOrAdded(uuid);
            if (node != null) {
                return node;
            }
        }
        node = this.getNode(workspace, uuid);
        return node;
    }

    protected void destroyNode(WorkspaceType workspace, NodeType node) {
        WorkspaceChanges changes = this.getChangesFor(workspace, true);
        this.destroyNode(changes, workspace, node);
    }

    private void destroyNode(WorkspaceChanges changes, WorkspaceType workspace, NodeType node) {
        for (UUID childUuid : ((MapNode)node).getChildren()) {
            Object child = changes.getChangedOrAdded(childUuid);
            if (child == null) {
                child = this.getNode(workspace, childUuid);
            }
            this.destroyNode(changes, workspace, child);
        }
        UUID uuid = ((MapNode)node).getUuid();
        changes.removed(uuid);
    }

    @Override
    public NodeType addChild(WorkspaceType workspace, NodeType parent, Name name, int index, UUID uuid, Iterable<Property> properties) {
        if (uuid == null) {
            uuid = UUID.randomUUID();
        }
        parent = this.findLatest(workspace, parent);
        WorkspaceChanges changes = this.getChangesFor(workspace, true);
        NodeType newNode = null;
        if (index < 0) {
            int snsIndex = 1;
            for (MapNode child : this.getChildren(workspace, parent)) {
                if (!child.getName().getName().equals(name)) continue;
                ++snsIndex;
            }
            newNode = this.createNode(uuid, this.pathFactory.createSegment(name, snsIndex), ((MapNode)parent).getUuid(), properties);
            parent = ((MapNode)parent).withChild(uuid);
        } else {
            int snsIndex = 0;
            ListIterator<NodeType> existingSiblings = this.getChildren(workspace, parent).listIterator(index);
            while (existingSiblings.hasNext()) {
                MapNode existingSibling = (MapNode)existingSiblings.next();
                Path.Segment existingSegment = existingSibling.getName();
                if (!existingSegment.getName().equals(name)) continue;
                int existingIndex = existingSegment.getIndex();
                if (snsIndex == 0) {
                    snsIndex = existingIndex;
                }
                existingSibling = existingSibling.withName(this.pathFactory.createSegment(name, existingIndex + 1));
                changes.changed(existingSibling);
            }
            newNode = this.createNode(uuid, this.pathFactory.createSegment(name, snsIndex + 1), ((MapNode)parent).getUuid(), properties);
            parent = ((MapNode)parent).withChild(index, uuid);
        }
        changes.created(newNode);
        changes.changed(parent);
        return newNode;
    }

    @Override
    public Location addChild(WorkspaceType workspace, NodeType parent, NodeType newChild, NodeType beforeOtherChild, Name desiredName) {
        parent = this.findLatest(workspace, parent);
        Path.Segment newChildSegment = ((MapNode)newChild).getName();
        Name newChildName = newChildSegment.getName();
        int snsIndex = newChildSegment.getIndex();
        UUID newChildUuid = ((MapNode)newChild).getUuid();
        Object oldParent = this.getParent(workspace, newChild);
        WorkspaceChanges changes = this.getChangesFor(workspace, true);
        int oldIndex = -1;
        if (oldParent != null) {
            oldIndex = ((MapNode)oldParent).getChildren().indexOf(newChildUuid);
            if (oldParent == parent) {
                oldParent = ((MapNode)oldParent).withoutChild(newChildUuid);
                changes.changed(oldParent);
                parent = oldParent;
            } else {
                oldParent = ((MapNode)oldParent).withoutChild(newChildUuid);
                changes.changed(oldParent);
            }
            List<NodeType> siblings = this.getChildren(workspace, oldParent);
            ListIterator<NodeType> iter = siblings.listIterator(oldIndex);
            while (iter.hasNext()) {
                MapNode sibling = (MapNode)iter.next();
                if (!sibling.getName().getName().equals(newChildName)) continue;
                sibling = sibling.withName(this.pathFactory.createSegment(newChildName, snsIndex++));
                changes.changed(sibling);
            }
        }
        int index = ((MapNode)parent).getChildren().size();
        if (beforeOtherChild != null) {
            if (!((MapNode)beforeOtherChild).getParent().equals(((MapNode)parent).getUuid())) {
                throw new RepositorySourceException(null);
            }
            UUID otherChild = ((MapNode)beforeOtherChild).getUuid();
            index = ((MapNode)parent).getChildren().indexOf(otherChild);
            if (index == -1) {
                index = ((MapNode)parent).getChildren().size();
            }
        }
        assert (index >= 0);
        newChildName = desiredName != null ? desiredName : newChildName;
        ListIterator<NodeType> existingSiblings = this.getChildren(workspace, parent).listIterator();
        int i = 0;
        snsIndex = 1;
        Path.Segment childName = null;
        while (existingSiblings.hasNext()) {
            MapNode existingSibling = (MapNode)existingSiblings.next();
            Path.Segment existingSegment = existingSibling.getName();
            if (i < index) {
                if (existingSegment.getName().equals(newChildName)) {
                    ++snsIndex;
                }
            } else {
                if (i == index) {
                    childName = this.pathFactory.createSegment(newChildName, snsIndex);
                }
                if (existingSegment.getName().equals(newChildName)) {
                    existingSibling = existingSibling.withName(this.pathFactory.createSegment(newChildName, ++snsIndex));
                    changes.changed(existingSibling);
                }
            }
            ++i;
        }
        if (childName == null) {
            childName = this.pathFactory.createSegment(newChildName, snsIndex);
        }
        newChild = ((MapNode)newChild).withName(childName).withParent(((MapNode)parent).getUuid());
        parent = ((MapNode)parent).withChild(index, newChildUuid);
        changes.changed(newChild);
        changes.changed(parent);
        return Location.create(this.pathFor(workspace, newChild), newChildUuid);
    }

    protected NodeType createNode(UUID uuid, Path.Segment name, UUID parentUuid, Iterable<Property> properties) {
        return (NodeType)new MapNode(uuid, name, parentUuid, properties, null);
    }

    @Override
    public NodeType getChild(WorkspaceType workspace, NodeType parent, Path.Segment childSegment) {
        parent = this.findLatest(workspace, parent);
        Children children = new Children(this, ((MapNode)parent).getChildren(), workspace);
        for (MapNode child : children) {
            if (!child.getName().equals(childSegment)) continue;
            return (NodeType)child;
        }
        return null;
    }

    @Override
    public List<NodeType> getChildren(WorkspaceType workspace, NodeType node) {
        List<UUID> children = ((MapNode)(node = this.findLatest(workspace, node))).getChildren();
        if (children.isEmpty()) {
            return Collections.emptyList();
        }
        return new Children(this, children, workspace);
    }

    @Override
    public List<Location> getChildrenLocations(WorkspaceType workspace, NodeType node) {
        List<UUID> children = ((MapNode)(node = this.findLatest(workspace, node))).getChildren();
        if (children.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Location> locations = new ArrayList<Location>(children.size());
        for (UUID uuid : children) {
            NodeType child = this.findNode(workspace, uuid);
            locations.add(Location.create(this.pathFor(workspace, child), uuid));
        }
        return locations;
    }

    @Override
    public NodeType getParent(WorkspaceType workspace, NodeType node) {
        UUID parentUuid = ((MapNode)(node = this.findLatest(workspace, node))).getParent();
        if (parentUuid == null) {
            return null;
        }
        return this.getNode(workspace, Location.create(parentUuid));
    }

    @Override
    public void removeAllChildren(WorkspaceType workspace, NodeType node) {
        boolean hadChanges = ((MapNode)node).hasChanges();
        node = this.findLatest(workspace, node);
        for (MapNode child : this.getChildren(workspace, node)) {
            this.destroyNode(workspace, child);
        }
        node = ((MapNode)node).withoutChildren();
        if (!hadChanges) {
            this.getChangesFor(workspace, true).changed(node);
        }
    }

    @Override
    public Location removeNode(WorkspaceType workspace, NodeType node) {
        Object parent = this.getParent(workspace, node = this.findLatest(workspace, node));
        if (parent == null) {
            WorkspaceChanges changes = this.getChangesFor(workspace, true);
            changes.removeAll(this.createNode(this.rootNodeUuid, null, null, null));
            return Location.create(this.pathFactory.createRootPath(), this.rootNodeUuid);
        }
        Location result = Location.create(this.pathFor(workspace, node), ((MapNode)node).getUuid());
        int index = ((MapNode)parent).getChildren().indexOf(((MapNode)node).getUuid());
        assert (index != -1);
        Name name = ((MapNode)node).getName().getName();
        int snsIndex = ((MapNode)node).getName().getIndex();
        parent = ((MapNode)parent).withoutChild(((MapNode)node).getUuid());
        WorkspaceChanges changes = this.getChangesFor(workspace, true);
        changes.changed(parent);
        List<NodeType> siblings = this.getChildren(workspace, parent);
        if (index < siblings.size()) {
            ListIterator<NodeType> iter = siblings.listIterator(index);
            while (iter.hasNext()) {
                MapNode sibling = (MapNode)iter.next();
                if (!sibling.getName().getName().equals(name)) continue;
                sibling = sibling.withName(this.pathFactory.createSegment(name, snsIndex++));
                changes.changed(sibling);
            }
        }
        this.destroyNode(changes, workspace, node);
        return result;
    }

    @Override
    public NodeType removeProperty(WorkspaceType workspace, NodeType node, Name propertyName) {
        MapNode copy = ((MapNode)(node = this.findLatest(workspace, node))).withoutProperty(propertyName);
        if (copy != node) {
            WorkspaceChanges changes = this.getChangesFor(workspace, true);
            changes.changed(copy);
        }
        return (NodeType)copy;
    }

    @Override
    public NodeType setProperties(WorkspaceType workspace, NodeType node, Iterable<Property> propertiesToSet, Iterable<Name> propertiesToRemove, boolean removeAllExisting) {
        MapNode copy = ((MapNode)(node = this.findLatest(workspace, node))).withProperties(propertiesToSet, propertiesToRemove, removeAllExisting);
        if (copy != node) {
            WorkspaceChanges changes = this.getChangesFor(workspace, true);
            changes.changed(copy);
        }
        return (NodeType)copy;
    }

    @Override
    public NodeType copyNode(WorkspaceType originalWorkspace, NodeType original, WorkspaceType newWorkspace, NodeType newParent, Name desiredName, boolean recursive) {
        WorkspaceChanges changes;
        if (desiredName == null) {
            desiredName = ((MapNode)original).getName().getName();
        }
        UUID uuid = UUID.randomUUID();
        Object copy = this.addChild(newWorkspace, newParent, desiredName, -1, uuid, ((MapNode)original).getProperties().values());
        HashMap<UUID, UUID> oldToNewUuids = new HashMap<UUID, UUID>();
        oldToNewUuids.put(((MapNode)original).getUuid(), uuid);
        if (recursive) {
            changes = this.getChangesFor(newWorkspace, true);
            for (MapNode originalChild : this.getChildren(originalWorkspace, original)) {
                MapNode newChild = this.copyBranch(originalWorkspace, originalChild, changes, newWorkspace, copy, false, oldToNewUuids);
                copy = ((MapNode)copy).withChild(newChild.getUuid());
            }
        }
        changes = this.getChangesFor(newWorkspace, true);
        changes.changed(copy);
        UuidFactory uuidFactory = this.context.getValueFactories().getUuidFactory();
        ReferenceFactory referenceFactory = this.context.getValueFactories().getReferenceFactory();
        for (Map.Entry oldToNew : oldToNewUuids.entrySet()) {
            Object newNode = this.findNode(newWorkspace, (UUID)oldToNew.getValue());
            assert (newNode != null);
            for (Map.Entry<Name, Property> entry : ((MapNode)newNode).getProperties().entrySet()) {
                Property property = entry.getValue();
                ArrayList<Object> newValues = new ArrayList<Object>();
                boolean foundReference = false;
                Iterator<?> iter = property.getValues();
                while (iter.hasNext()) {
                    Object value = iter.next();
                    PropertyType type = PropertyType.discoverType(value);
                    if (type == PropertyType.REFERENCE) {
                        UUID oldReferencedUuid = (UUID)uuidFactory.create(value);
                        UUID newReferencedUuid = (UUID)oldToNewUuids.get(oldReferencedUuid);
                        if (newReferencedUuid == null) continue;
                        newValues.add(referenceFactory.create(newReferencedUuid));
                        foundReference = true;
                        continue;
                    }
                    newValues.add(value);
                }
                if (!foundReference) continue;
                Property newProperty = this.propertyFactory.create(property.getName(), newValues);
                newNode = ((MapNode)newNode).withProperty(newProperty);
                changes.changed(newNode);
            }
        }
        return copy;
    }

    protected void print(WorkspaceType workspace, NodeType node, int level) {
        StringBuilder sb = new StringBuilder();
        sb.append(StringUtil.createString((char)' ', (int)(level * 2)));
        sb.append(this.readable(((MapNode)node).getName())).append(" (").append(((MapNode)node).getUuid()).append(") {");
        boolean first = true;
        for (Property property : ((MapNode)node).getProperties().values()) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append(this.readable(property.getName())).append('=');
            if (property.isMultiple()) {
                sb.append(property.getValuesAsArray());
                continue;
            }
            sb.append(this.readable(property.getFirstValue()));
        }
        sb.append('}');
        System.out.println(sb);
        for (MapNode child : this.getChildren(workspace, node)) {
            this.print(workspace, child, level + 1);
        }
    }

    @Override
    public NodeType cloneNode(WorkspaceType originalWorkspace, NodeType original, WorkspaceType newWorkspace, NodeType newParent, Name desiredName, Path.Segment desiredSegment, boolean removeExisting, Set<Location> removedExistingNodes) throws UuidAlreadyExistsException {
        WorkspaceChanges changes = this.getChangesFor(newWorkspace, true);
        MapNode newNode = null;
        Set<UUID> uuidsInFromBranch = this.getUuidsUnderNode(originalWorkspace, original);
        Object existing = null;
        if (removeExisting) {
            for (UUID uuid : uuidsInFromBranch) {
                NodeType NodeType = this.findNode(newWorkspace, uuid);
                existing = NodeType;
                if (null == NodeType) continue;
                if (removedExistingNodes != null) {
                    Path path = this.pathFor(newWorkspace, existing);
                    removedExistingNodes.add(Location.create(path, uuid));
                }
                this.removeNode(newWorkspace, existing);
            }
        } else {
            uuidsInFromBranch.add(((MapNode)original).getUuid());
            for (UUID uuid : uuidsInFromBranch) {
                NodeType NodeType = this.findNode(newWorkspace, uuid);
                existing = NodeType;
                if (null == NodeType) continue;
                NamespaceRegistry namespaces = this.context.getNamespaceRegistry();
                String path = this.pathFor(newWorkspace, existing).getString(namespaces);
                throw new UuidAlreadyExistsException(this.getRepository().getSourceName(), uuid, path, ((MapWorkspace)newWorkspace).getName());
            }
        }
        UUID uuid = ((MapNode)original).getUuid();
        if (desiredSegment != null) {
            int index = 0;
            List<NodeType> children = this.getChildren(newWorkspace, newParent);
            MapNode existingWithSameName = null;
            for (MapNode child : children) {
                if (child.getName().equals(desiredSegment)) {
                    existingWithSameName = child;
                    break;
                }
                ++index;
            }
            if (index == children.size()) {
                newNode = (MapNode)this.addChild(newWorkspace, newParent, ((MapNode)original).getName().getName(), -1, uuid, ((MapNode)original).getProperties().values());
            } else {
                newNode = (MapNode)this.createNode(uuid, desiredSegment, ((MapNode)newParent).getUuid(), ((MapNode)original).getProperties().values());
                assert (existingWithSameName != null);
                this.destroyNode(newWorkspace, existingWithSameName);
                newParent = ((MapNode)newParent).withoutChild(existingWithSameName.getUuid()).withChild(index, uuid);
            }
        } else {
            existing = this.findNode(newWorkspace, ((MapNode)original).getUuid());
            if (existing != null) {
                if (removedExistingNodes != null) {
                    Path path = this.pathFor(newWorkspace, existing);
                    removedExistingNodes.add(Location.create(path, ((MapNode)original).getUuid()));
                }
                this.removeNode(newWorkspace, existing);
            }
            newNode = desiredName != null ? (MapNode)this.addChild(newWorkspace, newParent, desiredName, -1, uuid, ((MapNode)original).getProperties().values()) : (MapNode)this.addChild(newWorkspace, newParent, ((MapNode)original).getName().getName(), -1, uuid, ((MapNode)original).getProperties().values());
        }
        if (!((MapNode)newParent).hasChanges()) {
            newParent = this.findNode(newWorkspace, ((MapNode)newParent).getUuid());
        }
        for (MapNode originalChild : this.getChildren(originalWorkspace, original)) {
            MapNode newChild = this.copyBranch(originalWorkspace, originalChild, changes, newWorkspace, newNode, true, null);
            newNode = newNode.withChild(newChild.getUuid());
        }
        changes.created(newNode);
        changes.changed(newParent);
        return (NodeType)newNode;
    }

    protected Set<UUID> getUuidsUnderNode(WorkspaceType workspace, NodeType node) {
        HashSet<UUID> uuids = new HashSet<UUID>();
        this.uuidsUnderNode(workspace, node, uuids);
        return uuids;
    }

    private void uuidsUnderNode(WorkspaceType workspace, NodeType node, Set<UUID> accumulator) {
        for (MapNode child : this.getChildren(workspace, node)) {
            accumulator.add(child.getUuid());
            this.uuidsUnderNode(workspace, child, accumulator);
        }
    }

    protected NodeType copyBranch(WorkspaceType originalWorkspace, NodeType original, WorkspaceChanges newWorkspaceChanges, WorkspaceType newWorkspace, NodeType newParent, boolean reuseUuid, Map<UUID, UUID> oldToNewUuids) {
        UUID copyUuid = reuseUuid ? ((MapNode)original).getUuid() : UUID.randomUUID();
        Object copy = this.createNode(copyUuid, ((MapNode)original).getName(), ((MapNode)newParent).getUuid(), ((MapNode)original).getProperties().values());
        newWorkspaceChanges.created(copy);
        if (!reuseUuid) {
            assert (oldToNewUuids != null);
            oldToNewUuids.put(((MapNode)original).getUuid(), ((MapNode)copy).getUuid());
        }
        for (MapNode originalChild : this.getChildren(originalWorkspace, original)) {
            MapNode newChild = this.copyBranch(originalWorkspace, originalChild, newWorkspaceChanges, newWorkspace, copy, reuseUuid, oldToNewUuids);
            copy = ((MapNode)copy).withChild(newChild.getUuid());
        }
        newWorkspaceChanges.changed(copy);
        return copy;
    }

    @Override
    public QueryResults query(WorkspaceType workspace, AccessQueryRequest accessQuery) {
        return null;
    }

    @Override
    public QueryResults search(WorkspaceType workspace, FullTextSearchRequest search) {
        return null;
    }

    @Override
    public void commit() {
        super.commit();
        if (this.changesByWorkspaceName != null) {
            for (WorkspaceChanges changes : this.changesByWorkspaceName.values()) {
                changes.commit();
            }
            this.changesByWorkspaceName.clear();
        }
    }

    @Override
    public void rollback() {
        super.rollback();
        if (this.changesByWorkspaceName != null) {
            this.changesByWorkspaceName.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Children
    implements List<NodeType> {
        private final List<UUID> uuids;
        private final WorkspaceType workspace;
        private final List<NodeType> cache;
        final /* synthetic */ MapTransaction this$0;

        protected Children(List<UUID> uuids, WorkspaceType workspace) {
            this.this$0 = var1_1;
            this.uuids = uuids instanceof RandomAccess || uuids.size() < 10 ? uuids : new ArrayList(uuids);
            this.workspace = workspace;
            this.cache = new ArrayList(uuids.size());
        }

        @Override
        public int size() {
            return this.uuids.size();
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof MapNode) {
                return this.uuids.contains(((MapNode)o).getUuid());
            }
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            for (Object o : c) {
                if (this.contains(o)) continue;
                return false;
            }
            return true;
        }

        @Override
        public NodeType get(int index) {
            MapNode result = null;
            if (this.cache.size() > index) {
                result = (MapNode)this.cache.get(index);
            }
            if (result == null) {
                UUID uuid = this.uuids.get(index);
                result = this.this$0.findNode(this.workspace, uuid);
                if (result == null) {
                    result = this.this$0.getNode(this.workspace, Location.create(uuid));
                }
                while (this.cache.size() <= index) {
                    this.cache.add(null);
                }
                this.cache.set(index, result);
            }
            return result;
        }

        @Override
        public int indexOf(Object o) {
            if (o instanceof MapNode) {
                return this.uuids.indexOf(((MapNode)o).getUuid());
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.indexOf(0);
        }

        @Override
        public boolean isEmpty() {
            return this.uuids.isEmpty();
        }

        @Override
        public Iterator<NodeType> iterator() {
            return this.listIterator(0);
        }

        @Override
        public ListIterator<NodeType> listIterator() {
            return this.listIterator(0);
        }

        @Override
        public ListIterator<NodeType> listIterator(final int index) {
            final int maxIndex = this.size();
            return new ListIterator<NodeType>(){
                private int current;
                {
                    this.current = index;
                }

                @Override
                public boolean hasNext() {
                    return this.current < maxIndex;
                }

                @Override
                public NodeType next() {
                    return Children.this.get(this.current++);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void add(NodeType e) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean hasPrevious() {
                    return this.current > 0;
                }

                @Override
                public int nextIndex() {
                    return this.current;
                }

                @Override
                public NodeType previous() {
                    return Children.this.get(--this.current);
                }

                @Override
                public int previousIndex() {
                    return this.current - 1;
                }

                @Override
                public void set(NodeType e) {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public List<NodeType> subList(int fromIndex, int toIndex) {
            return new Children(this.this$0, this.uuids.subList(fromIndex, toIndex), this.workspace);
        }

        @Override
        public Object[] toArray() {
            int length = this.uuids.size();
            Object[] result = new Object[length];
            for (int i = 0; i != length; ++i) {
                result[i] = this.get(i);
            }
            return result;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            int length = this.uuids.size();
            for (int i = 0; i != length; ++i) {
                a[i] = this.get(i);
            }
            return a;
        }

        @Override
        public boolean add(NodeType e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int index, NodeType element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends NodeType> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int index, Collection<? extends NodeType> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public NodeType remove(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public NodeType set(int index, NodeType element) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class WorkspaceChanges {
        private final WorkspaceType workspace;
        private final Map<UUID, NodeType> changedOrAddedNodes = new HashMap();
        private final Set<UUID> removedNodes = new HashSet<UUID>();
        private boolean removeAll = false;
        final /* synthetic */ MapTransaction this$0;

        protected WorkspaceChanges(WorkspaceType workspace) {
            this.this$0 = var1_1;
            this.workspace = workspace;
        }

        public WorkspaceType getWorkspace() {
            return this.workspace;
        }

        public void removeAll(NodeType newRootNode) {
            this.changedOrAddedNodes.clear();
            this.removedNodes.clear();
            this.removeAll = true;
            this.changedOrAddedNodes.put(((MapNode)newRootNode).getUuid(), newRootNode);
        }

        public boolean isRemoved(UUID uuid) {
            return this.removedNodes.contains(uuid);
        }

        public NodeType getChangedOrAdded(UUID uuid) {
            return (MapNode)this.changedOrAddedNodes.get(uuid);
        }

        public void removed(UUID uuid) {
            this.removedNodes.add(uuid);
            this.changedOrAddedNodes.remove(uuid);
        }

        public void created(NodeType node) {
            UUID uuid = ((MapNode)node).getUuid();
            this.removedNodes.remove(uuid);
            this.changedOrAddedNodes.put(uuid, node);
        }

        public void changed(NodeType node) {
            UUID uuid = ((MapNode)node).getUuid();
            assert (!this.removedNodes.contains(uuid));
            this.changedOrAddedNodes.put(uuid, node);
        }

        public void commit() {
            if (this.removeAll) {
                ((MapWorkspace)this.workspace).removeAll();
            }
            for (MapNode changed : this.changedOrAddedNodes.values()) {
                ((MapWorkspace)this.workspace).putNode((MapNode)changed.freeze());
            }
            for (UUID uuid : this.removedNodes) {
                ((MapWorkspace)this.workspace).removeNode(uuid);
            }
        }
    }
}

