/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.naming.Reference;
import javax.transaction.xa.XAResource;
import org.mockito.Mockito;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.cache.CachePolicy;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositoryContext;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.connector.RepositorySourceCapabilities;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.request.Request;

@ThreadSafe
public class TimeDelayingRepositorySource
implements RepositorySource {
    private static final long serialVersionUID = -2756725117087437347L;
    public static final int DEFAULT_RETRY_LIMIT = 0;
    protected static final RepositorySourceCapabilities CAPABILITIES = new RepositorySourceCapabilities(true, true);
    private String name;
    private final AtomicInteger connectionsOpenedCount = new AtomicInteger(0);
    private final AtomicInteger connectionsClosedCount = new AtomicInteger(0);
    private final Set<Connection> openConnections = new CopyOnWriteArraySet<Connection>();
    private final AtomicLong loadCount = new AtomicLong(0L);
    private final AtomicLong loadDelay = new AtomicLong(0L);
    private final AtomicLong pingCount = new AtomicLong(0L);
    private final AtomicLong pingDelay = new AtomicLong(0L);
    private final AtomicInteger retryLimit = new AtomicInteger(0);
    private CachePolicy defaultCachePolicy;
    private transient RepositoryContext repositoryContext;

    public TimeDelayingRepositorySource(String identifier) {
        this.name = identifier;
    }

    public void initialize(RepositoryContext context) throws RepositorySourceException {
        this.repositoryContext = context;
    }

    public RepositoryContext getRepositoryContext() {
        return this.repositoryContext;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getRetryLimit() {
        return this.retryLimit.get();
    }

    public void setRetryLimit(int limit) {
        this.retryLimit.set(limit < 0 ? 0 : limit);
    }

    public CachePolicy getDefaultCachePolicy() {
        return this.defaultCachePolicy;
    }

    public void setDefaultCachePolicy(CachePolicy defaultCachePolicy) {
        this.defaultCachePolicy = defaultCachePolicy;
    }

    public long getTotalExecuteCount() {
        return this.loadCount.get();
    }

    public long getTotalPingCount() {
        return this.pingCount.get();
    }

    public long getConnectionExecuteDelayInMillis() {
        return this.loadDelay.get();
    }

    public void setConnectionExecuteDelay(long time, TimeUnit unit) {
        this.loadDelay.set(unit.toMillis(time));
    }

    public long getConnectionPingDelayInMillis() {
        return this.pingDelay.get();
    }

    public void setConnectionPingDelay(long time, TimeUnit unit) {
        this.pingDelay.set(unit.toMillis(time));
    }

    public RepositoryConnection getConnection() throws RepositorySourceException {
        int connectionNumber = this.connectionsOpenedCount.incrementAndGet();
        String connectionName = "Connection " + connectionNumber;
        XAResource xaResource = this.newXaResource(connectionName);
        Connection c = this.newConnection(connectionName, xaResource);
        this.openConnections.add(c);
        return c;
    }

    public void close() {
    }

    protected XAResource newXaResource(String connectionName) {
        return (XAResource)Mockito.mock(XAResource.class);
    }

    protected Connection newConnection(String connectionName, XAResource xaResource) throws RepositorySourceException {
        Connection c = new Connection(connectionName, this.loadDelay.get(), this.pingDelay.get());
        c.setXaResource(xaResource);
        return c;
    }

    protected void close(Connection conn) {
        if (conn != null && this.openConnections.remove(conn)) {
            this.connectionsClosedCount.incrementAndGet();
            this.loadCount.addAndGet(conn.getLoadCount());
            this.pingCount.addAndGet(conn.getPingCount());
        }
    }

    public int getOpenConnectionCount() {
        return this.openConnections.size();
    }

    public int getTotalConnectionsCreated() {
        return this.connectionsOpenedCount.get();
    }

    public int getTotalConnectionsClosed() {
        return this.connectionsClosedCount.get();
    }

    public Reference getReference() {
        throw new UnsupportedOperationException();
    }

    public RepositorySourceCapabilities getCapabilities() {
        return CAPABILITIES;
    }

    public class Connection
    implements RepositoryConnection {
        private final String connectionName;
        private final AtomicBoolean closed = new AtomicBoolean(false);
        private final AtomicBoolean loadResponse = new AtomicBoolean(true);
        private final AtomicBoolean pingResponse = new AtomicBoolean(true);
        private final AtomicLong closeCount = new AtomicLong(0L);
        private final AtomicLong loadCount = new AtomicLong(0L);
        private final AtomicLong loadDelay;
        private final AtomicLong pingCount = new AtomicLong(0L);
        private final AtomicLong pingDelay;
        private final AtomicReference<XAResource> xaResource = new AtomicReference();

        protected Connection(String connectionName, long loadDelay, long pingDelay) {
            assert (connectionName != null && connectionName.trim().length() != 0);
            this.loadDelay = new AtomicLong(loadDelay);
            this.pingDelay = new AtomicLong(pingDelay);
            this.connectionName = connectionName;
        }

        public String getConnectionName() {
            return this.connectionName;
        }

        public void close() {
            this.closeCount.incrementAndGet();
            this.closed.set(true);
            TimeDelayingRepositorySource.this.close(this);
        }

        public String getSourceName() {
            return TimeDelayingRepositorySource.this.getName();
        }

        public CachePolicy getDefaultCachePolicy() {
            return TimeDelayingRepositorySource.this.getDefaultCachePolicy();
        }

        public XAResource getXAResource() {
            return this.xaResource.get();
        }

        public void setXaResource(XAResource xaResource) {
            this.xaResource.set(xaResource);
        }

        public void execute(ExecutionContext context, Request request) throws RepositorySourceException {
            long delay = this.loadDelay.get();
            if (delay > 0L) {
                try {
                    Thread.sleep(delay);
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                    throw new RepositorySourceException(this.getSourceName(), (Throwable)e);
                }
            }
            this.loadCount.incrementAndGet();
        }

        public void setLoadResponse(boolean response) {
            this.loadResponse.set(response);
        }

        public void setLoadDelay(long time, TimeUnit unit) {
            this.loadDelay.set(unit.toMillis(time));
        }

        public boolean ping(long time, TimeUnit unit) {
            try {
                Thread.sleep(this.pingDelay.get());
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                return false;
            }
            return this.pingResponse.get();
        }

        public void setPingResponse(boolean pingResponse) {
            this.pingResponse.set(pingResponse);
        }

        public void setPingDelay(long time, TimeUnit unit) {
            this.pingDelay.set(unit.toMillis(time));
        }

        public long getPingCount() {
            return this.pingCount.get();
        }

        public long getLoadCount() {
            return this.loadCount.get();
        }

        public long getCloseCount() {
            return this.closeCount.get();
        }
    }
}

