/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.base;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.connector.base.MockPathNode;
import org.modeshape.graph.connector.base.PathWorkspace;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockPathWorkspace
extends PathWorkspace<MockPathNode> {
    protected ExecutionContext context = new ExecutionContext();
    protected InternalNode rootNode;

    public MockPathWorkspace(String name, UUID rootNodeUuid) {
        super(name, rootNodeUuid);
    }

    public MockPathWorkspace(String name, MockPathWorkspace originalToClone) {
        super(name, (PathWorkspace)originalToClone);
    }

    protected PathFactory pathFactory() {
        return this.context.getValueFactories().getPathFactory();
    }

    private InternalNode nodeAt(Path path) {
        InternalNode node = this.rootNode();
        for (Path.Segment segment : path) {
            if ((node = node.getChild(segment)) != null) continue;
            return null;
        }
        return node;
    }

    public MockPathNode getNode(Path path) {
        if (this.nodeAt(path) == null) assert (this.nodeAt(path) != null);
        return this.pathNodeFor(this.nodeAt(path));
    }

    private InternalNode rootNode() {
        if (this.rootNode == null) {
            this.rootNode = new InternalNode(this.getRootNodeUuid());
        }
        return this.rootNode;
    }

    public MockPathNode getRootNode() {
        return this.pathNodeFor(this.rootNode());
    }

    private MockPathNode pathNodeFor(InternalNode node) {
        if (node.getParent() == null) {
            new MockPathNode(node.getUuid(), null, node.getName(), node.getProperties(), node.getChildren());
        }
        return new MockPathNode(node.getUuid(), node.getPath().getParent(), node.getName(), node.getProperties(), node.getChildren());
    }

    public MockPathNode putNode(MockPathNode node) {
        InternalNode target;
        if (node.getParent() == null) {
            target = this.rootNode;
        } else {
            InternalNode parent = this.nodeAt(node.getParent());
            target = parent.getChild(node.getName());
            if (target == null) {
                target = new InternalNode(parent, node.getName(), node.getProperties(), null);
                parent.addChild(target);
                return this.pathNodeFor(target);
            }
        }
        target.setProperties(node.getProperties());
        return this.pathNodeFor(target);
    }

    public MockPathNode moveNode(MockPathNode node, MockPathNode newNode) {
        InternalNode parent = this.nodeAt(newNode.getParent());
        InternalNode child = this.nodeAt(this.pathFactory().create(node.getParent(), new Path.Segment[]{node.getName()}));
        parent.addChild(child);
        return this.pathNodeFor(child);
    }

    public void removeAll() {
        this.rootNode = null;
    }

    public MockPathNode removeNode(Path path) {
        if (path.isRoot()) {
            InternalNode oldRoot = this.rootNode;
            this.removeAll();
            return this.pathNodeFor(oldRoot);
        }
        InternalNode target = this.nodeAt(path);
        InternalNode parent = target.getParent();
        parent.removeChild(target.getName());
        return this.pathNodeFor(target);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InternalNode {
        private UUID uuid;
        private Path.Segment name;
        private InternalNode parent;
        private Map<Name, Property> properties;
        private List<InternalNode> children;

        protected InternalNode(UUID uuid) {
            this(uuid, null, null, null, null);
        }

        protected InternalNode(InternalNode parent, Path.Segment name, Map<Name, Property> properties, List<InternalNode> children) {
            this(null, parent, name, properties, children);
        }

        protected InternalNode(UUID uuid, InternalNode parent, Path.Segment name, Map<Name, Property> properties, List<InternalNode> children) {
            this.uuid = uuid;
            this.parent = parent;
            this.name = name;
            this.properties = properties == null ? new HashMap<Name, Property>() : new HashMap<Name, Property>(properties);
            this.children = children == null ? new ArrayList() : children;
        }

        protected InternalNode getChild(Path.Segment segment) {
            for (InternalNode node : this.children) {
                if (!node.getName().equals(segment)) continue;
                return node;
            }
            return null;
        }

        protected void removeChild(Path.Segment segment) {
            this.children.remove(segment);
        }

        protected void addChild(InternalNode child) {
            this.children.add(child);
            child.parent = this;
        }

        protected List<Path.Segment> getChildren() {
            ArrayList<Path.Segment> childSegments = new ArrayList<Path.Segment>(this.children.size());
            for (InternalNode child : this.children) {
                childSegments.add(child.getName());
            }
            return childSegments;
        }

        protected Map<Name, Property> getProperties() {
            return new HashMap<Name, Property>(this.properties);
        }

        protected void setProperties(Map<Name, Property> properties) {
            this.properties = new HashMap<Name, Property>(properties);
        }

        protected InternalNode getParent() {
            return this.parent;
        }

        protected Path.Segment getName() {
            return this.name;
        }

        protected UUID getUuid() {
            return this.uuid;
        }

        protected Path getPath() {
            if (this.parent == null) {
                return MockPathWorkspace.this.pathFactory().createRootPath();
            }
            return MockPathWorkspace.this.pathFactory().create(this.parent.getPath(), new Path.Segment[]{this.name});
        }

        public String toString() {
            return this.getPath().getString(MockPathWorkspace.this.context.getNamespaceRegistry());
        }
    }
}

