/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.federation;

import java.util.concurrent.CountDownLatch;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.hamcrest.core.IsSame;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.modeshape.common.statistic.Stopwatch;
import org.modeshape.graph.connector.federation.FederatedRequest;
import org.modeshape.graph.connector.federation.Projection;
import org.modeshape.graph.request.Request;

public class FederatedRequestTest {
    private FederatedRequest request;
    @Mock
    private Request original;
    private Projection[] projection;
    private Request[] projectedRequest;

    @Before
    public void beforeEach() {
        MockitoAnnotations.initMocks((Object)this);
        this.request = new FederatedRequest(this.original);
        this.projection = new Projection[]{(Projection)Mockito.mock(Projection.class), (Projection)Mockito.mock(Projection.class), (Projection)Mockito.mock(Projection.class)};
        this.projectedRequest = new Request[]{(Request)Mockito.mock(Request.class), (Request)Mockito.mock(Request.class), (Request)Mockito.mock(Request.class)};
    }

    @Test
    public void shouldHaveOriginalRequest() {
        Assert.assertThat((Object)this.request.original(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.original)));
    }

    @Test
    public void shouldAddFirstProjectedRequest() {
        this.request.add(this.projectedRequest[0], false, false, this.projection[0]);
        Assert.assertThat((Object)this.request.hasIncompleteRequests(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.request.getFirstProjectedRequest().getProjection(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.projection[0])));
        Assert.assertThat((Object)this.request.getFirstProjectedRequest().getRequest(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.projectedRequest[0])));
        Assert.assertThat((Object)this.request.getFirstProjectedRequest().hasNext(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.request.getFirstProjectedRequest().next(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldAddMultipleProjectedRequests() {
        this.request.add(this.projectedRequest[0], false, false, this.projection[0]);
        this.request.add(this.projectedRequest[1], false, true, this.projection[1]);
        this.request.add(this.projectedRequest[2], false, false, this.projection[2]);
        Assert.assertThat((Object)this.request.hasIncompleteRequests(), (Matcher)Is.is((Object)true));
        FederatedRequest.ProjectedRequest first = this.request.getFirstProjectedRequest();
        Assert.assertThat((Object)first.getProjection(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.projection[0])));
        Assert.assertThat((Object)first.getRequest(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.projectedRequest[0])));
        Assert.assertThat((Object)first.isComplete(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)first.hasNext(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)first.next(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        FederatedRequest.ProjectedRequest second = first.next();
        Assert.assertThat((Object)second.getProjection(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.projection[1])));
        Assert.assertThat((Object)second.getRequest(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.projectedRequest[1])));
        Assert.assertThat((Object)second.isComplete(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)second.hasNext(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)second.next(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        FederatedRequest.ProjectedRequest third = second.next();
        Assert.assertThat((Object)third.getProjection(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.projection[2])));
        Assert.assertThat((Object)third.getRequest(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.projectedRequest[2])));
        Assert.assertThat((Object)third.isComplete(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)third.hasNext(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)third.next(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldAddMultipleProjectedRequestsAddedInMethodChain() {
        this.request.add(this.projectedRequest[0], false, false, this.projection[0]).add(this.projectedRequest[1], false, true, this.projection[1]).add(this.projectedRequest[2], false, false, this.projection[2]);
        Assert.assertThat((Object)this.request.hasIncompleteRequests(), (Matcher)Is.is((Object)true));
        FederatedRequest.ProjectedRequest first = this.request.getFirstProjectedRequest();
        Assert.assertThat((Object)first.getProjection(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.projection[0])));
        Assert.assertThat((Object)first.getRequest(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.projectedRequest[0])));
        Assert.assertThat((Object)first.isComplete(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)first.hasNext(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)first.next(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        FederatedRequest.ProjectedRequest second = first.next();
        Assert.assertThat((Object)second.getProjection(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.projection[1])));
        Assert.assertThat((Object)second.getRequest(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.projectedRequest[1])));
        Assert.assertThat((Object)second.isComplete(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)second.hasNext(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)second.next(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        FederatedRequest.ProjectedRequest third = second.next();
        Assert.assertThat((Object)third.getProjection(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.projection[2])));
        Assert.assertThat((Object)third.getRequest(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.projectedRequest[2])));
        Assert.assertThat((Object)third.isComplete(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)third.hasNext(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)third.next(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldCreateCountDownLatchUponFreezeIfNumberOfIncompleteProjectedRequestsIsNonZero() {
        this.request.add(this.projectedRequest[0], false, false, this.projection[0]);
        this.request.freeze();
        Assert.assertThat((Object)this.request.getLatch(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)this.request.getLatch().getCount(), (Matcher)Is.is((Object)1L));
        Assert.assertThat((Object)this.request.hasIncompleteRequests(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldUseClosedLatchUponFreezeIfNumberOfIncompleteProjectedRequestsIsZero() {
        this.request.add(this.projectedRequest[0], false, true, this.projection[0]);
        this.request.freeze();
        Assert.assertThat((Object)this.request.getLatch(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)FederatedRequest.CLOSED_LATCH)));
        Assert.assertThat((Object)this.request.hasIncompleteRequests(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldNotBlockWhenAwaitingOnRequestWithNoIncompleteRequests() throws InterruptedException {
        this.request.add(this.projectedRequest[0], false, true, this.projection[0]);
        this.request.freeze();
        Assert.assertThat((Object)this.request.hasIncompleteRequests(), (Matcher)Is.is((Object)false));
        this.request.await();
    }

    @Test
    public void shouldBlockWhenAwaitingOnRequestWithIncompleteRequests() throws InterruptedException {
        this.request.add(this.projectedRequest[0], false, false, this.projection[0]);
        this.request.add(this.projectedRequest[1], false, false, this.projection[1]);
        this.request.add(this.projectedRequest[2], false, false, this.projection[2]);
        this.request.freeze();
        Assert.assertThat((Object)this.request.hasIncompleteRequests(), (Matcher)Is.is((Object)true));
        CountDownLatch latch = this.request.getLatch();
        Assert.assertThat((Object)latch.getCount(), (Matcher)Is.is((Object)3L));
        Stopwatch sw = new Stopwatch();
        sw.start();
        new Thread(new CountDownRunnable(latch, 100L)).start();
        this.request.await();
        Assert.assertThat((Object)latch.getCount(), (Matcher)Is.is((Object)0L));
        sw.stop();
        Assert.assertThat((Object)(sw.getTotalDuration().getDurationInMilliseconds().intValue() >= 250 ? 1 : 0), (Matcher)Is.is((Object)true));
    }

    protected static class CountDownRunnable
    implements Runnable {
        private final CountDownLatch latch;
        private final long sleepTimeInMillis;

        protected CountDownRunnable(CountDownLatch latch, long sleepTimeInMillis) {
            assert (latch != null);
            this.latch = latch;
            this.sleepTimeInMillis = sleepTimeInMillis;
        }

        public void run() {
            while (this.latch.getCount() != 0L) {
                try {
                    Thread.sleep(this.sleepTimeInMillis);
                }
                catch (InterruptedException err) {
                    System.err.println("Error: interrupted while sleeping before counting down in " + this.getClass().getName());
                }
                this.latch.countDown();
            }
        }
    }
}

