/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.test;

import java.util.List;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.common.statistic.Stopwatch;
import org.modeshape.graph.Graph;
import org.modeshape.graph.Location;
import org.modeshape.graph.Subgraph;
import org.modeshape.graph.Workspace;
import org.modeshape.graph.connector.test.AbstractConnectorTest;
import org.modeshape.graph.request.InvalidRequestException;
import org.modeshape.graph.request.InvalidWorkspaceException;
import org.modeshape.graph.request.ReadNodeRequest;

public abstract class WorkspaceConnectorTest
extends AbstractConnectorTest {
    protected abstract String[] generateValidNamesForNewWorkspaces();

    protected abstract String[] generateInvalidNamesForNewWorkspaces();

    protected String generateNonExistantWorkspaceName() {
        String workspaceName = "something bogus" + this.context.getValueFactories().getDateFactory().create().getString();
        Set workspaces = this.graph.getWorkspaces();
        while (workspaces.contains(workspaceName)) {
            workspaceName = workspaceName + "1";
        }
        return workspaceName;
    }

    protected void initializeContents(Graph graph) {
        String initialPath = "";
        int depth = 4;
        int numChildrenPerNode = 4;
        int numPropertiesPerNode = 7;
        Stopwatch sw = new Stopwatch();
        boolean batch = true;
        this.createSubgraph(graph, initialPath, depth, numChildrenPerNode, numPropertiesPerNode, batch, sw, this.output, null);
    }

    @Test
    public void shouldBeAtLeastOneWorkspaceAvailableInSource() {
        Set workspaces = this.graph.getWorkspaces();
        Assert.assertThat((Object)workspaces, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)workspaces.isEmpty(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldGetRootNodeInEachWorkspace() {
        for (String workspaceName : this.graph.getWorkspaces()) {
            Location root = this.graph.useWorkspace(workspaceName).getRoot();
            Assert.assertThat((Object)root, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
            this.readNodeThoroughly(root);
        }
    }

    @Test
    public void shouldReadTheChildrenOfTheRootNodeInEachWorkspace() {
        for (String workspaceName : this.graph.getWorkspaces()) {
            Location root = this.graph.useWorkspace(workspaceName).getRoot();
            List children = (List)this.graph.getChildren().of(root);
            Assert.assertThat((Object)children, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
            for (Location child : children) {
                Assert.assertThat((Object)child.hasPath(), (Matcher)Is.is((Object)true));
                Assert.assertThat((Object)child.getPath().getParent().isRoot(), (Matcher)Is.is((Object)true));
                this.readNodeThoroughly(child);
            }
        }
    }

    @Test(expected=InvalidWorkspaceException.class)
    public void shouldNotReadNodesInWorkspacesThatDoNotExist() {
        String nonExistantWorkspaceName = this.generateNonExistantWorkspaceName();
        ReadNodeRequest request = new ReadNodeRequest(this.location("/"), nonExistantWorkspaceName);
        this.execute(request);
    }

    @Test
    public void shouldNotAllowCreatingWorkspacesIfCapabilitiesSayCreatingWorkspacesIsNotSupported() {
        if (!this.source.getCapabilities().supportsCreatingWorkspaces()) {
            try {
                this.graph.createWorkspace().namedSomethingLike("argle bargle");
                Assert.fail((String)"Should not allow creating workspaces when source capabilities say it's not supported");
            }
            catch (InvalidRequestException error) {
                // empty catch block
            }
            String nonExistWorkspaceName = this.generateNonExistantWorkspaceName();
            try {
                this.graph.createWorkspace().named(nonExistWorkspaceName);
                Assert.fail((String)"Should not allow creating workspaces when source capabilities say it's not supported");
            }
            catch (InvalidRequestException invalidRequestException) {
                // empty catch block
            }
        }
    }

    @Test
    public void shouldNotAllowCloningWorkspacesIfCapabilitiesSayCreatingWorkspacesIsNotSupported() {
        if (!this.source.getCapabilities().supportsCreatingWorkspaces()) {
            String existingWorkspaceName = (String)this.graph.getWorkspaces().iterator().next();
            String nonExistWorkspaceName = this.generateNonExistantWorkspaceName();
            try {
                this.graph.createWorkspace().clonedFrom(existingWorkspaceName).namedSomethingLike("something");
                Assert.fail((String)"Should not allow cloning workspaces when source capabilities say it's not supported");
            }
            catch (InvalidRequestException error) {
                // empty catch block
            }
            try {
                this.graph.createWorkspace().clonedFrom(existingWorkspaceName).named(nonExistWorkspaceName);
                Assert.fail((String)"Should not allow cloning workspaces when source capabilities say it's not supported");
            }
            catch (InvalidRequestException invalidRequestException) {
                // empty catch block
            }
        }
    }

    @Test
    public void shouldNotAllowCloningWorkspaceFromWorkspaceWithSameNameIfAllowedByCapabilities() {
        block8: {
            if (this.source.getCapabilities().supportsCreatingWorkspaces()) {
                try {
                    Workspace existing = null;
                    Set existingWorkspaceNames = this.graph.getWorkspaces();
                    if (existingWorkspaceNames.isEmpty()) {
                        String[] validWorkspaceNames = this.generateValidNamesForNewWorkspaces();
                        if (validWorkspaceNames.length == 0) {
                            return;
                        }
                        existing = this.graph.createWorkspace().namedSomethingLike(validWorkspaceNames[0]);
                        Assert.assertThat((Object)existing, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
                        String workspaceName1 = existing.getName();
                        Assert.assertThat((Object)workspaceName1, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
                        Assert.assertThat((Object)workspaceName1.trim().length(), (Matcher)Is.is((Matcher)IsNot.not((Object)0)));
                        this.initializeContents(this.graph);
                    } else {
                        existing = this.graph.useWorkspace((String)existingWorkspaceNames.iterator().next());
                    }
                    try {
                        this.graph.createWorkspace().clonedFrom(existing.getName()).named(existing.getName());
                        Assert.fail((String)"No error reported after attempting to create a cloned workspace that was same name as clone");
                    }
                    catch (InvalidWorkspaceException invalidWorkspaceException) {}
                }
                catch (InvalidRequestException error) {
                    if (!this.source.getCapabilities().supportsUpdates()) break block8;
                    throw error;
                }
            }
        }
    }

    @Test
    public void shouldAllowCreatingWorkspaceWithValidNameIfAllowedByCapabilities() {
        if (this.source.getCapabilities().supportsCreatingWorkspaces()) {
            String[] validNames;
            for (String validName : validNames = this.generateValidNamesForNewWorkspaces()) {
                Workspace workspace = this.graph.createWorkspace().named(validName);
                Assert.assertThat((Object)workspace, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
                String workspaceName1 = workspace.getName();
                Assert.assertThat((Object)workspaceName1, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
                Assert.assertThat((Object)workspaceName1.trim().length(), (Matcher)Is.is((Matcher)IsNot.not((Object)0)));
            }
        }
    }

    @Test
    public void shouldNotAllowCreatingWorkspaceWithInvalidNameIfAllowedByCapabilities() {
        String[] invalidNames;
        if (this.source.getCapabilities().supportsCreatingWorkspaces() && (invalidNames = this.generateInvalidNamesForNewWorkspaces()) != null) {
            for (String invalidName : invalidNames) {
                try {
                    this.graph.createWorkspace().named(invalidName);
                    Assert.fail((String)"Did not fail to create workspace with name that should be invalid");
                }
                catch (InvalidWorkspaceException error) {
                    // empty catch block
                }
            }
        }
    }

    @Test
    public void shouldAllowCreatingWorkspaceByCloningAnExistingWorkspaceIfAllowedByCapabilities() {
        block8: {
            if (this.source.getCapabilities().supportsCreatingWorkspaces()) {
                String[] validWorkspaceNames = this.generateValidNamesForNewWorkspaces();
                if (validWorkspaceNames.length < 1) {
                    return;
                }
                try {
                    Set existingWorkspaceNames = this.graph.getWorkspaces();
                    Workspace workspace1 = null;
                    String newWorkspaceName = null;
                    if (existingWorkspaceNames.isEmpty()) {
                        workspace1 = this.graph.createWorkspace().namedSomethingLike(validWorkspaceNames[0]);
                        newWorkspaceName = validWorkspaceNames[1];
                        Assert.assertThat((Object)workspace1, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
                        String workspaceName1 = workspace1.getName();
                        Assert.assertThat((Object)workspaceName1, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
                        Assert.assertThat((Object)workspaceName1.trim().length(), (Matcher)Is.is((Matcher)IsNot.not((Object)0)));
                        this.initializeContents(this.graph);
                    } else {
                        workspace1 = this.graph.useWorkspace((String)existingWorkspaceNames.iterator().next());
                        newWorkspaceName = validWorkspaceNames[0];
                    }
                    assert (workspace1 != null);
                    assert (newWorkspaceName != null);
                    String workspaceName = workspace1.getName();
                    Workspace workspace2 = this.graph.createWorkspace().clonedFrom(workspaceName).named(newWorkspaceName);
                    Subgraph subgraph1 = (Subgraph)this.graph.getSubgraphOfDepth(100000).at(workspace1.getRoot());
                    Subgraph subgraph2 = (Subgraph)this.graph.getSubgraphOfDepth(100000).at(workspace2.getRoot());
                    WorkspaceConnectorTest.assertEquivalentSubgraphs(subgraph1, subgraph2, true, true);
                }
                catch (InvalidRequestException error) {
                    if (!this.source.getCapabilities().supportsUpdates()) break block8;
                    throw error;
                }
            }
        }
    }
}

